<?php
Yii::import('zii.widgets.CMenu');

/**
 * MGMenu class file.
 *
 * @author Vincent Van Uffelen <novazembla@gmail.com>
 */

/**
 * MGMenu is a extension of CMenu. It is just overwriting the  isItemActive() method to cater for 
 * MG's needs
 *
 * 
 *
 * @author Vincent Van Uffelen <novazembla@gmail.com>
 */
class MGMenu extends CMenu
{
   /**
   * Checks whether a menu item is active.
   * This is done by checking if the currently requested URL is generated by the 'url' option
   * of the menu item. Note that the GET parameters not specified in the 'url' option will be ignored.
   * @param array $item the menu item to be checked
   * @param string $route the route of the current request
   * @return boolean whether the menu item is active
   */

  protected function isItemActive($item,$route)
  {
      
    if(isset($item['url']) && is_array($item['url']) && !strcasecmp(trim($item['url'][0],'/'),$route))
    {
      if(count($item['url'])>1)
      {
        foreach(array_splice($item['url'],1) as $name=>$value)
        {
          if(!isset($_GET[$name]) || $_GET[$name]!=$value)
            return false;
        }
      }
      return true;
    }
    
    if(isset($item['url']) && is_array($item['url']) && count($item['url']) == 1)
    {
      $arr_url = explode("/", trim($item['url'][0],'/'));
      $arr_route = explode("/", $route);
      
      $in_path = false;
      for($i=0;$i<count($arr_url);$i++) {
        if (isset($arr_route[$i]) && $arr_url[$i] == $arr_route[$i]) {
          $in_path = true;    
        } else {
          $in_path = false;
          break;
        }
      }
      // some paths have to be hard coded
      if (trim($item['url'][0],'/') == "admin/user" && strpos($route, 'admin/profileField') !== false) {
        $in_path = true;
      }
      return $in_path;
    }
    
    return false;
  }
}