<?php

// uncomment the following to define a path alias
// Yii::setPathOfAlias('local','path/to/local-folder');

// This is the main Web application configuration. Any writable
// CWebApplication properties can be configured here.
return array(
	'basePath'=>dirname(__FILE__).DIRECTORY_SEPARATOR.'..',
	'name'=>'MetaData Games', //xxx set via installer

	// preloading 'log' component
	'preload'=>array('log', 'fbvStorage'),

	// autoloading model and component classes
	'import'=>array(
		'application.models.*',
		'application.components.*',
    'ext.giix-components.*',
    'ext.components.*',
    'ext.yii-flash.*',
    'application.helpers.*',
    'application.modules.games.*',
    'application.modules.plugins.components.*',
    'ext.yii-mail.YiiMailMessage',
	),

	'modules'=>array(
		// uncomment the following to enable the Gii tool
    'gii'=>array(
			'class'=>'system.gii.GiiModule',
			'password'=>false,
		 	// If removed, Gii defaults to localhost only. Edit carefully to taste.
			'ipFilters'=>array('127.0.0.1','::1'),
  	  'generatorPaths' => array(
        'ext.giix-core', // giix generators
      ),
		),
		'admin',
		'user',
		'plugins',
		'api',
		'games',
	),

	// application components
	'components'=>array(
		'user'=>array(
			// enable cookie-based authentication
			//'class' => 'WebUser',
			'allowAutoLogin'=>true,
			'loginUrl' => array('/user/login'),
		),
		'authManager'=>array(
            'class'=>'CPhpAuthManager',
            // 'authFile' => 'path'                  // only if necessary
    ),
		// uncomment the following to enable URLs in path-format
		'urlManager'=>array(
			'urlFormat'=>'path',
			'rules'=>array(
			  'user/login/restore-password' => 'user/recovery/recovery',
        'user/login/restore-password/<activekey:.+>/<email:.+>' => 'user/recovery/recovery/<activekey>/<email>',
				'<controller:\w+>/<id:\d+>'=>'<controller>/view',
				'<controller:\w+>/<action:\w+>/<id:\d+>'=>'<controller>/<action>',
				'<controller:\w+>/<action:\w+>'=>'<controller>/<action>',
			),
		),
    // xxx rest api http://stackoverflow.com/questions/6656219/routing-requests-to-module-in-yii-framework
    
		'db'=>array(
			'connectionString' => 'mysql:host=localhost;dbname=mg', //xxx set via installer
			'emulatePrepare' => true,
			'username' => 'root', //xxx set via installer
			'password' => '', //xxx set via installer
			'charset' => 'utf8',
			'tablePrefix'=>'', //xxx set via installer
		),
		
		'errorHandler'=>array(
			// use 'site/error' action to display errors
            'errorAction'=>'site/error',
        ),
		
		'log'=>array(
			'class'=>'CLogRouter',
			'routes'=>array(
				array(
					'class'=>'CFileLogRoute',
					'levels'=>'error, warning',
				),
				// uncomment the following to show log messages on web pages
				// xxx comment web log out. xxx configure logging
				array(
					'class'=>'CWebLogRoute',
				),
			),
		),
		
    'fbvStorage'=>array(
      'class'=>'application.components.FBVStorage'
    ),
    
    'xUploadWidget' => array(
      'class' => 'ext.xupload.XUploadWidget',
    ),
    
    'clientScript' => array(
      'class' => 'ext.components.NLSClientScript',
      'hashMode' => 'PATH', //PATH|CONTENT
      'bInlineJs' => false
    ),
    
    'image'=>array(
      'class'=>'ext.image.CImageComponent',
      'driver'=>'GD',
    ),
    
    'mail' => array(
      'class' => 'ext.yii-mail.YiiMail',
      'transportType' => 'php',
      'viewPath' => 'application.views.mail',
      'logging' => true,
      'dryRun' => false
    ),
	),
  
  'behaviors'=>array(
    'onbeginRequest'=>array('class'=>'ext.components.NLSClientScriptBehaviour'),
  ),
  
	// application-level parameters that can be accessed
	// using Yii::app()->params['paramName']
	'params'=>array(
		// this is used in contact page
		'adminEmail'=>'novazembla@gmail.com', //xxx set via installer
		'pagination.pageSize'=> 25, // used in GridViews generated by GiiX using the MG CRUD templates
		'upload_path'=>'/../uploads', // relative to protected folder retrieved by Yii::app()->getBasePath()
		'upload_url'=>'/uploads', // relative to protected folder retrieved by Yii::app()->getBasePath()
	),
);