<?php

/**
 * This is the model base class for the table "game_submission".
 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.
 * If any changes are necessary, you must set or override the required
 * property or method in class "GameSubmission".
 *
 * Columns in table "game_submission" available as properties of the model,
 * followed by relations of table "game_submission" available as properties of the model.
 *
 * @property string $id
 * @property string $submission
 * @property integer $session_id
 * @property integer $played_game_id
 * @property string $created
 *
 * @property PlayedGame $playedGame
 * @property Session $session
 * @property TagUse[] $tagUses
 */
abstract class BaseGameSubmission extends GxActiveRecord {

	public static function model($className=__CLASS__) {
		return parent::model($className);
	}

	public function tableName() {
		return 'game_submission';
	}

	public static function label($n = 1) {
		return Yii::t('app', 'GameSubmission|GameSubmissions', $n);
	}

	public static function representingColumn() {
		return 'submission';
	}

	public function rules() {
		return array(
			array('submission, session_id, played_game_id', 'required'),
			array('session_id, played_game_id', 'numerical', 'integerOnly'=>true),
			array('created', 'safe'),
			array('created', 'default', 'setOnEmpty' => true, 'value' => null),
			array('id, submission, session_id, played_game_id, created', 'safe', 'on'=>'search'),
		);
	}

	public function relations() {
		return array(
			'playedGame' => array(self::BELONGS_TO, 'PlayedGame', 'played_game_id'),
			'session' => array(self::BELONGS_TO, 'Session', 'session_id'),
			'tagUses' => array(self::HAS_MANY, 'TagUse', 'game_submission_id'),
		);
	}

	public function pivotModels() {
		return array(
		);
	}

	public function attributeLabels() {
		return array(
			'id' => Yii::t('app', 'ID'),
			'submission' => Yii::t('app', 'Submission'),
			'session_id' => null,
			'played_game_id' => null,
			'created' => Yii::t('app', 'Created'),
			'playedGame' => null,
			'session' => null,
			'tagUses' => null,
		);
	}

	public function search() {
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id, true);
		$criteria->compare('submission', $this->submission, true);
		$criteria->compare('session_id', $this->session_id);
		$criteria->compare('played_game_id', $this->played_game_id);
		$criteria->compare('created', $this->created, true);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
			'pagination'=>array(
        'pageSize'=>Yii::app()->params['pagination.pageSize'],
      ),
		));
	}
}