<?php

/**
 * This is the model base class for the table "licence".
 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.
 * If any changes are necessary, you must set or override the required
 * property or method in class "Licence".
 *
 * Columns in table "licence" available as properties of the model,
 * followed by relations of table "licence" available as properties of the model.
 *
 * @property integer $id
 * @property string $name
 * @property string $description
 * @property string $created
 * @property string $modified
 *
 * @property ImageSet[] $imageSets
 */
abstract class BaseLicence extends GxActiveRecord {

	public static function model($className=__CLASS__) {
		return parent::model($className);
	}

	public function tableName() {
		return 'licence';
	}

	public static function label($n = 1) {
		return Yii::t('app', 'Licence|Licences', $n);
	}

	public static function representingColumn() {
		return 'name';
	}

	public function rules() {
		return array(
			array('name, created, modified', 'required'),
			array('name', 'length', 'max'=>64),
			array('description', 'safe'),
			array('description', 'default', 'setOnEmpty' => true, 'value' => null),
			array('id, name, description, created, modified', 'safe', 'on'=>'search'),
		);
	}

	public function relations() {
		return array(
			'imageSets' => array(self::HAS_MANY, 'ImageSet', 'licence_id'),
		);
	}

	public function pivotModels() {
		return array(
		);
	}

	public function attributeLabels() {
		return array(
			'id' => Yii::t('app', 'ID'),
			'name' => Yii::t('app', 'Name'),
			'description' => Yii::t('app', 'Description'),
			'created' => Yii::t('app', 'Created'),
			'modified' => Yii::t('app', 'Modified'),
			'imageSets' => null,
		);
	}

	public function search() {
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('name', $this->name, true);
		$criteria->compare('description', $this->description, true);
		$criteria->compare('created', $this->created, true);
		$criteria->compare('modified', $this->modified, true);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
			'pagination'=>array(
        'pageSize'=>Yii::app()->params['pagination.pageSize'],
      ),
		));
	}
}