<?php

/**
 * This is the model base class for the table "log".
 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.
 * If any changes are necessary, you must set or override the required
 * property or method in class "Log".
 *
 * Columns in table "log" available as properties of the model,
 * followed by relations of table "log" available as properties of the model.
 *
 * @property integer $id
 * @property string $category
 * @property string $message
 * @property integer $user_id
 * @property string $created
 *
 * @property User $user
 */
abstract class BaseLog extends GxActiveRecord {

	public static function model($className=__CLASS__) {
		return parent::model($className);
	}

	public function tableName() {
		return 'log';
	}

	public static function label($n = 1) {
		return Yii::t('app', 'Log|Logs', $n);
	}

	public static function representingColumn() {
		return 'category';
	}

	public function rules() {
		return array(
			array('category, message, created', 'required'),
			array('user_id', 'numerical', 'integerOnly'=>true),
			array('category', 'length', 'max'=>128),
			array('user_id', 'default', 'setOnEmpty' => true, 'value' => null),
			array('id, category, message, user_id, created', 'safe', 'on'=>'search'),
		);
	}

	public function relations() {
		return array(
			'user' => array(self::BELONGS_TO, 'User', 'user_id'),
		);
	}

	public function pivotModels() {
		return array(
		);
	}

	public function attributeLabels() {
		return array(
			'id' => Yii::t('app', 'ID'),
			'category' => Yii::t('app', 'Category'),
			'message' => Yii::t('app', 'Message'),
			'user_id' => null,
			'created' => Yii::t('app', 'Created'),
			'user' => null,
		);
	}

	public function search() {
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('category', $this->category, true);
		$criteria->compare('message', $this->message, true);
		$criteria->compare('user_id', $this->user_id);
		$criteria->compare('created', $this->created, true);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
			'pagination'=>array(
        'pageSize'=>Yii::app()->params['pagination.pageSize'],
      ),
		));
	}
}