<?php

/**
 * This is the model base class for the table "menu_item".
 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.
 * If any changes are necessary, you must set or override the required
 * property or method in class "MenuItem".
 *
 * Columns in table "menu_item" available as properties of the model,
 * followed by relations of table "menu_item" available as properties of the model.
 *
 * @property integer $id
 * @property integer $menu_id
 * @property string $name
 * @property integer $weight
 * @property integer $active
 * @property integer $special
 * @property string $lang
 * @property integer $pages_id
 * @property string $created
 * @property string $modified
 *
 * @property Page $pages
 * @property Menu $menu
 */
abstract class BaseMenuItem extends GxActiveRecord {

	public static function model($className=__CLASS__) {
		return parent::model($className);
	}

	public function tableName() {
		return 'menu_item';
	}

	public static function label($n = 1) {
		return Yii::t('app', 'MenuItem|MenuItems', $n);
	}

	public static function representingColumn() {
		return 'name';
	}

	public function rules() {
		return array(
			array('menu_id, name, pages_id, created, modified', 'required'),
			array('menu_id, weight, active, special, pages_id', 'numerical', 'integerOnly'=>true),
			array('name', 'length', 'max'=>45),
			array('lang', 'length', 'max'=>10),
			array('weight, active, special, lang', 'default', 'setOnEmpty' => true, 'value' => null),
			array('id, menu_id, name, weight, active, special, lang, pages_id, created, modified', 'safe', 'on'=>'search'),
		);
	}

	public function relations() {
		return array(
			'pages' => array(self::BELONGS_TO, 'Page', 'pages_id'),
			'menu' => array(self::BELONGS_TO, 'Menu', 'menu_id'),
		);
	}

	public function pivotModels() {
		return array(
		);
	}

	public function attributeLabels() {
		return array(
			'id' => Yii::t('app', 'ID'),
			'menu_id' => null,
			'name' => Yii::t('app', 'Name'),
			'weight' => Yii::t('app', 'Weight'),
			'active' => Yii::t('app', 'Active'),
			'special' => Yii::t('app', 'Special'),
			'lang' => Yii::t('app', 'Lang'),
			'pages_id' => null,
			'created' => Yii::t('app', 'Created'),
			'modified' => Yii::t('app', 'Modified'),
			'pages' => null,
			'menu' => null,
		);
	}

	public function search() {
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('menu_id', $this->menu_id);
		$criteria->compare('name', $this->name, true);
		$criteria->compare('weight', $this->weight);
		$criteria->compare('active', $this->active);
		$criteria->compare('special', $this->special);
		$criteria->compare('lang', $this->lang, true);
		$criteria->compare('pages_id', $this->pages_id);
		$criteria->compare('created', $this->created, true);
		$criteria->compare('modified', $this->modified, true);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
			'pagination'=>array(
        'pageSize'=>Yii::app()->params['pagination.pageSize'],
      ),
		));
	}
}