<?php

/**
 * This is the model base class for the table "session".
 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.
 * If any changes are necessary, you must set or override the required
 * property or method in class "Session".
 *
 * Columns in table "session" available as properties of the model,
 * followed by relations of table "session" available as properties of the model.
 *
 * @property integer $id
 * @property string $username
 * @property integer $ip_address
 * @property string $php_sid
 * @property string $shared_secret
 * @property integer $user_id
 * @property string $created
 * @property string $modified
 *
 * @property GamePartner[] $gamePartners
 * @property GameSubmission[] $gameSubmissions
 * @property Message $message
 * @property PlayedGame[] $playedGames
 * @property PlayedGame[] $playedGames1
 * @property User $user
 */
abstract class BaseSession extends GxActiveRecord {

	public static function model($className=__CLASS__) {
		return parent::model($className);
	}

	public function tableName() {
		return 'session';
	}

	public static function label($n = 1) {
		return Yii::t('app', 'Session|Sessions', $n);
	}

	public static function representingColumn() {
		return 'username';
	}

	public function rules() {
		return array(
			array('username, ip_address, php_sid, shared_secret, created, modified', 'required'),
			array('ip_address, user_id', 'numerical', 'integerOnly'=>true),
			array('username', 'length', 'max'=>32),
			array('php_sid, shared_secret', 'length', 'max'=>45),
			array('user_id', 'default', 'setOnEmpty' => true, 'value' => null),
			array('id, username, ip_address, php_sid, shared_secret, user_id, created, modified', 'safe', 'on'=>'search'),
		);
	}

	public function relations() {
		return array(
			'gamePartners' => array(self::HAS_MANY, 'GamePartner', 'session_id'),
			'gameSubmissions' => array(self::HAS_MANY, 'GameSubmission', 'session_id'),
			'message' => array(self::HAS_ONE, 'Message', 'session_id'),
			'playedGames' => array(self::HAS_MANY, 'PlayedGame', 'session_id_1'),
			'playedGames1' => array(self::HAS_MANY, 'PlayedGame', 'session_id_2'),
			'user' => array(self::BELONGS_TO, 'User', 'user_id'),
		);
	}

	public function pivotModels() {
		return array(
		);
	}

	public function attributeLabels() {
		return array(
			'id' => Yii::t('app', 'ID'),
			'username' => Yii::t('app', 'Username'),
			'ip_address' => Yii::t('app', 'Ip Address'),
			'php_sid' => Yii::t('app', 'Php Sid'),
			'shared_secret' => Yii::t('app', 'Shared Secret'),
			'user_id' => null,
			'created' => Yii::t('app', 'Created'),
			'modified' => Yii::t('app', 'Modified'),
			'gamePartners' => null,
			'gameSubmissions' => null,
			'message' => null,
			'playedGames' => null,
			'playedGames1' => null,
			'user' => null,
		);
	}

	public function search() {
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('username', $this->username, true);
		$criteria->compare('ip_address', $this->ip_address);
		$criteria->compare('php_sid', $this->php_sid, true);
		$criteria->compare('shared_secret', $this->shared_secret, true);
		$criteria->compare('user_id', $this->user_id);
		$criteria->compare('created', $this->created, true);
		$criteria->compare('modified', $this->modified, true);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
			'pagination'=>array(
        'pageSize'=>Yii::app()->params['pagination.pageSize'],
      ),
		));
	}
}