<?php

/**
 * This is the model base class for the table "tag".
 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.
 * If any changes are necessary, you must set or override the required
 * property or method in class "Tag".
 *
 * Columns in table "tag" available as properties of the model,
 * followed by relations of table "tag" available as properties of the model.
 *
 * @property integer $id
 * @property string $tag
 * @property string $created
 * @property string $modified
 *
 * @property TagUse[] $tagUses
 */
abstract class BaseTag extends GxActiveRecord {

	public static function model($className=__CLASS__) {
		return parent::model($className);
	}

	public function tableName() {
		return 'tag';
	}

	public static function label($n = 1) {
		return Yii::t('app', 'Tag|Tags', $n);
	}

	public static function representingColumn() {
		return 'tag';
	}

	public function rules() {
		return array(
			array('tag, created, modified', 'required'),
			array('tag', 'length', 'max'=>64),
			array('id, tag, created, modified', 'safe', 'on'=>'search'),
		);
	}

	public function relations() {
		return array(
			'tagUses' => array(self::HAS_MANY, 'TagUse', 'tag_id'),
		);
	}

	public function pivotModels() {
		return array(
		);
	}

	public function attributeLabels() {
		return array(
			'id' => Yii::t('app', 'ID'),
			'tag' => Yii::t('app', 'Tag'),
			'created' => Yii::t('app', 'Created'),
			'modified' => Yii::t('app', 'Modified'),
			'tagUses' => null,
		);
	}

	public function search() {
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('tag', $this->tag, true);
		$criteria->compare('created', $this->created, true);
		$criteria->compare('modified', $this->modified, true);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
			'pagination'=>array(
        'pageSize'=>Yii::app()->params['pagination.pageSize'],
      ),
		));
	}
}