<?php

/**
 * This is the model base class for the table "tag_original_version".
 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.
 * If any changes are necessary, you must set or override the required
 * property or method in class "TagOriginalVersion".
 *
 * Columns in table "tag_original_version" available as properties of the model,
 * followed by relations of table "tag_original_version" available as properties of the model.
 *
 * @property integer $id
 * @property string $original_tag
 * @property integer $tag_uses_id
 * @property integer $by_editor
 * @property string $comments
 *
 * @property TagUse $tagUses
 */
abstract class BaseTagOriginalVersion extends GxActiveRecord {

	public static function model($className=__CLASS__) {
		return parent::model($className);
	}

	public function tableName() {
		return 'tag_original_version';
	}

	public static function label($n = 1) {
		return Yii::t('app', 'TagOriginalVersion|TagOriginalVersions', $n);
	}

	public static function representingColumn() {
		return 'original_tag';
	}

	public function rules() {
		return array(
			array('id, tag_uses_id', 'required'),
			array('id, tag_uses_id, by_editor', 'numerical', 'integerOnly'=>true),
			array('original_tag', 'length', 'max'=>64),
			array('comments', 'safe'),
			array('original_tag, by_editor, comments', 'default', 'setOnEmpty' => true, 'value' => null),
			array('id, original_tag, tag_uses_id, by_editor, comments', 'safe', 'on'=>'search'),
		);
	}

	public function relations() {
		return array(
			'tagUses' => array(self::BELONGS_TO, 'TagUse', 'tag_uses_id'),
		);
	}

	public function pivotModels() {
		return array(
		);
	}

	public function attributeLabels() {
		return array(
			'id' => Yii::t('app', 'ID'),
			'original_tag' => Yii::t('app', 'Original Tag'),
			'tag_uses_id' => null,
			'by_editor' => Yii::t('app', 'By Editor'),
			'comments' => Yii::t('app', 'Comments'),
			'tagUses' => null,
		);
	}

	public function search() {
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('original_tag', $this->original_tag, true);
		$criteria->compare('tag_uses_id', $this->tag_uses_id);
		$criteria->compare('by_editor', $this->by_editor);
		$criteria->compare('comments', $this->comments, true);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
			'pagination'=>array(
        'pageSize'=>Yii::app()->params['pagination.pageSize'],
      ),
		));
	}
}