<?php

/**
 * This is the model base class for the table "user_to_game".
 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.
 * If any changes are necessary, you must set or override the required
 * property or method in class "UserToGame".
 *
 * Columns in table "user_to_game" available as properties of the model,
 * and there are no model relations.
 *
 * @property integer $user_id
 * @property integer $game_id
 * @property integer $score
 * @property integer $number_played
 *
 */
abstract class BaseUserToGame extends GxActiveRecord {

	public static function model($className=__CLASS__) {
		return parent::model($className);
	}

	public function tableName() {
		return 'user_to_game';
	}

	public static function label($n = 1) {
		return Yii::t('app', 'UserToGame|UserToGames', $n);
	}

	public static function representingColumn() {
		return array(
			'user_id',
			'game_id',
		);
	}

	public function rules() {
		return array(
			array('user_id, game_id', 'required'),
			array('user_id, game_id, score, number_played', 'numerical', 'integerOnly'=>true),
			array('score, number_played', 'default', 'setOnEmpty' => true, 'value' => null),
			array('user_id, game_id, score, number_played', 'safe', 'on'=>'search'),
		);
	}

	public function relations() {
		return array(
		);
	}

	public function pivotModels() {
		return array(
		);
	}

	public function attributeLabels() {
		return array(
			'user_id' => null,
			'game_id' => null,
			'score' => Yii::t('app', 'Score'),
			'number_played' => Yii::t('app', 'Number Played'),
		);
	}

	public function search() {
		$criteria = new CDbCriteria;

		$criteria->compare('user_id', $this->user_id);
		$criteria->compare('game_id', $this->game_id);
		$criteria->compare('score', $this->score);
		$criteria->compare('number_played', $this->number_played);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
			'pagination'=>array(
        'pageSize'=>Yii::app()->params['pagination.pageSize'],
      ),
		));
	}
}