<?php

/**
 * This is the model base class for the table "user_to_subject_matter".
 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.
 * If any changes are necessary, you must set or override the required
 * property or method in class "UserToSubjectMatter".
 *
 * Columns in table "user_to_subject_matter" available as properties of the model,
 * and there are no model relations.
 *
 * @property integer $user_id
 * @property integer $subject_matter_id
 * @property integer $trust
 * @property integer $expertise
 * @property integer $interest
 *
 */
abstract class BaseUserToSubjectMatter extends GxActiveRecord {

	public static function model($className=__CLASS__) {
		return parent::model($className);
	}

	public function tableName() {
		return 'user_to_subject_matter';
	}

	public static function label($n = 1) {
		return Yii::t('app', 'UserToSubjectMatter|UserToSubjectMatters', $n);
	}

	public static function representingColumn() {
		return array(
			'user_id',
			'subject_matter_id',
		);
	}

	public function rules() {
		return array(
			array('user_id, subject_matter_id', 'required'),
			array('user_id, subject_matter_id, trust, expertise, interest', 'numerical', 'integerOnly'=>true),
			array('trust, expertise, interest', 'default', 'setOnEmpty' => true, 'value' => null),
			array('user_id, subject_matter_id, trust, expertise, interest', 'safe', 'on'=>'search'),
		);
	}

	public function relations() {
		return array(
		);
	}

	public function pivotModels() {
		return array(
		);
	}

	public function attributeLabels() {
		return array(
			'user_id' => null,
			'subject_matter_id' => null,
			'trust' => Yii::t('app', 'Trust'),
			'expertise' => Yii::t('app', 'Expertise'),
			'interest' => Yii::t('app', 'Interest'),
		);
	}

	public function search() {
		$criteria = new CDbCriteria;

		$criteria->compare('user_id', $this->user_id);
		$criteria->compare('subject_matter_id', $this->subject_matter_id);
		$criteria->compare('trust', $this->trust);
		$criteria->compare('expertise', $this->expertise);
		$criteria->compare('interest', $this->interest);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
			'pagination'=>array(
        'pageSize'=>Yii::app()->params['pagination.pageSize'],
      ),
		));
	}
}