<?php

/**
 * This is the model base class for the table "stop_word".
 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.
 * If any changes are necessary, you must set or override the required
 * property or method in class "StopWord".
 *
 * Columns in table "stop_word" available as properties of the model,
 * and there are no model relations.
 *
 * @property integer $id
 * @property string $word
 * @property string $counter
 * @property integer $active
 * @property string $created
 * @property string $modified
 *
 */
abstract class BaseStopWord extends GxActiveRecord {

	public static function model($className=__CLASS__) {
		return parent::model($className);
	}

	public function tableName() {
		return 'stop_word';
	}

	public static function label($n = 1) {
		return Yii::t('app', 'StopWord|StopWords', $n);
	}

	public static function representingColumn() {
		return 'word';
	}

	public function rules() {
		return array(
			array('word, created, modified', 'required'),
			array('active', 'numerical', 'integerOnly'=>true),
			array('word', 'length', 'max'=>64),
			array('counter', 'length', 'max'=>10),
			array('counter, active', 'default', 'setOnEmpty' => true, 'value' => null),
			array('id, word, counter, active, created, modified', 'safe', 'on'=>'search'),
		);
	}

	public function relations() {
		return array(
		);
	}

	public function pivotModels() {
		return array(
		);
	}

	public function attributeLabels() {
		return array(
			'id' => Yii::t('app', 'ID'),
			'word' => Yii::t('app', 'Word'),
			'counter' => Yii::t('app', 'Counter'),
			'active' => Yii::t('app', 'Active'),
			'created' => Yii::t('app', 'Created'),
			'modified' => Yii::t('app', 'Modified'),
		);
	}

	public function search() {
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('word', $this->word, true);
		$criteria->compare('counter', $this->counter, true);
		$criteria->compare('active', $this->active);
		$criteria->compare('created', $this->created, true);
		$criteria->compare('modified', $this->modified, true);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
			'pagination'=>array(
        'pageSize'=>Yii::app()->params['pagination.pageSize'],
      ),
		));
	}
}