---
id: schema-def
title: Introduction
---

## Quick Summary

Schema describes the definition of one entity type in the graph, like `User` or `Group`,
and can contain the following configurations:
- Entity fields (or properties), like: name or age of a `User`.
- Entity edges (or relations), like: `User`'s groups, or `User`'s friends.
- Database specific options, like: indexes or unique indexes.

<br/>
Here's an example of a schema:

```go
package schema

import (
	"github.com/facebook/ent"
	"github.com/facebook/ent/schema/field"
	"github.com/facebook/ent/schema/edge"
	"github.com/facebook/ent/schema/index"
)

type User struct {
	ent.Schema
}

func (User) Fields() []ent.Field {
	return []ent.Field{
		field.Int("age"),
		field.String("name"),
		field.String("nickname").
			Unique(),
	}
}

func (User) Edges() []ent.Edge {
	return []ent.Edge{
		edge.To("groups", Group.Type),
		edge.To("friends", User.Type),
	}
}

func (User) Index() []ent.Index {
	return []ent.Index{
		index.Fields("age", "name").
			Unique(),
	}
}
```

Entity schemas are usually stored inside `ent/schema` directory under
the root directory of your project, and can be generated by `entc` as follows:

```console
entc init User Group
```

## It's Just Another ORM

If you are used to the definition of relations over edges, that's fine.
The modeling is the same. You can model with `ent` whatever you can model
with other traditional ORMs.
There are many examples in this website that can help you get started
in the [Edges](schema-edges.md) section.
