// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by entc, DO NOT EDIT.

package ent

import (
	"fmt"
	"strings"

	"github.com/facebook/ent/entc/integration/customid/ent/blob"
	"github.com/google/uuid"
)

// Blob is the model entity for the Blob schema.
type Blob struct {
	config `json:"-"`
	// ID of the ent.
	ID uuid.UUID `json:"id,omitempty"`
	// UUID holds the value of the "uuid" field.
	UUID uuid.UUID `json:"uuid,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the BlobQuery when eager-loading is set.
	Edges       BlobEdges `json:"edges"`
	blob_parent *uuid.UUID
}

// BlobEdges holds the relations/edges for other nodes in the graph.
type BlobEdges struct {
	// Parent holds the value of the parent edge.
	Parent *Blob
	// Links holds the value of the links edge.
	Links []*Blob
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [2]bool
}

// ParentOrErr returns the Parent value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e BlobEdges) ParentOrErr() (*Blob, error) {
	if e.loadedTypes[0] {
		if e.Parent == nil {
			// The edge parent was loaded in eager-loading,
			// but was not found.
			return nil, &NotFoundError{label: blob.Label}
		}
		return e.Parent, nil
	}
	return nil, &NotLoadedError{edge: "parent"}
}

// LinksOrErr returns the Links value or an error if the edge
// was not loaded in eager-loading.
func (e BlobEdges) LinksOrErr() ([]*Blob, error) {
	if e.loadedTypes[1] {
		return e.Links, nil
	}
	return nil, &NotLoadedError{edge: "links"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*Blob) scanValues() []interface{} {
	return []interface{}{
		&uuid.UUID{}, // id
		&uuid.UUID{}, // uuid
	}
}

// fkValues returns the types for scanning foreign-keys values from sql.Rows.
func (*Blob) fkValues() []interface{} {
	return []interface{}{
		&uuid.UUID{}, // blob_parent
	}
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the Blob fields.
func (b *Blob) assignValues(values ...interface{}) error {
	if m, n := len(values), len(blob.Columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	if value, ok := values[0].(*uuid.UUID); !ok {
		return fmt.Errorf("unexpected type %T for field id", values[0])
	} else if value != nil {
		b.ID = *value
	}
	values = values[1:]
	if value, ok := values[0].(*uuid.UUID); !ok {
		return fmt.Errorf("unexpected type %T for field uuid", values[0])
	} else if value != nil {
		b.UUID = *value
	}
	values = values[1:]
	if len(values) == len(blob.ForeignKeys) {
		if value, ok := values[0].(*uuid.UUID); !ok {
			return fmt.Errorf("unexpected type %T for field blob_parent", values[0])
		} else if value != nil {
			b.blob_parent = value
		}
	}
	return nil
}

// QueryParent queries the parent edge of the Blob.
func (b *Blob) QueryParent() *BlobQuery {
	return (&BlobClient{config: b.config}).QueryParent(b)
}

// QueryLinks queries the links edge of the Blob.
func (b *Blob) QueryLinks() *BlobQuery {
	return (&BlobClient{config: b.config}).QueryLinks(b)
}

// Update returns a builder for updating this Blob.
// Note that, you need to call Blob.Unwrap() before calling this method, if this Blob
// was returned from a transaction, and the transaction was committed or rolled back.
func (b *Blob) Update() *BlobUpdateOne {
	return (&BlobClient{config: b.config}).UpdateOne(b)
}

// Unwrap unwraps the entity that was returned from a transaction after it was closed,
// so that all next queries will be executed through the driver which created the transaction.
func (b *Blob) Unwrap() *Blob {
	tx, ok := b.config.driver.(*txDriver)
	if !ok {
		panic("ent: Blob is not a transactional entity")
	}
	b.config.driver = tx.drv
	return b
}

// String implements the fmt.Stringer.
func (b *Blob) String() string {
	var builder strings.Builder
	builder.WriteString("Blob(")
	builder.WriteString(fmt.Sprintf("id=%v", b.ID))
	builder.WriteString(", uuid=")
	builder.WriteString(fmt.Sprintf("%v", b.UUID))
	builder.WriteByte(')')
	return builder.String()
}

// Blobs is a parsable slice of Blob.
type Blobs []*Blob

func (b Blobs) config(cfg config) {
	for _i := range b {
		b[_i].config = cfg
	}
}
