// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by entc, DO NOT EDIT.

package entv2

import (
	"fmt"
	"strings"

	"github.com/facebook/ent/dialect/sql"
	"github.com/facebook/ent/entc/integration/migrate/entv2/pet"
	"github.com/facebook/ent/entc/integration/migrate/entv2/user"
)

// User is the model entity for the User schema.
type User struct {
	config `json:"-"`
	// ID of the ent.
	ID int `json:"id,omitempty"`
	// MixedString holds the value of the "mixed_string" field.
	MixedString string `json:"mixed_string,omitempty"`
	// MixedEnum holds the value of the "mixed_enum" field.
	MixedEnum user.MixedEnum `json:"mixed_enum,omitempty"`
	// Age holds the value of the "age" field.
	Age int `json:"age,omitempty"`
	// Name holds the value of the "name" field.
	Name string `json:"name,omitempty"`
	// Nickname holds the value of the "nickname" field.
	Nickname string `json:"nickname,omitempty"`
	// Phone holds the value of the "phone" field.
	Phone string `json:"phone,omitempty"`
	// Buffer holds the value of the "buffer" field.
	Buffer []byte `json:"buffer,omitempty"`
	// Title holds the value of the "title" field.
	Title string `json:"title,omitempty"`
	// NewName holds the value of the "new_name" field.
	NewName string `json:"new_name,omitempty"`
	// Blob holds the value of the "blob" field.
	Blob []byte `json:"blob,omitempty"`
	// State holds the value of the "state" field.
	State user.State `json:"state,omitempty"`
	// Status holds the value of the "status" field.
	Status user.Status `json:"status,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the UserQuery when eager-loading is set.
	Edges UserEdges `json:"edges"`
}

// UserEdges holds the relations/edges for other nodes in the graph.
type UserEdges struct {
	// Car holds the value of the car edge.
	Car []*Car
	// Pets holds the value of the pets edge.
	Pets *Pet
	// Friends holds the value of the friends edge.
	Friends []*User
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [3]bool
}

// CarOrErr returns the Car value or an error if the edge
// was not loaded in eager-loading.
func (e UserEdges) CarOrErr() ([]*Car, error) {
	if e.loadedTypes[0] {
		return e.Car, nil
	}
	return nil, &NotLoadedError{edge: "car"}
}

// PetsOrErr returns the Pets value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e UserEdges) PetsOrErr() (*Pet, error) {
	if e.loadedTypes[1] {
		if e.Pets == nil {
			// The edge pets was loaded in eager-loading,
			// but was not found.
			return nil, &NotFoundError{label: pet.Label}
		}
		return e.Pets, nil
	}
	return nil, &NotLoadedError{edge: "pets"}
}

// FriendsOrErr returns the Friends value or an error if the edge
// was not loaded in eager-loading.
func (e UserEdges) FriendsOrErr() ([]*User, error) {
	if e.loadedTypes[2] {
		return e.Friends, nil
	}
	return nil, &NotLoadedError{edge: "friends"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*User) scanValues() []interface{} {
	return []interface{}{
		&sql.NullInt64{},  // id
		&sql.NullString{}, // mixed_string
		&sql.NullString{}, // mixed_enum
		&sql.NullInt64{},  // age
		&sql.NullString{}, // name
		&sql.NullString{}, // nickname
		&sql.NullString{}, // phone
		&[]byte{},         // buffer
		&sql.NullString{}, // title
		&sql.NullString{}, // new_name
		&[]byte{},         // blob
		&sql.NullString{}, // state
		&sql.NullString{}, // status
	}
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the User fields.
func (u *User) assignValues(values ...interface{}) error {
	if m, n := len(values), len(user.Columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	value, ok := values[0].(*sql.NullInt64)
	if !ok {
		return fmt.Errorf("unexpected type %T for field id", value)
	}
	u.ID = int(value.Int64)
	values = values[1:]
	if value, ok := values[0].(*sql.NullString); !ok {
		return fmt.Errorf("unexpected type %T for field mixed_string", values[0])
	} else if value.Valid {
		u.MixedString = value.String
	}
	if value, ok := values[1].(*sql.NullString); !ok {
		return fmt.Errorf("unexpected type %T for field mixed_enum", values[1])
	} else if value.Valid {
		u.MixedEnum = user.MixedEnum(value.String)
	}
	if value, ok := values[2].(*sql.NullInt64); !ok {
		return fmt.Errorf("unexpected type %T for field age", values[2])
	} else if value.Valid {
		u.Age = int(value.Int64)
	}
	if value, ok := values[3].(*sql.NullString); !ok {
		return fmt.Errorf("unexpected type %T for field name", values[3])
	} else if value.Valid {
		u.Name = value.String
	}
	if value, ok := values[4].(*sql.NullString); !ok {
		return fmt.Errorf("unexpected type %T for field nickname", values[4])
	} else if value.Valid {
		u.Nickname = value.String
	}
	if value, ok := values[5].(*sql.NullString); !ok {
		return fmt.Errorf("unexpected type %T for field phone", values[5])
	} else if value.Valid {
		u.Phone = value.String
	}
	if value, ok := values[6].(*[]byte); !ok {
		return fmt.Errorf("unexpected type %T for field buffer", values[6])
	} else if value != nil {
		u.Buffer = *value
	}
	if value, ok := values[7].(*sql.NullString); !ok {
		return fmt.Errorf("unexpected type %T for field title", values[7])
	} else if value.Valid {
		u.Title = value.String
	}
	if value, ok := values[8].(*sql.NullString); !ok {
		return fmt.Errorf("unexpected type %T for field new_name", values[8])
	} else if value.Valid {
		u.NewName = value.String
	}
	if value, ok := values[9].(*[]byte); !ok {
		return fmt.Errorf("unexpected type %T for field blob", values[9])
	} else if value != nil {
		u.Blob = *value
	}
	if value, ok := values[10].(*sql.NullString); !ok {
		return fmt.Errorf("unexpected type %T for field state", values[10])
	} else if value.Valid {
		u.State = user.State(value.String)
	}
	if value, ok := values[11].(*sql.NullString); !ok {
		return fmt.Errorf("unexpected type %T for field status", values[11])
	} else if value.Valid {
		u.Status = user.Status(value.String)
	}
	return nil
}

// QueryCar queries the car edge of the User.
func (u *User) QueryCar() *CarQuery {
	return (&UserClient{config: u.config}).QueryCar(u)
}

// QueryPets queries the pets edge of the User.
func (u *User) QueryPets() *PetQuery {
	return (&UserClient{config: u.config}).QueryPets(u)
}

// QueryFriends queries the friends edge of the User.
func (u *User) QueryFriends() *UserQuery {
	return (&UserClient{config: u.config}).QueryFriends(u)
}

// Update returns a builder for updating this User.
// Note that, you need to call User.Unwrap() before calling this method, if this User
// was returned from a transaction, and the transaction was committed or rolled back.
func (u *User) Update() *UserUpdateOne {
	return (&UserClient{config: u.config}).UpdateOne(u)
}

// Unwrap unwraps the entity that was returned from a transaction after it was closed,
// so that all next queries will be executed through the driver which created the transaction.
func (u *User) Unwrap() *User {
	tx, ok := u.config.driver.(*txDriver)
	if !ok {
		panic("entv2: User is not a transactional entity")
	}
	u.config.driver = tx.drv
	return u
}

// String implements the fmt.Stringer.
func (u *User) String() string {
	var builder strings.Builder
	builder.WriteString("User(")
	builder.WriteString(fmt.Sprintf("id=%v", u.ID))
	builder.WriteString(", mixed_string=")
	builder.WriteString(u.MixedString)
	builder.WriteString(", mixed_enum=")
	builder.WriteString(fmt.Sprintf("%v", u.MixedEnum))
	builder.WriteString(", age=")
	builder.WriteString(fmt.Sprintf("%v", u.Age))
	builder.WriteString(", name=")
	builder.WriteString(u.Name)
	builder.WriteString(", nickname=")
	builder.WriteString(u.Nickname)
	builder.WriteString(", phone=")
	builder.WriteString(u.Phone)
	builder.WriteString(", buffer=")
	builder.WriteString(fmt.Sprintf("%v", u.Buffer))
	builder.WriteString(", title=")
	builder.WriteString(u.Title)
	builder.WriteString(", new_name=")
	builder.WriteString(u.NewName)
	builder.WriteString(", blob=")
	builder.WriteString(fmt.Sprintf("%v", u.Blob))
	builder.WriteString(", state=")
	builder.WriteString(fmt.Sprintf("%v", u.State))
	builder.WriteString(", status=")
	builder.WriteString(fmt.Sprintf("%v", u.Status))
	builder.WriteByte(')')
	return builder.String()
}

// Users is a parsable slice of User.
type Users []*User

func (u Users) config(cfg config) {
	for _i := range u {
		u[_i].config = cfg
	}
}
