// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by entc, DO NOT EDIT.

package galaxy

import (
	"fmt"

	"github.com/facebook/ent"
)

const (
	// Label holds the string label denoting the galaxy type in the database.
	Label = "galaxy"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldName holds the string denoting the name field in the database.
	FieldName = "name"
	// FieldType holds the string denoting the type field in the database.
	FieldType = "type"

	// EdgePlanets holds the string denoting the planets edge name in mutations.
	EdgePlanets = "planets"

	// Table holds the table name of the galaxy in the database.
	Table = "galaxies"
	// PlanetsTable is the table the holds the planets relation/edge.
	PlanetsTable = "planets"
	// PlanetsInverseTable is the table name for the Planet entity.
	// It exists in this package in order to avoid circular dependency with the "planet" package.
	PlanetsInverseTable = "planets"
	// PlanetsColumn is the table column denoting the planets relation/edge.
	PlanetsColumn = "galaxy_planets"
)

// Columns holds all SQL columns for galaxy fields.
var Columns = []string{
	FieldID,
	FieldName,
	FieldType,
}

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	return false
}

// Note that the variables below are initialized by the runtime
// package on the initialization of the application. Therefore,
// it should be imported in the main as follows:
//
//	import _ "github.com/facebook/ent/entc/integration/privacy/ent/runtime"
//
var (
	Hooks  [1]ent.Hook
	Policy ent.Policy
	// NameValidator is a validator for the "name" field. It is called by the builders before save.
	NameValidator func(string) error
)

// Type defines the type for the type enum field.
type Type string

// Type values.
const (
	TypeSpiral       Type = "spiral"
	TypeBarredSpiral Type = "barred_spiral"
	TypeElliptical   Type = "elliptical"
	TypeIrregular    Type = "irregular"
)

func (_type Type) String() string {
	return string(_type)
}

// TypeValidator is a validator for the "type" field enum values. It is called by the builders before save.
func TypeValidator(_type Type) error {
	switch _type {
	case TypeSpiral, TypeBarredSpiral, TypeElliptical, TypeIrregular:
		return nil
	default:
		return fmt.Errorf("galaxy: invalid enum value for type field: %q", _type)
	}
}
