// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by entc, DO NOT EDIT.

package planet

import (
	"github.com/facebook/ent"
)

const (
	// Label holds the string label denoting the planet type in the database.
	Label = "planet"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldName holds the string denoting the name field in the database.
	FieldName = "name"
	// FieldAge holds the string denoting the age field in the database.
	FieldAge = "age"

	// EdgeNeighbors holds the string denoting the neighbors edge name in mutations.
	EdgeNeighbors = "neighbors"

	// Table holds the table name of the planet in the database.
	Table = "planets"
	// NeighborsTable is the table the holds the neighbors relation/edge. The primary key declared below.
	NeighborsTable = "planet_neighbors"
)

// Columns holds all SQL columns for planet fields.
var Columns = []string{
	FieldID,
	FieldName,
	FieldAge,
}

// ForeignKeys holds the SQL foreign-keys that are owned by the Planet type.
var ForeignKeys = []string{
	"galaxy_planets",
}

var (
	// NeighborsPrimaryKey and NeighborsColumn2 are the table columns denoting the
	// primary key for the neighbors relation (M2M).
	NeighborsPrimaryKey = []string{"planet_id", "neighbor_id"}
)

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	for i := range ForeignKeys {
		if column == ForeignKeys[i] {
			return true
		}
	}
	return false
}

// Note that the variables below are initialized by the runtime
// package on the initialization of the application. Therefore,
// it should be imported in the main as follows:
//
//	import _ "github.com/facebook/ent/entc/integration/privacy/ent/runtime"
//
var (
	Hooks  [2]ent.Hook
	Policy ent.Policy
	// NameValidator is a validator for the "name" field. It is called by the builders before save.
	NameValidator func(string) error
)
