/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp.iobalancer;

import com.hazelcast.instance.HazelcastThreadGroup;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.tcp.IOSelector;
import com.hazelcast.nio.tcp.InSelectorImpl;
import com.hazelcast.nio.tcp.MigratableHandler;
import com.hazelcast.nio.tcp.OutSelectorImpl;
import com.hazelcast.nio.tcp.ReadHandler;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.nio.tcp.WriteHandler;
import com.hazelcast.nio.tcp.iobalancer.EventCountBasicMigrationStrategy;
import com.hazelcast.nio.tcp.iobalancer.IOBalancerThread;
import com.hazelcast.nio.tcp.iobalancer.LoadImbalance;
import com.hazelcast.nio.tcp.iobalancer.LoadTracker;
import com.hazelcast.nio.tcp.iobalancer.MigrationStrategy;
import com.hazelcast.nio.tcp.iobalancer.MonkeyMigrationStrategy;

public class IOBalancer {
    private static final String PROP_MONKEY_BALANCER = "hazelcast.io.balancer.monkey";
    private final ILogger log;
    private final int migrationIntervalSeconds;
    private final MigrationStrategy strategy;
    private final LoadTracker inLoadTracker;
    private final LoadTracker outLoadTracker;
    private final HazelcastThreadGroup threadGroup;
    private volatile boolean enabled;
    private IOBalancerThread ioBalancerThread;

    public IOBalancer(InSelectorImpl[] inSelectors, OutSelectorImpl[] outSelectors, HazelcastThreadGroup threadGroup, int migrationIntervalSeconds, LoggingService loggingService) {
        this.log = loggingService.getLogger(IOBalancer.class);
        this.migrationIntervalSeconds = migrationIntervalSeconds;
        this.strategy = this.createMigrationStrategy();
        this.threadGroup = threadGroup;
        this.inLoadTracker = new LoadTracker(inSelectors, loggingService);
        this.outLoadTracker = new LoadTracker(outSelectors, loggingService);
        this.enabled = this.isEnabled(inSelectors, outSelectors);
    }

    LoadTracker getInLoadTracker() {
        return this.inLoadTracker;
    }

    LoadTracker getOutLoadTracker() {
        return this.outLoadTracker;
    }

    public void connectionAdded(Connection connection) {
        if (!(connection instanceof TcpIpConnection)) {
            return;
        }
        ReadHandler readHandler = ((TcpIpConnection)connection).getReadHandler();
        WriteHandler writeHandler = ((TcpIpConnection)connection).getWriteHandler();
        if (this.log.isFinestEnabled()) {
            this.log.finest("Connection " + connection + " uses read handler " + readHandler + " and write handler " + writeHandler);
        }
        this.inLoadTracker.addHandler(readHandler);
        this.outLoadTracker.addHandler(writeHandler);
    }

    public void connectionRemoved(Connection connection) {
        if (!(connection instanceof TcpIpConnection)) {
            return;
        }
        ReadHandler readHandler = ((TcpIpConnection)connection).getReadHandler();
        if (this.log.isFinestEnabled()) {
            this.log.finest("Removing a read handler " + readHandler);
        }
        this.inLoadTracker.removeHandler(readHandler);
        WriteHandler writeHandler = ((TcpIpConnection)connection).getWriteHandler();
        if (this.log.isFinestEnabled()) {
            this.log.finest("Removing a write handler " + readHandler);
        }
        this.outLoadTracker.removeHandler(writeHandler);
    }

    public void stop() {
        if (this.ioBalancerThread != null) {
            this.ioBalancerThread.interrupt();
        }
    }

    public void start() {
        if (this.enabled) {
            this.ioBalancerThread = new IOBalancerThread(this, this.migrationIntervalSeconds, this.threadGroup, this.log);
            this.ioBalancerThread.start();
        }
    }

    void checkWriteHandlers() {
        this.scheduleMigrationIfNeeded(this.outLoadTracker);
    }

    void checkReadHandlers() {
        this.scheduleMigrationIfNeeded(this.inLoadTracker);
    }

    private void scheduleMigrationIfNeeded(LoadTracker loadTracker) {
        LoadImbalance loadImbalance = loadTracker.updateImbalance();
        if (this.strategy.imbalanceDetected(loadImbalance)) {
            this.tryMigrate(loadImbalance);
        } else if (this.log.isFinestEnabled()) {
            long min = loadImbalance.minimumEvents;
            long max = loadImbalance.maximumEvents;
            this.log.finest("No imbalance has been detected. Max. events: " + max + " Min events: " + min + ".");
        }
    }

    private MigrationStrategy createMigrationStrategy() {
        MigrationStrategy strategy;
        if (Boolean.getBoolean(PROP_MONKEY_BALANCER)) {
            this.log.warning("Using Monkey IO Balancer Strategy. This is for stress tests only. Do not user in production! Disable by not setting the property 'hazelcast.io.balancer.monkey' to true.");
            strategy = new MonkeyMigrationStrategy();
        } else {
            this.log.finest("Using normal IO Balancer Strategy.");
            strategy = new EventCountBasicMigrationStrategy();
        }
        return strategy;
    }

    private boolean isEnabled(InSelectorImpl[] inSelectors, OutSelectorImpl[] outSelectors) {
        if (this.migrationIntervalSeconds < 0) {
            if (this.log.isFinestEnabled()) {
                this.log.finest("I/O Balancer is disabled as the 'hazelcast.io.balancer.interval.seconds' property is set to " + this.migrationIntervalSeconds + ". Set the property to a positive value to enable I/O Balancer.");
            }
            return false;
        }
        if (inSelectors.length == 1 && outSelectors.length == 1) {
            this.log.finest("I/O Balancer is disabled as there is only a single a pair of I/O threads. Use the 'hazelcast.io.thread.count' property to increase number of I/O Threads.");
            return false;
        }
        return true;
    }

    private void tryMigrate(LoadImbalance loadImbalance) {
        MigratableHandler handler = this.strategy.findHandlerToMigrate(loadImbalance);
        if (handler == null) {
            this.log.finest("There had been I/O imbalance detected, but no suitable migration candidate was found.");
            return;
        }
        IOSelector destinationSelector = loadImbalance.destinationSelector;
        if (this.log.isFinestEnabled()) {
            IOSelector sourceSelector = loadImbalance.sourceSelector;
            this.log.finest("Scheduling a migration of a handler " + handler + " from a selector thread " + sourceSelector + " to " + destinationSelector);
        }
        handler.requestMigration(destinationSelector);
    }
}

