/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import dagger.Binds;
import dagger.Module;
import dagger.internal.codegen.Validation;
import dagger.internal.codegen.ValidationReport;
import dagger.producers.ProducerModule;
import dagger.shaded.auto.common.MoreElements;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

final class BindsMethodValidator {
    private final Elements elements;
    private final Types types;
    private final LoadingCache<ExecutableElement, ValidationReport<ExecutableElement>> validationCache;

    BindsMethodValidator(Elements elements, Types types) {
        this.elements = (Elements)Preconditions.checkNotNull((Object)elements);
        this.types = (Types)Preconditions.checkNotNull((Object)types);
        this.validationCache = CacheBuilder.newBuilder().build((CacheLoader)new ValidationLoader());
    }

    ValidationReport<ExecutableElement> validate(ExecutableElement bindsMethodElement) {
        return (ValidationReport)this.validationCache.getUnchecked((Object)bindsMethodElement);
    }

    private String formatErrorMessage(String msg) {
        return String.format(msg, Binds.class.getSimpleName());
    }

    private String formatErrorMessage(String msg, String parameter) {
        return String.format(msg, Binds.class.getSimpleName(), parameter);
    }

    private final class ValidationLoader
    extends CacheLoader<ExecutableElement, ValidationReport<ExecutableElement>> {
        private ValidationLoader() {
        }

        public ValidationReport<ExecutableElement> load(ExecutableElement bindsMethodElement) {
            Set<Modifier> modifiers;
            ValidationReport.Builder<ExecutableElement> builder = ValidationReport.about(bindsMethodElement);
            Preconditions.checkArgument((boolean)MoreElements.isAnnotationPresent(bindsMethodElement, Binds.class));
            Element enclosingElement = bindsMethodElement.getEnclosingElement();
            if (!MoreElements.isAnnotationPresent(enclosingElement, Module.class) && !MoreElements.isAnnotationPresent(enclosingElement, ProducerModule.class)) {
                builder.addError(BindsMethodValidator.this.formatErrorMessage("@%s methods can only be present within a @%s", String.format("%s or @%s", Module.class.getSimpleName(), ProducerModule.class.getSimpleName())), bindsMethodElement);
            }
            if (!bindsMethodElement.getTypeParameters().isEmpty()) {
                builder.addError(BindsMethodValidator.this.formatErrorMessage("@%s methods may not have type parameters."), bindsMethodElement);
            }
            if (!(modifiers = bindsMethodElement.getModifiers()).contains((Object)Modifier.ABSTRACT)) {
                builder.addError(BindsMethodValidator.this.formatErrorMessage("@Bind methods must be abstract"), bindsMethodElement);
            }
            TypeMirror returnType = bindsMethodElement.getReturnType();
            Validation.validateReturnType(Binds.class, builder, returnType);
            List<? extends VariableElement> parameters = bindsMethodElement.getParameters();
            if (parameters.size() == 1) {
                VariableElement parameter = (VariableElement)Iterables.getOnlyElement(parameters);
                if (!BindsMethodValidator.this.types.isAssignable(parameter.asType(), returnType)) {
                    builder.addError(BindsMethodValidator.this.formatErrorMessage("@Bind methods must have only one parameter whose type is assignable to the return type"), bindsMethodElement);
                }
            } else {
                builder.addError(BindsMethodValidator.this.formatErrorMessage("@Bind methods must have only one parameter whose type is assignable to the return type"), bindsMethodElement);
            }
            Validation.validateUncheckedThrows(BindsMethodValidator.this.elements, BindsMethodValidator.this.types, bindsMethodElement, Binds.class, builder);
            Validation.validateMethodQualifiers(builder, bindsMethodElement);
            return builder.build();
        }
    }
}

