/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import dagger.Lazy;
import dagger.MembersInjector;
import dagger.internal.codegen.AutoValue_DependencyRequest;
import dagger.internal.codegen.AutoValue_DependencyRequest_Factory_KindAndType;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.Key;
import dagger.producers.Produced;
import dagger.producers.Producer;
import dagger.producers.internal.AbstractProducer;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.List;
import javax.inject.Provider;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor7;

abstract class DependencyRequest {
    static final Function<DependencyRequest, BindingKey> BINDING_KEY_FUNCTION = new Function<DependencyRequest, BindingKey>(){

        public BindingKey apply(DependencyRequest request) {
            return request.bindingKey();
        }
    };

    DependencyRequest() {
    }

    abstract Kind kind();

    abstract Key key();

    BindingKey bindingKey() {
        switch (this.kind()) {
            case INSTANCE: 
            case LAZY: 
            case PROVIDER: 
            case PROVIDER_OF_LAZY: 
            case PRODUCER: 
            case PRODUCED: 
            case FUTURE: {
                return BindingKey.create(BindingKey.Kind.CONTRIBUTION, this.key());
            }
            case MEMBERS_INJECTOR: {
                return BindingKey.create(BindingKey.Kind.MEMBERS_INJECTION, this.key());
            }
        }
        throw new AssertionError();
    }

    abstract Element requestElement();

    DeclaredType enclosingType() {
        return (DeclaredType)this.wrappedEnclosingType().get();
    }

    abstract Equivalence.Wrapper<DeclaredType> wrappedEnclosingType();

    abstract boolean isNullable();

    abstract Optional<String> overriddenVariableName();

    static final class Factory {
        private final Elements elements;
        private final Key.Factory keyFactory;

        Factory(Elements elements, Key.Factory keyFactory) {
            this.elements = elements;
            this.keyFactory = keyFactory;
        }

        ImmutableSet<DependencyRequest> forRequiredResolvedVariables(DeclaredType container, List<? extends VariableElement> variables, List<? extends TypeMirror> resolvedTypes) {
            Preconditions.checkState((resolvedTypes.size() == variables.size() ? 1 : 0) != 0);
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (int i = 0; i < variables.size(); ++i) {
                builder.add((Object)this.forRequiredResolvedVariable(container, variables.get(i), resolvedTypes.get(i)));
            }
            return builder.build();
        }

        ImmutableSet<DependencyRequest> forRequiredVariables(List<? extends VariableElement> variables) {
            return FluentIterable.from(variables).transform((Function)new Function<VariableElement, DependencyRequest>(){

                public DependencyRequest apply(VariableElement input) {
                    return Factory.this.forRequiredVariable(input);
                }
            }).toSet();
        }

        DependencyRequest forImplicitMapBinding(DependencyRequest mapOfValueRequest, Key mapOfFactoryKey) {
            Preconditions.checkNotNull((Object)mapOfValueRequest);
            return new AutoValue_DependencyRequest(Kind.PROVIDER, mapOfFactoryKey, mapOfValueRequest.requestElement(), mapOfValueRequest.wrappedEnclosingType(), false, (Optional<String>)Optional.absent());
        }

        DependencyRequest forMultibindingContribution(DependencyRequest request, ContributionBinding multibindingContribution) {
            Preconditions.checkArgument((boolean)multibindingContribution.key().bindingMethod().isPresent(), (String)"multibindingContribution's key must have a binding method identifier: %s", (Object[])new Object[]{multibindingContribution});
            return new AutoValue_DependencyRequest(this.multibindingContributionRequestKind(multibindingContribution), multibindingContribution.key(), request.requestElement(), request.wrappedEnclosingType(), false, (Optional<String>)Optional.absent());
        }

        private Kind multibindingContributionRequestKind(ContributionBinding multibindingContribution) {
            switch (multibindingContribution.contributionType()) {
                case MAP: {
                    return multibindingContribution.bindingType().equals((Object)BindingType.PRODUCTION) ? Kind.PRODUCER : Kind.PROVIDER;
                }
                case SET: 
                case SET_VALUES: {
                    return Kind.INSTANCE;
                }
                case UNIQUE: {
                    String string = String.valueOf(multibindingContribution);
                    throw new IllegalArgumentException(new StringBuilder(49 + String.valueOf(string).length()).append("multibindingContribution must be a multibinding: ").append(string).toString());
                }
            }
            throw new AssertionError((Object)multibindingContribution.toString());
        }

        ImmutableSet<DependencyRequest> forMultibindingContributions(DependencyRequest request, Iterable<ContributionBinding> multibindingContributions) {
            ImmutableSet.Builder requests = ImmutableSet.builder();
            for (ContributionBinding multibindingContribution : multibindingContributions) {
                requests.add((Object)this.forMultibindingContribution(request, multibindingContribution));
            }
            return requests.build();
        }

        DependencyRequest forRequiredVariable(VariableElement variableElement) {
            return this.forRequiredVariable(variableElement, (Optional<String>)Optional.absent());
        }

        DependencyRequest forRequiredVariable(VariableElement variableElement, Optional<String> name) {
            Preconditions.checkNotNull((Object)variableElement);
            TypeMirror type = variableElement.asType();
            Optional<AnnotationMirror> qualifier = InjectionAnnotations.getQualifier(variableElement);
            return this.newDependencyRequest(variableElement, type, qualifier, Factory.getEnclosingType(variableElement), name);
        }

        DependencyRequest forRequiredResolvedVariable(DeclaredType container, VariableElement variableElement, TypeMirror resolvedType) {
            Preconditions.checkNotNull((Object)variableElement);
            Preconditions.checkNotNull((Object)resolvedType);
            Optional<AnnotationMirror> qualifier = InjectionAnnotations.getQualifier(variableElement);
            return this.newDependencyRequest(variableElement, resolvedType, qualifier, container, (Optional<String>)Optional.absent());
        }

        DependencyRequest forComponentProvisionMethod(ExecutableElement provisionMethod, ExecutableType provisionMethodType) {
            Preconditions.checkNotNull((Object)provisionMethod);
            Preconditions.checkNotNull((Object)provisionMethodType);
            Preconditions.checkArgument((boolean)provisionMethod.getParameters().isEmpty(), (String)"Component provision methods must be empty: %s", (Object[])new Object[]{provisionMethod});
            Optional<AnnotationMirror> qualifier = InjectionAnnotations.getQualifier(provisionMethod);
            return this.newDependencyRequest(provisionMethod, provisionMethodType.getReturnType(), qualifier, Factory.getEnclosingType(provisionMethod), (Optional<String>)Optional.absent());
        }

        DependencyRequest forComponentProductionMethod(ExecutableElement productionMethod, ExecutableType productionMethodType) {
            Preconditions.checkNotNull((Object)productionMethod);
            Preconditions.checkNotNull((Object)productionMethodType);
            Preconditions.checkArgument((boolean)productionMethod.getParameters().isEmpty(), (String)"Component production methods must be empty: %s", (Object[])new Object[]{productionMethod});
            TypeMirror type = productionMethodType.getReturnType();
            Optional<AnnotationMirror> qualifier = InjectionAnnotations.getQualifier(productionMethod);
            DeclaredType container = Factory.getEnclosingType(productionMethod);
            if (MoreTypes.isTypeOf(ListenableFuture.class, type)) {
                return new AutoValue_DependencyRequest(Kind.FUTURE, this.keyFactory.forQualifiedType(qualifier, (TypeMirror)Iterables.getOnlyElement(((DeclaredType)type).getTypeArguments())), productionMethod, (Equivalence.Wrapper<DeclaredType>)MoreTypes.equivalence().wrap((Object)container), false, (Optional<String>)Optional.absent());
            }
            return this.newDependencyRequest(productionMethod, type, qualifier, container, (Optional<String>)Optional.absent());
        }

        DependencyRequest forComponentMembersInjectionMethod(ExecutableElement membersInjectionMethod, ExecutableType membersInjectionMethodType) {
            Preconditions.checkNotNull((Object)membersInjectionMethod);
            Preconditions.checkNotNull((Object)membersInjectionMethodType);
            Optional<AnnotationMirror> qualifier = InjectionAnnotations.getQualifier(membersInjectionMethod);
            Preconditions.checkArgument((!qualifier.isPresent() ? 1 : 0) != 0);
            TypeMirror returnType = membersInjectionMethodType.getReturnType();
            Equivalence.Wrapper container = MoreTypes.equivalence().wrap((Object)Factory.getEnclosingType(membersInjectionMethod));
            TypeMirror membersInjectedType = MoreTypes.isType(returnType) && MoreTypes.isTypeOf(MembersInjector.class, returnType) ? (TypeMirror)Iterables.getOnlyElement(MoreTypes.asDeclared(returnType).getTypeArguments()) : (TypeMirror)Iterables.getOnlyElement(membersInjectionMethodType.getParameterTypes());
            return new AutoValue_DependencyRequest(Kind.MEMBERS_INJECTOR, this.keyFactory.forMembersInjectedType(membersInjectedType), membersInjectionMethod, (Equivalence.Wrapper<DeclaredType>)container, false, (Optional<String>)Optional.absent());
        }

        DependencyRequest forMembersInjectedType(DeclaredType type) {
            return new AutoValue_DependencyRequest(Kind.MEMBERS_INJECTOR, this.keyFactory.forMembersInjectedType(type), type.asElement(), (Equivalence.Wrapper<DeclaredType>)MoreTypes.equivalence().wrap((Object)type), false, (Optional<String>)Optional.absent());
        }

        DependencyRequest forProductionImplementationExecutor() {
            Key key = this.keyFactory.forProductionImplementationExecutor();
            return new AutoValue_DependencyRequest(Kind.PROVIDER, key, MoreTypes.asElement(key.type()), (Equivalence.Wrapper<DeclaredType>)MoreTypes.equivalence().wrap((Object)MoreTypes.asDeclared(key.type())), false, (Optional<String>)Optional.absent());
        }

        DependencyRequest forProductionComponentMonitorProvider() {
            TypeElement element = this.elements.getTypeElement(AbstractProducer.class.getCanonicalName());
            for (ExecutableElement constructor : ElementFilter.constructorsIn(element.getEnclosedElements())) {
                if (constructor.getParameters().size() != 2) continue;
                return this.forRequiredVariable(constructor.getParameters().get(0), (Optional<String>)Optional.of((Object)"monitor"));
            }
            throw new AssertionError((Object)"expected 2-arg constructor in AbstractProducer");
        }

        private DependencyRequest newDependencyRequest(Element requestElement, TypeMirror type, Optional<AnnotationMirror> qualifier, DeclaredType container, Optional<String> name) {
            KindAndType kindAndType = Factory.extractKindAndType(type);
            if (kindAndType.kind().equals((Object)Kind.MEMBERS_INJECTOR)) {
                Preconditions.checkArgument((!qualifier.isPresent() ? 1 : 0) != 0);
            }
            boolean allowsNull = !kindAndType.kind().equals((Object)Kind.INSTANCE) || ConfigurationAnnotations.getNullableType(requestElement).isPresent();
            return new AutoValue_DependencyRequest(kindAndType.kind(), this.keyFactory.forQualifiedType(qualifier, kindAndType.type()), requestElement, (Equivalence.Wrapper<DeclaredType>)MoreTypes.equivalence().wrap((Object)container), allowsNull, name);
        }

        static KindAndType extractKindAndType(TypeMirror type) {
            return type.accept(new SimpleTypeVisitor7<KindAndType, Void>(){

                @Override
                public KindAndType visitError(ErrorType errorType, Void p) {
                    throw new TypeNotPresentException(errorType.toString(), null);
                }

                @Override
                public KindAndType visitExecutable(ExecutableType executableType, Void p) {
                    return executableType.getReturnType().accept(this, null);
                }

                @Override
                public KindAndType visitDeclared(DeclaredType declaredType, Void p) {
                    return (KindAndType)KindAndType.from(declaredType).or((Object)this.defaultAction((TypeMirror)declaredType, p));
                }

                @Override
                protected KindAndType defaultAction(TypeMirror otherType, Void p) {
                    return new AutoValue_DependencyRequest_Factory_KindAndType(Kind.INSTANCE, otherType);
                }
            }, null);
        }

        static DeclaredType getEnclosingType(Element element) {
            while (!MoreElements.isType(element)) {
                element = element.getEnclosingElement();
            }
            return MoreTypes.asDeclared(element.asType());
        }

        static abstract class KindAndType {
            KindAndType() {
            }

            abstract Kind kind();

            abstract TypeMirror type();

            static Optional<KindAndType> from(TypeMirror type) {
                for (Kind kind : Kind.values()) {
                    Optional<KindAndType> kindAndType = kind.from(type);
                    if (!kindAndType.isPresent()) continue;
                    return ((KindAndType)kindAndType.get()).maybeProviderOfLazy().or(kindAndType);
                }
                return Optional.absent();
            }

            private Optional<KindAndType> maybeProviderOfLazy() {
                Optional<KindAndType> providedKindAndType;
                if (this.kind().equals((Object)Kind.PROVIDER) && (providedKindAndType = KindAndType.from(this.type())).isPresent() && ((KindAndType)providedKindAndType.get()).kind().equals((Object)Kind.LAZY)) {
                    return Optional.of((Object)Kind.PROVIDER_OF_LAZY.ofType(((KindAndType)providedKindAndType.get()).type()));
                }
                return Optional.absent();
            }
        }
    }

    static enum Kind {
        INSTANCE,
        PROVIDER(Provider.class),
        LAZY(Lazy.class),
        PROVIDER_OF_LAZY,
        MEMBERS_INJECTOR(MembersInjector.class),
        PRODUCER(Producer.class),
        PRODUCED(Produced.class),
        FUTURE;

        final Optional<Class<?>> frameworkClass;

        private Kind(Class<?> frameworkClass) {
            this.frameworkClass = Optional.of(frameworkClass);
        }

        private Kind() {
            this.frameworkClass = Optional.absent();
        }

        Optional<Factory.KindAndType> from(TypeMirror type) {
            return this.frameworkClass.isPresent() && MoreTypes.isType(type) && MoreTypes.isTypeOf((Class)this.frameworkClass.get(), type) ? Optional.of((Object)this.ofType((TypeMirror)Iterables.getOnlyElement(MoreTypes.asDeclared(type).getTypeArguments()))) : Optional.absent();
        }

        Factory.KindAndType ofType(TypeMirror type) {
            return new AutoValue_DependencyRequest_Factory_KindAndType(this, type);
        }
    }
}

