/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Optional;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.Formatter;
import dagger.internal.codegen.MethodSignatureFormatter;
import dagger.internal.codegen.SourceElement;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;

final class HasSourceElementFormatter
extends Formatter<SourceElement.HasSourceElement> {
    private final MethodSignatureFormatter methodSignatureFormatter;

    HasSourceElementFormatter(MethodSignatureFormatter methodSignatureFormatter) {
        this.methodSignatureFormatter = methodSignatureFormatter;
    }

    @Override
    public String format(SourceElement.HasSourceElement hasElement) {
        SourceElement sourceElement = hasElement.sourceElement();
        switch (sourceElement.element().asType().getKind()) {
            case EXECUTABLE: {
                Optional<TypeElement> contributedBy = sourceElement.contributedBy();
                return this.methodSignatureFormatter.format(MoreElements.asExecutable(sourceElement.element()), (Optional<DeclaredType>)(contributedBy.isPresent() ? Optional.of((Object)MoreTypes.asDeclared(((TypeElement)contributedBy.get()).asType())) : Optional.absent()));
            }
            case DECLARED: {
                return ErrorMessages.stripCommonTypePrefixes(sourceElement.element().asType().toString());
            }
        }
        String string = String.valueOf(sourceElement.element());
        throw new IllegalArgumentException(new StringBuilder(36 + String.valueOf(string).length()).append("Formatting unsupported for element: ").append(string).toString());
    }
}

