/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import dagger.Binds;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.MethodSignatureFormatter;
import dagger.internal.codegen.ModuleDescriptor;
import dagger.internal.codegen.ValidationReport;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.Visibility;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;

final class ModuleValidator {
    private final Types types;
    private final Elements elements;
    private final MethodSignatureFormatter methodSignatureFormatter;

    ModuleValidator(Types types, Elements elements, MethodSignatureFormatter methodSignatureFormatter) {
        this.types = types;
        this.elements = elements;
        this.methodSignatureFormatter = methodSignatureFormatter;
    }

    ValidationReport<TypeElement> validate(TypeElement subject) {
        ValidationReport.Builder<TypeElement> builder = ValidationReport.about(subject);
        ModuleDescriptor.Kind moduleKind = (ModuleDescriptor.Kind)((Object)ModuleDescriptor.Kind.forAnnotatedElement(subject).get());
        List<ExecutableElement> moduleMethods = ElementFilter.methodsIn(subject.getEnclosedElements());
        ArrayListMultimap allMethodsByName = ArrayListMultimap.create();
        ArrayListMultimap bindingMethodsByName = ArrayListMultimap.create();
        EnumSet<ModuleMethodKind> methodKinds = EnumSet.noneOf(ModuleMethodKind.class);
        for (ExecutableElement moduleMethod : moduleMethods) {
            if (MoreElements.isAnnotationPresent(moduleMethod, moduleKind.methodAnnotation())) {
                bindingMethodsByName.put((Object)moduleMethod.getSimpleName().toString(), (Object)moduleMethod);
                methodKinds.add(moduleMethod.getModifiers().contains((Object)Modifier.STATIC) ? ModuleMethodKind.STATIC_BINDING : ModuleMethodKind.INSTANCE_BINDING);
            } else if (MoreElements.isAnnotationPresent(moduleMethod, Binds.class)) {
                methodKinds.add(ModuleMethodKind.ABSTRACT_DECLARATION);
            }
            allMethodsByName.put((Object)moduleMethod.getSimpleName().toString(), (Object)moduleMethod);
        }
        if (methodKinds.containsAll(EnumSet.of(ModuleMethodKind.ABSTRACT_DECLARATION, ModuleMethodKind.INSTANCE_BINDING))) {
            builder.addError(String.format("A @%1$s may contain non-static @%2$s methods or @Bind methods, but not both at the same time.  (Static @%2$s may be used with either.)", moduleKind.moduleAnnotation().getSimpleName(), moduleKind.methodAnnotation().getSimpleName()));
        }
        this.validateModuleVisibility(subject, moduleKind, builder);
        this.validateMethodsWithSameName(moduleKind, builder, (ListMultimap<String, ExecutableElement>)bindingMethodsByName);
        if (subject.getKind() != ElementKind.INTERFACE) {
            this.validateProvidesOverrides(subject, moduleKind, builder, (ListMultimap<String, ExecutableElement>)allMethodsByName, (ListMultimap<String, ExecutableElement>)bindingMethodsByName);
        }
        this.validateModifiers(subject, builder);
        this.validateReferencedModules(subject, moduleKind, builder);
        return builder.build();
    }

    private void validateModifiers(TypeElement subject, ValidationReport.Builder<TypeElement> builder) {
        if (!subject.getTypeParameters().isEmpty() && !subject.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            builder.addError("Modules with type parameters must be abstract", subject);
        }
    }

    private void validateMethodsWithSameName(ModuleDescriptor.Kind moduleKind, ValidationReport.Builder<TypeElement> builder, ListMultimap<String, ExecutableElement> bindingMethodsByName) {
        for (Map.Entry entry : bindingMethodsByName.asMap().entrySet()) {
            if (((Collection)entry.getValue()).size() <= 1) continue;
            for (ExecutableElement offendingMethod : (Collection)entry.getValue()) {
                builder.addError(String.format("Cannot have more than one @%s method with the same name in a single module", moduleKind.methodAnnotation().getSimpleName()), offendingMethod);
            }
        }
    }

    private void validateReferencedModules(TypeElement subject, ModuleDescriptor.Kind moduleKind, ValidationReport.Builder<TypeElement> builder) {
        AnnotationMirror mirror = (AnnotationMirror)MoreElements.getAnnotationMirror(subject, moduleKind.moduleAnnotation()).get();
        ImmutableList<TypeMirror> includes = ConfigurationAnnotations.getModuleIncludes(mirror);
        this.validateReferencedModules(subject, mirror, builder, includes, (ImmutableSet<ModuleDescriptor.Kind>)ImmutableSet.of((Object)((Object)moduleKind)));
    }

    private static ImmutableSet<? extends Class<? extends Annotation>> includedModuleClasses(ImmutableSet<ModuleDescriptor.Kind> validModuleKinds) {
        return FluentIterable.from(validModuleKinds).transformAndConcat((Function)new Function<ModuleDescriptor.Kind, Set<? extends Class<? extends Annotation>>>(){

            public Set<? extends Class<? extends Annotation>> apply(ModuleDescriptor.Kind moduleKind) {
                return moduleKind.includesTypes();
            }
        }).toSet();
    }

    void validateReferencedModules(final TypeElement subject, AnnotationMirror moduleAnnotation, final ValidationReport.Builder<TypeElement> builder, ImmutableList<TypeMirror> includes, ImmutableSet<ModuleDescriptor.Kind> validModuleKinds) {
        final ImmutableSet<? extends Class<? extends Annotation>> includedModuleClasses = ModuleValidator.includedModuleClasses(validModuleKinds);
        for (TypeMirror includesType : includes) {
            includesType.accept(new SimpleTypeVisitor6<Void, Void>(){

                @Override
                protected Void defaultAction(TypeMirror mirror, Void p) {
                    String string = String.valueOf(mirror);
                    builder.addError(new StringBuilder(28 + String.valueOf(string).length()).append(string).append(" is not a valid module type.").toString(), subject);
                    return null;
                }

                @Override
                public Void visitDeclared(DeclaredType t, Void p) {
                    boolean isIncludedModule;
                    final TypeElement element = MoreElements.asType(t.asElement());
                    if (!t.getTypeArguments().isEmpty()) {
                        builder.addError(String.format("%s is listed as a module, but has type parameters", element.getQualifiedName()), subject);
                    }
                    if (!(isIncludedModule = Iterables.any((Iterable)includedModuleClasses, (Predicate)new Predicate<Class<? extends Annotation>>(){

                        public boolean apply(Class<? extends Annotation> otherClass) {
                            return MoreElements.isAnnotationPresent(element, otherClass);
                        }
                    }))) {
                        Object[] objectArray = new Object[2];
                        objectArray[0] = element.getQualifiedName();
                        String string = String.valueOf(includedModuleClasses.size() > 1 ? "one of " : "");
                        String string2 = String.valueOf(Joiner.on((String)", ").join((Iterable)FluentIterable.from((Iterable)includedModuleClasses).transform((Function)new Function<Class<? extends Annotation>, String>(){

                            public String apply(Class<? extends Annotation> otherClass) {
                                String string = String.valueOf(otherClass.getSimpleName());
                                return string.length() != 0 ? "@".concat(string) : new String("@");
                            }
                        })));
                        objectArray[1] = string2.length() != 0 ? string.concat(string2) : new String(string);
                        builder.addError(String.format("%s is listed as a module, but is not annotated with %s", objectArray), subject);
                    }
                    return null;
                }
            }, null);
        }
    }

    private void validateProvidesOverrides(TypeElement subject, ModuleDescriptor.Kind moduleKind, ValidationReport.Builder<TypeElement> builder, ListMultimap<String, ExecutableElement> allMethodsByName, ListMultimap<String, ExecutableElement> bindingMethodsByName) {
        TypeElement currentClass = subject;
        TypeMirror objectType = this.elements.getTypeElement(Object.class.getCanonicalName()).asType();
        HashSet failedMethods = Sets.newHashSet();
        while (!this.types.isSameType(currentClass.getSuperclass(), objectType)) {
            currentClass = MoreElements.asType(this.types.asElement(currentClass.getSuperclass()));
            List<ExecutableElement> superclassMethods = ElementFilter.methodsIn(currentClass.getEnclosedElements());
            for (ExecutableElement superclassMethod : superclassMethods) {
                String name = superclassMethod.getSimpleName().toString();
                for (ExecutableElement providesMethod : bindingMethodsByName.get((Object)name)) {
                    if (failedMethods.contains(providesMethod) || !this.elements.overrides(providesMethod, superclassMethod, subject)) continue;
                    failedMethods.add(providesMethod);
                    builder.addError(String.format("@%s methods may not override another method. Overrides: %s", moduleKind.methodAnnotation().getSimpleName(), this.methodSignatureFormatter.format(superclassMethod)), providesMethod);
                }
                if (MoreElements.isAnnotationPresent(superclassMethod, moduleKind.methodAnnotation())) {
                    for (ExecutableElement method : allMethodsByName.get((Object)name)) {
                        if (failedMethods.contains(method) || !this.elements.overrides(method, superclassMethod, subject)) continue;
                        failedMethods.add(method);
                        builder.addError(String.format("@%s methods may not be overridden in modules. Overrides: %s", moduleKind.methodAnnotation().getSimpleName(), this.methodSignatureFormatter.format(superclassMethod)), method);
                    }
                }
                allMethodsByName.put((Object)superclassMethod.getSimpleName().toString(), (Object)superclassMethod);
            }
        }
    }

    private void validateModuleVisibility(TypeElement moduleElement, ModuleDescriptor.Kind moduleKind, ValidationReport.Builder<?> reportBuilder) {
        Visibility moduleVisibility = Visibility.ofElement(moduleElement);
        if (moduleVisibility.equals((Object)Visibility.PRIVATE)) {
            reportBuilder.addError("Modules cannot be private.", moduleElement);
        } else if (Visibility.effectiveVisibilityOfElement(moduleElement).equals((Object)Visibility.PRIVATE)) {
            reportBuilder.addError("Modules cannot be enclosed in private types.", moduleElement);
        }
        switch (moduleElement.getNestingKind()) {
            case ANONYMOUS: {
                throw new IllegalStateException("Can't apply @Module to an anonymous class");
            }
            case LOCAL: {
                throw new IllegalStateException("Local classes shouldn't show up in the processor");
            }
            case MEMBER: 
            case TOP_LEVEL: {
                ImmutableSet nonPublicModules;
                if (!moduleVisibility.equals((Object)Visibility.PUBLIC) || (nonPublicModules = FluentIterable.from(ConfigurationAnnotations.getModuleIncludes((AnnotationMirror)MoreElements.getAnnotationMirror(moduleElement, moduleKind.moduleAnnotation()).get())).transform((Function)new Function<TypeMirror, Element>(){

                    public Element apply(TypeMirror input) {
                        return ModuleValidator.this.types.asElement(input);
                    }
                }).filter((Predicate)new Predicate<Element>(){

                    public boolean apply(Element input) {
                        return Visibility.effectiveVisibilityOfElement(input).compareTo(Visibility.PUBLIC) < 0;
                    }
                }).toSet()).isEmpty()) break;
                reportBuilder.addError(String.format("This module is public, but it includes non-public (or effectively non-public) modules. Either reduce the visibility of this module or make %s public.", ModuleValidator.formatListForErrorMessage(nonPublicModules.asList())), moduleElement);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private static String formatListForErrorMessage(List<?> things) {
        switch (things.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return things.get(0).toString();
            }
        }
        StringBuilder output = new StringBuilder();
        Joiner.on((String)", ").appendTo(output, things.subList(0, things.size() - 1));
        output.append(" and ").append(things.get(things.size() - 1));
        return output.toString();
    }

    static enum ModuleMethodKind {
        ABSTRACT_DECLARATION,
        INSTANCE_BINDING,
        STATIC_BINDING;

    }
}

