/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.analysis;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.analysis.BugCheckerLocalAnalysis;
import com.google.errorprone.analysis.LocalAnalysisAsTopLevelAnalysis;
import com.google.errorprone.analysis.SumTopLevelAnalysis;
import com.google.errorprone.analysis.TopLevelAnalysis;
import com.google.errorprone.analysis.TopLevelAnalysisWithSeverity;
import com.google.errorprone.bugpatterns.BugChecker;
import java.util.Arrays;
import java.util.ServiceLoader;

public class ErrorProneTopLevelAnalysis {
    private static final Function<Class<? extends BugChecker>, BugChecker> INSTANTIATE_CHECKER = new Function<Class<? extends BugChecker>, BugChecker>(){

        public BugChecker apply(Class<? extends BugChecker> checkerClass) {
            try {
                return checkerClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new LinkageError("Could not instantiate BugChecker.", e);
            }
        }
    };
    private static final ServiceLoader<BugChecker> bugCheckerLoader = ServiceLoader.load(BugChecker.class);

    private static TopLevelAnalysis create(BugChecker checker, BugPattern.MaturityLevel maturity) {
        return TopLevelAnalysisWithSeverity.wrap(checker.canonicalName(), maturity == BugPattern.MaturityLevel.MATURE, checker.defaultSeverity(), checker.suppressibility().disableable(), LocalAnalysisAsTopLevelAnalysis.wrap(new BugCheckerLocalAnalysis(checker)));
    }

    public static TopLevelAnalysis createMature(BugChecker checker) {
        return ErrorProneTopLevelAnalysis.create(checker, BugPattern.MaturityLevel.MATURE);
    }

    public static TopLevelAnalysis create(BugChecker ... checkers) {
        return ErrorProneTopLevelAnalysis.create(Arrays.asList(checkers));
    }

    public static TopLevelAnalysis create(Iterable<? extends BugChecker> checkers) {
        ImmutableList.Builder analyses = ImmutableList.builder();
        for (BugChecker bugChecker : checkers) {
            analyses.add((Object)ErrorProneTopLevelAnalysis.create(bugChecker, bugChecker.maturity()));
        }
        return SumTopLevelAnalysis.create((Iterable<? extends TopLevelAnalysis>)analyses.build());
    }

    public static TopLevelAnalysis createMature(Iterable<? extends BugChecker> checkers) {
        ImmutableList.Builder analyses = ImmutableList.builder();
        for (BugChecker bugChecker : checkers) {
            analyses.add((Object)ErrorProneTopLevelAnalysis.create(bugChecker, BugPattern.MaturityLevel.MATURE));
        }
        return SumTopLevelAnalysis.create((Iterable<? extends TopLevelAnalysis>)analyses.build());
    }

    public static TopLevelAnalysis createFromClasses(Iterable<? extends Class<? extends BugChecker>> classes) {
        return ErrorProneTopLevelAnalysis.create(Iterables.transform(classes, INSTANTIATE_CHECKER));
    }

    public static TopLevelAnalysis createMatureFromClasses(Iterable<? extends Class<? extends BugChecker>> classes) {
        return ErrorProneTopLevelAnalysis.createMature(Iterables.transform(classes, INSTANTIATE_CHECKER));
    }

    public static TopLevelAnalysis createFromServiceLoader() {
        return ErrorProneTopLevelAnalysis.create(bugCheckerLoader);
    }

    private ErrorProneTopLevelAnalysis() {
    }
}

