/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.analysis;

import com.google.common.base.Predicate;
import com.google.common.io.CharStreams;
import com.google.errorprone.DescriptionListener;
import com.google.errorprone.analysis.AnalysesConfig;
import com.google.errorprone.analysis.AutoValue_RecompilingTopLevelAnalysis;
import com.google.errorprone.analysis.TopLevelAnalysis;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.Replacement;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.JavacTask;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public abstract class RecompilingTopLevelAnalysis
implements TopLevelAnalysis {
    public static RecompilingTopLevelAnalysis create(TopLevelAnalysis analysis) {
        return new AutoValue_RecompilingTopLevelAnalysis(analysis);
    }

    RecompilingTopLevelAnalysis() {
    }

    abstract TopLevelAnalysis analysis();

    @Override
    public Set<String> knownAnalysisNames() {
        return this.analysis().knownAnalysisNames();
    }

    @Override
    public void analyze(final CompilationUnitTree compilationUnit, final Context context, AnalysesConfig configuration, final DescriptionListener listener) {
        this.analysis().analyze(compilationUnit, context, configuration, new DescriptionListener(){

            @Override
            public void onDescribed(Description description) {
                listener.onDescribed(description.filterFixes((Predicate<? super Fix>)new Predicate<Fix>(){

                    public boolean apply(Fix fix) {
                        return RecompilingTopLevelAnalysis.compiles(fix, (JCTree.JCCompilationUnit)compilationUnit, context);
                    }
                }));
            }
        });
    }

    private static boolean compiles(Fix fix, JCTree.JCCompilationUnit compilationUnit, Context context) {
        final TreeSet<Replacement> replacements = new TreeSet<Replacement>(ByStartPosition.INSTANCE);
        replacements.addAll(fix.getReplacements(compilationUnit.endPositions));
        JavaFileObject modifiedFile = compilationUnit.getSourceFile();
        if (replacements.isEmpty()) {
            return true;
        }
        JavacTaskImpl javacTask = (JavacTaskImpl)context.get(JavacTask.class);
        if (javacTask == null) {
            throw new IllegalArgumentException("No JavacTask in context.");
        }
        ArrayList<JavaFileObject> fileObjects = new ArrayList<JavaFileObject>(RecompilingTopLevelAnalysis.fileObjectsForTask(javacTask));
        for (int i = 0; i < fileObjects.size(); ++i) {
            final JavaFileObject oldFile = (JavaFileObject)fileObjects.get(i);
            if (!modifiedFile.toUri().equals(oldFile.toUri())) continue;
            fileObjects.set(i, new SimpleJavaFileObject(modifiedFile.toUri(), JavaFileObject.Kind.SOURCE){

                @Override
                public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                    StringBuilder builder = new StringBuilder(oldFile.getCharContent(ignoreEncodingErrors));
                    for (Replacement replacement : replacements.descendingSet()) {
                        builder.replace(replacement.startPosition(), replacement.endPosition(), replacement.replaceWith());
                    }
                    return builder;
                }
            });
            break;
        }
        JavacTool compiler = JavacTool.create();
        DiagnosticCollector<JavaFileObject> diagnosticListener = new DiagnosticCollector<JavaFileObject>();
        JavacTask newTask = (JavacTask)compiler.getTask(CharStreams.nullWriter(), context.get(JavaFileManager.class), diagnosticListener, RecompilingTopLevelAnalysis.asListOrNull(RecompilingTopLevelAnalysis.argsForTask(javacTask)), RecompilingTopLevelAnalysis.asListOrNull(RecompilingTopLevelAnalysis.classesForTask(javacTask)), fileObjects);
        try {
            newTask.analyze();
        }
        catch (Throwable e) {
            return false;
        }
        return RecompilingTopLevelAnalysis.countErrors(diagnosticListener) == 0;
    }

    private static int countErrors(DiagnosticCollector<JavaFileObject> diagnosticCollector) {
        int errorCount = 0;
        for (Diagnostic<JavaFileObject> diag : diagnosticCollector.getDiagnostics()) {
            if (diag.getKind() != Diagnostic.Kind.ERROR) continue;
            ++errorCount;
        }
        return errorCount;
    }

    private static Object getFieldReflectively(JavacTaskImpl task, String fieldName) {
        try {
            Field field = JavacTaskImpl.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(task);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static <E> List<E> asListOrNull(@Nullable E[] array) {
        return array == null ? null : Arrays.asList(array);
    }

    private static List<JavaFileObject> fileObjectsForTask(JavacTaskImpl task) {
        return (List)RecompilingTopLevelAnalysis.getFieldReflectively(task, "fileObjects");
    }

    private static String[] argsForTask(JavacTaskImpl task) {
        return (String[])RecompilingTopLevelAnalysis.getFieldReflectively(task, "args");
    }

    private static String[] classesForTask(JavacTaskImpl task) {
        return (String[])RecompilingTopLevelAnalysis.getFieldReflectively(task, "classNames");
    }

    private static enum ByStartPosition implements Comparator<Replacement>
    {
        INSTANCE{

            @Override
            public int compare(Replacement o1, Replacement o2) {
                return Integer.compare(o1.startPosition(), o2.startPosition());
            }
        };

    }
}

