/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;

@BugPattern(name="ClassCanBeStatic", summary="Inner class is non-static but does not reference enclosing class", explanation="An inner class should be static unless it references membersof its enclosing class. An inner class that is made non-static unnecessarilyuses more memory and does not make the intent of the class clear.", category=BugPattern.Category.JDK, maturity=BugPattern.MaturityLevel.EXPERIMENTAL, severity=BugPattern.SeverityLevel.ERROR)
public class ClassCanBeStatic
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static Matcher<ClassTree> classTreeMatcher = new Matcher<ClassTree>(){

        @Override
        public boolean matches(ClassTree classTree, VisitorState state) {
            return Matchers.allOf(Matchers.not(Matchers.hasModifier(Modifier.STATIC)), Matchers.kindIs(Tree.Kind.CLASS), Matchers.nestingKind(NestingKind.MEMBER), Matchers.parentNode(Matchers.kindIs(Tree.Kind.CLASS)), Matchers.anyOf(Matchers.parentNode(Matchers.nestingKind(NestingKind.TOP_LEVEL)), Matchers.parentNode(Matchers.hasModifier(Modifier.STATIC))), Matchers.not(Matchers.hasIdentifier(ClassCanBeStatic.referenceEnclosing(classTree, state.getTypes())))).matches(classTree, state);
        }
    };

    private static Matcher<IdentifierTree> referenceEnclosing(ClassTree classTree, Types types) {
        return new ReferenceEnclosing(classTree, types);
    }

    @Override
    public Description matchClass(ClassTree tree, VisitorState state) {
        if (!classTreeMatcher.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        Description.Builder builder = this.buildDescription(tree);
        Fix fix = SuggestedFix.addModifier(tree, Modifier.STATIC, state);
        if (fix != null) {
            builder.addFix(fix);
        }
        return builder.build();
    }

    private static class ReferenceEnclosing
    implements Matcher<IdentifierTree> {
        private final Symbol.ClassSymbol currentClass;
        private final Types types;

        public ReferenceEnclosing(ClassTree classTree, Types types) {
            this.currentClass = ASTHelpers.getSymbol(classTree);
            this.types = types;
        }

        @Override
        public boolean matches(IdentifierTree node, VisitorState state) {
            Symbol sym = ASTHelpers.getSymbol(node);
            return !sym.isLocal() && !sym.isMemberOf(this.currentClass, this.types);
        }
    }
}

