/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractSuppressWarningsMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.AnnotationTree;
import java.util.List;

@BugPattern(name="FallthroughSuppression", summary="Fallthrough warning suppression has no effect if warning is suppressed", explanation="Remove all arguments to @SuppressWarnings annotations that suppress the Java compiler's fallthrough warning. If there are no more arguments in a @SuppressWarnings annotation, remove the whole annotation.\n\nNote: This checker was specific to a refactoring we performed and should not be used as a general error or warning.", category=BugPattern.Category.ONE_OFF, severity=BugPattern.SeverityLevel.NOT_A_PROBLEM, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class FallThroughSuppression
extends AbstractSuppressWarningsMatcher {
    private static final Matcher<AnnotationTree> matcher = Matchers.allOf(Matchers.isType("java.lang.SuppressWarnings"), Matchers.hasArgumentWithValue("value", Matchers.stringLiteral("fallthrough")));

    @Override
    public final Description matchAnnotation(AnnotationTree annotationTree, VisitorState state) {
        if (matcher.matches(annotationTree, state)) {
            return this.describeMatch(annotationTree, this.getSuggestedFix(annotationTree));
        }
        return Description.NO_MATCH;
    }

    @Override
    protected void processSuppressWarningsValues(List<String> values) {
        values.remove("fallthrough");
    }
}

