/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;

@BugPattern(name="Finally", altNames={"finally", "ThrowFromFinallyBlock"}, summary="If you return or throw from a finally, then values returned or thrown from the try-catch block will be ignored. Consider using try-with-resources instead.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, maturity=BugPattern.MaturityLevel.MATURE, generateExamplesFromTestCases=false)
public class Finally
extends BugChecker
implements BugChecker.ContinueTreeMatcher,
BugChecker.ThrowTreeMatcher,
BugChecker.BreakTreeMatcher,
BugChecker.ReturnTreeMatcher {
    @Override
    public Description matchContinue(ContinueTree tree, VisitorState state) {
        if (new FinallyJumpMatcher((JCTree.JCContinue)tree).matches(tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    @Override
    public Description matchBreak(BreakTree tree, VisitorState state) {
        if (new FinallyJumpMatcher((JCTree.JCBreak)tree).matches(tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    @Override
    public Description matchThrow(ThrowTree tree, VisitorState state) {
        if (new FinallyThrowMatcher().matches(tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    @Override
    public Description matchReturn(ReturnTree tree, VisitorState state) {
        if (new FinallyCompletionMatcher<ReturnTree>().matches(tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    private class FinallyThrowMatcher
    extends FinallyCompletionMatcher<ThrowTree> {
        private FinallyThrowMatcher() {
        }

        @Override
        protected MatchResult matchAncestor(Tree tree, Tree prevTree) {
            TryTree tryTree;
            if (tree instanceof TryTree && (tryTree = (TryTree)tree).getBlock().equals(prevTree) && !tryTree.getCatches().isEmpty()) {
                return MatchResult.NO_MATCH;
            }
            return super.matchAncestor(tree, prevTree);
        }
    }

    private static class FinallyJumpMatcher
    extends FinallyCompletionMatcher<StatementTree> {
        private Name label;
        private JumpType jumpType;

        public FinallyJumpMatcher(JCTree.JCContinue jcContinue) {
            this.label = jcContinue.label;
            this.jumpType = JumpType.CONTINUE;
        }

        public FinallyJumpMatcher(JCTree.JCBreak jcBreak) {
            this.label = jcBreak.label;
            this.jumpType = JumpType.BREAK;
        }

        @Override
        protected MatchResult matchAncestor(Tree leaf, Tree prevTree) {
            if (this.label == null) {
                switch (leaf.getKind()) {
                    case WHILE_LOOP: 
                    case DO_WHILE_LOOP: 
                    case FOR_LOOP: 
                    case ENHANCED_FOR_LOOP: {
                        return MatchResult.NO_MATCH;
                    }
                }
            }
            if (this.label != null && leaf instanceof LabeledStatementTree && this.label.equals(((LabeledStatementTree)leaf).getLabel())) {
                return MatchResult.NO_MATCH;
            }
            if (this.jumpType == JumpType.BREAK && leaf instanceof SwitchTree) {
                return MatchResult.NO_MATCH;
            }
            return super.matchAncestor(leaf, prevTree);
        }

        private static enum JumpType {
            BREAK,
            CONTINUE;

        }
    }

    private static class FinallyCompletionMatcher<T extends StatementTree>
    implements Matcher<T> {
        private FinallyCompletionMatcher() {
        }

        @Override
        public boolean matches(T tree, VisitorState state) {
            TreePath path = state.getPath();
            Tree prevTree = path.getLeaf();
            while (path != null && path.getLeaf().getKind() != Tree.Kind.METHOD && path.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT) {
                prevTree = path.getLeaf();
                MatchResult mr = this.matchAncestor((path = path.getParentPath()).getLeaf(), prevTree);
                if (mr == MatchResult.KEEP_LOOKING) continue;
                return mr == MatchResult.FOUND_ERROR;
            }
            return false;
        }

        protected MatchResult matchAncestor(Tree leaf, Tree prevTree) {
            TryTree tryTree;
            if (leaf instanceof TryTree && (tryTree = (TryTree)leaf).getFinallyBlock() != null && tryTree.getFinallyBlock().equals(prevTree)) {
                return MatchResult.FOUND_ERROR;
            }
            return MatchResult.KEEP_LOOKING;
        }
    }

    private static enum MatchResult {
        KEEP_LOOKING,
        NO_MATCH,
        FOUND_ERROR;

    }
}

