/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import javax.lang.model.element.Modifier;

@BugPattern(name="GuiceInjectOnFinalField", summary="Although Guice allows injecting final fields, doing so is not recommended because the injected value may not be visible to other threads.", explanation="See https://code.google.com/p/google-guice/wiki/InjectionPoints", category=BugPattern.Category.GUICE, severity=BugPattern.SeverityLevel.WARNING, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class GuiceInjectOnFinalField
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final String GUICE_INJECT_ANNOTATION = "com.google.inject.Inject";
    private static final MultiMatcher<Tree, AnnotationTree> ANNOTATED_WITH_GUICE_INJECT_MATCHER = Matchers.annotations(ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.isType("com.google.inject.Inject"));
    private static final Matcher<Tree> FINAL_FIELD_MATCHER = new Matcher<Tree>(){

        @Override
        public boolean matches(Tree t, VisitorState state) {
            return GuiceInjectOnFinalField.isField(t, state) && ((VariableTree)t).getModifiers().getFlags().contains((Object)Modifier.FINAL);
        }
    };

    @Override
    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (ANNOTATED_WITH_GUICE_INJECT_MATCHER.matches(tree, state) && FINAL_FIELD_MATCHER.matches(tree, state)) {
            JCTree.JCModifiers modifiers = ((JCTree.JCVariableDecl)tree).getModifiers();
            long replacementFlags = modifiers.flags ^ 0x10L;
            JCTree.JCModifiers replacementModifiers = TreeMaker.instance(state.context).Modifiers(replacementFlags, modifiers.annotations);
            String replacementModifiersString = replacementModifiers.toString().replace('\n', ' ').replace("()", "").trim();
            return this.describeMatch(modifiers, SuggestedFix.replace(modifiers, replacementModifiersString));
        }
        return Description.NO_MATCH;
    }

    private static boolean isField(Tree tree, VisitorState state) {
        return tree.getKind().equals((Object)Tree.Kind.VARIABLE) && ASTHelpers.findEnclosingNode(state.getPath(), ClassTree.class).getMembers().contains(tree);
    }
}

