/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.errorprone.refaster.AutoValue_UAssignOp;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.CouldNotResolveImportException;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.UExpression;
import com.google.errorprone.refaster.Unifier;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.tools.javac.tree.JCTree;

abstract class UAssignOp
extends UExpression
implements CompoundAssignmentTree {
    private static final ImmutableBiMap<Tree.Kind, JCTree.Tag> TAG = ImmutableBiMap.builder().put((Object)Tree.Kind.PLUS_ASSIGNMENT, (Object)JCTree.Tag.PLUS_ASG).put((Object)Tree.Kind.MINUS_ASSIGNMENT, (Object)JCTree.Tag.MINUS_ASG).put((Object)Tree.Kind.MULTIPLY_ASSIGNMENT, (Object)JCTree.Tag.MUL_ASG).put((Object)Tree.Kind.DIVIDE_ASSIGNMENT, (Object)JCTree.Tag.DIV_ASG).put((Object)Tree.Kind.REMAINDER_ASSIGNMENT, (Object)JCTree.Tag.MOD_ASG).put((Object)Tree.Kind.LEFT_SHIFT_ASSIGNMENT, (Object)JCTree.Tag.SL_ASG).put((Object)Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, (Object)JCTree.Tag.SR_ASG).put((Object)Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, (Object)JCTree.Tag.USR_ASG).put((Object)Tree.Kind.OR_ASSIGNMENT, (Object)JCTree.Tag.BITOR_ASG).put((Object)Tree.Kind.AND_ASSIGNMENT, (Object)JCTree.Tag.BITAND_ASG).put((Object)Tree.Kind.XOR_ASSIGNMENT, (Object)JCTree.Tag.BITXOR_ASG).build();

    UAssignOp() {
    }

    public static UAssignOp create(UExpression variable, Tree.Kind operator, UExpression expression) {
        Preconditions.checkArgument((boolean)TAG.containsKey((Object)operator), (String)"Tree kind %s does not represent a compound assignment operator", (Object[])new Object[]{operator});
        return new AutoValue_UAssignOp(variable, operator, expression);
    }

    @Override
    public abstract UExpression getVariable();

    @Override
    public abstract Tree.Kind getKind();

    @Override
    public abstract UExpression getExpression();

    @Override
    public JCTree.JCAssignOp inline(Inliner inliner) throws CouldNotResolveImportException {
        return inliner.maker().Assignop((JCTree.Tag)((Object)TAG.get((Object)this.getKind())), (JCTree)this.getVariable().inline(inliner), (JCTree)this.getExpression().inline(inliner));
    }

    @Override
    public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
        return visitor.visitCompoundAssignment(this, data);
    }

    @Override
    public Choice<Unifier> visitCompoundAssignment(CompoundAssignmentTree assignOp, Unifier unifier) {
        return Choice.condition(this.getKind() == assignOp.getKind(), unifier).thenChoose(Unifier.unifications(this.getVariable(), assignOp.getVariable())).thenChoose(Unifier.unifications(this.getExpression(), assignOp.getExpression()));
    }
}

