/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import dagger.producers.Producer;
import dagger.producers.internal.AbstractProducer;
import dagger.producers.monitoring.ProducerMonitor;
import java.util.Map;

public final class MapOfProducerProducer<K, V>
extends AbstractProducer<Map<K, Producer<V>>> {
    private static final MapOfProducerProducer<Object, Object> EMPTY = new MapOfProducerProducer(ImmutableMap.of());
    private final ImmutableMap<K, Producer<V>> contributingMap;

    public static <K, V> Builder<K, V> builder(int size) {
        return new Builder(size);
    }

    public static <K, V> MapOfProducerProducer<K, V> empty() {
        return EMPTY;
    }

    private MapOfProducerProducer(ImmutableMap<K, Producer<V>> contributingMap) {
        this.contributingMap = contributingMap;
    }

    @Override
    public ListenableFuture<Map<K, Producer<V>>> compute(ProducerMonitor unusedMonitor) {
        return Futures.immediateFuture(this.contributingMap);
    }

    public static final class Builder<K, V> {
        private final ImmutableMap.Builder<K, Producer<V>> mapBuilder = ImmutableMap.builder();

        private Builder(int size) {
        }

        public MapOfProducerProducer<K, V> build() {
            return new MapOfProducerProducer(this.mapBuilder.build());
        }

        public Builder<K, V> put(K key, Producer<V> producerOfValue) {
            Preconditions.checkNotNull(key, (Object)"key");
            Preconditions.checkNotNull(producerOfValue, (Object)"producer of value");
            this.mapBuilder.put(key, producerOfValue);
            return this;
        }
    }
}

