/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.internal;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import dagger.producers.Produced;
import dagger.producers.Producer;
import dagger.producers.internal.AbstractProducer;
import dagger.producers.internal.Producers;
import dagger.producers.internal.SetProducer;
import dagger.producers.monitoring.ProducerMonitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;

public final class SetOfProducedProducer<T>
extends AbstractProducer<Set<Produced<T>>> {
    private final ImmutableSet<Producer<Set<T>>> contributingProducers;

    public static <T> Producer<Set<T>> create() {
        return SetProducer.create();
    }

    @SafeVarargs
    public static <T> Producer<Set<Produced<T>>> create(Producer<Set<T>> ... producers) {
        return new SetOfProducedProducer<T>(ImmutableSet.copyOf((Object[])producers));
    }

    private SetOfProducedProducer(ImmutableSet<Producer<Set<T>>> contributingProducers) {
        this.contributingProducers = contributingProducers;
    }

    @Override
    public ListenableFuture<Set<Produced<T>>> compute(ProducerMonitor unusedMonitor) {
        ArrayList futureProducedSets = new ArrayList(this.contributingProducers.size());
        for (Producer producer : this.contributingProducers) {
            ListenableFuture futureSet = producer.get();
            if (futureSet == null) {
                String string = String.valueOf(producer);
                throw new NullPointerException(new StringBuilder(14 + String.valueOf(string).length()).append(string).append(" returned null").toString());
            }
            futureProducedSets.add(Producers.createFutureProduced(futureSet));
        }
        return Futures.transform((ListenableFuture)Futures.allAsList(futureProducedSets), (Function)new Function<List<Produced<Set<T>>>, Set<Produced<T>>>(){

            public Set<Produced<T>> apply(List<Produced<Set<T>>> producedSets) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                for (Produced producedSet : producedSets) {
                    try {
                        Set set = producedSet.get();
                        if (set == null) {
                            builder.add(Produced.failed(new NullPointerException("Cannot contribute a null set into a producer set binding when it's injected as Set<Produced<T>>.")));
                            continue;
                        }
                        for (Object value : set) {
                            if (value == null) {
                                builder.add(Produced.failed(new NullPointerException("Cannot contribute a null element into a producer set binding when it's injected as Set<Produced<T>>.")));
                                continue;
                            }
                            builder.add(Produced.successful(value));
                        }
                    }
                    catch (ExecutionException e) {
                        builder.add(Produced.failed(e.getCause()));
                    }
                }
                return builder.build();
            }
        });
    }
}

