/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.internal;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import dagger.producers.Producer;
import dagger.producers.internal.AbstractProducer;
import dagger.producers.monitoring.ProducerMonitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class SetProducer<T>
extends AbstractProducer<Set<T>> {
    private static final Producer<Set<Object>> EMPTY_PRODUCER = new Producer<Set<Object>>(){

        @Override
        public ListenableFuture<Set<Object>> get() {
            return Futures.immediateFuture((Object)ImmutableSet.of());
        }
    };
    private final Set<Producer<Set<T>>> contributingProducers;

    public static <T> Producer<Set<T>> create() {
        return EMPTY_PRODUCER;
    }

    public static <T> Producer<Set<T>> create(Producer<Set<T>> producer) {
        return producer;
    }

    @SafeVarargs
    public static <T> Producer<Set<T>> create(Producer<Set<T>> ... producers) {
        return new SetProducer<T>(ImmutableSet.copyOf((Object[])producers));
    }

    private SetProducer(Set<Producer<Set<T>>> contributingProducers) {
        this.contributingProducers = contributingProducers;
    }

    @Override
    public ListenableFuture<Set<T>> compute(ProducerMonitor unusedMonitor) {
        ArrayList<ListenableFuture<Set<T>>> futureSets = new ArrayList<ListenableFuture<Set<T>>>(this.contributingProducers.size());
        for (Producer<Set<T>> producer : this.contributingProducers) {
            ListenableFuture<Set<T>> futureSet = producer.get();
            if (futureSet == null) {
                String string = String.valueOf(producer);
                throw new NullPointerException(new StringBuilder(14 + String.valueOf(string).length()).append(string).append(" returned null").toString());
            }
            futureSets.add(futureSet);
        }
        return Futures.transform((ListenableFuture)Futures.allAsList(futureSets), (Function)new Function<List<Set<T>>, Set<T>>(){

            public Set<T> apply(List<Set<T>> sets) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                for (Set set : sets) {
                    builder.addAll(set);
                }
                return builder.build();
            }
        });
    }
}

