/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.monitoring;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;

public abstract class ProducerMonitor {
    private static final ProducerMonitor NO_OP = new ProducerMonitor(){

        @Override
        public <T> void addCallbackTo(ListenableFuture<T> future) {
        }
    };

    public void requested() {
    }

    public void methodStarting() {
    }

    public void methodFinished() {
    }

    public void succeeded(Object o) {
    }

    public void failed(Throwable t) {
    }

    public <T> void addCallbackTo(ListenableFuture<T> future) {
        Futures.addCallback(future, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(T value) {
                ProducerMonitor.this.succeeded(value);
            }

            public void onFailure(Throwable t) {
                ProducerMonitor.this.failed(t);
            }
        });
    }

    public static ProducerMonitor noOp() {
        return NO_OP;
    }
}

