# Go API client for openapi

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

## Overview
This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [OpenAPI-spec](https://www.openapis.org/) from a remote server, you can easily generate an API client.

- API version: 0.0.2
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.GoClientCodegen

## Installation

Install the following dependencies:
```
go get github.com/stretchr/testify/assert
go get golang.org/x/oauth2
go get golang.org/x/net/context
go get github.com/antihax/optional
```

Put the package under your project folder and add the following in import:
```golang
import "./openapi"
```

## Documentation for API Endpoints

All URIs are relative to *https://api.hyperone.com/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ContainerApi* | [**ContainerActionRestart**](docs/ContainerApi.md#containeractionrestart) | **Post** /container/{containerId}/actions/restart | /actions/restart
*ContainerApi* | [**ContainerActionStart**](docs/ContainerApi.md#containeractionstart) | **Post** /container/{containerId}/actions/start | /actions/start
*ContainerApi* | [**ContainerActionStop**](docs/ContainerApi.md#containeractionstop) | **Post** /container/{containerId}/actions/stop | /actions/stop
*ContainerApi* | [**ContainerCreate**](docs/ContainerApi.md#containercreate) | **Post** /container | Create
*ContainerApi* | [**ContainerDelete**](docs/ContainerApi.md#containerdelete) | **Delete** /container/{containerId} | Delete
*ContainerApi* | [**ContainerDeleteAccessrightsIdentity**](docs/ContainerApi.md#containerdeleteaccessrightsidentity) | **Delete** /container/{containerId}/accessrights/{identity} | /accessrights/:identity
*ContainerApi* | [**ContainerDeleteTagKey**](docs/ContainerApi.md#containerdeletetagkey) | **Delete** /container/{containerId}/tag/{key} | /tag/:key
*ContainerApi* | [**ContainerGetServicesServiceId**](docs/ContainerApi.md#containergetservicesserviceid) | **Get** /container/{containerId}/services/{serviceId} | /services/:serviceId
*ContainerApi* | [**ContainerGetTag**](docs/ContainerApi.md#containergettag) | **Get** /container/{containerId}/tag | /tag
*ContainerApi* | [**ContainerList**](docs/ContainerApi.md#containerlist) | **Get** /container | List
*ContainerApi* | [**ContainerListAccessrights**](docs/ContainerApi.md#containerlistaccessrights) | **Get** /container/{containerId}/accessrights | /accessrights
*ContainerApi* | [**ContainerListQueue**](docs/ContainerApi.md#containerlistqueue) | **Get** /container/{containerId}/queue | /queue
*ContainerApi* | [**ContainerListServices**](docs/ContainerApi.md#containerlistservices) | **Get** /container/{containerId}/services | /services
*ContainerApi* | [**ContainerPatchTag**](docs/ContainerApi.md#containerpatchtag) | **Patch** /container/{containerId}/tag | /tag
*ContainerApi* | [**ContainerPostAccessrights**](docs/ContainerApi.md#containerpostaccessrights) | **Post** /container/{containerId}/accessrights | /accessrights
*ContainerApi* | [**ContainerShow**](docs/ContainerApi.md#containershow) | **Get** /container/{containerId} | Get
*ContainerApi* | [**ContainerUpdate**](docs/ContainerApi.md#containerupdate) | **Patch** /container/{containerId} | Update
*DiskApi* | [**DiskActionResize**](docs/DiskApi.md#diskactionresize) | **Post** /disk/{diskId}/actions/resize | /actions/resize
*DiskApi* | [**DiskActionTransfer**](docs/DiskApi.md#diskactiontransfer) | **Post** /disk/{diskId}/actions/transfer | /actions/transfer
*DiskApi* | [**DiskCreate**](docs/DiskApi.md#diskcreate) | **Post** /disk | Create
*DiskApi* | [**DiskDelete**](docs/DiskApi.md#diskdelete) | **Delete** /disk/{diskId} | Delete
*DiskApi* | [**DiskDeleteAccessrightsIdentity**](docs/DiskApi.md#diskdeleteaccessrightsidentity) | **Delete** /disk/{diskId}/accessrights/{identity} | /accessrights/:identity
*DiskApi* | [**DiskDeleteTagKey**](docs/DiskApi.md#diskdeletetagkey) | **Delete** /disk/{diskId}/tag/{key} | /tag/:key
*DiskApi* | [**DiskGetServicesServiceId**](docs/DiskApi.md#diskgetservicesserviceid) | **Get** /disk/{diskId}/services/{serviceId} | /services/:serviceId
*DiskApi* | [**DiskGetTag**](docs/DiskApi.md#diskgettag) | **Get** /disk/{diskId}/tag | /tag
*DiskApi* | [**DiskList**](docs/DiskApi.md#disklist) | **Get** /disk | List
*DiskApi* | [**DiskListAccessrights**](docs/DiskApi.md#disklistaccessrights) | **Get** /disk/{diskId}/accessrights | /accessrights
*DiskApi* | [**DiskListQueue**](docs/DiskApi.md#disklistqueue) | **Get** /disk/{diskId}/queue | /queue
*DiskApi* | [**DiskListServices**](docs/DiskApi.md#disklistservices) | **Get** /disk/{diskId}/services | /services
*DiskApi* | [**DiskPatchTag**](docs/DiskApi.md#diskpatchtag) | **Patch** /disk/{diskId}/tag | /tag
*DiskApi* | [**DiskPostAccessrights**](docs/DiskApi.md#diskpostaccessrights) | **Post** /disk/{diskId}/accessrights | /accessrights
*DiskApi* | [**DiskShow**](docs/DiskApi.md#diskshow) | **Get** /disk/{diskId} | Get
*DiskApi* | [**DiskUpdate**](docs/DiskApi.md#diskupdate) | **Patch** /disk/{diskId} | Update
*FirewallApi* | [**FirewallActionAttach**](docs/FirewallApi.md#firewallactionattach) | **Post** /firewall/{firewallId}/actions/attach | /actions/attach
*FirewallApi* | [**FirewallActionDetach**](docs/FirewallApi.md#firewallactiondetach) | **Post** /firewall/{firewallId}/actions/detach | /actions/detach
*FirewallApi* | [**FirewallActionTransfer**](docs/FirewallApi.md#firewallactiontransfer) | **Post** /firewall/{firewallId}/actions/transfer | /actions/transfer
*FirewallApi* | [**FirewallCreate**](docs/FirewallApi.md#firewallcreate) | **Post** /firewall | Create
*FirewallApi* | [**FirewallDelete**](docs/FirewallApi.md#firewalldelete) | **Delete** /firewall/{firewallId} | Delete
*FirewallApi* | [**FirewallDeleteAccessrightsIdentity**](docs/FirewallApi.md#firewalldeleteaccessrightsidentity) | **Delete** /firewall/{firewallId}/accessrights/{identity} | /accessrights/:identity
*FirewallApi* | [**FirewallDeleteEgressRuleId**](docs/FirewallApi.md#firewalldeleteegressruleid) | **Delete** /firewall/{firewallId}/egress/{ruleId} | /egress/:ruleId
*FirewallApi* | [**FirewallDeleteIngressRuleId**](docs/FirewallApi.md#firewalldeleteingressruleid) | **Delete** /firewall/{firewallId}/ingress/{ruleId} | /ingress/:ruleId
*FirewallApi* | [**FirewallDeleteTagKey**](docs/FirewallApi.md#firewalldeletetagkey) | **Delete** /firewall/{firewallId}/tag/{key} | /tag/:key
*FirewallApi* | [**FirewallGetEgressRuleId**](docs/FirewallApi.md#firewallgetegressruleid) | **Get** /firewall/{firewallId}/egress/{ruleId} | /egress/:ruleId
*FirewallApi* | [**FirewallGetIngressRuleId**](docs/FirewallApi.md#firewallgetingressruleid) | **Get** /firewall/{firewallId}/ingress/{ruleId} | /ingress/:ruleId
*FirewallApi* | [**FirewallGetServicesServiceId**](docs/FirewallApi.md#firewallgetservicesserviceid) | **Get** /firewall/{firewallId}/services/{serviceId} | /services/:serviceId
*FirewallApi* | [**FirewallGetTag**](docs/FirewallApi.md#firewallgettag) | **Get** /firewall/{firewallId}/tag | /tag
*FirewallApi* | [**FirewallList**](docs/FirewallApi.md#firewalllist) | **Get** /firewall | List
*FirewallApi* | [**FirewallListAccessrights**](docs/FirewallApi.md#firewalllistaccessrights) | **Get** /firewall/{firewallId}/accessrights | /accessrights
*FirewallApi* | [**FirewallListEgress**](docs/FirewallApi.md#firewalllistegress) | **Get** /firewall/{firewallId}/egress | /egress
*FirewallApi* | [**FirewallListIngress**](docs/FirewallApi.md#firewalllistingress) | **Get** /firewall/{firewallId}/ingress | /ingress
*FirewallApi* | [**FirewallListQueue**](docs/FirewallApi.md#firewalllistqueue) | **Get** /firewall/{firewallId}/queue | /queue
*FirewallApi* | [**FirewallListServices**](docs/FirewallApi.md#firewalllistservices) | **Get** /firewall/{firewallId}/services | /services
*FirewallApi* | [**FirewallPatchTag**](docs/FirewallApi.md#firewallpatchtag) | **Patch** /firewall/{firewallId}/tag | /tag
*FirewallApi* | [**FirewallPostAccessrights**](docs/FirewallApi.md#firewallpostaccessrights) | **Post** /firewall/{firewallId}/accessrights | /accessrights
*FirewallApi* | [**FirewallPostEgress**](docs/FirewallApi.md#firewallpostegress) | **Post** /firewall/{firewallId}/egress | /egress
*FirewallApi* | [**FirewallPostIngress**](docs/FirewallApi.md#firewallpostingress) | **Post** /firewall/{firewallId}/ingress | /ingress
*FirewallApi* | [**FirewallShow**](docs/FirewallApi.md#firewallshow) | **Get** /firewall/{firewallId} | Get
*FirewallApi* | [**FirewallUpdate**](docs/FirewallApi.md#firewallupdate) | **Patch** /firewall/{firewallId} | Update
*ImageApi* | [**ImageActionTransfer**](docs/ImageApi.md#imageactiontransfer) | **Post** /image/{imageId}/actions/transfer | /actions/transfer
*ImageApi* | [**ImageCreate**](docs/ImageApi.md#imagecreate) | **Post** /image | Create
*ImageApi* | [**ImageDelete**](docs/ImageApi.md#imagedelete) | **Delete** /image/{imageId} | Delete
*ImageApi* | [**ImageDeleteAccessrightsIdentity**](docs/ImageApi.md#imagedeleteaccessrightsidentity) | **Delete** /image/{imageId}/accessrights/{identity} | /accessrights/:identity
*ImageApi* | [**ImageDeleteTagKey**](docs/ImageApi.md#imagedeletetagkey) | **Delete** /image/{imageId}/tag/{key} | /tag/:key
*ImageApi* | [**ImageGetServicesServiceId**](docs/ImageApi.md#imagegetservicesserviceid) | **Get** /image/{imageId}/services/{serviceId} | /services/:serviceId
*ImageApi* | [**ImageGetTag**](docs/ImageApi.md#imagegettag) | **Get** /image/{imageId}/tag | /tag
*ImageApi* | [**ImageList**](docs/ImageApi.md#imagelist) | **Get** /image | List
*ImageApi* | [**ImageListAccessrights**](docs/ImageApi.md#imagelistaccessrights) | **Get** /image/{imageId}/accessrights | /accessrights
*ImageApi* | [**ImageListQueue**](docs/ImageApi.md#imagelistqueue) | **Get** /image/{imageId}/queue | /queue
*ImageApi* | [**ImageListServices**](docs/ImageApi.md#imagelistservices) | **Get** /image/{imageId}/services | /services
*ImageApi* | [**ImagePatchTag**](docs/ImageApi.md#imagepatchtag) | **Patch** /image/{imageId}/tag | /tag
*ImageApi* | [**ImagePostAccessrights**](docs/ImageApi.md#imagepostaccessrights) | **Post** /image/{imageId}/accessrights | /accessrights
*ImageApi* | [**ImageShow**](docs/ImageApi.md#imageshow) | **Get** /image/{imageId} | Get
*ImageApi* | [**ImageUpdate**](docs/ImageApi.md#imageupdate) | **Patch** /image/{imageId} | Update
*IpApi* | [**IpActionAllocate**](docs/IpApi.md#ipactionallocate) | **Post** /ip/{ipId}/actions/allocate | /actions/allocate
*IpApi* | [**IpActionAssociate**](docs/IpApi.md#ipactionassociate) | **Post** /ip/{ipId}/actions/associate | /actions/associate
*IpApi* | [**IpActionDisassociate**](docs/IpApi.md#ipactiondisassociate) | **Post** /ip/{ipId}/actions/disassociate | /actions/disassociate
*IpApi* | [**IpActionRelease**](docs/IpApi.md#ipactionrelease) | **Post** /ip/{ipId}/actions/release | /actions/release
*IpApi* | [**IpActionTransfer**](docs/IpApi.md#ipactiontransfer) | **Post** /ip/{ipId}/actions/transfer | /actions/transfer
*IpApi* | [**IpCreate**](docs/IpApi.md#ipcreate) | **Post** /ip | Create
*IpApi* | [**IpDelete**](docs/IpApi.md#ipdelete) | **Delete** /ip/{ipId} | Delete
*IpApi* | [**IpDeleteAccessrightsIdentity**](docs/IpApi.md#ipdeleteaccessrightsidentity) | **Delete** /ip/{ipId}/accessrights/{identity} | /accessrights/:identity
*IpApi* | [**IpDeleteTagKey**](docs/IpApi.md#ipdeletetagkey) | **Delete** /ip/{ipId}/tag/{key} | /tag/:key
*IpApi* | [**IpGetServicesServiceId**](docs/IpApi.md#ipgetservicesserviceid) | **Get** /ip/{ipId}/services/{serviceId} | /services/:serviceId
*IpApi* | [**IpGetTag**](docs/IpApi.md#ipgettag) | **Get** /ip/{ipId}/tag | /tag
*IpApi* | [**IpList**](docs/IpApi.md#iplist) | **Get** /ip | List
*IpApi* | [**IpListAccessrights**](docs/IpApi.md#iplistaccessrights) | **Get** /ip/{ipId}/accessrights | /accessrights
*IpApi* | [**IpListQueue**](docs/IpApi.md#iplistqueue) | **Get** /ip/{ipId}/queue | /queue
*IpApi* | [**IpListServices**](docs/IpApi.md#iplistservices) | **Get** /ip/{ipId}/services | /services
*IpApi* | [**IpPatchTag**](docs/IpApi.md#ippatchtag) | **Patch** /ip/{ipId}/tag | /tag
*IpApi* | [**IpPostAccessrights**](docs/IpApi.md#ippostaccessrights) | **Post** /ip/{ipId}/accessrights | /accessrights
*IpApi* | [**IpShow**](docs/IpApi.md#ipshow) | **Get** /ip/{ipId} | Get
*IpApi* | [**IpUpdate**](docs/IpApi.md#ipupdate) | **Patch** /ip/{ipId} | Update
*IsoApi* | [**IsoActionTransfer**](docs/IsoApi.md#isoactiontransfer) | **Post** /iso/{isoId}/actions/transfer | /actions/transfer
*IsoApi* | [**IsoCreate**](docs/IsoApi.md#isocreate) | **Post** /iso | Create
*IsoApi* | [**IsoDelete**](docs/IsoApi.md#isodelete) | **Delete** /iso/{isoId} | Delete
*IsoApi* | [**IsoDeleteAccessrightsIdentity**](docs/IsoApi.md#isodeleteaccessrightsidentity) | **Delete** /iso/{isoId}/accessrights/{identity} | /accessrights/:identity
*IsoApi* | [**IsoDeleteTagKey**](docs/IsoApi.md#isodeletetagkey) | **Delete** /iso/{isoId}/tag/{key} | /tag/:key
*IsoApi* | [**IsoGetServicesServiceId**](docs/IsoApi.md#isogetservicesserviceid) | **Get** /iso/{isoId}/services/{serviceId} | /services/:serviceId
*IsoApi* | [**IsoGetTag**](docs/IsoApi.md#isogettag) | **Get** /iso/{isoId}/tag | /tag
*IsoApi* | [**IsoList**](docs/IsoApi.md#isolist) | **Get** /iso | List
*IsoApi* | [**IsoListAccessrights**](docs/IsoApi.md#isolistaccessrights) | **Get** /iso/{isoId}/accessrights | /accessrights
*IsoApi* | [**IsoListQueue**](docs/IsoApi.md#isolistqueue) | **Get** /iso/{isoId}/queue | /queue
*IsoApi* | [**IsoListServices**](docs/IsoApi.md#isolistservices) | **Get** /iso/{isoId}/services | /services
*IsoApi* | [**IsoPatchTag**](docs/IsoApi.md#isopatchtag) | **Patch** /iso/{isoId}/tag | /tag
*IsoApi* | [**IsoPostAccessrights**](docs/IsoApi.md#isopostaccessrights) | **Post** /iso/{isoId}/accessrights | /accessrights
*IsoApi* | [**IsoShow**](docs/IsoApi.md#isoshow) | **Get** /iso/{isoId} | Get
*IsoApi* | [**IsoUpdate**](docs/IsoApi.md#isoupdate) | **Patch** /iso/{isoId} | Update
*LogArchiveApi* | [**LogArchiveActionTransfer**](docs/LogArchiveApi.md#logarchiveactiontransfer) | **Post** /logArchive/{logArchiveId}/actions/transfer | /actions/transfer
*LogArchiveApi* | [**LogArchiveCreate**](docs/LogArchiveApi.md#logarchivecreate) | **Post** /logArchive | Create
*LogArchiveApi* | [**LogArchiveDelete**](docs/LogArchiveApi.md#logarchivedelete) | **Delete** /logArchive/{logArchiveId} | Delete
*LogArchiveApi* | [**LogArchiveDeleteAccessrightsIdentity**](docs/LogArchiveApi.md#logarchivedeleteaccessrightsidentity) | **Delete** /logArchive/{logArchiveId}/accessrights/{identity} | /accessrights/:identity
*LogArchiveApi* | [**LogArchiveDeleteCredentialcertificateId**](docs/LogArchiveApi.md#logarchivedeletecredentialcertificateid) | **Delete** /logArchive/{logArchiveId}/credential/certificate/{id} | /credential/certificate/:id
*LogArchiveApi* | [**LogArchiveDeleteCredentialpasswordId**](docs/LogArchiveApi.md#logarchivedeletecredentialpasswordid) | **Delete** /logArchive/{logArchiveId}/credential/password/{id} | /credential/password/:id
*LogArchiveApi* | [**LogArchiveDeleteTagKey**](docs/LogArchiveApi.md#logarchivedeletetagkey) | **Delete** /logArchive/{logArchiveId}/tag/{key} | /tag/:key
*LogArchiveApi* | [**LogArchiveGetCredentialcertificateId**](docs/LogArchiveApi.md#logarchivegetcredentialcertificateid) | **Get** /logArchive/{logArchiveId}/credential/certificate/{id} | /credential/certificate/:id
*LogArchiveApi* | [**LogArchiveGetCredentialpasswordId**](docs/LogArchiveApi.md#logarchivegetcredentialpasswordid) | **Get** /logArchive/{logArchiveId}/credential/password/{id} | /credential/password/:id
*LogArchiveApi* | [**LogArchiveGetServicesServiceId**](docs/LogArchiveApi.md#logarchivegetservicesserviceid) | **Get** /logArchive/{logArchiveId}/services/{serviceId} | /services/:serviceId
*LogArchiveApi* | [**LogArchiveGetTag**](docs/LogArchiveApi.md#logarchivegettag) | **Get** /logArchive/{logArchiveId}/tag | /tag
*LogArchiveApi* | [**LogArchiveList**](docs/LogArchiveApi.md#logarchivelist) | **Get** /logArchive | List
*LogArchiveApi* | [**LogArchiveListAccessrights**](docs/LogArchiveApi.md#logarchivelistaccessrights) | **Get** /logArchive/{logArchiveId}/accessrights | /accessrights
*LogArchiveApi* | [**LogArchiveListCredentialcertificate**](docs/LogArchiveApi.md#logarchivelistcredentialcertificate) | **Get** /logArchive/{logArchiveId}/credential/certificate | /credential/certificate
*LogArchiveApi* | [**LogArchiveListCredentialpassword**](docs/LogArchiveApi.md#logarchivelistcredentialpassword) | **Get** /logArchive/{logArchiveId}/credential/password | /credential/password
*LogArchiveApi* | [**LogArchiveListQueue**](docs/LogArchiveApi.md#logarchivelistqueue) | **Get** /logArchive/{logArchiveId}/queue | /queue
*LogArchiveApi* | [**LogArchiveListServices**](docs/LogArchiveApi.md#logarchivelistservices) | **Get** /logArchive/{logArchiveId}/services | /services
*LogArchiveApi* | [**LogArchivePatchCredentialcertificateId**](docs/LogArchiveApi.md#logarchivepatchcredentialcertificateid) | **Patch** /logArchive/{logArchiveId}/credential/certificate/{id} | /credential/certificate/:id
*LogArchiveApi* | [**LogArchivePatchCredentialpasswordId**](docs/LogArchiveApi.md#logarchivepatchcredentialpasswordid) | **Patch** /logArchive/{logArchiveId}/credential/password/{id} | /credential/password/:id
*LogArchiveApi* | [**LogArchivePatchTag**](docs/LogArchiveApi.md#logarchivepatchtag) | **Patch** /logArchive/{logArchiveId}/tag | /tag
*LogArchiveApi* | [**LogArchivePostAccessrights**](docs/LogArchiveApi.md#logarchivepostaccessrights) | **Post** /logArchive/{logArchiveId}/accessrights | /accessrights
*LogArchiveApi* | [**LogArchivePostCredentialcertificate**](docs/LogArchiveApi.md#logarchivepostcredentialcertificate) | **Post** /logArchive/{logArchiveId}/credential/certificate | /credential/certificate
*LogArchiveApi* | [**LogArchivePostCredentialpassword**](docs/LogArchiveApi.md#logarchivepostcredentialpassword) | **Post** /logArchive/{logArchiveId}/credential/password | /credential/password
*LogArchiveApi* | [**LogArchiveShow**](docs/LogArchiveApi.md#logarchiveshow) | **Get** /logArchive/{logArchiveId} | Get
*LogArchiveApi* | [**LogArchiveUpdate**](docs/LogArchiveApi.md#logarchiveupdate) | **Patch** /logArchive/{logArchiveId} | Update
*NetadpApi* | [**NetadpDeleteAccessrightsIdentity**](docs/NetadpApi.md#netadpdeleteaccessrightsidentity) | **Delete** /netadp/{netadpId}/accessrights/{identity} | /accessrights/:identity
*NetadpApi* | [**NetadpDeleteTagKey**](docs/NetadpApi.md#netadpdeletetagkey) | **Delete** /netadp/{netadpId}/tag/{key} | /tag/:key
*NetadpApi* | [**NetadpGetServicesServiceId**](docs/NetadpApi.md#netadpgetservicesserviceid) | **Get** /netadp/{netadpId}/services/{serviceId} | /services/:serviceId
*NetadpApi* | [**NetadpGetTag**](docs/NetadpApi.md#netadpgettag) | **Get** /netadp/{netadpId}/tag | /tag
*NetadpApi* | [**NetadpList**](docs/NetadpApi.md#netadplist) | **Get** /netadp | List
*NetadpApi* | [**NetadpListAccessrights**](docs/NetadpApi.md#netadplistaccessrights) | **Get** /netadp/{netadpId}/accessrights | /accessrights
*NetadpApi* | [**NetadpListQueue**](docs/NetadpApi.md#netadplistqueue) | **Get** /netadp/{netadpId}/queue | /queue
*NetadpApi* | [**NetadpListServices**](docs/NetadpApi.md#netadplistservices) | **Get** /netadp/{netadpId}/services | /services
*NetadpApi* | [**NetadpPatchTag**](docs/NetadpApi.md#netadppatchtag) | **Patch** /netadp/{netadpId}/tag | /tag
*NetadpApi* | [**NetadpPostAccessrights**](docs/NetadpApi.md#netadppostaccessrights) | **Post** /netadp/{netadpId}/accessrights | /accessrights
*NetadpApi* | [**NetadpShow**](docs/NetadpApi.md#netadpshow) | **Get** /netadp/{netadpId} | Get
*NetgwApi* | [**NetgwActionAttach**](docs/NetgwApi.md#netgwactionattach) | **Post** /netgw/{netgwId}/actions/attach | /actions/attach
*NetgwApi* | [**NetgwActionDetach**](docs/NetgwApi.md#netgwactiondetach) | **Post** /netgw/{netgwId}/actions/detach | /actions/detach
*NetgwApi* | [**NetgwCreate**](docs/NetgwApi.md#netgwcreate) | **Post** /netgw | Create
*NetgwApi* | [**NetgwDelete**](docs/NetgwApi.md#netgwdelete) | **Delete** /netgw/{netgwId} | Delete
*NetgwApi* | [**NetgwDeleteAccessrightsIdentity**](docs/NetgwApi.md#netgwdeleteaccessrightsidentity) | **Delete** /netgw/{netgwId}/accessrights/{identity} | /accessrights/:identity
*NetgwApi* | [**NetgwDeleteTagKey**](docs/NetgwApi.md#netgwdeletetagkey) | **Delete** /netgw/{netgwId}/tag/{key} | /tag/:key
*NetgwApi* | [**NetgwGetServicesServiceId**](docs/NetgwApi.md#netgwgetservicesserviceid) | **Get** /netgw/{netgwId}/services/{serviceId} | /services/:serviceId
*NetgwApi* | [**NetgwGetTag**](docs/NetgwApi.md#netgwgettag) | **Get** /netgw/{netgwId}/tag | /tag
*NetgwApi* | [**NetgwList**](docs/NetgwApi.md#netgwlist) | **Get** /netgw | List
*NetgwApi* | [**NetgwListAccessrights**](docs/NetgwApi.md#netgwlistaccessrights) | **Get** /netgw/{netgwId}/accessrights | /accessrights
*NetgwApi* | [**NetgwListQueue**](docs/NetgwApi.md#netgwlistqueue) | **Get** /netgw/{netgwId}/queue | /queue
*NetgwApi* | [**NetgwListServices**](docs/NetgwApi.md#netgwlistservices) | **Get** /netgw/{netgwId}/services | /services
*NetgwApi* | [**NetgwPatchTag**](docs/NetgwApi.md#netgwpatchtag) | **Patch** /netgw/{netgwId}/tag | /tag
*NetgwApi* | [**NetgwPostAccessrights**](docs/NetgwApi.md#netgwpostaccessrights) | **Post** /netgw/{netgwId}/accessrights | /accessrights
*NetgwApi* | [**NetgwShow**](docs/NetgwApi.md#netgwshow) | **Get** /netgw/{netgwId} | Get
*NetgwApi* | [**NetgwUpdate**](docs/NetgwApi.md#netgwupdate) | **Patch** /netgw/{netgwId} | Update
*NetworkApi* | [**NetworkCreate**](docs/NetworkApi.md#networkcreate) | **Post** /network | Create
*NetworkApi* | [**NetworkDelete**](docs/NetworkApi.md#networkdelete) | **Delete** /network/{networkId} | Delete
*NetworkApi* | [**NetworkDeleteAccessrightsIdentity**](docs/NetworkApi.md#networkdeleteaccessrightsidentity) | **Delete** /network/{networkId}/accessrights/{identity} | /accessrights/:identity
*NetworkApi* | [**NetworkDeleteIpIpId**](docs/NetworkApi.md#networkdeleteipipid) | **Delete** /network/{networkId}/ip/{ipId} | /ip/:ipId
*NetworkApi* | [**NetworkDeleteTagKey**](docs/NetworkApi.md#networkdeletetagkey) | **Delete** /network/{networkId}/tag/{key} | /tag/:key
*NetworkApi* | [**NetworkGetIpIpId**](docs/NetworkApi.md#networkgetipipid) | **Get** /network/{networkId}/ip/{ipId} | /ip/:ipId
*NetworkApi* | [**NetworkGetServicesServiceId**](docs/NetworkApi.md#networkgetservicesserviceid) | **Get** /network/{networkId}/services/{serviceId} | /services/:serviceId
*NetworkApi* | [**NetworkGetTag**](docs/NetworkApi.md#networkgettag) | **Get** /network/{networkId}/tag | /tag
*NetworkApi* | [**NetworkList**](docs/NetworkApi.md#networklist) | **Get** /network | List
*NetworkApi* | [**NetworkListAccessrights**](docs/NetworkApi.md#networklistaccessrights) | **Get** /network/{networkId}/accessrights | /accessrights
*NetworkApi* | [**NetworkListIp**](docs/NetworkApi.md#networklistip) | **Get** /network/{networkId}/ip | /ip
*NetworkApi* | [**NetworkListQueue**](docs/NetworkApi.md#networklistqueue) | **Get** /network/{networkId}/queue | /queue
*NetworkApi* | [**NetworkListServices**](docs/NetworkApi.md#networklistservices) | **Get** /network/{networkId}/services | /services
*NetworkApi* | [**NetworkPatchTag**](docs/NetworkApi.md#networkpatchtag) | **Patch** /network/{networkId}/tag | /tag
*NetworkApi* | [**NetworkPostAccessrights**](docs/NetworkApi.md#networkpostaccessrights) | **Post** /network/{networkId}/accessrights | /accessrights
*NetworkApi* | [**NetworkPostIp**](docs/NetworkApi.md#networkpostip) | **Post** /network/{networkId}/ip | /ip
*NetworkApi* | [**NetworkShow**](docs/NetworkApi.md#networkshow) | **Get** /network/{networkId} | Get
*NetworkApi* | [**NetworkUpdate**](docs/NetworkApi.md#networkupdate) | **Patch** /network/{networkId} | Update
*OrganisationApi* | [**OrganisationActionTransferAccept**](docs/OrganisationApi.md#organisationactiontransferaccept) | **Post** /organisation/{organisationId}/actions/transfer_accept | /actions/transfer_accept
*OrganisationApi* | [**OrganisationCreate**](docs/OrganisationApi.md#organisationcreate) | **Post** /organisation | Create
*OrganisationApi* | [**OrganisationDeleteAccessrightsId**](docs/OrganisationApi.md#organisationdeleteaccessrightsid) | **Delete** /organisation/{organisationId}/accessrights/{id} | /accessrights/:id
*OrganisationApi* | [**OrganisationDeleteTagKey**](docs/OrganisationApi.md#organisationdeletetagkey) | **Delete** /organisation/{organisationId}/tag/{key} | /tag/:key
*OrganisationApi* | [**OrganisationGetTag**](docs/OrganisationApi.md#organisationgettag) | **Get** /organisation/{organisationId}/tag | /tag
*OrganisationApi* | [**OrganisationList**](docs/OrganisationApi.md#organisationlist) | **Get** /organisation | List
*OrganisationApi* | [**OrganisationListAccessrights**](docs/OrganisationApi.md#organisationlistaccessrights) | **Get** /organisation/{organisationId}/accessrights | /accessrights
*OrganisationApi* | [**OrganisationListQueue**](docs/OrganisationApi.md#organisationlistqueue) | **Get** /organisation/{organisationId}/queue | /queue
*OrganisationApi* | [**OrganisationPatchTag**](docs/OrganisationApi.md#organisationpatchtag) | **Patch** /organisation/{organisationId}/tag | /tag
*OrganisationApi* | [**OrganisationPostAccessrights**](docs/OrganisationApi.md#organisationpostaccessrights) | **Post** /organisation/{organisationId}/accessrights | /accessrights
*OrganisationApi* | [**OrganisationShow**](docs/OrganisationApi.md#organisationshow) | **Get** /organisation/{organisationId} | Get
*OrganisationApi* | [**OrganisationUpdate**](docs/OrganisationApi.md#organisationupdate) | **Patch** /organisation/{organisationId} | Update
*ProjectApi* | [**ProjectCreate**](docs/ProjectApi.md#projectcreate) | **Post** /project | Create
*ProjectApi* | [**ProjectDelete**](docs/ProjectApi.md#projectdelete) | **Delete** /project/{projectId} | Delete
*ProjectApi* | [**ProjectDeleteAccessrightsId**](docs/ProjectApi.md#projectdeleteaccessrightsid) | **Delete** /project/{projectId}/accessrights/{id} | /accessrights/:id
*ProjectApi* | [**ProjectDeleteCredentialStorecertificateId**](docs/ProjectApi.md#projectdeletecredentialstorecertificateid) | **Delete** /project/{projectId}/credentialStore/certificate/{id} | /credentialStore/certificate/:id
*ProjectApi* | [**ProjectDeleteTagKey**](docs/ProjectApi.md#projectdeletetagkey) | **Delete** /project/{projectId}/tag/{key} | /tag/:key
*ProjectApi* | [**ProjectGetCredentialStorecertificateId**](docs/ProjectApi.md#projectgetcredentialstorecertificateid) | **Get** /project/{projectId}/credentialStore/certificate/{id} | /credentialStore/certificate/:id
*ProjectApi* | [**ProjectGetServicesServiceId**](docs/ProjectApi.md#projectgetservicesserviceid) | **Get** /project/{projectId}/services/{serviceId} | /services/:serviceId
*ProjectApi* | [**ProjectGetTag**](docs/ProjectApi.md#projectgettag) | **Get** /project/{projectId}/tag | /tag
*ProjectApi* | [**ProjectList**](docs/ProjectApi.md#projectlist) | **Get** /project | List
*ProjectApi* | [**ProjectListAccessrights**](docs/ProjectApi.md#projectlistaccessrights) | **Get** /project/{projectId}/accessrights | /accessrights
*ProjectApi* | [**ProjectListCredentialStorecertificate**](docs/ProjectApi.md#projectlistcredentialstorecertificate) | **Get** /project/{projectId}/credentialStore/certificate | /credentialStore/certificate
*ProjectApi* | [**ProjectListQueue**](docs/ProjectApi.md#projectlistqueue) | **Get** /project/{projectId}/queue | /queue
*ProjectApi* | [**ProjectListServices**](docs/ProjectApi.md#projectlistservices) | **Get** /project/{projectId}/services | /services
*ProjectApi* | [**ProjectPatchCredentialStorecertificateId**](docs/ProjectApi.md#projectpatchcredentialstorecertificateid) | **Patch** /project/{projectId}/credentialStore/certificate/{id} | /credentialStore/certificate/:id
*ProjectApi* | [**ProjectPatchTag**](docs/ProjectApi.md#projectpatchtag) | **Patch** /project/{projectId}/tag | /tag
*ProjectApi* | [**ProjectPostAccessrights**](docs/ProjectApi.md#projectpostaccessrights) | **Post** /project/{projectId}/accessrights | /accessrights
*ProjectApi* | [**ProjectPostCredentialStorecertificate**](docs/ProjectApi.md#projectpostcredentialstorecertificate) | **Post** /project/{projectId}/credentialStore/certificate | /credentialStore/certificate
*ProjectApi* | [**ProjectShow**](docs/ProjectApi.md#projectshow) | **Get** /project/{projectId} | Get
*ProjectApi* | [**ProjectUpdate**](docs/ProjectApi.md#projectupdate) | **Patch** /project/{projectId} | Update
*ReplicaApi* | [**ReplicaActionImage**](docs/ReplicaApi.md#replicaactionimage) | **Post** /replica/{replicaId}/actions/image | /actions/image
*ReplicaApi* | [**ReplicaCreate**](docs/ReplicaApi.md#replicacreate) | **Post** /replica | Create
*ReplicaApi* | [**ReplicaDelete**](docs/ReplicaApi.md#replicadelete) | **Delete** /replica/{replicaId} | Delete
*ReplicaApi* | [**ReplicaDeleteAccessrightsIdentity**](docs/ReplicaApi.md#replicadeleteaccessrightsidentity) | **Delete** /replica/{replicaId}/accessrights/{identity} | /accessrights/:identity
*ReplicaApi* | [**ReplicaDeleteTagKey**](docs/ReplicaApi.md#replicadeletetagkey) | **Delete** /replica/{replicaId}/tag/{key} | /tag/:key
*ReplicaApi* | [**ReplicaGetServicesServiceId**](docs/ReplicaApi.md#replicagetservicesserviceid) | **Get** /replica/{replicaId}/services/{serviceId} | /services/:serviceId
*ReplicaApi* | [**ReplicaGetTag**](docs/ReplicaApi.md#replicagettag) | **Get** /replica/{replicaId}/tag | /tag
*ReplicaApi* | [**ReplicaList**](docs/ReplicaApi.md#replicalist) | **Get** /replica | List
*ReplicaApi* | [**ReplicaListAccessrights**](docs/ReplicaApi.md#replicalistaccessrights) | **Get** /replica/{replicaId}/accessrights | /accessrights
*ReplicaApi* | [**ReplicaListQueue**](docs/ReplicaApi.md#replicalistqueue) | **Get** /replica/{replicaId}/queue | /queue
*ReplicaApi* | [**ReplicaListServices**](docs/ReplicaApi.md#replicalistservices) | **Get** /replica/{replicaId}/services | /services
*ReplicaApi* | [**ReplicaPatchTag**](docs/ReplicaApi.md#replicapatchtag) | **Patch** /replica/{replicaId}/tag | /tag
*ReplicaApi* | [**ReplicaPostAccessrights**](docs/ReplicaApi.md#replicapostaccessrights) | **Post** /replica/{replicaId}/accessrights | /accessrights
*ReplicaApi* | [**ReplicaShow**](docs/ReplicaApi.md#replicashow) | **Get** /replica/{replicaId} | Get
*ReservationApi* | [**ReservationActionAssign**](docs/ReservationApi.md#reservationactionassign) | **Post** /reservation/{reservationId}/actions/assign | /actions/assign
*ReservationApi* | [**ReservationActionExtend**](docs/ReservationApi.md#reservationactionextend) | **Post** /reservation/{reservationId}/actions/extend | /actions/extend
*ReservationApi* | [**ReservationActionUnassign**](docs/ReservationApi.md#reservationactionunassign) | **Post** /reservation/{reservationId}/actions/unassign | /actions/unassign
*ReservationApi* | [**ReservationCreate**](docs/ReservationApi.md#reservationcreate) | **Post** /reservation | Create
*ReservationApi* | [**ReservationDelete**](docs/ReservationApi.md#reservationdelete) | **Delete** /reservation/{reservationId} | Delete
*ReservationApi* | [**ReservationDeleteAccessrightsIdentity**](docs/ReservationApi.md#reservationdeleteaccessrightsidentity) | **Delete** /reservation/{reservationId}/accessrights/{identity} | /accessrights/:identity
*ReservationApi* | [**ReservationDeleteTagKey**](docs/ReservationApi.md#reservationdeletetagkey) | **Delete** /reservation/{reservationId}/tag/{key} | /tag/:key
*ReservationApi* | [**ReservationGetServicesServiceId**](docs/ReservationApi.md#reservationgetservicesserviceid) | **Get** /reservation/{reservationId}/services/{serviceId} | /services/:serviceId
*ReservationApi* | [**ReservationGetTag**](docs/ReservationApi.md#reservationgettag) | **Get** /reservation/{reservationId}/tag | /tag
*ReservationApi* | [**ReservationList**](docs/ReservationApi.md#reservationlist) | **Get** /reservation | List
*ReservationApi* | [**ReservationListAccessrights**](docs/ReservationApi.md#reservationlistaccessrights) | **Get** /reservation/{reservationId}/accessrights | /accessrights
*ReservationApi* | [**ReservationListQueue**](docs/ReservationApi.md#reservationlistqueue) | **Get** /reservation/{reservationId}/queue | /queue
*ReservationApi* | [**ReservationListServices**](docs/ReservationApi.md#reservationlistservices) | **Get** /reservation/{reservationId}/services | /services
*ReservationApi* | [**ReservationPatchTag**](docs/ReservationApi.md#reservationpatchtag) | **Patch** /reservation/{reservationId}/tag | /tag
*ReservationApi* | [**ReservationPostAccessrights**](docs/ReservationApi.md#reservationpostaccessrights) | **Post** /reservation/{reservationId}/accessrights | /accessrights
*ReservationApi* | [**ReservationShow**](docs/ReservationApi.md#reservationshow) | **Get** /reservation/{reservationId} | Get
*ReservationApi* | [**ReservationUpdate**](docs/ReservationApi.md#reservationupdate) | **Patch** /reservation/{reservationId} | Update
*SnapshotApi* | [**SnapshotCreate**](docs/SnapshotApi.md#snapshotcreate) | **Post** /snapshot | Create
*SnapshotApi* | [**SnapshotDelete**](docs/SnapshotApi.md#snapshotdelete) | **Delete** /snapshot/{snapshotId} | Delete
*SnapshotApi* | [**SnapshotDeleteAccessrightsIdentity**](docs/SnapshotApi.md#snapshotdeleteaccessrightsidentity) | **Delete** /snapshot/{snapshotId}/accessrights/{identity} | /accessrights/:identity
*SnapshotApi* | [**SnapshotDeleteTagKey**](docs/SnapshotApi.md#snapshotdeletetagkey) | **Delete** /snapshot/{snapshotId}/tag/{key} | /tag/:key
*SnapshotApi* | [**SnapshotGetServicesServiceId**](docs/SnapshotApi.md#snapshotgetservicesserviceid) | **Get** /snapshot/{snapshotId}/services/{serviceId} | /services/:serviceId
*SnapshotApi* | [**SnapshotGetTag**](docs/SnapshotApi.md#snapshotgettag) | **Get** /snapshot/{snapshotId}/tag | /tag
*SnapshotApi* | [**SnapshotList**](docs/SnapshotApi.md#snapshotlist) | **Get** /snapshot | List
*SnapshotApi* | [**SnapshotListAccessrights**](docs/SnapshotApi.md#snapshotlistaccessrights) | **Get** /snapshot/{snapshotId}/accessrights | /accessrights
*SnapshotApi* | [**SnapshotListQueue**](docs/SnapshotApi.md#snapshotlistqueue) | **Get** /snapshot/{snapshotId}/queue | /queue
*SnapshotApi* | [**SnapshotListServices**](docs/SnapshotApi.md#snapshotlistservices) | **Get** /snapshot/{snapshotId}/services | /services
*SnapshotApi* | [**SnapshotPatchTag**](docs/SnapshotApi.md#snapshotpatchtag) | **Patch** /snapshot/{snapshotId}/tag | /tag
*SnapshotApi* | [**SnapshotPostAccessrights**](docs/SnapshotApi.md#snapshotpostaccessrights) | **Post** /snapshot/{snapshotId}/accessrights | /accessrights
*SnapshotApi* | [**SnapshotShow**](docs/SnapshotApi.md#snapshotshow) | **Get** /snapshot/{snapshotId} | Get
*SnapshotApi* | [**SnapshotUpdate**](docs/SnapshotApi.md#snapshotupdate) | **Patch** /snapshot/{snapshotId} | Update
*VaultApi* | [**VaultActionResize**](docs/VaultApi.md#vaultactionresize) | **Post** /vault/{vaultId}/actions/resize | /actions/resize
*VaultApi* | [**VaultActionSnapshot**](docs/VaultApi.md#vaultactionsnapshot) | **Post** /vault/{vaultId}/actions/snapshot | /actions/snapshot
*VaultApi* | [**VaultActionStart**](docs/VaultApi.md#vaultactionstart) | **Post** /vault/{vaultId}/actions/start | /actions/start
*VaultApi* | [**VaultActionStop**](docs/VaultApi.md#vaultactionstop) | **Post** /vault/{vaultId}/actions/stop | /actions/stop
*VaultApi* | [**VaultCreate**](docs/VaultApi.md#vaultcreate) | **Post** /vault | Create
*VaultApi* | [**VaultDelete**](docs/VaultApi.md#vaultdelete) | **Delete** /vault/{vaultId} | Delete
*VaultApi* | [**VaultDeleteAccessrightsIdentity**](docs/VaultApi.md#vaultdeleteaccessrightsidentity) | **Delete** /vault/{vaultId}/accessrights/{identity} | /accessrights/:identity
*VaultApi* | [**VaultDeleteCredentialcertificateId**](docs/VaultApi.md#vaultdeletecredentialcertificateid) | **Delete** /vault/{vaultId}/credential/certificate/{id} | /credential/certificate/:id
*VaultApi* | [**VaultDeleteCredentialpasswordId**](docs/VaultApi.md#vaultdeletecredentialpasswordid) | **Delete** /vault/{vaultId}/credential/password/{id} | /credential/password/:id
*VaultApi* | [**VaultDeleteTagKey**](docs/VaultApi.md#vaultdeletetagkey) | **Delete** /vault/{vaultId}/tag/{key} | /tag/:key
*VaultApi* | [**VaultGetCredentialcertificateId**](docs/VaultApi.md#vaultgetcredentialcertificateid) | **Get** /vault/{vaultId}/credential/certificate/{id} | /credential/certificate/:id
*VaultApi* | [**VaultGetCredentialpasswordId**](docs/VaultApi.md#vaultgetcredentialpasswordid) | **Get** /vault/{vaultId}/credential/password/{id} | /credential/password/:id
*VaultApi* | [**VaultGetServicesServiceId**](docs/VaultApi.md#vaultgetservicesserviceid) | **Get** /vault/{vaultId}/services/{serviceId} | /services/:serviceId
*VaultApi* | [**VaultGetTag**](docs/VaultApi.md#vaultgettag) | **Get** /vault/{vaultId}/tag | /tag
*VaultApi* | [**VaultList**](docs/VaultApi.md#vaultlist) | **Get** /vault | List
*VaultApi* | [**VaultListAccessrights**](docs/VaultApi.md#vaultlistaccessrights) | **Get** /vault/{vaultId}/accessrights | /accessrights
*VaultApi* | [**VaultListCredentialcertificate**](docs/VaultApi.md#vaultlistcredentialcertificate) | **Get** /vault/{vaultId}/credential/certificate | /credential/certificate
*VaultApi* | [**VaultListCredentialpassword**](docs/VaultApi.md#vaultlistcredentialpassword) | **Get** /vault/{vaultId}/credential/password | /credential/password
*VaultApi* | [**VaultListQueue**](docs/VaultApi.md#vaultlistqueue) | **Get** /vault/{vaultId}/queue | /queue
*VaultApi* | [**VaultListServices**](docs/VaultApi.md#vaultlistservices) | **Get** /vault/{vaultId}/services | /services
*VaultApi* | [**VaultPatchCredentialcertificateId**](docs/VaultApi.md#vaultpatchcredentialcertificateid) | **Patch** /vault/{vaultId}/credential/certificate/{id} | /credential/certificate/:id
*VaultApi* | [**VaultPatchCredentialpasswordId**](docs/VaultApi.md#vaultpatchcredentialpasswordid) | **Patch** /vault/{vaultId}/credential/password/{id} | /credential/password/:id
*VaultApi* | [**VaultPatchTag**](docs/VaultApi.md#vaultpatchtag) | **Patch** /vault/{vaultId}/tag | /tag
*VaultApi* | [**VaultPostAccessrights**](docs/VaultApi.md#vaultpostaccessrights) | **Post** /vault/{vaultId}/accessrights | /accessrights
*VaultApi* | [**VaultPostCredentialcertificate**](docs/VaultApi.md#vaultpostcredentialcertificate) | **Post** /vault/{vaultId}/credential/certificate | /credential/certificate
*VaultApi* | [**VaultPostCredentialpassword**](docs/VaultApi.md#vaultpostcredentialpassword) | **Post** /vault/{vaultId}/credential/password | /credential/password
*VaultApi* | [**VaultShow**](docs/VaultApi.md#vaultshow) | **Get** /vault/{vaultId} | Get
*VaultApi* | [**VaultUpdate**](docs/VaultApi.md#vaultupdate) | **Patch** /vault/{vaultId} | Update
*VmApi* | [**VmActionFlavour**](docs/VmApi.md#vmactionflavour) | **Post** /vm/{vmId}/actions/flavour | /actions/flavour
*VmApi* | [**VmActionImage**](docs/VmApi.md#vmactionimage) | **Post** /vm/{vmId}/actions/image | /actions/image
*VmApi* | [**VmActionPasswordReset**](docs/VmApi.md#vmactionpasswordreset) | **Post** /vm/{vmId}/actions/password_reset | /actions/password_reset
*VmApi* | [**VmActionRename**](docs/VmApi.md#vmactionrename) | **Post** /vm/{vmId}/actions/rename | /actions/rename
*VmApi* | [**VmActionRestart**](docs/VmApi.md#vmactionrestart) | **Post** /vm/{vmId}/actions/restart | /actions/restart
*VmApi* | [**VmActionStart**](docs/VmApi.md#vmactionstart) | **Post** /vm/{vmId}/actions/start | /actions/start
*VmApi* | [**VmActionStop**](docs/VmApi.md#vmactionstop) | **Post** /vm/{vmId}/actions/stop | /actions/stop
*VmApi* | [**VmActionTurnoff**](docs/VmApi.md#vmactionturnoff) | **Post** /vm/{vmId}/actions/turnoff | /actions/turnoff
*VmApi* | [**VmCreate**](docs/VmApi.md#vmcreate) | **Post** /vm | Create
*VmApi* | [**VmDelete**](docs/VmApi.md#vmdelete) | **Delete** /vm/{vmId} | Delete
*VmApi* | [**VmDeleteAccessrightsIdentity**](docs/VmApi.md#vmdeleteaccessrightsidentity) | **Delete** /vm/{vmId}/accessrights/{identity} | /accessrights/:identity
*VmApi* | [**VmDeleteHddDiskId**](docs/VmApi.md#vmdeletehdddiskid) | **Delete** /vm/{vmId}/hdd/{diskId} | /hdd/:diskId
*VmApi* | [**VmDeleteNetadpNetadpId**](docs/VmApi.md#vmdeletenetadpnetadpid) | **Delete** /vm/{vmId}/netadp/{netadpId} | /netadp/:netadpId
*VmApi* | [**VmDeleteTagKey**](docs/VmApi.md#vmdeletetagkey) | **Delete** /vm/{vmId}/tag/{key} | /tag/:key
*VmApi* | [**VmGetServicesServiceId**](docs/VmApi.md#vmgetservicesserviceid) | **Get** /vm/{vmId}/services/{serviceId} | /services/:serviceId
*VmApi* | [**VmGetTag**](docs/VmApi.md#vmgettag) | **Get** /vm/{vmId}/tag | /tag
*VmApi* | [**VmList**](docs/VmApi.md#vmlist) | **Get** /vm | List
*VmApi* | [**VmListAccessrights**](docs/VmApi.md#vmlistaccessrights) | **Get** /vm/{vmId}/accessrights | /accessrights
*VmApi* | [**VmListHdd**](docs/VmApi.md#vmlisthdd) | **Get** /vm/{vmId}/hdd | /hdd
*VmApi* | [**VmListNetadp**](docs/VmApi.md#vmlistnetadp) | **Get** /vm/{vmId}/netadp | /netadp
*VmApi* | [**VmListQueue**](docs/VmApi.md#vmlistqueue) | **Get** /vm/{vmId}/queue | /queue
*VmApi* | [**VmListServices**](docs/VmApi.md#vmlistservices) | **Get** /vm/{vmId}/services | /services
*VmApi* | [**VmPatchTag**](docs/VmApi.md#vmpatchtag) | **Patch** /vm/{vmId}/tag | /tag
*VmApi* | [**VmPostAccessrights**](docs/VmApi.md#vmpostaccessrights) | **Post** /vm/{vmId}/accessrights | /accessrights
*VmApi* | [**VmPostHdd**](docs/VmApi.md#vmposthdd) | **Post** /vm/{vmId}/hdd | /hdd
*VmApi* | [**VmPostNetadp**](docs/VmApi.md#vmpostnetadp) | **Post** /vm/{vmId}/netadp | /netadp
*VmApi* | [**VmShow**](docs/VmApi.md#vmshow) | **Get** /vm/{vmId} | Get
*VmApi* | [**VmUpdate**](docs/VmApi.md#vmupdate) | **Patch** /vm/{vmId} | Update
*VmhostApi* | [**VmhostActionMoveDisk**](docs/VmhostApi.md#vmhostactionmovedisk) | **Post** /vmhost/{vmhostId}/actions/moveDisk | /actions/moveDisk
*VmhostApi* | [**VmhostActionMoveISO**](docs/VmhostApi.md#vmhostactionmoveiso) | **Post** /vmhost/{vmhostId}/actions/moveISO | /actions/moveISO
*VmhostApi* | [**VmhostActionMoveImage**](docs/VmhostApi.md#vmhostactionmoveimage) | **Post** /vmhost/{vmhostId}/actions/moveImage | /actions/moveImage
*VmhostApi* | [**VmhostActionMoveVM**](docs/VmhostApi.md#vmhostactionmovevm) | **Post** /vmhost/{vmhostId}/actions/moveVM | /actions/moveVM
*VmhostApi* | [**VmhostDelete**](docs/VmhostApi.md#vmhostdelete) | **Delete** /vmhost/{vmhostId} | Delete
*VmhostApi* | [**VmhostDeleteAccessrightsIdentity**](docs/VmhostApi.md#vmhostdeleteaccessrightsidentity) | **Delete** /vmhost/{vmhostId}/accessrights/{identity} | /accessrights/:identity
*VmhostApi* | [**VmhostDeleteTagKey**](docs/VmhostApi.md#vmhostdeletetagkey) | **Delete** /vmhost/{vmhostId}/tag/{key} | /tag/:key
*VmhostApi* | [**VmhostGetServicesServiceId**](docs/VmhostApi.md#vmhostgetservicesserviceid) | **Get** /vmhost/{vmhostId}/services/{serviceId} | /services/:serviceId
*VmhostApi* | [**VmhostGetTag**](docs/VmhostApi.md#vmhostgettag) | **Get** /vmhost/{vmhostId}/tag | /tag
*VmhostApi* | [**VmhostList**](docs/VmhostApi.md#vmhostlist) | **Get** /vmhost | List
*VmhostApi* | [**VmhostListAccessrights**](docs/VmhostApi.md#vmhostlistaccessrights) | **Get** /vmhost/{vmhostId}/accessrights | /accessrights
*VmhostApi* | [**VmhostListQueue**](docs/VmhostApi.md#vmhostlistqueue) | **Get** /vmhost/{vmhostId}/queue | /queue
*VmhostApi* | [**VmhostListServices**](docs/VmhostApi.md#vmhostlistservices) | **Get** /vmhost/{vmhostId}/services | /services
*VmhostApi* | [**VmhostPatchTag**](docs/VmhostApi.md#vmhostpatchtag) | **Patch** /vmhost/{vmhostId}/tag | /tag
*VmhostApi* | [**VmhostPostAccessrights**](docs/VmhostApi.md#vmhostpostaccessrights) | **Post** /vmhost/{vmhostId}/accessrights | /accessrights
*VmhostApi* | [**VmhostShow**](docs/VmhostApi.md#vmhostshow) | **Get** /vmhost/{vmhostId} | Get
*VmhostApi* | [**VmhostUpdate**](docs/VmhostApi.md#vmhostupdate) | **Patch** /vmhost/{vmhostId} | Update


## Documentation For Models

 - [AccessrightsUserRole](docs/AccessrightsUserRole.md)
 - [Container](docs/Container.md)
 - [ContainerCreate](docs/ContainerCreate.md)
 - [ContainerCreateExpose](docs/ContainerCreateExpose.md)
 - [ContainerCreateRegistry](docs/ContainerCreateRegistry.md)
 - [ContainerCreateVolumes](docs/ContainerCreateVolumes.md)
 - [ContainerPostAccessrights](docs/ContainerPostAccessrights.md)
 - [ContainerServices](docs/ContainerServices.md)
 - [ContainerUpdate](docs/ContainerUpdate.md)
 - [CredentialCertificate](docs/CredentialCertificate.md)
 - [CredentialPassword](docs/CredentialPassword.md)
 - [Disk](docs/Disk.md)
 - [DiskActionResize](docs/DiskActionResize.md)
 - [DiskActionTransfer](docs/DiskActionTransfer.md)
 - [DiskCreate](docs/DiskCreate.md)
 - [DiskMetadata](docs/DiskMetadata.md)
 - [DiskMetadataSource](docs/DiskMetadataSource.md)
 - [DiskPostAccessrights](docs/DiskPostAccessrights.md)
 - [DiskServices](docs/DiskServices.md)
 - [DiskUpdate](docs/DiskUpdate.md)
 - [Event](docs/Event.md)
 - [EventResource](docs/EventResource.md)
 - [Firewall](docs/Firewall.md)
 - [FirewallActionAttach](docs/FirewallActionAttach.md)
 - [FirewallActionTransfer](docs/FirewallActionTransfer.md)
 - [FirewallCreate](docs/FirewallCreate.md)
 - [FirewallPostAccessrights](docs/FirewallPostAccessrights.md)
 - [FirewallPostEgress](docs/FirewallPostEgress.md)
 - [FirewallPostIngress](docs/FirewallPostIngress.md)
 - [FirewallServices](docs/FirewallServices.md)
 - [FirewallUpdate](docs/FirewallUpdate.md)
 - [Hdd](docs/Hdd.md)
 - [HddDisk](docs/HddDisk.md)
 - [Image](docs/Image.md)
 - [ImageActionTransfer](docs/ImageActionTransfer.md)
 - [ImageAttachedOn](docs/ImageAttachedOn.md)
 - [ImageCreate](docs/ImageCreate.md)
 - [ImageDisk](docs/ImageDisk.md)
 - [ImageDisks](docs/ImageDisks.md)
 - [ImagePostAccessrights](docs/ImagePostAccessrights.md)
 - [ImageServices](docs/ImageServices.md)
 - [ImageUpdate](docs/ImageUpdate.md)
 - [ImageVm](docs/ImageVm.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [Ip](docs/Ip.md)
 - [IpActionAllocate](docs/IpActionAllocate.md)
 - [IpActionAssociate](docs/IpActionAssociate.md)
 - [IpActionTransfer](docs/IpActionTransfer.md)
 - [IpAssociated](docs/IpAssociated.md)
 - [IpCreate](docs/IpCreate.md)
 - [IpPostAccessrights](docs/IpPostAccessrights.md)
 - [IpServices](docs/IpServices.md)
 - [IpUpdate](docs/IpUpdate.md)
 - [Iso](docs/Iso.md)
 - [IsoActionTransfer](docs/IsoActionTransfer.md)
 - [IsoCreate](docs/IsoCreate.md)
 - [IsoPostAccessrights](docs/IsoPostAccessrights.md)
 - [IsoServices](docs/IsoServices.md)
 - [IsoUpdate](docs/IsoUpdate.md)
 - [LogArchive](docs/LogArchive.md)
 - [LogArchiveActionTransfer](docs/LogArchiveActionTransfer.md)
 - [LogArchiveCreate](docs/LogArchiveCreate.md)
 - [LogArchivePatchCredentialcertificateId](docs/LogArchivePatchCredentialcertificateId.md)
 - [LogArchivePatchCredentialpasswordId](docs/LogArchivePatchCredentialpasswordId.md)
 - [LogArchivePostAccessrights](docs/LogArchivePostAccessrights.md)
 - [LogArchivePostCredentialcertificate](docs/LogArchivePostCredentialcertificate.md)
 - [LogArchivePostCredentialpassword](docs/LogArchivePostCredentialpassword.md)
 - [LogArchiveServices](docs/LogArchiveServices.md)
 - [LogArchiveUpdate](docs/LogArchiveUpdate.md)
 - [Netadp](docs/Netadp.md)
 - [NetadpAssigned](docs/NetadpAssigned.md)
 - [NetadpPostAccessrights](docs/NetadpPostAccessrights.md)
 - [NetadpServices](docs/NetadpServices.md)
 - [Netgw](docs/Netgw.md)
 - [NetgwActionAttach](docs/NetgwActionAttach.md)
 - [NetgwActionAttachPrivate](docs/NetgwActionAttachPrivate.md)
 - [NetgwCreate](docs/NetgwCreate.md)
 - [NetgwCreatePublic](docs/NetgwCreatePublic.md)
 - [NetgwPostAccessrights](docs/NetgwPostAccessrights.md)
 - [NetgwServices](docs/NetgwServices.md)
 - [NetgwUpdate](docs/NetgwUpdate.md)
 - [Network](docs/Network.md)
 - [NetworkCreate](docs/NetworkCreate.md)
 - [NetworkDns](docs/NetworkDns.md)
 - [NetworkPostAccessrights](docs/NetworkPostAccessrights.md)
 - [NetworkPostIp](docs/NetworkPostIp.md)
 - [NetworkServices](docs/NetworkServices.md)
 - [NetworkUpdate](docs/NetworkUpdate.md)
 - [Organisation](docs/Organisation.md)
 - [OrganisationActionTransferAccept](docs/OrganisationActionTransferAccept.md)
 - [OrganisationBilling](docs/OrganisationBilling.md)
 - [OrganisationBillingAddress](docs/OrganisationBillingAddress.md)
 - [OrganisationCreate](docs/OrganisationCreate.md)
 - [OrganisationCreateAccessRights](docs/OrganisationCreateAccessRights.md)
 - [OrganisationCreateBilling](docs/OrganisationCreateBilling.md)
 - [OrganisationCreateBillingAddress](docs/OrganisationCreateBillingAddress.md)
 - [OrganisationLimit](docs/OrganisationLimit.md)
 - [OrganisationLimitOrganisation](docs/OrganisationLimitOrganisation.md)
 - [OrganisationPostAccessrights](docs/OrganisationPostAccessrights.md)
 - [OrganisationTransfer](docs/OrganisationTransfer.md)
 - [OrganisationUpdate](docs/OrganisationUpdate.md)
 - [OrganisationUpdateBilling](docs/OrganisationUpdateBilling.md)
 - [OrganisationUpdateBillingAddress](docs/OrganisationUpdateBillingAddress.md)
 - [Payment](docs/Payment.md)
 - [Project](docs/Project.md)
 - [ProjectAccess](docs/ProjectAccess.md)
 - [ProjectAccessRights](docs/ProjectAccessRights.md)
 - [ProjectBilling](docs/ProjectBilling.md)
 - [ProjectCompliance](docs/ProjectCompliance.md)
 - [ProjectCreate](docs/ProjectCreate.md)
 - [ProjectCreateAccessRights](docs/ProjectCreateAccessRights.md)
 - [ProjectDuplicate](docs/ProjectDuplicate.md)
 - [ProjectInvoices](docs/ProjectInvoices.md)
 - [ProjectLimit](docs/ProjectLimit.md)
 - [ProjectLimitDisk](docs/ProjectLimitDisk.md)
 - [ProjectLimitDomain](docs/ProjectLimitDomain.md)
 - [ProjectLimitIso](docs/ProjectLimitIso.md)
 - [ProjectLimitVm](docs/ProjectLimitVm.md)
 - [ProjectNetworkAcl](docs/ProjectNetworkAcl.md)
 - [ProjectPatchCredentialStorecertificateId](docs/ProjectPatchCredentialStorecertificateId.md)
 - [ProjectPostAccessrights](docs/ProjectPostAccessrights.md)
 - [ProjectPostCredentialStorecertificate](docs/ProjectPostCredentialStorecertificate.md)
 - [ProjectRoles](docs/ProjectRoles.md)
 - [ProjectServices](docs/ProjectServices.md)
 - [ProjectThreshold](docs/ProjectThreshold.md)
 - [ProjectThresholdCredits](docs/ProjectThresholdCredits.md)
 - [ProjectTransfer](docs/ProjectTransfer.md)
 - [ProjectUpdate](docs/ProjectUpdate.md)
 - [Replica](docs/Replica.md)
 - [ReplicaActionImage](docs/ReplicaActionImage.md)
 - [ReplicaCreate](docs/ReplicaCreate.md)
 - [ReplicaPostAccessrights](docs/ReplicaPostAccessrights.md)
 - [ReplicaServices](docs/ReplicaServices.md)
 - [Reservation](docs/Reservation.md)
 - [ReservationActionAssign](docs/ReservationActionAssign.md)
 - [ReservationCreate](docs/ReservationCreate.md)
 - [ReservationPostAccessrights](docs/ReservationPostAccessrights.md)
 - [ReservationServices](docs/ReservationServices.md)
 - [ReservationUpdate](docs/ReservationUpdate.md)
 - [Snapshot](docs/Snapshot.md)
 - [SnapshotCreate](docs/SnapshotCreate.md)
 - [SnapshotPostAccessrights](docs/SnapshotPostAccessrights.md)
 - [SnapshotServices](docs/SnapshotServices.md)
 - [SnapshotUpdate](docs/SnapshotUpdate.md)
 - [Vault](docs/Vault.md)
 - [VaultActionResize](docs/VaultActionResize.md)
 - [VaultActionSnapshot](docs/VaultActionSnapshot.md)
 - [VaultCreate](docs/VaultCreate.md)
 - [VaultCreateCredential](docs/VaultCreateCredential.md)
 - [VaultCreateCredentialCertificate](docs/VaultCreateCredentialCertificate.md)
 - [VaultCreateCredentialPassword](docs/VaultCreateCredentialPassword.md)
 - [VaultDelete](docs/VaultDelete.md)
 - [VaultPatchCredentialcertificateId](docs/VaultPatchCredentialcertificateId.md)
 - [VaultPatchCredentialpasswordId](docs/VaultPatchCredentialpasswordId.md)
 - [VaultPostAccessrights](docs/VaultPostAccessrights.md)
 - [VaultPostCredentialcertificate](docs/VaultPostCredentialcertificate.md)
 - [VaultPostCredentialpassword](docs/VaultPostCredentialpassword.md)
 - [VaultServices](docs/VaultServices.md)
 - [VaultUpdate](docs/VaultUpdate.md)
 - [Vm](docs/Vm.md)
 - [VmActionFlavour](docs/VmActionFlavour.md)
 - [VmActionImage](docs/VmActionImage.md)
 - [VmActionPasswordReset](docs/VmActionPasswordReset.md)
 - [VmActionRename](docs/VmActionRename.md)
 - [VmCreate](docs/VmCreate.md)
 - [VmCreateDisk](docs/VmCreateDisk.md)
 - [VmCreateNetadp](docs/VmCreateNetadp.md)
 - [VmCreatePassword](docs/VmCreatePassword.md)
 - [VmData](docs/VmData.md)
 - [VmDelete](docs/VmDelete.md)
 - [VmPostAccessrights](docs/VmPostAccessrights.md)
 - [VmPostHdd](docs/VmPostHdd.md)
 - [VmPostNetadp](docs/VmPostNetadp.md)
 - [VmServices](docs/VmServices.md)
 - [VmSourceImage](docs/VmSourceImage.md)
 - [VmUpdate](docs/VmUpdate.md)
 - [Vmhost](docs/Vmhost.md)
 - [VmhostActionMoveDisk](docs/VmhostActionMoveDisk.md)
 - [VmhostActionMoveImage](docs/VmhostActionMoveImage.md)
 - [VmhostActionMoveIso](docs/VmhostActionMoveIso.md)
 - [VmhostActionMoveVm](docs/VmhostActionMoveVm.md)
 - [VmhostPostAccessrights](docs/VmhostPostAccessrights.md)
 - [VmhostServices](docs/VmhostServices.md)
 - [VmhostUpdate](docs/VmhostUpdate.md)


## Documentation For Authorization

## Project
- **Type**: API key 

Example
```golang
auth := context.WithValue(context.Background(), sw.ContextAPIKey, sw.APIKey{
	Key: "APIKEY",
	Prefix: "Bearer", // Omit if not necessary.
})
r, err := client.Service.Operation(auth, args)
```
## ServiceAccount
- **Type**: API key 

Example
```golang
auth := context.WithValue(context.Background(), sw.ContextAPIKey, sw.APIKey{
	Key: "APIKEY",
	Prefix: "Bearer", // Omit if not necessary.
})
r, err := client.Service.Operation(auth, args)
```
## Session
- **Type**: API key 

Example
```golang
auth := context.WithValue(context.Background(), sw.ContextAPIKey, sw.APIKey{
	Key: "APIKEY",
	Prefix: "Bearer", // Omit if not necessary.
})
r, err := client.Service.Operation(auth, args)
```

## Author



