// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/compute/v1/instancegroup/instance_group.proto

package instancegroup

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type IpVersion int32

const (
	IpVersion_IP_VERSION_UNSPECIFIED IpVersion = 0
	// IPv4 address, for example 192.168.0.0.
	IpVersion_IPV4 IpVersion = 1
	// IPv6 address, not available yet.
	IpVersion_IPV6 IpVersion = 2
)

var IpVersion_name = map[int32]string{
	0: "IP_VERSION_UNSPECIFIED",
	1: "IPV4",
	2: "IPV6",
}

var IpVersion_value = map[string]int32{
	"IP_VERSION_UNSPECIFIED": 0,
	"IPV4":                   1,
	"IPV6":                   2,
}

func (x IpVersion) String() string {
	return proto.EnumName(IpVersion_name, int32(x))
}

func (IpVersion) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{0}
}

type AttachedDiskSpec_Mode int32

const (
	AttachedDiskSpec_MODE_UNSPECIFIED AttachedDiskSpec_Mode = 0
	// Read-only access.
	AttachedDiskSpec_READ_ONLY AttachedDiskSpec_Mode = 1
	// Read/Write access.
	AttachedDiskSpec_READ_WRITE AttachedDiskSpec_Mode = 2
)

var AttachedDiskSpec_Mode_name = map[int32]string{
	0: "MODE_UNSPECIFIED",
	1: "READ_ONLY",
	2: "READ_WRITE",
}

var AttachedDiskSpec_Mode_value = map[string]int32{
	"MODE_UNSPECIFIED": 0,
	"READ_ONLY":        1,
	"READ_WRITE":       2,
}

func (x AttachedDiskSpec_Mode) String() string {
	return proto.EnumName(AttachedDiskSpec_Mode_name, int32(x))
}

func (AttachedDiskSpec_Mode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{8, 0}
}

type ManagedInstance_Status int32

const (
	ManagedInstance_STATUS_UNSPECIFIED ManagedInstance_Status = 0
	// Instance is being created.
	ManagedInstance_CREATING_INSTANCE ManagedInstance_Status = 11
	// Instance is being updated.
	ManagedInstance_UPDATING_INSTANCE ManagedInstance_Status = 12
	// Instance is being deleted.
	ManagedInstance_DELETING_INSTANCE ManagedInstance_Status = 13
	// Instance is being started.
	ManagedInstance_STARTING_INSTANCE ManagedInstance_Status = 14
	// Instance is being stopped.
	ManagedInstance_STOPPING_INSTANCE ManagedInstance_Status = 15
	// Instance has been created successfully, but startup duration has not elapsed yet.
	ManagedInstance_AWAITING_STARTUP_DURATION ManagedInstance_Status = 16
	// Instance has been created successfully and startup duration has elapsed, but health checks have not passed yet and the managed instance is not ready to receive traffic.
	ManagedInstance_CHECKING_HEALTH ManagedInstance_Status = 17
	// Instance Groups is initiating health checks and routing traffic to the instances.
	ManagedInstance_OPENING_TRAFFIC ManagedInstance_Status = 18
	// Instance is now receiving traffic, but warmup duration has not elapsed yet.
	ManagedInstance_AWAITING_WARMUP_DURATION ManagedInstance_Status = 19
	// Instance Groups has initiated the process of stopping routing traffic to the instances.
	ManagedInstance_CLOSING_TRAFFIC ManagedInstance_Status = 20
	// Instance is running normally and its attributes match the current InstanceTemplate.
	ManagedInstance_RUNNING_ACTUAL ManagedInstance_Status = 21
	// Instance is running normally, but its attributes do not match the current InstanceTemplate.
	// It will be updated, recreated or deleted shortly.
	ManagedInstance_RUNNING_OUTDATED ManagedInstance_Status = 22
	// Instance was stopped.
	ManagedInstance_STOPPED ManagedInstance_Status = 23
	// Instance was deleted.
	ManagedInstance_DELETED ManagedInstance_Status = 24
)

var ManagedInstance_Status_name = map[int32]string{
	0:  "STATUS_UNSPECIFIED",
	11: "CREATING_INSTANCE",
	12: "UPDATING_INSTANCE",
	13: "DELETING_INSTANCE",
	14: "STARTING_INSTANCE",
	15: "STOPPING_INSTANCE",
	16: "AWAITING_STARTUP_DURATION",
	17: "CHECKING_HEALTH",
	18: "OPENING_TRAFFIC",
	19: "AWAITING_WARMUP_DURATION",
	20: "CLOSING_TRAFFIC",
	21: "RUNNING_ACTUAL",
	22: "RUNNING_OUTDATED",
	23: "STOPPED",
	24: "DELETED",
}

var ManagedInstance_Status_value = map[string]int32{
	"STATUS_UNSPECIFIED":        0,
	"CREATING_INSTANCE":         11,
	"UPDATING_INSTANCE":         12,
	"DELETING_INSTANCE":         13,
	"STARTING_INSTANCE":         14,
	"STOPPING_INSTANCE":         15,
	"AWAITING_STARTUP_DURATION": 16,
	"CHECKING_HEALTH":           17,
	"OPENING_TRAFFIC":           18,
	"AWAITING_WARMUP_DURATION":  19,
	"CLOSING_TRAFFIC":           20,
	"RUNNING_ACTUAL":            21,
	"RUNNING_OUTDATED":          22,
	"STOPPED":                   23,
	"DELETED":                   24,
}

func (x ManagedInstance_Status) String() string {
	return proto.EnumName(ManagedInstance_Status_name, int32(x))
}

func (ManagedInstance_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{17, 0}
}

type InstanceGroup struct {
	// ID of the instance group.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the instance group belongs to.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	CreatedAt *timestamp.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the instance group.
	// The name is unique within the folder.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the instance group.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `key:value` pairs.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Instance template for creating the instance group.
	// For more information, see [Instance Templates](/docs/compute/concepts/ig-instance-templates).
	InstanceTemplate *InstanceTemplate `protobuf:"bytes,7,opt,name=instance_template,json=instanceTemplate,proto3" json:"instance_template,omitempty"`
	// Scaling policy of the instance group.
	ScalePolicy *ScalePolicy `protobuf:"bytes,8,opt,name=scale_policy,json=scalePolicy,proto3" json:"scale_policy,omitempty"`
	// Deployment policy of the instance group.
	DeployPolicy *DeployPolicy `protobuf:"bytes,9,opt,name=deploy_policy,json=deployPolicy,proto3" json:"deploy_policy,omitempty"`
	// Allocation policy of the instance group by zones and regions.
	AllocationPolicy *AllocationPolicy `protobuf:"bytes,10,opt,name=allocation_policy,json=allocationPolicy,proto3" json:"allocation_policy,omitempty"`
	// Information that indicates which entities can be related to this load balancer.
	LoadBalancerState *LoadBalancerState `protobuf:"bytes,11,opt,name=load_balancer_state,json=loadBalancerState,proto3" json:"load_balancer_state,omitempty"`
	// States of instances for this instance group.
	ManagedInstancesState *ManagedInstancesState `protobuf:"bytes,12,opt,name=managed_instances_state,json=managedInstancesState,proto3" json:"managed_instances_state,omitempty"`
	// Load balancing specification.
	LoadBalancerSpec *LoadBalancerSpec `protobuf:"bytes,14,opt,name=load_balancer_spec,json=loadBalancerSpec,proto3" json:"load_balancer_spec,omitempty"`
	// Health checking specification. For more information, see [Health check](/docs/load-balancer/concepts/health-check).
	HealthChecksSpec *HealthChecksSpec `protobuf:"bytes,15,opt,name=health_checks_spec,json=healthChecksSpec,proto3" json:"health_checks_spec,omitempty"`
	// ID of the service account. The service account will be used for all API calls
	// made by the Instance Groups component on behalf of the user (for example, creating instances, adding them to load balancer target group, etc.). For more information, see [Service accounts](/docs/iam/concepts/users/service-accounts).
	// To get the service account ID, use a [yandex.cloud.iam.v1.ServiceAccountService.List] request.
	ServiceAccountId     string   `protobuf:"bytes,16,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InstanceGroup) Reset()         { *m = InstanceGroup{} }
func (m *InstanceGroup) String() string { return proto.CompactTextString(m) }
func (*InstanceGroup) ProtoMessage()    {}
func (*InstanceGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{0}
}

func (m *InstanceGroup) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InstanceGroup.Unmarshal(m, b)
}
func (m *InstanceGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InstanceGroup.Marshal(b, m, deterministic)
}
func (m *InstanceGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstanceGroup.Merge(m, src)
}
func (m *InstanceGroup) XXX_Size() int {
	return xxx_messageInfo_InstanceGroup.Size(m)
}
func (m *InstanceGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_InstanceGroup.DiscardUnknown(m)
}

var xxx_messageInfo_InstanceGroup proto.InternalMessageInfo

func (m *InstanceGroup) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *InstanceGroup) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *InstanceGroup) GetCreatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *InstanceGroup) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *InstanceGroup) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *InstanceGroup) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *InstanceGroup) GetInstanceTemplate() *InstanceTemplate {
	if m != nil {
		return m.InstanceTemplate
	}
	return nil
}

func (m *InstanceGroup) GetScalePolicy() *ScalePolicy {
	if m != nil {
		return m.ScalePolicy
	}
	return nil
}

func (m *InstanceGroup) GetDeployPolicy() *DeployPolicy {
	if m != nil {
		return m.DeployPolicy
	}
	return nil
}

func (m *InstanceGroup) GetAllocationPolicy() *AllocationPolicy {
	if m != nil {
		return m.AllocationPolicy
	}
	return nil
}

func (m *InstanceGroup) GetLoadBalancerState() *LoadBalancerState {
	if m != nil {
		return m.LoadBalancerState
	}
	return nil
}

func (m *InstanceGroup) GetManagedInstancesState() *ManagedInstancesState {
	if m != nil {
		return m.ManagedInstancesState
	}
	return nil
}

func (m *InstanceGroup) GetLoadBalancerSpec() *LoadBalancerSpec {
	if m != nil {
		return m.LoadBalancerSpec
	}
	return nil
}

func (m *InstanceGroup) GetHealthChecksSpec() *HealthChecksSpec {
	if m != nil {
		return m.HealthChecksSpec
	}
	return nil
}

func (m *InstanceGroup) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

type LoadBalancerState struct {
	// ID of the target group used for load balancing.
	TargetGroupId string `protobuf:"bytes,1,opt,name=target_group_id,json=targetGroupId,proto3" json:"target_group_id,omitempty"`
	// Status message of the target group.
	StatusMessage        string   `protobuf:"bytes,2,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LoadBalancerState) Reset()         { *m = LoadBalancerState{} }
func (m *LoadBalancerState) String() string { return proto.CompactTextString(m) }
func (*LoadBalancerState) ProtoMessage()    {}
func (*LoadBalancerState) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{1}
}

func (m *LoadBalancerState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LoadBalancerState.Unmarshal(m, b)
}
func (m *LoadBalancerState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LoadBalancerState.Marshal(b, m, deterministic)
}
func (m *LoadBalancerState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LoadBalancerState.Merge(m, src)
}
func (m *LoadBalancerState) XXX_Size() int {
	return xxx_messageInfo_LoadBalancerState.Size(m)
}
func (m *LoadBalancerState) XXX_DiscardUnknown() {
	xxx_messageInfo_LoadBalancerState.DiscardUnknown(m)
}

var xxx_messageInfo_LoadBalancerState proto.InternalMessageInfo

func (m *LoadBalancerState) GetTargetGroupId() string {
	if m != nil {
		return m.TargetGroupId
	}
	return ""
}

func (m *LoadBalancerState) GetStatusMessage() string {
	if m != nil {
		return m.StatusMessage
	}
	return ""
}

type ManagedInstancesState struct {
	// Target number of instances for this instance group.
	TargetSize int64 `protobuf:"varint,1,opt,name=target_size,json=targetSize,proto3" json:"target_size,omitempty"`
	// The number of running instances that match the current instance template. For more information, see [ManagedInstance.Status.RUNNING_ACTUAL].
	RunningActualCount int64 `protobuf:"varint,4,opt,name=running_actual_count,json=runningActualCount,proto3" json:"running_actual_count,omitempty"`
	// The number of running instances that does not match the current instance template. For more information, see [ManagedInstance.Status.RUNNING_OUTDATED].
	RunningOutdatedCount int64 `protobuf:"varint,5,opt,name=running_outdated_count,json=runningOutdatedCount,proto3" json:"running_outdated_count,omitempty"`
	// The number of instances in flight (for example, updating, starting, deleting). For more information, see [ManagedInstance.Status].
	ProcessingCount      int64    `protobuf:"varint,6,opt,name=processing_count,json=processingCount,proto3" json:"processing_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ManagedInstancesState) Reset()         { *m = ManagedInstancesState{} }
func (m *ManagedInstancesState) String() string { return proto.CompactTextString(m) }
func (*ManagedInstancesState) ProtoMessage()    {}
func (*ManagedInstancesState) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{2}
}

func (m *ManagedInstancesState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ManagedInstancesState.Unmarshal(m, b)
}
func (m *ManagedInstancesState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ManagedInstancesState.Marshal(b, m, deterministic)
}
func (m *ManagedInstancesState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ManagedInstancesState.Merge(m, src)
}
func (m *ManagedInstancesState) XXX_Size() int {
	return xxx_messageInfo_ManagedInstancesState.Size(m)
}
func (m *ManagedInstancesState) XXX_DiscardUnknown() {
	xxx_messageInfo_ManagedInstancesState.DiscardUnknown(m)
}

var xxx_messageInfo_ManagedInstancesState proto.InternalMessageInfo

func (m *ManagedInstancesState) GetTargetSize() int64 {
	if m != nil {
		return m.TargetSize
	}
	return 0
}

func (m *ManagedInstancesState) GetRunningActualCount() int64 {
	if m != nil {
		return m.RunningActualCount
	}
	return 0
}

func (m *ManagedInstancesState) GetRunningOutdatedCount() int64 {
	if m != nil {
		return m.RunningOutdatedCount
	}
	return 0
}

func (m *ManagedInstancesState) GetProcessingCount() int64 {
	if m != nil {
		return m.ProcessingCount
	}
	return 0
}

type ManagedInstancesState_Statuses struct {
	// Instance is being created.
	Creating int64 `protobuf:"varint,1,opt,name=creating,proto3" json:"creating,omitempty"`
	// Instance is being started.
	Starting int64 `protobuf:"varint,2,opt,name=starting,proto3" json:"starting,omitempty"`
	// Instance is being opened to receive traffic.
	Opening int64 `protobuf:"varint,3,opt,name=opening,proto3" json:"opening,omitempty"`
	// Instance is being warmed.
	Warming int64 `protobuf:"varint,4,opt,name=warming,proto3" json:"warming,omitempty"`
	// Instance is running normally.
	Running int64 `protobuf:"varint,5,opt,name=running,proto3" json:"running,omitempty"`
	// Instance is being closed to traffic.
	Closing int64 `protobuf:"varint,6,opt,name=closing,proto3" json:"closing,omitempty"`
	// Instance is being stopped.
	Stopping int64 `protobuf:"varint,7,opt,name=stopping,proto3" json:"stopping,omitempty"`
	// Instance is being updated.
	Updating int64 `protobuf:"varint,8,opt,name=updating,proto3" json:"updating,omitempty"`
	// Instance is being deleted.
	Deleting int64 `protobuf:"varint,9,opt,name=deleting,proto3" json:"deleting,omitempty"`
	// Instance failed and needs to be recreated.
	Failed               int64    `protobuf:"varint,10,opt,name=failed,proto3" json:"failed,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ManagedInstancesState_Statuses) Reset()         { *m = ManagedInstancesState_Statuses{} }
func (m *ManagedInstancesState_Statuses) String() string { return proto.CompactTextString(m) }
func (*ManagedInstancesState_Statuses) ProtoMessage()    {}
func (*ManagedInstancesState_Statuses) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{2, 0}
}

func (m *ManagedInstancesState_Statuses) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ManagedInstancesState_Statuses.Unmarshal(m, b)
}
func (m *ManagedInstancesState_Statuses) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ManagedInstancesState_Statuses.Marshal(b, m, deterministic)
}
func (m *ManagedInstancesState_Statuses) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ManagedInstancesState_Statuses.Merge(m, src)
}
func (m *ManagedInstancesState_Statuses) XXX_Size() int {
	return xxx_messageInfo_ManagedInstancesState_Statuses.Size(m)
}
func (m *ManagedInstancesState_Statuses) XXX_DiscardUnknown() {
	xxx_messageInfo_ManagedInstancesState_Statuses.DiscardUnknown(m)
}

var xxx_messageInfo_ManagedInstancesState_Statuses proto.InternalMessageInfo

func (m *ManagedInstancesState_Statuses) GetCreating() int64 {
	if m != nil {
		return m.Creating
	}
	return 0
}

func (m *ManagedInstancesState_Statuses) GetStarting() int64 {
	if m != nil {
		return m.Starting
	}
	return 0
}

func (m *ManagedInstancesState_Statuses) GetOpening() int64 {
	if m != nil {
		return m.Opening
	}
	return 0
}

func (m *ManagedInstancesState_Statuses) GetWarming() int64 {
	if m != nil {
		return m.Warming
	}
	return 0
}

func (m *ManagedInstancesState_Statuses) GetRunning() int64 {
	if m != nil {
		return m.Running
	}
	return 0
}

func (m *ManagedInstancesState_Statuses) GetClosing() int64 {
	if m != nil {
		return m.Closing
	}
	return 0
}

func (m *ManagedInstancesState_Statuses) GetStopping() int64 {
	if m != nil {
		return m.Stopping
	}
	return 0
}

func (m *ManagedInstancesState_Statuses) GetUpdating() int64 {
	if m != nil {
		return m.Updating
	}
	return 0
}

func (m *ManagedInstancesState_Statuses) GetDeleting() int64 {
	if m != nil {
		return m.Deleting
	}
	return 0
}

func (m *ManagedInstancesState_Statuses) GetFailed() int64 {
	if m != nil {
		return m.Failed
	}
	return 0
}

type ScalePolicy struct {
	// Types that are valid to be assigned to ScaleType:
	//	*ScalePolicy_FixedScale_
	//	*ScalePolicy_AutoScale_
	ScaleType            isScalePolicy_ScaleType `protobuf_oneof:"scale_type"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *ScalePolicy) Reset()         { *m = ScalePolicy{} }
func (m *ScalePolicy) String() string { return proto.CompactTextString(m) }
func (*ScalePolicy) ProtoMessage()    {}
func (*ScalePolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{3}
}

func (m *ScalePolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScalePolicy.Unmarshal(m, b)
}
func (m *ScalePolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScalePolicy.Marshal(b, m, deterministic)
}
func (m *ScalePolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScalePolicy.Merge(m, src)
}
func (m *ScalePolicy) XXX_Size() int {
	return xxx_messageInfo_ScalePolicy.Size(m)
}
func (m *ScalePolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_ScalePolicy.DiscardUnknown(m)
}

var xxx_messageInfo_ScalePolicy proto.InternalMessageInfo

type isScalePolicy_ScaleType interface {
	isScalePolicy_ScaleType()
}

type ScalePolicy_FixedScale_ struct {
	FixedScale *ScalePolicy_FixedScale `protobuf:"bytes,1,opt,name=fixed_scale,json=fixedScale,proto3,oneof"`
}

type ScalePolicy_AutoScale_ struct {
	AutoScale *ScalePolicy_AutoScale `protobuf:"bytes,2,opt,name=auto_scale,json=autoScale,proto3,oneof"`
}

func (*ScalePolicy_FixedScale_) isScalePolicy_ScaleType() {}

func (*ScalePolicy_AutoScale_) isScalePolicy_ScaleType() {}

func (m *ScalePolicy) GetScaleType() isScalePolicy_ScaleType {
	if m != nil {
		return m.ScaleType
	}
	return nil
}

func (m *ScalePolicy) GetFixedScale() *ScalePolicy_FixedScale {
	if x, ok := m.GetScaleType().(*ScalePolicy_FixedScale_); ok {
		return x.FixedScale
	}
	return nil
}

func (m *ScalePolicy) GetAutoScale() *ScalePolicy_AutoScale {
	if x, ok := m.GetScaleType().(*ScalePolicy_AutoScale_); ok {
		return x.AutoScale
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ScalePolicy) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ScalePolicy_FixedScale_)(nil),
		(*ScalePolicy_AutoScale_)(nil),
	}
}

type ScalePolicy_AutoScale struct {
	// Lower limit for instance count in each zone.
	MinZoneSize int64 `protobuf:"varint,1,opt,name=min_zone_size,json=minZoneSize,proto3" json:"min_zone_size,omitempty"`
	// Upper limit for total instance count (across all zones).
	// 0 means maximum limit = 100.
	MaxSize               int64                           `protobuf:"varint,2,opt,name=max_size,json=maxSize,proto3" json:"max_size,omitempty"`
	MeasurementDuration   *duration.Duration              `protobuf:"bytes,3,opt,name=measurement_duration,json=measurementDuration,proto3" json:"measurement_duration,omitempty"`
	WarmupDuration        *duration.Duration              `protobuf:"bytes,4,opt,name=warmup_duration,json=warmupDuration,proto3" json:"warmup_duration,omitempty"`
	StabilizationDuration *duration.Duration              `protobuf:"bytes,5,opt,name=stabilization_duration,json=stabilizationDuration,proto3" json:"stabilization_duration,omitempty"`
	InitialSize           int64                           `protobuf:"varint,6,opt,name=initial_size,json=initialSize,proto3" json:"initial_size,omitempty"`
	CpuUtilizationRule    *ScalePolicy_CpuUtilizationRule `protobuf:"bytes,7,opt,name=cpu_utilization_rule,json=cpuUtilizationRule,proto3" json:"cpu_utilization_rule,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}                        `json:"-"`
	XXX_unrecognized      []byte                          `json:"-"`
	XXX_sizecache         int32                           `json:"-"`
}

func (m *ScalePolicy_AutoScale) Reset()         { *m = ScalePolicy_AutoScale{} }
func (m *ScalePolicy_AutoScale) String() string { return proto.CompactTextString(m) }
func (*ScalePolicy_AutoScale) ProtoMessage()    {}
func (*ScalePolicy_AutoScale) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{3, 0}
}

func (m *ScalePolicy_AutoScale) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScalePolicy_AutoScale.Unmarshal(m, b)
}
func (m *ScalePolicy_AutoScale) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScalePolicy_AutoScale.Marshal(b, m, deterministic)
}
func (m *ScalePolicy_AutoScale) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScalePolicy_AutoScale.Merge(m, src)
}
func (m *ScalePolicy_AutoScale) XXX_Size() int {
	return xxx_messageInfo_ScalePolicy_AutoScale.Size(m)
}
func (m *ScalePolicy_AutoScale) XXX_DiscardUnknown() {
	xxx_messageInfo_ScalePolicy_AutoScale.DiscardUnknown(m)
}

var xxx_messageInfo_ScalePolicy_AutoScale proto.InternalMessageInfo

func (m *ScalePolicy_AutoScale) GetMinZoneSize() int64 {
	if m != nil {
		return m.MinZoneSize
	}
	return 0
}

func (m *ScalePolicy_AutoScale) GetMaxSize() int64 {
	if m != nil {
		return m.MaxSize
	}
	return 0
}

func (m *ScalePolicy_AutoScale) GetMeasurementDuration() *duration.Duration {
	if m != nil {
		return m.MeasurementDuration
	}
	return nil
}

func (m *ScalePolicy_AutoScale) GetWarmupDuration() *duration.Duration {
	if m != nil {
		return m.WarmupDuration
	}
	return nil
}

func (m *ScalePolicy_AutoScale) GetStabilizationDuration() *duration.Duration {
	if m != nil {
		return m.StabilizationDuration
	}
	return nil
}

func (m *ScalePolicy_AutoScale) GetInitialSize() int64 {
	if m != nil {
		return m.InitialSize
	}
	return 0
}

func (m *ScalePolicy_AutoScale) GetCpuUtilizationRule() *ScalePolicy_CpuUtilizationRule {
	if m != nil {
		return m.CpuUtilizationRule
	}
	return nil
}

type ScalePolicy_CpuUtilizationRule struct {
	UtilizationTarget    float64  `protobuf:"fixed64,1,opt,name=utilization_target,json=utilizationTarget,proto3" json:"utilization_target,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ScalePolicy_CpuUtilizationRule) Reset()         { *m = ScalePolicy_CpuUtilizationRule{} }
func (m *ScalePolicy_CpuUtilizationRule) String() string { return proto.CompactTextString(m) }
func (*ScalePolicy_CpuUtilizationRule) ProtoMessage()    {}
func (*ScalePolicy_CpuUtilizationRule) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{3, 1}
}

func (m *ScalePolicy_CpuUtilizationRule) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScalePolicy_CpuUtilizationRule.Unmarshal(m, b)
}
func (m *ScalePolicy_CpuUtilizationRule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScalePolicy_CpuUtilizationRule.Marshal(b, m, deterministic)
}
func (m *ScalePolicy_CpuUtilizationRule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScalePolicy_CpuUtilizationRule.Merge(m, src)
}
func (m *ScalePolicy_CpuUtilizationRule) XXX_Size() int {
	return xxx_messageInfo_ScalePolicy_CpuUtilizationRule.Size(m)
}
func (m *ScalePolicy_CpuUtilizationRule) XXX_DiscardUnknown() {
	xxx_messageInfo_ScalePolicy_CpuUtilizationRule.DiscardUnknown(m)
}

var xxx_messageInfo_ScalePolicy_CpuUtilizationRule proto.InternalMessageInfo

func (m *ScalePolicy_CpuUtilizationRule) GetUtilizationTarget() float64 {
	if m != nil {
		return m.UtilizationTarget
	}
	return 0
}

type ScalePolicy_FixedScale struct {
	// Number of instances in the instance group.
	Size                 int64    `protobuf:"varint,1,opt,name=size,proto3" json:"size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ScalePolicy_FixedScale) Reset()         { *m = ScalePolicy_FixedScale{} }
func (m *ScalePolicy_FixedScale) String() string { return proto.CompactTextString(m) }
func (*ScalePolicy_FixedScale) ProtoMessage()    {}
func (*ScalePolicy_FixedScale) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{3, 2}
}

func (m *ScalePolicy_FixedScale) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScalePolicy_FixedScale.Unmarshal(m, b)
}
func (m *ScalePolicy_FixedScale) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScalePolicy_FixedScale.Marshal(b, m, deterministic)
}
func (m *ScalePolicy_FixedScale) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScalePolicy_FixedScale.Merge(m, src)
}
func (m *ScalePolicy_FixedScale) XXX_Size() int {
	return xxx_messageInfo_ScalePolicy_FixedScale.Size(m)
}
func (m *ScalePolicy_FixedScale) XXX_DiscardUnknown() {
	xxx_messageInfo_ScalePolicy_FixedScale.DiscardUnknown(m)
}

var xxx_messageInfo_ScalePolicy_FixedScale proto.InternalMessageInfo

func (m *ScalePolicy_FixedScale) GetSize() int64 {
	if m != nil {
		return m.Size
	}
	return 0
}

type DeployPolicy struct {
	// The maximum number of running instances that can be taken offline (i.e., stopped or deleted) at the same time
	// during the update process.
	// If [max_expansion] is not specified or set to zero, [max_unavailable] must be set to a non-zero value.
	MaxUnavailable int64 `protobuf:"varint,1,opt,name=max_unavailable,json=maxUnavailable,proto3" json:"max_unavailable,omitempty"`
	// The maximum number of instances that can be deleted at the same time.
	MaxDeleting int64 `protobuf:"varint,2,opt,name=max_deleting,json=maxDeleting,proto3" json:"max_deleting,omitempty"`
	// The maximum number of instances that can be created at the same time.
	MaxCreating int64 `protobuf:"varint,3,opt,name=max_creating,json=maxCreating,proto3" json:"max_creating,omitempty"`
	// The maximum number of instances that can be temporarily allocated above the group's target size
	// during the update process.
	// If [max_unavailable] is not specified or set to zero, [max_expansion] must be set to a non-zero value.
	MaxExpansion int64 `protobuf:"varint,6,opt,name=max_expansion,json=maxExpansion,proto3" json:"max_expansion,omitempty"`
	// Instance startup duration.
	// Instance will be considered up and running (and start receiving traffic) only after startup_duration
	// has elapsed and all health checks are passed.
	// See [yandex.cloud.compute.v1.instancegroup.ManagedInstance.Status] for more information.
	StartupDuration      *duration.Duration `protobuf:"bytes,7,opt,name=startup_duration,json=startupDuration,proto3" json:"startup_duration,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *DeployPolicy) Reset()         { *m = DeployPolicy{} }
func (m *DeployPolicy) String() string { return proto.CompactTextString(m) }
func (*DeployPolicy) ProtoMessage()    {}
func (*DeployPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{4}
}

func (m *DeployPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeployPolicy.Unmarshal(m, b)
}
func (m *DeployPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeployPolicy.Marshal(b, m, deterministic)
}
func (m *DeployPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeployPolicy.Merge(m, src)
}
func (m *DeployPolicy) XXX_Size() int {
	return xxx_messageInfo_DeployPolicy.Size(m)
}
func (m *DeployPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_DeployPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_DeployPolicy proto.InternalMessageInfo

func (m *DeployPolicy) GetMaxUnavailable() int64 {
	if m != nil {
		return m.MaxUnavailable
	}
	return 0
}

func (m *DeployPolicy) GetMaxDeleting() int64 {
	if m != nil {
		return m.MaxDeleting
	}
	return 0
}

func (m *DeployPolicy) GetMaxCreating() int64 {
	if m != nil {
		return m.MaxCreating
	}
	return 0
}

func (m *DeployPolicy) GetMaxExpansion() int64 {
	if m != nil {
		return m.MaxExpansion
	}
	return 0
}

func (m *DeployPolicy) GetStartupDuration() *duration.Duration {
	if m != nil {
		return m.StartupDuration
	}
	return nil
}

type AllocationPolicy struct {
	// List of availability zones.
	Zones                []*AllocationPolicy_Zone `protobuf:"bytes,1,rep,name=zones,proto3" json:"zones,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *AllocationPolicy) Reset()         { *m = AllocationPolicy{} }
func (m *AllocationPolicy) String() string { return proto.CompactTextString(m) }
func (*AllocationPolicy) ProtoMessage()    {}
func (*AllocationPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{5}
}

func (m *AllocationPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AllocationPolicy.Unmarshal(m, b)
}
func (m *AllocationPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AllocationPolicy.Marshal(b, m, deterministic)
}
func (m *AllocationPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AllocationPolicy.Merge(m, src)
}
func (m *AllocationPolicy) XXX_Size() int {
	return xxx_messageInfo_AllocationPolicy.Size(m)
}
func (m *AllocationPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_AllocationPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_AllocationPolicy proto.InternalMessageInfo

func (m *AllocationPolicy) GetZones() []*AllocationPolicy_Zone {
	if m != nil {
		return m.Zones
	}
	return nil
}

type AllocationPolicy_Zone struct {
	// ID of the availability zone where the instance resides.
	ZoneId               string   `protobuf:"bytes,1,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AllocationPolicy_Zone) Reset()         { *m = AllocationPolicy_Zone{} }
func (m *AllocationPolicy_Zone) String() string { return proto.CompactTextString(m) }
func (*AllocationPolicy_Zone) ProtoMessage()    {}
func (*AllocationPolicy_Zone) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{5, 0}
}

func (m *AllocationPolicy_Zone) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AllocationPolicy_Zone.Unmarshal(m, b)
}
func (m *AllocationPolicy_Zone) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AllocationPolicy_Zone.Marshal(b, m, deterministic)
}
func (m *AllocationPolicy_Zone) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AllocationPolicy_Zone.Merge(m, src)
}
func (m *AllocationPolicy_Zone) XXX_Size() int {
	return xxx_messageInfo_AllocationPolicy_Zone.Size(m)
}
func (m *AllocationPolicy_Zone) XXX_DiscardUnknown() {
	xxx_messageInfo_AllocationPolicy_Zone.DiscardUnknown(m)
}

var xxx_messageInfo_AllocationPolicy_Zone proto.InternalMessageInfo

func (m *AllocationPolicy_Zone) GetZoneId() string {
	if m != nil {
		return m.ZoneId
	}
	return ""
}

type InstanceTemplate struct {
	// Description of the instance template.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `key:value` pairs.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// ID of the hardware platform configuration for the instance.
	// Platforms allows you to create various types of instances: with a large amount of memory,
	// with a large number of cores, with a burstable performance.
	// For more information, see [Platforms](/docs/compute/concepts/vm-platforms).
	PlatformId string `protobuf:"bytes,3,opt,name=platform_id,json=platformId,proto3" json:"platform_id,omitempty"`
	// Computing resources of the instance such as the amount of memory and number of cores.
	ResourcesSpec *ResourcesSpec `protobuf:"bytes,4,opt,name=resources_spec,json=resourcesSpec,proto3" json:"resources_spec,omitempty"`
	// The metadata `key:value` pairs assigned to this instance template. This includes custom metadata and predefined keys.
	//
	// For example, you may use the metadata in order to provide your public SSH key to the instance.
	// For more information, see [Metadata](/docs/compute/concepts/vm-metadata).
	Metadata map[string]string `protobuf:"bytes,5,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Boot disk specification that will be attached to the instance.
	BootDiskSpec *AttachedDiskSpec `protobuf:"bytes,6,opt,name=boot_disk_spec,json=bootDiskSpec,proto3" json:"boot_disk_spec,omitempty"`
	// Array of secondary disks that will be attached to the instance.
	SecondaryDiskSpecs []*AttachedDiskSpec `protobuf:"bytes,7,rep,name=secondary_disk_specs,json=secondaryDiskSpecs,proto3" json:"secondary_disk_specs,omitempty"`
	// Array of network interfaces that will be attached to the instance.
	NetworkInterfaceSpecs []*NetworkInterfaceSpec `protobuf:"bytes,8,rep,name=network_interface_specs,json=networkInterfaceSpecs,proto3" json:"network_interface_specs,omitempty"`
	// Scheduling policy for the instance.
	SchedulingPolicy *SchedulingPolicy `protobuf:"bytes,9,opt,name=scheduling_policy,json=schedulingPolicy,proto3" json:"scheduling_policy,omitempty"`
	// Service account ID for the instance.
	ServiceAccountId     string   `protobuf:"bytes,10,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InstanceTemplate) Reset()         { *m = InstanceTemplate{} }
func (m *InstanceTemplate) String() string { return proto.CompactTextString(m) }
func (*InstanceTemplate) ProtoMessage()    {}
func (*InstanceTemplate) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{6}
}

func (m *InstanceTemplate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InstanceTemplate.Unmarshal(m, b)
}
func (m *InstanceTemplate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InstanceTemplate.Marshal(b, m, deterministic)
}
func (m *InstanceTemplate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstanceTemplate.Merge(m, src)
}
func (m *InstanceTemplate) XXX_Size() int {
	return xxx_messageInfo_InstanceTemplate.Size(m)
}
func (m *InstanceTemplate) XXX_DiscardUnknown() {
	xxx_messageInfo_InstanceTemplate.DiscardUnknown(m)
}

var xxx_messageInfo_InstanceTemplate proto.InternalMessageInfo

func (m *InstanceTemplate) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *InstanceTemplate) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *InstanceTemplate) GetPlatformId() string {
	if m != nil {
		return m.PlatformId
	}
	return ""
}

func (m *InstanceTemplate) GetResourcesSpec() *ResourcesSpec {
	if m != nil {
		return m.ResourcesSpec
	}
	return nil
}

func (m *InstanceTemplate) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *InstanceTemplate) GetBootDiskSpec() *AttachedDiskSpec {
	if m != nil {
		return m.BootDiskSpec
	}
	return nil
}

func (m *InstanceTemplate) GetSecondaryDiskSpecs() []*AttachedDiskSpec {
	if m != nil {
		return m.SecondaryDiskSpecs
	}
	return nil
}

func (m *InstanceTemplate) GetNetworkInterfaceSpecs() []*NetworkInterfaceSpec {
	if m != nil {
		return m.NetworkInterfaceSpecs
	}
	return nil
}

func (m *InstanceTemplate) GetSchedulingPolicy() *SchedulingPolicy {
	if m != nil {
		return m.SchedulingPolicy
	}
	return nil
}

func (m *InstanceTemplate) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

type ResourcesSpec struct {
	// The amount of memory available to the instance, specified in bytes.
	Memory int64 `protobuf:"varint,1,opt,name=memory,proto3" json:"memory,omitempty"`
	// The number of cores available to the instance.
	Cores int64 `protobuf:"varint,2,opt,name=cores,proto3" json:"cores,omitempty"`
	// Baseline level of CPU performance with the ability to burst performance above that baseline level.
	// This field sets baseline performance for each core.
	CoreFraction int64 `protobuf:"varint,3,opt,name=core_fraction,json=coreFraction,proto3" json:"core_fraction,omitempty"`
	// The number of GPUs available to the instance.
	Gpus                 int64    `protobuf:"varint,4,opt,name=gpus,proto3" json:"gpus,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResourcesSpec) Reset()         { *m = ResourcesSpec{} }
func (m *ResourcesSpec) String() string { return proto.CompactTextString(m) }
func (*ResourcesSpec) ProtoMessage()    {}
func (*ResourcesSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{7}
}

func (m *ResourcesSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResourcesSpec.Unmarshal(m, b)
}
func (m *ResourcesSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResourcesSpec.Marshal(b, m, deterministic)
}
func (m *ResourcesSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourcesSpec.Merge(m, src)
}
func (m *ResourcesSpec) XXX_Size() int {
	return xxx_messageInfo_ResourcesSpec.Size(m)
}
func (m *ResourcesSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourcesSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ResourcesSpec proto.InternalMessageInfo

func (m *ResourcesSpec) GetMemory() int64 {
	if m != nil {
		return m.Memory
	}
	return 0
}

func (m *ResourcesSpec) GetCores() int64 {
	if m != nil {
		return m.Cores
	}
	return 0
}

func (m *ResourcesSpec) GetCoreFraction() int64 {
	if m != nil {
		return m.CoreFraction
	}
	return 0
}

func (m *ResourcesSpec) GetGpus() int64 {
	if m != nil {
		return m.Gpus
	}
	return 0
}

type AttachedDiskSpec struct {
	// Access mode to the Disk resource.
	Mode AttachedDiskSpec_Mode `protobuf:"varint,1,opt,name=mode,proto3,enum=yandex.cloud.compute.v1.instancegroup.AttachedDiskSpec_Mode" json:"mode,omitempty"`
	// Serial number that is reflected in the /dev/disk/by-id/ tree
	// of a Linux operating system running within the instance.
	//
	// This value can be used to reference the device for mounting, resizing, and so on, from within the instance.
	DeviceName string `protobuf:"bytes,2,opt,name=device_name,json=deviceName,proto3" json:"device_name,omitempty"`
	// Disk specification that is attached to the instance. For more information, see [Disks](/docs/compute/concepts/disk).
	DiskSpec             *AttachedDiskSpec_DiskSpec `protobuf:"bytes,3,opt,name=disk_spec,json=diskSpec,proto3" json:"disk_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *AttachedDiskSpec) Reset()         { *m = AttachedDiskSpec{} }
func (m *AttachedDiskSpec) String() string { return proto.CompactTextString(m) }
func (*AttachedDiskSpec) ProtoMessage()    {}
func (*AttachedDiskSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{8}
}

func (m *AttachedDiskSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AttachedDiskSpec.Unmarshal(m, b)
}
func (m *AttachedDiskSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AttachedDiskSpec.Marshal(b, m, deterministic)
}
func (m *AttachedDiskSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttachedDiskSpec.Merge(m, src)
}
func (m *AttachedDiskSpec) XXX_Size() int {
	return xxx_messageInfo_AttachedDiskSpec.Size(m)
}
func (m *AttachedDiskSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_AttachedDiskSpec.DiscardUnknown(m)
}

var xxx_messageInfo_AttachedDiskSpec proto.InternalMessageInfo

func (m *AttachedDiskSpec) GetMode() AttachedDiskSpec_Mode {
	if m != nil {
		return m.Mode
	}
	return AttachedDiskSpec_MODE_UNSPECIFIED
}

func (m *AttachedDiskSpec) GetDeviceName() string {
	if m != nil {
		return m.DeviceName
	}
	return ""
}

func (m *AttachedDiskSpec) GetDiskSpec() *AttachedDiskSpec_DiskSpec {
	if m != nil {
		return m.DiskSpec
	}
	return nil
}

type AttachedDiskSpec_DiskSpec struct {
	// Description of the disk.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// ID of the disk type.
	TypeId string `protobuf:"bytes,2,opt,name=type_id,json=typeId,proto3" json:"type_id,omitempty"`
	// Size of the disk, specified in bytes.
	Size int64 `protobuf:"varint,3,opt,name=size,proto3" json:"size,omitempty"`
	// Types that are valid to be assigned to SourceOneof:
	//	*AttachedDiskSpec_DiskSpec_ImageId
	//	*AttachedDiskSpec_DiskSpec_SnapshotId
	SourceOneof          isAttachedDiskSpec_DiskSpec_SourceOneof `protobuf_oneof:"source_oneof"`
	XXX_NoUnkeyedLiteral struct{}                                `json:"-"`
	XXX_unrecognized     []byte                                  `json:"-"`
	XXX_sizecache        int32                                   `json:"-"`
}

func (m *AttachedDiskSpec_DiskSpec) Reset()         { *m = AttachedDiskSpec_DiskSpec{} }
func (m *AttachedDiskSpec_DiskSpec) String() string { return proto.CompactTextString(m) }
func (*AttachedDiskSpec_DiskSpec) ProtoMessage()    {}
func (*AttachedDiskSpec_DiskSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{8, 0}
}

func (m *AttachedDiskSpec_DiskSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AttachedDiskSpec_DiskSpec.Unmarshal(m, b)
}
func (m *AttachedDiskSpec_DiskSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AttachedDiskSpec_DiskSpec.Marshal(b, m, deterministic)
}
func (m *AttachedDiskSpec_DiskSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttachedDiskSpec_DiskSpec.Merge(m, src)
}
func (m *AttachedDiskSpec_DiskSpec) XXX_Size() int {
	return xxx_messageInfo_AttachedDiskSpec_DiskSpec.Size(m)
}
func (m *AttachedDiskSpec_DiskSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_AttachedDiskSpec_DiskSpec.DiscardUnknown(m)
}

var xxx_messageInfo_AttachedDiskSpec_DiskSpec proto.InternalMessageInfo

func (m *AttachedDiskSpec_DiskSpec) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *AttachedDiskSpec_DiskSpec) GetTypeId() string {
	if m != nil {
		return m.TypeId
	}
	return ""
}

func (m *AttachedDiskSpec_DiskSpec) GetSize() int64 {
	if m != nil {
		return m.Size
	}
	return 0
}

type isAttachedDiskSpec_DiskSpec_SourceOneof interface {
	isAttachedDiskSpec_DiskSpec_SourceOneof()
}

type AttachedDiskSpec_DiskSpec_ImageId struct {
	ImageId string `protobuf:"bytes,4,opt,name=image_id,json=imageId,proto3,oneof"`
}

type AttachedDiskSpec_DiskSpec_SnapshotId struct {
	SnapshotId string `protobuf:"bytes,5,opt,name=snapshot_id,json=snapshotId,proto3,oneof"`
}

func (*AttachedDiskSpec_DiskSpec_ImageId) isAttachedDiskSpec_DiskSpec_SourceOneof() {}

func (*AttachedDiskSpec_DiskSpec_SnapshotId) isAttachedDiskSpec_DiskSpec_SourceOneof() {}

func (m *AttachedDiskSpec_DiskSpec) GetSourceOneof() isAttachedDiskSpec_DiskSpec_SourceOneof {
	if m != nil {
		return m.SourceOneof
	}
	return nil
}

func (m *AttachedDiskSpec_DiskSpec) GetImageId() string {
	if x, ok := m.GetSourceOneof().(*AttachedDiskSpec_DiskSpec_ImageId); ok {
		return x.ImageId
	}
	return ""
}

func (m *AttachedDiskSpec_DiskSpec) GetSnapshotId() string {
	if x, ok := m.GetSourceOneof().(*AttachedDiskSpec_DiskSpec_SnapshotId); ok {
		return x.SnapshotId
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AttachedDiskSpec_DiskSpec) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AttachedDiskSpec_DiskSpec_ImageId)(nil),
		(*AttachedDiskSpec_DiskSpec_SnapshotId)(nil),
	}
}

type NetworkInterfaceSpec struct {
	// ID of the network.
	NetworkId string `protobuf:"bytes,1,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// IDs of the subnets.
	SubnetIds []string `protobuf:"bytes,2,rep,name=subnet_ids,json=subnetIds,proto3" json:"subnet_ids,omitempty"`
	// Primary IPv4 address that is assigned to the instance for this network interface.
	PrimaryV4AddressSpec *PrimaryAddressSpec `protobuf:"bytes,3,opt,name=primary_v4_address_spec,json=primaryV4AddressSpec,proto3" json:"primary_v4_address_spec,omitempty"`
	// Primary IPv6 address that is assigned to the instance for this network interface. IPv6 not available yet.
	PrimaryV6AddressSpec *PrimaryAddressSpec `protobuf:"bytes,4,opt,name=primary_v6_address_spec,json=primaryV6AddressSpec,proto3" json:"primary_v6_address_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *NetworkInterfaceSpec) Reset()         { *m = NetworkInterfaceSpec{} }
func (m *NetworkInterfaceSpec) String() string { return proto.CompactTextString(m) }
func (*NetworkInterfaceSpec) ProtoMessage()    {}
func (*NetworkInterfaceSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{9}
}

func (m *NetworkInterfaceSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NetworkInterfaceSpec.Unmarshal(m, b)
}
func (m *NetworkInterfaceSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NetworkInterfaceSpec.Marshal(b, m, deterministic)
}
func (m *NetworkInterfaceSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkInterfaceSpec.Merge(m, src)
}
func (m *NetworkInterfaceSpec) XXX_Size() int {
	return xxx_messageInfo_NetworkInterfaceSpec.Size(m)
}
func (m *NetworkInterfaceSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkInterfaceSpec.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkInterfaceSpec proto.InternalMessageInfo

func (m *NetworkInterfaceSpec) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

func (m *NetworkInterfaceSpec) GetSubnetIds() []string {
	if m != nil {
		return m.SubnetIds
	}
	return nil
}

func (m *NetworkInterfaceSpec) GetPrimaryV4AddressSpec() *PrimaryAddressSpec {
	if m != nil {
		return m.PrimaryV4AddressSpec
	}
	return nil
}

func (m *NetworkInterfaceSpec) GetPrimaryV6AddressSpec() *PrimaryAddressSpec {
	if m != nil {
		return m.PrimaryV6AddressSpec
	}
	return nil
}

type PrimaryAddressSpec struct {
	// An external IP address configuration.
	// If not specified, then this managed instance will have no external internet access.
	OneToOneNatSpec      *OneToOneNatSpec `protobuf:"bytes,1,opt,name=one_to_one_nat_spec,json=oneToOneNatSpec,proto3" json:"one_to_one_nat_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *PrimaryAddressSpec) Reset()         { *m = PrimaryAddressSpec{} }
func (m *PrimaryAddressSpec) String() string { return proto.CompactTextString(m) }
func (*PrimaryAddressSpec) ProtoMessage()    {}
func (*PrimaryAddressSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{10}
}

func (m *PrimaryAddressSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PrimaryAddressSpec.Unmarshal(m, b)
}
func (m *PrimaryAddressSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PrimaryAddressSpec.Marshal(b, m, deterministic)
}
func (m *PrimaryAddressSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrimaryAddressSpec.Merge(m, src)
}
func (m *PrimaryAddressSpec) XXX_Size() int {
	return xxx_messageInfo_PrimaryAddressSpec.Size(m)
}
func (m *PrimaryAddressSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_PrimaryAddressSpec.DiscardUnknown(m)
}

var xxx_messageInfo_PrimaryAddressSpec proto.InternalMessageInfo

func (m *PrimaryAddressSpec) GetOneToOneNatSpec() *OneToOneNatSpec {
	if m != nil {
		return m.OneToOneNatSpec
	}
	return nil
}

type OneToOneNatSpec struct {
	// IP version for the public IP address.
	IpVersion            IpVersion `protobuf:"varint,1,opt,name=ip_version,json=ipVersion,proto3,enum=yandex.cloud.compute.v1.instancegroup.IpVersion" json:"ip_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *OneToOneNatSpec) Reset()         { *m = OneToOneNatSpec{} }
func (m *OneToOneNatSpec) String() string { return proto.CompactTextString(m) }
func (*OneToOneNatSpec) ProtoMessage()    {}
func (*OneToOneNatSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{11}
}

func (m *OneToOneNatSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OneToOneNatSpec.Unmarshal(m, b)
}
func (m *OneToOneNatSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OneToOneNatSpec.Marshal(b, m, deterministic)
}
func (m *OneToOneNatSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OneToOneNatSpec.Merge(m, src)
}
func (m *OneToOneNatSpec) XXX_Size() int {
	return xxx_messageInfo_OneToOneNatSpec.Size(m)
}
func (m *OneToOneNatSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_OneToOneNatSpec.DiscardUnknown(m)
}

var xxx_messageInfo_OneToOneNatSpec proto.InternalMessageInfo

func (m *OneToOneNatSpec) GetIpVersion() IpVersion {
	if m != nil {
		return m.IpVersion
	}
	return IpVersion_IP_VERSION_UNSPECIFIED
}

type SchedulingPolicy struct {
	// Preemptible instances are stopped at least once every 24 hours, and can be stopped at any time
	// if their resources are needed by Compute.
	// For more information, see [Preemptible Virtual Machines](/docs/compute/concepts/preemptible-vm).
	Preemptible          bool     `protobuf:"varint,1,opt,name=preemptible,proto3" json:"preemptible,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SchedulingPolicy) Reset()         { *m = SchedulingPolicy{} }
func (m *SchedulingPolicy) String() string { return proto.CompactTextString(m) }
func (*SchedulingPolicy) ProtoMessage()    {}
func (*SchedulingPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{12}
}

func (m *SchedulingPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SchedulingPolicy.Unmarshal(m, b)
}
func (m *SchedulingPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SchedulingPolicy.Marshal(b, m, deterministic)
}
func (m *SchedulingPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SchedulingPolicy.Merge(m, src)
}
func (m *SchedulingPolicy) XXX_Size() int {
	return xxx_messageInfo_SchedulingPolicy.Size(m)
}
func (m *SchedulingPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_SchedulingPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_SchedulingPolicy proto.InternalMessageInfo

func (m *SchedulingPolicy) GetPreemptible() bool {
	if m != nil {
		return m.Preemptible
	}
	return false
}

type LoadBalancerSpec struct {
	// Specification of the target group that the instance group will be added to. For more information, see [Target groups and resources](/docs/load-balancer/target-resources).
	TargetGroupSpec      *TargetGroupSpec `protobuf:"bytes,1,opt,name=target_group_spec,json=targetGroupSpec,proto3" json:"target_group_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *LoadBalancerSpec) Reset()         { *m = LoadBalancerSpec{} }
func (m *LoadBalancerSpec) String() string { return proto.CompactTextString(m) }
func (*LoadBalancerSpec) ProtoMessage()    {}
func (*LoadBalancerSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{13}
}

func (m *LoadBalancerSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LoadBalancerSpec.Unmarshal(m, b)
}
func (m *LoadBalancerSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LoadBalancerSpec.Marshal(b, m, deterministic)
}
func (m *LoadBalancerSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LoadBalancerSpec.Merge(m, src)
}
func (m *LoadBalancerSpec) XXX_Size() int {
	return xxx_messageInfo_LoadBalancerSpec.Size(m)
}
func (m *LoadBalancerSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_LoadBalancerSpec.DiscardUnknown(m)
}

var xxx_messageInfo_LoadBalancerSpec proto.InternalMessageInfo

func (m *LoadBalancerSpec) GetTargetGroupSpec() *TargetGroupSpec {
	if m != nil {
		return m.TargetGroupSpec
	}
	return nil
}

type TargetGroupSpec struct {
	// Name of the target group.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the target group.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `key:value` pairs.
	Labels               map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *TargetGroupSpec) Reset()         { *m = TargetGroupSpec{} }
func (m *TargetGroupSpec) String() string { return proto.CompactTextString(m) }
func (*TargetGroupSpec) ProtoMessage()    {}
func (*TargetGroupSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{14}
}

func (m *TargetGroupSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TargetGroupSpec.Unmarshal(m, b)
}
func (m *TargetGroupSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TargetGroupSpec.Marshal(b, m, deterministic)
}
func (m *TargetGroupSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TargetGroupSpec.Merge(m, src)
}
func (m *TargetGroupSpec) XXX_Size() int {
	return xxx_messageInfo_TargetGroupSpec.Size(m)
}
func (m *TargetGroupSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_TargetGroupSpec.DiscardUnknown(m)
}

var xxx_messageInfo_TargetGroupSpec proto.InternalMessageInfo

func (m *TargetGroupSpec) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *TargetGroupSpec) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *TargetGroupSpec) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

type HealthChecksSpec struct {
	// Health checking specification. For more information, see [Health check](/docs/load-balancer/concepts/health-check).
	HealthCheckSpecs     []*HealthCheckSpec `protobuf:"bytes,1,rep,name=health_check_specs,json=healthCheckSpecs,proto3" json:"health_check_specs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *HealthChecksSpec) Reset()         { *m = HealthChecksSpec{} }
func (m *HealthChecksSpec) String() string { return proto.CompactTextString(m) }
func (*HealthChecksSpec) ProtoMessage()    {}
func (*HealthChecksSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{15}
}

func (m *HealthChecksSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HealthChecksSpec.Unmarshal(m, b)
}
func (m *HealthChecksSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HealthChecksSpec.Marshal(b, m, deterministic)
}
func (m *HealthChecksSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HealthChecksSpec.Merge(m, src)
}
func (m *HealthChecksSpec) XXX_Size() int {
	return xxx_messageInfo_HealthChecksSpec.Size(m)
}
func (m *HealthChecksSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_HealthChecksSpec.DiscardUnknown(m)
}

var xxx_messageInfo_HealthChecksSpec proto.InternalMessageInfo

func (m *HealthChecksSpec) GetHealthCheckSpecs() []*HealthCheckSpec {
	if m != nil {
		return m.HealthCheckSpecs
	}
	return nil
}

type HealthCheckSpec struct {
	// The interval between health checks. The default is 2 seconds.
	Interval *duration.Duration `protobuf:"bytes,1,opt,name=interval,proto3" json:"interval,omitempty"`
	// Timeout for the managed instance to return a response for the health check. The default is 1 second.
	Timeout *duration.Duration `protobuf:"bytes,2,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// The number of failed health checks for the managed instance to be considered unhealthy. The default (0) is 2.
	UnhealthyThreshold int64 `protobuf:"varint,3,opt,name=unhealthy_threshold,json=unhealthyThreshold,proto3" json:"unhealthy_threshold,omitempty"`
	// The number of successful health checks required in order for the managed instance to be considered healthy. The default (0) is 2.
	HealthyThreshold int64 `protobuf:"varint,4,opt,name=healthy_threshold,json=healthyThreshold,proto3" json:"healthy_threshold,omitempty"`
	// Types that are valid to be assigned to HealthCheckOptions:
	//	*HealthCheckSpec_TcpOptions_
	//	*HealthCheckSpec_HttpOptions_
	HealthCheckOptions   isHealthCheckSpec_HealthCheckOptions `protobuf_oneof:"health_check_options"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *HealthCheckSpec) Reset()         { *m = HealthCheckSpec{} }
func (m *HealthCheckSpec) String() string { return proto.CompactTextString(m) }
func (*HealthCheckSpec) ProtoMessage()    {}
func (*HealthCheckSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{16}
}

func (m *HealthCheckSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HealthCheckSpec.Unmarshal(m, b)
}
func (m *HealthCheckSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HealthCheckSpec.Marshal(b, m, deterministic)
}
func (m *HealthCheckSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HealthCheckSpec.Merge(m, src)
}
func (m *HealthCheckSpec) XXX_Size() int {
	return xxx_messageInfo_HealthCheckSpec.Size(m)
}
func (m *HealthCheckSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_HealthCheckSpec.DiscardUnknown(m)
}

var xxx_messageInfo_HealthCheckSpec proto.InternalMessageInfo

func (m *HealthCheckSpec) GetInterval() *duration.Duration {
	if m != nil {
		return m.Interval
	}
	return nil
}

func (m *HealthCheckSpec) GetTimeout() *duration.Duration {
	if m != nil {
		return m.Timeout
	}
	return nil
}

func (m *HealthCheckSpec) GetUnhealthyThreshold() int64 {
	if m != nil {
		return m.UnhealthyThreshold
	}
	return 0
}

func (m *HealthCheckSpec) GetHealthyThreshold() int64 {
	if m != nil {
		return m.HealthyThreshold
	}
	return 0
}

type isHealthCheckSpec_HealthCheckOptions interface {
	isHealthCheckSpec_HealthCheckOptions()
}

type HealthCheckSpec_TcpOptions_ struct {
	TcpOptions *HealthCheckSpec_TcpOptions `protobuf:"bytes,5,opt,name=tcp_options,json=tcpOptions,proto3,oneof"`
}

type HealthCheckSpec_HttpOptions_ struct {
	HttpOptions *HealthCheckSpec_HttpOptions `protobuf:"bytes,6,opt,name=http_options,json=httpOptions,proto3,oneof"`
}

func (*HealthCheckSpec_TcpOptions_) isHealthCheckSpec_HealthCheckOptions() {}

func (*HealthCheckSpec_HttpOptions_) isHealthCheckSpec_HealthCheckOptions() {}

func (m *HealthCheckSpec) GetHealthCheckOptions() isHealthCheckSpec_HealthCheckOptions {
	if m != nil {
		return m.HealthCheckOptions
	}
	return nil
}

func (m *HealthCheckSpec) GetTcpOptions() *HealthCheckSpec_TcpOptions {
	if x, ok := m.GetHealthCheckOptions().(*HealthCheckSpec_TcpOptions_); ok {
		return x.TcpOptions
	}
	return nil
}

func (m *HealthCheckSpec) GetHttpOptions() *HealthCheckSpec_HttpOptions {
	if x, ok := m.GetHealthCheckOptions().(*HealthCheckSpec_HttpOptions_); ok {
		return x.HttpOptions
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*HealthCheckSpec) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*HealthCheckSpec_TcpOptions_)(nil),
		(*HealthCheckSpec_HttpOptions_)(nil),
	}
}

type HealthCheckSpec_TcpOptions struct {
	// Port to use for TCP health checks.
	Port                 int64    `protobuf:"varint,1,opt,name=port,proto3" json:"port,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HealthCheckSpec_TcpOptions) Reset()         { *m = HealthCheckSpec_TcpOptions{} }
func (m *HealthCheckSpec_TcpOptions) String() string { return proto.CompactTextString(m) }
func (*HealthCheckSpec_TcpOptions) ProtoMessage()    {}
func (*HealthCheckSpec_TcpOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{16, 0}
}

func (m *HealthCheckSpec_TcpOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HealthCheckSpec_TcpOptions.Unmarshal(m, b)
}
func (m *HealthCheckSpec_TcpOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HealthCheckSpec_TcpOptions.Marshal(b, m, deterministic)
}
func (m *HealthCheckSpec_TcpOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HealthCheckSpec_TcpOptions.Merge(m, src)
}
func (m *HealthCheckSpec_TcpOptions) XXX_Size() int {
	return xxx_messageInfo_HealthCheckSpec_TcpOptions.Size(m)
}
func (m *HealthCheckSpec_TcpOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_HealthCheckSpec_TcpOptions.DiscardUnknown(m)
}

var xxx_messageInfo_HealthCheckSpec_TcpOptions proto.InternalMessageInfo

func (m *HealthCheckSpec_TcpOptions) GetPort() int64 {
	if m != nil {
		return m.Port
	}
	return 0
}

type HealthCheckSpec_HttpOptions struct {
	// Port to use for HTTP health checks.
	Port int64 `protobuf:"varint,1,opt,name=port,proto3" json:"port,omitempty"`
	// URL path to set for health checking requests.
	Path                 string   `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HealthCheckSpec_HttpOptions) Reset()         { *m = HealthCheckSpec_HttpOptions{} }
func (m *HealthCheckSpec_HttpOptions) String() string { return proto.CompactTextString(m) }
func (*HealthCheckSpec_HttpOptions) ProtoMessage()    {}
func (*HealthCheckSpec_HttpOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{16, 1}
}

func (m *HealthCheckSpec_HttpOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HealthCheckSpec_HttpOptions.Unmarshal(m, b)
}
func (m *HealthCheckSpec_HttpOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HealthCheckSpec_HttpOptions.Marshal(b, m, deterministic)
}
func (m *HealthCheckSpec_HttpOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HealthCheckSpec_HttpOptions.Merge(m, src)
}
func (m *HealthCheckSpec_HttpOptions) XXX_Size() int {
	return xxx_messageInfo_HealthCheckSpec_HttpOptions.Size(m)
}
func (m *HealthCheckSpec_HttpOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_HealthCheckSpec_HttpOptions.DiscardUnknown(m)
}

var xxx_messageInfo_HealthCheckSpec_HttpOptions proto.InternalMessageInfo

func (m *HealthCheckSpec_HttpOptions) GetPort() int64 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *HealthCheckSpec_HttpOptions) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

// A ManagedInstance resource. For more information, see [Instance Groups Concepts](/docs/compute/concepts/instance-groups/).
type ManagedInstance struct {
	// ID of the managed instance.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Status of the managed instance.
	Status ManagedInstance_Status `protobuf:"varint,2,opt,name=status,proto3,enum=yandex.cloud.compute.v1.instancegroup.ManagedInstance_Status" json:"status,omitempty"`
	// ID of the instance.
	InstanceId string `protobuf:"bytes,3,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Fully Qualified Domain Name.
	Fqdn string `protobuf:"bytes,4,opt,name=fqdn,proto3" json:"fqdn,omitempty"`
	// The name of the managed instance.
	Name string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	// Status message for the managed instance.
	StatusMessage string `protobuf:"bytes,6,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// ID of the availability zone where the instance resides.
	ZoneId string `protobuf:"bytes,7,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// Array of network interfaces that are attached to the managed instance.
	NetworkInterfaces []*NetworkInterface `protobuf:"bytes,8,rep,name=network_interfaces,json=networkInterfaces,proto3" json:"network_interfaces,omitempty"`
	// The timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format when the status of the managed instance was last changed.
	StatusChangedAt      *timestamp.Timestamp `protobuf:"bytes,9,opt,name=status_changed_at,json=statusChangedAt,proto3" json:"status_changed_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ManagedInstance) Reset()         { *m = ManagedInstance{} }
func (m *ManagedInstance) String() string { return proto.CompactTextString(m) }
func (*ManagedInstance) ProtoMessage()    {}
func (*ManagedInstance) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{17}
}

func (m *ManagedInstance) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ManagedInstance.Unmarshal(m, b)
}
func (m *ManagedInstance) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ManagedInstance.Marshal(b, m, deterministic)
}
func (m *ManagedInstance) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ManagedInstance.Merge(m, src)
}
func (m *ManagedInstance) XXX_Size() int {
	return xxx_messageInfo_ManagedInstance.Size(m)
}
func (m *ManagedInstance) XXX_DiscardUnknown() {
	xxx_messageInfo_ManagedInstance.DiscardUnknown(m)
}

var xxx_messageInfo_ManagedInstance proto.InternalMessageInfo

func (m *ManagedInstance) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ManagedInstance) GetStatus() ManagedInstance_Status {
	if m != nil {
		return m.Status
	}
	return ManagedInstance_STATUS_UNSPECIFIED
}

func (m *ManagedInstance) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

func (m *ManagedInstance) GetFqdn() string {
	if m != nil {
		return m.Fqdn
	}
	return ""
}

func (m *ManagedInstance) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ManagedInstance) GetStatusMessage() string {
	if m != nil {
		return m.StatusMessage
	}
	return ""
}

func (m *ManagedInstance) GetZoneId() string {
	if m != nil {
		return m.ZoneId
	}
	return ""
}

func (m *ManagedInstance) GetNetworkInterfaces() []*NetworkInterface {
	if m != nil {
		return m.NetworkInterfaces
	}
	return nil
}

func (m *ManagedInstance) GetStatusChangedAt() *timestamp.Timestamp {
	if m != nil {
		return m.StatusChangedAt
	}
	return nil
}

type NetworkInterface struct {
	// The index of the network interface, generated by the server, 0,1,2... etc.
	// Currently only one network interface is supported per instance.
	Index string `protobuf:"bytes,1,opt,name=index,proto3" json:"index,omitempty"`
	// MAC address that is assigned to the network interface.
	MacAddress string `protobuf:"bytes,2,opt,name=mac_address,json=macAddress,proto3" json:"mac_address,omitempty"`
	// ID of the subnet.
	SubnetId string `protobuf:"bytes,3,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Primary IPv4 address that is assigned to the instance for this network interface.
	PrimaryV4Address *PrimaryAddress `protobuf:"bytes,4,opt,name=primary_v4_address,json=primaryV4Address,proto3" json:"primary_v4_address,omitempty"`
	// Primary IPv6 address that is assigned to the instance for this network interface. IPv6 is not available yet.
	PrimaryV6Address     *PrimaryAddress `protobuf:"bytes,5,opt,name=primary_v6_address,json=primaryV6Address,proto3" json:"primary_v6_address,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *NetworkInterface) Reset()         { *m = NetworkInterface{} }
func (m *NetworkInterface) String() string { return proto.CompactTextString(m) }
func (*NetworkInterface) ProtoMessage()    {}
func (*NetworkInterface) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{18}
}

func (m *NetworkInterface) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NetworkInterface.Unmarshal(m, b)
}
func (m *NetworkInterface) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NetworkInterface.Marshal(b, m, deterministic)
}
func (m *NetworkInterface) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkInterface.Merge(m, src)
}
func (m *NetworkInterface) XXX_Size() int {
	return xxx_messageInfo_NetworkInterface.Size(m)
}
func (m *NetworkInterface) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkInterface.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkInterface proto.InternalMessageInfo

func (m *NetworkInterface) GetIndex() string {
	if m != nil {
		return m.Index
	}
	return ""
}

func (m *NetworkInterface) GetMacAddress() string {
	if m != nil {
		return m.MacAddress
	}
	return ""
}

func (m *NetworkInterface) GetSubnetId() string {
	if m != nil {
		return m.SubnetId
	}
	return ""
}

func (m *NetworkInterface) GetPrimaryV4Address() *PrimaryAddress {
	if m != nil {
		return m.PrimaryV4Address
	}
	return nil
}

func (m *NetworkInterface) GetPrimaryV6Address() *PrimaryAddress {
	if m != nil {
		return m.PrimaryV6Address
	}
	return nil
}

type PrimaryAddress struct {
	// An IPv4 internal network address that is assigned to the managed instance for this network interface.
	// If not specified by the user, an unused internal IP is assigned by the system.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// One-to-one NAT configuration. If missing, NAT has not been set up.
	OneToOneNat          *OneToOneNat `protobuf:"bytes,2,opt,name=one_to_one_nat,json=oneToOneNat,proto3" json:"one_to_one_nat,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *PrimaryAddress) Reset()         { *m = PrimaryAddress{} }
func (m *PrimaryAddress) String() string { return proto.CompactTextString(m) }
func (*PrimaryAddress) ProtoMessage()    {}
func (*PrimaryAddress) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{19}
}

func (m *PrimaryAddress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PrimaryAddress.Unmarshal(m, b)
}
func (m *PrimaryAddress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PrimaryAddress.Marshal(b, m, deterministic)
}
func (m *PrimaryAddress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrimaryAddress.Merge(m, src)
}
func (m *PrimaryAddress) XXX_Size() int {
	return xxx_messageInfo_PrimaryAddress.Size(m)
}
func (m *PrimaryAddress) XXX_DiscardUnknown() {
	xxx_messageInfo_PrimaryAddress.DiscardUnknown(m)
}

var xxx_messageInfo_PrimaryAddress proto.InternalMessageInfo

func (m *PrimaryAddress) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *PrimaryAddress) GetOneToOneNat() *OneToOneNat {
	if m != nil {
		return m.OneToOneNat
	}
	return nil
}

type OneToOneNat struct {
	// An IPv4 external network address that is assigned to the managed instance for this network interface.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// External IP address version.
	IpVersion            IpVersion `protobuf:"varint,2,opt,name=ip_version,json=ipVersion,proto3,enum=yandex.cloud.compute.v1.instancegroup.IpVersion" json:"ip_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *OneToOneNat) Reset()         { *m = OneToOneNat{} }
func (m *OneToOneNat) String() string { return proto.CompactTextString(m) }
func (*OneToOneNat) ProtoMessage()    {}
func (*OneToOneNat) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{20}
}

func (m *OneToOneNat) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OneToOneNat.Unmarshal(m, b)
}
func (m *OneToOneNat) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OneToOneNat.Marshal(b, m, deterministic)
}
func (m *OneToOneNat) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OneToOneNat.Merge(m, src)
}
func (m *OneToOneNat) XXX_Size() int {
	return xxx_messageInfo_OneToOneNat.Size(m)
}
func (m *OneToOneNat) XXX_DiscardUnknown() {
	xxx_messageInfo_OneToOneNat.DiscardUnknown(m)
}

var xxx_messageInfo_OneToOneNat proto.InternalMessageInfo

func (m *OneToOneNat) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *OneToOneNat) GetIpVersion() IpVersion {
	if m != nil {
		return m.IpVersion
	}
	return IpVersion_IP_VERSION_UNSPECIFIED
}

type LogRecord struct {
	// Log timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	Timestamp *timestamp.Timestamp `protobuf:"bytes,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// The log message.
	Message              string   `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LogRecord) Reset()         { *m = LogRecord{} }
func (m *LogRecord) String() string { return proto.CompactTextString(m) }
func (*LogRecord) ProtoMessage()    {}
func (*LogRecord) Descriptor() ([]byte, []int) {
	return fileDescriptor_993454707bf70b9b, []int{21}
}

func (m *LogRecord) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogRecord.Unmarshal(m, b)
}
func (m *LogRecord) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogRecord.Marshal(b, m, deterministic)
}
func (m *LogRecord) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogRecord.Merge(m, src)
}
func (m *LogRecord) XXX_Size() int {
	return xxx_messageInfo_LogRecord.Size(m)
}
func (m *LogRecord) XXX_DiscardUnknown() {
	xxx_messageInfo_LogRecord.DiscardUnknown(m)
}

var xxx_messageInfo_LogRecord proto.InternalMessageInfo

func (m *LogRecord) GetTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *LogRecord) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func init() {
	proto.RegisterEnum("yandex.cloud.compute.v1.instancegroup.IpVersion", IpVersion_name, IpVersion_value)
	proto.RegisterEnum("yandex.cloud.compute.v1.instancegroup.AttachedDiskSpec_Mode", AttachedDiskSpec_Mode_name, AttachedDiskSpec_Mode_value)
	proto.RegisterEnum("yandex.cloud.compute.v1.instancegroup.ManagedInstance_Status", ManagedInstance_Status_name, ManagedInstance_Status_value)
	proto.RegisterType((*InstanceGroup)(nil), "yandex.cloud.compute.v1.instancegroup.InstanceGroup")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.compute.v1.instancegroup.InstanceGroup.LabelsEntry")
	proto.RegisterType((*LoadBalancerState)(nil), "yandex.cloud.compute.v1.instancegroup.LoadBalancerState")
	proto.RegisterType((*ManagedInstancesState)(nil), "yandex.cloud.compute.v1.instancegroup.ManagedInstancesState")
	proto.RegisterType((*ManagedInstancesState_Statuses)(nil), "yandex.cloud.compute.v1.instancegroup.ManagedInstancesState.Statuses")
	proto.RegisterType((*ScalePolicy)(nil), "yandex.cloud.compute.v1.instancegroup.ScalePolicy")
	proto.RegisterType((*ScalePolicy_AutoScale)(nil), "yandex.cloud.compute.v1.instancegroup.ScalePolicy.AutoScale")
	proto.RegisterType((*ScalePolicy_CpuUtilizationRule)(nil), "yandex.cloud.compute.v1.instancegroup.ScalePolicy.CpuUtilizationRule")
	proto.RegisterType((*ScalePolicy_FixedScale)(nil), "yandex.cloud.compute.v1.instancegroup.ScalePolicy.FixedScale")
	proto.RegisterType((*DeployPolicy)(nil), "yandex.cloud.compute.v1.instancegroup.DeployPolicy")
	proto.RegisterType((*AllocationPolicy)(nil), "yandex.cloud.compute.v1.instancegroup.AllocationPolicy")
	proto.RegisterType((*AllocationPolicy_Zone)(nil), "yandex.cloud.compute.v1.instancegroup.AllocationPolicy.Zone")
	proto.RegisterType((*InstanceTemplate)(nil), "yandex.cloud.compute.v1.instancegroup.InstanceTemplate")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.compute.v1.instancegroup.InstanceTemplate.LabelsEntry")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.compute.v1.instancegroup.InstanceTemplate.MetadataEntry")
	proto.RegisterType((*ResourcesSpec)(nil), "yandex.cloud.compute.v1.instancegroup.ResourcesSpec")
	proto.RegisterType((*AttachedDiskSpec)(nil), "yandex.cloud.compute.v1.instancegroup.AttachedDiskSpec")
	proto.RegisterType((*AttachedDiskSpec_DiskSpec)(nil), "yandex.cloud.compute.v1.instancegroup.AttachedDiskSpec.DiskSpec")
	proto.RegisterType((*NetworkInterfaceSpec)(nil), "yandex.cloud.compute.v1.instancegroup.NetworkInterfaceSpec")
	proto.RegisterType((*PrimaryAddressSpec)(nil), "yandex.cloud.compute.v1.instancegroup.PrimaryAddressSpec")
	proto.RegisterType((*OneToOneNatSpec)(nil), "yandex.cloud.compute.v1.instancegroup.OneToOneNatSpec")
	proto.RegisterType((*SchedulingPolicy)(nil), "yandex.cloud.compute.v1.instancegroup.SchedulingPolicy")
	proto.RegisterType((*LoadBalancerSpec)(nil), "yandex.cloud.compute.v1.instancegroup.LoadBalancerSpec")
	proto.RegisterType((*TargetGroupSpec)(nil), "yandex.cloud.compute.v1.instancegroup.TargetGroupSpec")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.compute.v1.instancegroup.TargetGroupSpec.LabelsEntry")
	proto.RegisterType((*HealthChecksSpec)(nil), "yandex.cloud.compute.v1.instancegroup.HealthChecksSpec")
	proto.RegisterType((*HealthCheckSpec)(nil), "yandex.cloud.compute.v1.instancegroup.HealthCheckSpec")
	proto.RegisterType((*HealthCheckSpec_TcpOptions)(nil), "yandex.cloud.compute.v1.instancegroup.HealthCheckSpec.TcpOptions")
	proto.RegisterType((*HealthCheckSpec_HttpOptions)(nil), "yandex.cloud.compute.v1.instancegroup.HealthCheckSpec.HttpOptions")
	proto.RegisterType((*ManagedInstance)(nil), "yandex.cloud.compute.v1.instancegroup.ManagedInstance")
	proto.RegisterType((*NetworkInterface)(nil), "yandex.cloud.compute.v1.instancegroup.NetworkInterface")
	proto.RegisterType((*PrimaryAddress)(nil), "yandex.cloud.compute.v1.instancegroup.PrimaryAddress")
	proto.RegisterType((*OneToOneNat)(nil), "yandex.cloud.compute.v1.instancegroup.OneToOneNat")
	proto.RegisterType((*LogRecord)(nil), "yandex.cloud.compute.v1.instancegroup.LogRecord")
}

func init() {
	proto.RegisterFile("yandex/cloud/compute/v1/instancegroup/instance_group.proto", fileDescriptor_993454707bf70b9b)
}

var fileDescriptor_993454707bf70b9b = []byte{
	// 3038 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x5a, 0xcd, 0x73, 0xdb, 0xc6,
	0xd9, 0x0f, 0x29, 0x8a, 0x1f, 0x0f, 0x25, 0x0a, 0x5a, 0xcb, 0x36, 0xc3, 0xc4, 0xaf, 0xfd, 0x72,
	0x5e, 0xbf, 0x93, 0xd7, 0x01, 0x29, 0x82, 0xa2, 0x28, 0x29, 0xb6, 0xdf, 0x84, 0x94, 0xe8, 0x98,
	0x53, 0x59, 0xd2, 0x40, 0x94, 0x9d, 0xc4, 0xc9, 0xa0, 0x2b, 0x60, 0x45, 0x61, 0x4c, 0x00, 0x2c,
	0x00, 0x2a, 0x92, 0xd2, 0x1c, 0xea, 0x1e, 0xda, 0xc9, 0xa9, 0xa7, 0x4c, 0x67, 0xd2, 0x99, 0xfe,
	0x0b, 0x9d, 0xce, 0x74, 0xa6, 0xc7, 0xf6, 0x24, 0x9f, 0x7a, 0xe9, 0xb9, 0x3d, 0xf5, 0xd0, 0x5e,
	0xd3, 0x9b, 0x4e, 0x9d, 0xfd, 0x00, 0x48, 0x42, 0xae, 0x2d, 0x29, 0xe9, 0x49, 0x7c, 0xbe, 0x9f,
	0xdd, 0x7d, 0xf6, 0xd9, 0xdf, 0x2e, 0x04, 0xef, 0x1d, 0x61, 0xdb, 0x20, 0x87, 0xf3, 0x7a, 0xcf,
	0x19, 0x18, 0xf3, 0xba, 0x63, 0xf5, 0x07, 0x3e, 0x99, 0x3f, 0x50, 0xe6, 0x4d, 0xdb, 0xf3, 0xb1,
	0xad, 0x93, 0xae, 0xeb, 0x0c, 0xfa, 0x21, 0xa5, 0x31, 0xb2, 0xdc, 0x77, 0x1d, 0xdf, 0x41, 0xb7,
	0xb9, 0x6d, 0x99, 0xd9, 0x96, 0x85, 0x6d, 0xf9, 0x40, 0x29, 0x8f, 0xd9, 0x16, 0x6e, 0x8c, 0x85,
	0x38, 0xc0, 0x3d, 0xd3, 0xc0, 0xbe, 0xe9, 0xd8, 0xdc, 0x4b, 0xe1, 0x66, 0xd7, 0x71, 0xba, 0x3d,
	0x32, 0xcf, 0xa8, 0xdd, 0xc1, 0xde, 0xbc, 0x6f, 0x5a, 0xc4, 0xf3, 0xb1, 0x25, 0xc2, 0x14, 0xfe,
	0x2b, 0xaa, 0x60, 0x0c, 0xdc, 0x11, 0x07, 0xc5, 0x6f, 0x32, 0x30, 0xdd, 0x16, 0x11, 0x3f, 0xa4,
	0x11, 0x51, 0x0e, 0xe2, 0xa6, 0x91, 0x8f, 0xdd, 0x8a, 0xbd, 0x93, 0x51, 0xe3, 0xa6, 0x81, 0xde,
	0x82, 0xcc, 0x9e, 0xd3, 0x33, 0x88, 0xab, 0x99, 0x46, 0x3e, 0xce, 0xd8, 0x69, 0xce, 0x68, 0x1b,
	0x68, 0x05, 0x40, 0x77, 0x09, 0xf6, 0x89, 0xa1, 0x61, 0x3f, 0x3f, 0x71, 0x2b, 0xf6, 0x4e, 0xb6,
	0x5a, 0x28, 0xf3, 0x98, 0xe5, 0x20, 0x66, 0xb9, 0x13, 0x24, 0xa5, 0x66, 0x84, 0x76, 0xc3, 0x47,
	0x08, 0x12, 0x36, 0xb6, 0x48, 0x3e, 0xc1, 0x5c, 0xb2, 0xdf, 0xe8, 0x16, 0x64, 0x0d, 0xe2, 0xe9,
	0xae, 0xd9, 0xa7, 0x29, 0xe6, 0x27, 0x99, 0x68, 0x94, 0x85, 0x3e, 0x82, 0x64, 0x0f, 0xef, 0x92,
	0x9e, 0x97, 0x4f, 0xde, 0x9a, 0x78, 0x27, 0x5b, 0xfd, 0xa0, 0x7c, 0xae, 0x79, 0x2c, 0x8f, 0x8d,
	0xb1, 0xbc, 0xce, 0x5c, 0xb4, 0x6c, 0xdf, 0x3d, 0x52, 0x85, 0x3f, 0x64, 0xc0, 0x6c, 0xb8, 0x50,
	0x3e, 0xb1, 0xfa, 0x3d, 0xec, 0x93, 0x7c, 0x8a, 0x8d, 0x68, 0xe9, 0x82, 0x41, 0x3a, 0xc2, 0x5c,
	0x95, 0xcc, 0x08, 0x07, 0xed, 0xc0, 0x94, 0xa7, 0xe3, 0x1e, 0xd1, 0xfa, 0x4e, 0xcf, 0xd4, 0x8f,
	0xf2, 0x69, 0x16, 0xa0, 0x7a, 0xce, 0x00, 0xdb, 0xd4, 0x74, 0x8b, 0x59, 0xaa, 0x59, 0x6f, 0x48,
	0xa0, 0x8f, 0x60, 0xda, 0x20, 0xfd, 0x9e, 0x73, 0x14, 0xf8, 0xcd, 0x30, 0xbf, 0x0b, 0xe7, 0xf4,
	0xbb, 0xc6, 0x6c, 0x85, 0xe3, 0x29, 0x63, 0x84, 0xa2, 0xd3, 0x82, 0x7b, 0x3d, 0x47, 0x67, 0x45,
	0x13, 0x78, 0x87, 0x0b, 0x4d, 0x4b, 0x23, 0xb4, 0x17, 0x11, 0x24, 0x1c, 0xe1, 0xa0, 0x7d, 0xb8,
	0xd2, 0x73, 0xb0, 0xa1, 0xed, 0xe2, 0x1e, 0xb5, 0x73, 0x35, 0xcf, 0xa7, 0xd3, 0x9f, 0x65, 0x71,
	0x96, 0xcf, 0x19, 0x67, 0xdd, 0xc1, 0x46, 0x53, 0x38, 0xd8, 0xa6, 0xf6, 0xea, 0x6c, 0x2f, 0xca,
	0x42, 0x3e, 0x5c, 0xb7, 0xb0, 0x8d, 0xbb, 0xc4, 0xd0, 0x02, 0x6b, 0x4f, 0x44, 0x9b, 0x62, 0xd1,
	0xee, 0x9d, 0x33, 0xda, 0x23, 0xee, 0x25, 0x58, 0x73, 0x8f, 0x47, 0xbc, 0x6a, 0xbd, 0x8c, 0x8d,
	0x08, 0xa0, 0xc8, 0xf8, 0xfa, 0x44, 0xcf, 0xe7, 0x2e, 0x34, 0x8d, 0x63, 0xc3, 0xeb, 0x13, 0x5d,
	0x95, 0x7a, 0x11, 0x0e, 0x0d, 0xb3, 0x4f, 0x70, 0xcf, 0xdf, 0xd7, 0xf4, 0x7d, 0xa2, 0x3f, 0xf3,
	0x78, 0x98, 0x99, 0x0b, 0x85, 0x79, 0xc8, 0x1c, 0xac, 0x32, 0x7b, 0x1e, 0x66, 0x3f, 0xc2, 0x41,
	0x32, 0x20, 0x8f, 0xb8, 0x07, 0xa6, 0x4e, 0x34, 0xac, 0xeb, 0xce, 0xc0, 0xf6, 0x69, 0x6f, 0x90,
	0xd8, 0x6e, 0x95, 0x84, 0xa4, 0xc1, 0x05, 0x6d, 0xa3, 0xb0, 0x02, 0xd9, 0x91, 0xfd, 0x86, 0x24,
	0x98, 0x78, 0x46, 0x8e, 0x44, 0x83, 0xa1, 0x3f, 0xd1, 0x1c, 0x4c, 0x1e, 0xe0, 0xde, 0x80, 0x88,
	0xee, 0xc2, 0x89, 0xf7, 0xe2, 0xcb, 0xb1, 0xe2, 0x2e, 0xcc, 0x9e, 0x59, 0x54, 0xf4, 0xbf, 0x30,
	0xe3, 0x63, 0xb7, 0x4b, 0x7c, 0xde, 0x4f, 0xb5, 0xb0, 0x5b, 0x4d, 0x73, 0x36, 0xdb, 0xe2, 0x6d,
	0x03, 0xdd, 0x86, 0x1c, 0x5d, 0xd7, 0x81, 0xa7, 0x59, 0xc4, 0xf3, 0x70, 0x37, 0xf0, 0x3f, 0xcd,
	0xb9, 0x8f, 0x38, 0xb3, 0xf8, 0xb7, 0x09, 0xb8, 0xfa, 0xd2, 0xb5, 0x44, 0x37, 0x21, 0x2b, 0x02,
	0x79, 0xe6, 0x31, 0x61, 0x41, 0x26, 0x54, 0xe0, 0xac, 0x6d, 0xf3, 0x98, 0xa0, 0x0a, 0xcc, 0xb9,
	0x03, 0xdb, 0x36, 0xed, 0xae, 0x86, 0x75, 0x7f, 0x80, 0x7b, 0x1a, 0x1b, 0x33, 0x6b, 0x69, 0x13,
	0x2a, 0x12, 0xb2, 0x06, 0x13, 0xad, 0x52, 0x09, 0xaa, 0xc1, 0xb5, 0xc0, 0xc2, 0x19, 0xf8, 0x06,
	0x6b, 0x9c, 0xdc, 0x66, 0x92, 0xd9, 0x04, 0xfe, 0x36, 0x85, 0x90, 0x5b, 0xfd, 0x1f, 0x48, 0x7d,
	0xd7, 0xd1, 0x89, 0xe7, 0x51, 0x43, 0xae, 0x9f, 0x64, 0xfa, 0x33, 0x43, 0x3e, 0x53, 0x2d, 0x7c,
	0x1d, 0x87, 0xf4, 0x36, 0x1b, 0x1f, 0xf1, 0x50, 0x01, 0xd2, 0xac, 0xdf, 0x9a, 0x76, 0x57, 0x64,
	0x1f, 0xd2, 0x54, 0xe6, 0xf9, 0xd8, 0x65, 0xb2, 0x38, 0x97, 0x05, 0x34, 0xca, 0x43, 0xca, 0xe9,
	0x13, 0x9a, 0x07, 0x6b, 0xe9, 0x13, 0x6a, 0x40, 0x52, 0xc9, 0xe7, 0xd8, 0xb5, 0xa8, 0x84, 0x0f,
	0x32, 0x20, 0xa9, 0x44, 0xe4, 0x2e, 0x86, 0x12, 0x90, 0x54, 0xa2, 0xf7, 0x1c, 0x9a, 0xa2, 0x48,
	0x3a, 0x20, 0x79, 0x0e, 0x4e, 0xbf, 0x4f, 0x45, 0xa9, 0x20, 0x07, 0x4e, 0x53, 0xd9, 0xa0, 0x6f,
	0xf0, 0xdc, 0xd3, 0x5c, 0x16, 0xd0, 0x54, 0x66, 0x90, 0x1e, 0x61, 0xb2, 0x0c, 0x97, 0x05, 0x34,
	0xba, 0x06, 0xc9, 0x3d, 0x6c, 0xf6, 0x88, 0xc1, 0x9a, 0xd4, 0x84, 0x2a, 0xa8, 0xe2, 0x3f, 0x93,
	0x90, 0x1d, 0x69, 0x9f, 0xe8, 0x87, 0x90, 0xdd, 0x33, 0x0f, 0x89, 0xa1, 0xb1, 0x36, 0xca, 0xa6,
	0x27, 0x5b, 0xbd, 0x7f, 0xf1, 0x3e, 0x5c, 0x7e, 0x40, 0xbd, 0x30, 0xc6, 0xc3, 0x37, 0x54, 0xd8,
	0x0b, 0x29, 0xf4, 0x19, 0x00, 0x1e, 0xf8, 0x8e, 0x08, 0x10, 0xbf, 0x50, 0x73, 0x19, 0x0d, 0xd0,
	0x18, 0xf8, 0x4e, 0xe0, 0x3f, 0x83, 0x03, 0xa2, 0xf0, 0x8b, 0x04, 0x64, 0x42, 0x11, 0x2a, 0xc1,
	0xb4, 0x65, 0xda, 0xda, 0xb1, 0x63, 0x93, 0x91, 0x6a, 0x6d, 0x66, 0x4e, 0x4f, 0x94, 0xc9, 0x4a,
	0x49, 0xa9, 0x54, 0xd4, 0xac, 0x65, 0xda, 0x9f, 0x38, 0x36, 0x61, 0x95, 0xfb, 0x3f, 0x90, 0xb6,
	0xf0, 0x21, 0xd7, 0x8c, 0x47, 0x35, 0x53, 0x16, 0x3e, 0x64, 0x5a, 0x9f, 0xc2, 0x9c, 0x45, 0xb0,
	0x37, 0x70, 0x89, 0x45, 0x6c, 0x5f, 0x0b, 0xa0, 0x83, 0x38, 0xe7, 0xdf, 0x3c, 0x73, 0xce, 0xaf,
	0x09, 0x85, 0x66, 0xee, 0xef, 0x27, 0x4a, 0xec, 0xf4, 0x44, 0x49, 0x2a, 0x56, 0x49, 0xa9, 0x58,
	0xea, 0x95, 0x11, 0x37, 0x81, 0x12, 0x7a, 0x04, 0x33, 0xb4, 0x78, 0x06, 0xfd, 0xa1, 0xe3, 0xc4,
	0xeb, 0x1c, 0xb3, 0x2c, 0xef, 0xdd, 0xa7, 0x3e, 0x73, 0xdc, 0x38, 0x74, 0xf7, 0x29, 0x5c, 0xf3,
	0x7c, 0xbc, 0x6b, 0xf6, 0xcc, 0x63, 0x7e, 0x56, 0x85, 0x5e, 0x27, 0x5f, 0xe7, 0x15, 0x44, 0xaa,
	0x0b, 0x15, 0x4b, 0xbd, 0x3a, 0xe6, 0x24, 0xf4, 0x7e, 0x07, 0xa6, 0x4c, 0xdb, 0xf4, 0x4d, 0xdc,
	0xe3, 0x93, 0xc6, 0x2a, 0xb9, 0x99, 0x3a, 0x3d, 0x51, 0x26, 0xfe, 0xff, 0xbe, 0xa2, 0x66, 0x85,
	0x90, 0x4d, 0xdb, 0xe7, 0x30, 0xa7, 0xf7, 0x07, 0xda, 0xc0, 0x1f, 0xe6, 0xe2, 0x0e, 0x7a, 0x01,
	0x98, 0x68, 0x5d, 0xa2, 0x04, 0x56, 0xfb, 0x83, 0x9d, 0xa1, 0x37, 0x75, 0xd0, 0x23, 0x2a, 0xd2,
	0xcf, 0xf0, 0x0a, 0x9b, 0x80, 0xce, 0x6a, 0xa2, 0x15, 0x40, 0xa3, 0xa9, 0xf0, 0xfe, 0xc5, 0xea,
	0x23, 0x26, 0x46, 0xce, 0x97, 0x7d, 0x76, 0x44, 0xab, 0xc3, 0x94, 0x0a, 0xef, 0x02, 0x0c, 0xcb,
	0x1b, 0xdd, 0x80, 0x44, 0xb4, 0xb4, 0x14, 0x66, 0xc9, 0xd8, 0x4d, 0x04, 0xc0, 0xa1, 0x8d, 0x7f,
	0xd4, 0x27, 0x28, 0xf1, 0x87, 0x3f, 0x2a, 0xb1, 0xe2, 0xaf, 0xe3, 0x30, 0x35, 0x0a, 0x2e, 0x50,
	0x15, 0x66, 0x68, 0xe1, 0x0d, 0x6c, 0x7c, 0x80, 0xcd, 0x1e, 0xde, 0xed, 0xbd, 0xa4, 0x52, 0x73,
	0x16, 0x3e, 0xdc, 0x19, 0x2a, 0x20, 0x19, 0xa6, 0xa8, 0x4d, 0xb8, 0xe5, 0xe3, 0x67, 0x4b, 0x1b,
	0x1f, 0xae, 0x05, 0x0d, 0x40, 0x68, 0x87, 0x8d, 0x6f, 0xe2, 0x65, 0xda, 0xab, 0x41, 0x1b, 0x2c,
	0xc3, 0x34, 0xd5, 0x26, 0x87, 0x7d, 0x6c, 0x7b, 0xb4, 0x58, 0x92, 0x51, 0x75, 0xea, 0xad, 0x15,
	0x88, 0xd1, 0x26, 0x48, 0xac, 0x4d, 0x8e, 0x56, 0x6d, 0xea, 0x5c, 0x55, 0x5b, 0xb1, 0x4a, 0xca,
	0xbe, 0x3a, 0x23, 0xac, 0x03, 0x59, 0xf1, 0xeb, 0x18, 0x48, 0x51, 0x80, 0x84, 0x9e, 0xc2, 0x24,
	0xdd, 0xc9, 0x5e, 0x3e, 0xc6, 0x40, 0xee, 0xbd, 0x4b, 0x02, 0xad, 0x32, 0xdd, 0xef, 0xcd, 0xd4,
	0xf3, 0x17, 0xbc, 0x48, 0xb9, 0xcf, 0xc2, 0x6d, 0x48, 0x50, 0x3e, 0xba, 0x01, 0x29, 0xd6, 0x2e,
	0x82, 0xf3, 0xb3, 0x99, 0xa0, 0xbb, 0x56, 0x4d, 0x52, 0x66, 0xdb, 0x28, 0xfe, 0x35, 0x0d, 0x52,
	0x14, 0xd0, 0xa2, 0x77, 0xc7, 0x01, 0x3a, 0xb7, 0xcb, 0x7c, 0xf5, 0x82, 0x6e, 0xca, 0xea, 0x62,
	0x7d, 0x1c, 0xab, 0xff, 0x2a, 0x16, 0x82, 0xf5, 0x38, 0x1b, 0xc7, 0xea, 0x25, 0x71, 0xf4, 0x28,
	0x5e, 0x6f, 0xbe, 0xff, 0xed, 0x89, 0x92, 0x7d, 0x5a, 0xd2, 0x2a, 0xa5, 0x15, 0x5c, 0x3a, 0xfe,
	0xec, 0xce, 0xf3, 0x17, 0x4a, 0xe2, 0xde, 0xfd, 0x7a, 0xed, 0x2b, 0xfe, 0x77, 0xe1, 0xb7, 0x2f,
	0x94, 0x64, 0x21, 0xa1, 0x94, 0xd8, 0x2f, 0x84, 0xa4, 0xa7, 0x54, 0x6b, 0x44, 0x3f, 0x04, 0xfc,
	0x37, 0x21, 0x4b, 0xbd, 0xef, 0x39, 0xae, 0x45, 0xe7, 0x60, 0x82, 0x81, 0x03, 0x08, 0x58, 0x6d,
	0x03, 0x61, 0xc8, 0xb9, 0xc4, 0x73, 0x06, 0x2e, 0x83, 0x88, 0x14, 0x49, 0xf1, 0xfe, 0x54, 0x3b,
	0xe7, 0x30, 0xd4, 0xc0, 0x98, 0x82, 0x26, 0x31, 0xbb, 0xd3, 0xee, 0x28, 0x13, 0xfd, 0x32, 0x06,
	0x69, 0x8b, 0xf8, 0xd8, 0xc0, 0x3e, 0xce, 0x4f, 0xb2, 0x49, 0x6a, 0x5d, 0x76, 0x92, 0x1e, 0x09,
	0x3f, 0x7c, 0x9a, 0x16, 0x9f, 0xb3, 0x45, 0x51, 0xaa, 0xcb, 0x5f, 0xbd, 0x50, 0xd2, 0xf7, 0xee,
	0x57, 0xeb, 0x55, 0xa5, 0x56, 0x7b, 0xed, 0xe4, 0x84, 0xd9, 0x20, 0x1d, 0x72, 0xbb, 0x8e, 0xe3,
	0x6b, 0x86, 0xe9, 0x3d, 0xe3, 0xa3, 0x4f, 0x5e, 0x0c, 0xf5, 0xfb, 0x3e, 0xd6, 0xf7, 0x89, 0xb1,
	0x66, 0x7a, 0xcf, 0x46, 0x26, 0x60, 0x8a, 0x3a, 0x0d, 0x78, 0xc8, 0x85, 0x39, 0x8f, 0xe8, 0x8e,
	0x6d, 0x60, 0xf7, 0x68, 0x18, 0xc9, 0xcb, 0xa7, 0xd8, 0x54, 0x5c, 0x3a, 0x14, 0x2b, 0xf9, 0x7b,
	0xf7, 0x17, 0x54, 0x14, 0x7a, 0x0f, 0x64, 0x1e, 0x3a, 0x86, 0xeb, 0x36, 0xf1, 0x3f, 0x77, 0xdc,
	0x67, 0x9a, 0x69, 0xfb, 0xc4, 0xdd, 0xc3, 0x3a, 0x11, 0x61, 0xd3, 0x2c, 0xec, 0xdd, 0x73, 0x86,
	0xdd, 0xe0, 0x5e, 0xda, 0x81, 0x13, 0x16, 0x7a, 0xf2, 0xf9, 0x0b, 0x25, 0xa6, 0xa8, 0x57, 0xed,
	0x97, 0x08, 0xd9, 0x25, 0xd3, 0xa3, 0x99, 0x0e, 0x7a, 0x14, 0xc9, 0x8d, 0xdd, 0xd5, 0x96, 0xce,
	0x7d, 0x2e, 0x04, 0xf6, 0xc1, 0x6d, 0xca, 0x8b, 0x70, 0xfe, 0x0d, 0x3e, 0x87, 0xef, 0x1d, 0x9f,
	0x17, 0xee, 0xc2, 0xf4, 0x58, 0xd5, 0x5d, 0x08, 0xdc, 0xff, 0x25, 0x06, 0xd3, 0x63, 0x5b, 0x04,
	0xdd, 0x81, 0xa4, 0x45, 0x2c, 0xc7, 0x3d, 0x12, 0x67, 0x02, 0x3a, 0x3d, 0x51, 0x72, 0xf7, 0xee,
	0x57, 0x97, 0x6a, 0xcb, 0x4b, 0x4b, 0x2b, 0x95, 0xfa, 0x4a, 0xad, 0xa6, 0x0a, 0x0d, 0xf4, 0x21,
	0x4c, 0xea, 0x8e, 0x4b, 0x3c, 0x71, 0x1a, 0x28, 0xa7, 0x27, 0x4a, 0x49, 0x91, 0xab, 0x72, 0x4d,
	0xae, 0xcb, 0xcb, 0xb2, 0x52, 0x91, 0x95, 0xaa, 0xac, 0xd4, 0x64, 0xa5, 0x2e, 0x2b, 0xcb, 0x72,
	0xb5, 0x22, 0x57, 0xab, 0x72, 0xb5, 0x26, 0x57, 0xeb, 0x72, 0x75, 0x59, 0x5e, 0xa8, 0xc8, 0x0b,
	0x55, 0x95, 0xdb, 0xa3, 0x3a, 0x4c, 0xd3, 0x1f, 0xda, 0x9e, 0x8b, 0xf5, 0x10, 0xdd, 0x4c, 0x34,
	0x67, 0x4f, 0x4f, 0x94, 0xe9, 0x8a, 0xbc, 0x48, 0x6d, 0x17, 0x2b, 0x32, 0x3b, 0x09, 0xa8, 0xde,
	0x03, 0xa1, 0x86, 0x6e, 0x42, 0xa2, 0xdb, 0x1f, 0x78, 0x1c, 0x07, 0x37, 0xb3, 0xa7, 0x27, 0x4a,
	0xaa, 0x22, 0xb3, 0x0c, 0x54, 0x26, 0x28, 0xfe, 0x2e, 0x01, 0x52, 0xb4, 0x32, 0xd1, 0x63, 0x48,
	0x58, 0x8e, 0xc1, 0x0f, 0xbd, 0xdc, 0xf9, 0x1b, 0x7b, 0xc4, 0x4d, 0xf9, 0x91, 0x63, 0x10, 0xb1,
	0xa1, 0x98, 0x3f, 0x74, 0x97, 0x36, 0x66, 0xb6, 0xe2, 0xec, 0x51, 0x85, 0x4d, 0x76, 0xb3, 0xf0,
	0xed, 0x89, 0x72, 0xed, 0xc7, 0x91, 0x3d, 0xfe, 0x45, 0x45, 0x56, 0x56, 0xbe, 0x54, 0x81, 0xab,
	0x6f, 0x60, 0x8b, 0x20, 0x1d, 0x32, 0xc3, 0x5d, 0xce, 0xc1, 0xdd, 0x07, 0x97, 0xcd, 0x2c, 0xb2,
	0xdd, 0xd3, 0x86, 0xa0, 0x0b, 0xff, 0x88, 0x41, 0x3a, 0x9c, 0x86, 0x0b, 0x9d, 0x23, 0x37, 0x20,
	0x45, 0x21, 0x45, 0xf8, 0xfe, 0x14, 0x1c, 0x54, 0x94, 0xd9, 0x36, 0x50, 0x49, 0xc0, 0x12, 0xbe,
	0x6e, 0x6f, 0x9e, 0x9e, 0x28, 0x57, 0x6b, 0xca, 0x4a, 0x6d, 0xa1, 0x52, 0x2b, 0xd5, 0x16, 0x56,
	0x96, 0x2b, 0xb5, 0xfa, 0xa2, 0xa2, 0x28, 0x95, 0x1a, 0x87, 0x29, 0xe8, 0x36, 0xa4, 0x4d, 0x0b,
	0x77, 0x99, 0x3b, 0xf6, 0xf6, 0xd4, 0x4c, 0xf3, 0xa3, 0x63, 0xb1, 0xf2, 0xf0, 0x0d, 0x35, 0xc5,
	0x64, 0x6d, 0x83, 0x66, 0xe8, 0xd9, 0xb8, 0xef, 0xed, 0x3b, 0x6c, 0xf3, 0x4c, 0x9e, 0xd1, 0x84,
	0x40, 0xdc, 0x36, 0x9a, 0x39, 0x98, 0xe2, 0x75, 0xac, 0x39, 0x36, 0x71, 0xf6, 0x8a, 0x77, 0x21,
	0x41, 0x57, 0x08, 0xcd, 0x81, 0xf4, 0x68, 0x73, 0xad, 0xa5, 0xed, 0x6c, 0x6c, 0x6f, 0xb5, 0x56,
	0xdb, 0x0f, 0xda, 0xad, 0x35, 0xe9, 0x0d, 0x34, 0x0d, 0x19, 0xb5, 0xd5, 0x58, 0xd3, 0x36, 0x37,
	0xd6, 0x3f, 0x96, 0x62, 0x28, 0x07, 0xc0, 0xc8, 0x27, 0x6a, 0xbb, 0xd3, 0x92, 0xe2, 0xc5, 0xdf,
	0xc7, 0x61, 0xee, 0x65, 0xad, 0x05, 0xdd, 0x00, 0x08, 0x1b, 0x57, 0x70, 0xe7, 0xcd, 0x04, 0x7d,
	0xc6, 0xa0, 0x62, 0x6f, 0xb0, 0x6b, 0x13, 0x9a, 0x2f, 0x3f, 0x71, 0x33, 0x6a, 0x86, 0x73, 0xda,
	0x86, 0x87, 0xfa, 0x70, 0xbd, 0xef, 0x9a, 0x16, 0x6d, 0xb4, 0x07, 0x35, 0x0d, 0x1b, 0x86, 0x4b,
	0x3c, 0x6f, 0x74, 0xc9, 0x57, 0xce, 0xb9, 0xe4, 0x5b, 0xdc, 0x4b, 0x83, 0x7b, 0x60, 0x4f, 0x04,
	0x73, 0xc2, 0xf3, 0xe3, 0xda, 0x08, 0x77, 0x2c, 0x62, 0x7d, 0x3c, 0x62, 0xe2, 0x7b, 0x8b, 0x58,
	0x1f, 0xe1, 0x16, 0x8f, 0x01, 0x9d, 0xd5, 0x45, 0x06, 0x5c, 0xa1, 0x38, 0xc7, 0x77, 0xe8, 0xea,
	0x68, 0x36, 0xf6, 0x79, 0x0e, 0xfc, 0xca, 0x57, 0x3f, 0x67, 0x0e, 0x9b, 0x36, 0xe9, 0x38, 0x9b,
	0x36, 0xd9, 0xc0, 0x3e, 0x4b, 0x60, 0xc6, 0x19, 0x67, 0x14, 0x77, 0x61, 0x26, 0xa2, 0x83, 0x36,
	0x01, 0xcc, 0xbe, 0x76, 0x40, 0x5c, 0x2f, 0x28, 0xf2, 0x5c, 0xb5, 0x72, 0xde, 0xe3, 0xbd, 0xff,
	0x98, 0xdb, 0xa9, 0x19, 0x33, 0xf8, 0x59, 0xac, 0x81, 0x14, 0x6d, 0xff, 0xe8, 0x16, 0x64, 0xfb,
	0x2e, 0x21, 0x56, 0xdf, 0x37, 0x03, 0x34, 0x9d, 0x56, 0x47, 0x59, 0xc5, 0x03, 0x90, 0xa2, 0x6f,
	0x47, 0x68, 0x17, 0x66, 0xc7, 0x1e, 0x51, 0x2e, 0x31, 0x23, 0x9d, 0xe1, 0x6b, 0x0b, 0x9f, 0x11,
	0x7f, 0x9c, 0x51, 0xfc, 0x53, 0x1c, 0x66, 0x22, 0x4a, 0x68, 0x51, 0xbc, 0xfa, 0xf2, 0x1d, 0xff,
	0xdf, 0xdf, 0x9e, 0x28, 0x37, 0x82, 0x06, 0x85, 0x4b, 0xc7, 0x95, 0xd2, 0xca, 0x67, 0x5f, 0x28,
	0x72, 0x5d, 0xf9, 0xf2, 0xa9, 0xa0, 0xc4, 0xc3, 0x70, 0xa4, 0x5f, 0xc4, 0x5f, 0xd9, 0x2f, 0xbe,
	0x19, 0xe2, 0xce, 0x09, 0x76, 0xa0, 0x37, 0x2f, 0x37, 0xa2, 0xff, 0x08, 0xec, 0xfc, 0x2e, 0xcf,
	0x61, 0x3f, 0x89, 0x81, 0x14, 0x7d, 0x9e, 0x43, 0xd6, 0xf8, 0x9b, 0x9f, 0x40, 0x32, 0xfc, 0xe2,
	0x50, 0xbf, 0xf8, 0x9b, 0xdf, 0x10, 0x3f, 0xd1, 0x2b, 0xc3, 0xe8, 0xdb, 0x1f, 0x43, 0x30, 0xc5,
	0x9f, 0x4f, 0xc2, 0x4c, 0x44, 0x1d, 0x35, 0x21, 0xcd, 0x90, 0xd4, 0x01, 0xee, 0x89, 0x1a, 0x7a,
	0xc5, 0x65, 0x88, 0x9d, 0x94, 0x8a, 0x57, 0x5a, 0xa8, 0x54, 0x3c, 0x35, 0xb4, 0x43, 0xef, 0x43,
	0xca, 0x37, 0x2d, 0xe2, 0x0c, 0x7c, 0xf1, 0x54, 0xf2, 0xda, 0xfb, 0xba, 0x57, 0xaa, 0x57, 0x3c,
	0x35, 0xb0, 0x42, 0x6d, 0xb8, 0x32, 0xb0, 0x79, 0xba, 0x47, 0x9a, 0xbf, 0xef, 0x12, 0x6f, 0xdf,
	0xe9, 0x19, 0xe2, 0x54, 0xc8, 0x9f, 0x9e, 0x28, 0x73, 0x15, 0xb9, 0x2a, 0x2f, 0xc8, 0x35, 0x79,
	0x51, 0xae, 0xcb, 0x4b, 0xf2, 0xb2, 0xbc, 0x22, 0x2b, 0x15, 0x15, 0x85, 0x46, 0x9d, 0xc0, 0x06,
	0xb5, 0x60, 0xf6, 0xac, 0xa3, 0xc4, 0x6b, 0x1c, 0x49, 0x67, 0xdc, 0x18, 0x90, 0xf5, 0xf5, 0xbe,
	0xe6, 0xb0, 0xaa, 0xf4, 0xc4, 0x33, 0x44, 0xe3, 0x72, 0x4b, 0x52, 0xee, 0xe8, 0xfd, 0x4d, 0xee,
	0x88, 0x9e, 0x3d, 0x7e, 0x48, 0xa1, 0x2e, 0x4c, 0xed, 0xfb, 0xfe, 0x30, 0x0c, 0x47, 0xe9, 0xcd,
	0x4b, 0x86, 0x79, 0xe8, 0xfb, 0x23, 0x71, 0xb2, 0xfb, 0x43, 0xb2, 0x50, 0x02, 0x18, 0x26, 0x41,
	0xe1, 0x4f, 0xdf, 0x71, 0x7d, 0x81, 0xd4, 0xf8, 0xa2, 0x96, 0x16, 0xaa, 0x4b, 0xf5, 0x25, 0x95,
	0x09, 0x0a, 0x4d, 0xc8, 0x8e, 0x38, 0x7b, 0xad, 0x3e, 0x42, 0x90, 0xe8, 0x63, 0x7f, 0x5f, 0x54,
	0x3d, 0xfb, 0xdd, 0x7c, 0x1b, 0xe6, 0xc6, 0x6a, 0x5b, 0x8c, 0x51, 0x3c, 0x2e, 0xfc, 0x2c, 0x09,
	0x33, 0x91, 0x97, 0xdb, 0x33, 0x5f, 0xaf, 0x76, 0x20, 0xc9, 0x9f, 0x7b, 0x99, 0xdf, 0xdc, 0xb9,
	0x5f, 0xf8, 0x22, 0x7e, 0xcb, 0xfc, 0x4d, 0x55, 0x15, 0xce, 0xe8, 0xdd, 0x31, 0xfc, 0x58, 0x34,
	0xbc, 0x3b, 0x06, 0xac, 0xb6, 0x41, 0x47, 0xb3, 0xf7, 0x23, 0xc3, 0x0e, 0xbe, 0x6e, 0xd1, 0xdf,
	0xe1, 0x17, 0xaf, 0xc9, 0x91, 0x2f, 0x5e, 0x67, 0x1f, 0xa9, 0x93, 0x2f, 0x79, 0xa4, 0x46, 0xd7,
	0x87, 0x77, 0xf5, 0x14, 0x93, 0x8b, 0x5b, 0x3a, 0xda, 0x03, 0x74, 0xe6, 0x32, 0x13, 0xdc, 0x63,
	0x96, 0x2e, 0x79, 0x8f, 0x51, 0x67, 0xa3, 0x97, 0x17, 0x0f, 0x3d, 0x80, 0x59, 0x91, 0xa7, 0xbe,
	0x8f, 0xed, 0x2e, 0xff, 0xde, 0x97, 0x79, 0xed, 0xf7, 0xbe, 0x19, 0x6e, 0xb4, 0xca, 0x6d, 0x1a,
	0x7e, 0xf1, 0xcf, 0x71, 0x48, 0xf2, 0xb9, 0x44, 0xd7, 0x00, 0x6d, 0x77, 0x1a, 0x9d, 0x9d, 0xed,
	0x08, 0x3c, 0xba, 0x0a, 0xb3, 0xab, 0x6a, 0xab, 0xd1, 0x69, 0x6f, 0x7c, 0xa8, 0xb5, 0x37, 0xb6,
	0x3b, 0x8d, 0x8d, 0xd5, 0x96, 0x94, 0xa5, 0xec, 0x9d, 0xad, 0xb5, 0x08, 0x7b, 0x8a, 0xb2, 0xd7,
	0x5a, 0xeb, 0xad, 0x71, 0xf6, 0x34, 0x65, 0x6f, 0x77, 0x1a, 0xea, 0x38, 0x3b, 0xc7, 0xd9, 0x9b,
	0x5b, 0x5b, 0x63, 0xec, 0x19, 0x74, 0x03, 0xde, 0x6c, 0x3c, 0x69, 0xb4, 0x99, 0x36, 0x33, 0xdb,
	0xd9, 0xd2, 0xd6, 0x76, 0xd4, 0x46, 0xa7, 0xbd, 0xb9, 0x21, 0x49, 0xe8, 0x0a, 0xcc, 0xac, 0x3e,
	0x6c, 0xad, 0xfe, 0x80, 0x8a, 0x1f, 0xb6, 0x1a, 0xeb, 0x9d, 0x87, 0xd2, 0x2c, 0x65, 0x6e, 0x6e,
	0xb5, 0x36, 0x28, 0xaf, 0xa3, 0x36, 0x1e, 0x3c, 0x68, 0xaf, 0x4a, 0x08, 0xbd, 0x0d, 0xf9, 0xd0,
	0xd1, 0x93, 0x86, 0xfa, 0x68, 0xd4, 0xcf, 0x15, 0xe6, 0x67, 0x7d, 0x73, 0x7b, 0xd4, 0x64, 0x0e,
	0x21, 0xc8, 0xa9, 0x3b, 0x1b, 0xcc, 0x4f, 0x63, 0xb5, 0xb3, 0xd3, 0x58, 0x97, 0xae, 0x52, 0xdc,
	0x18, 0xf0, 0x36, 0x77, 0x3a, 0x6b, 0x8d, 0x4e, 0x6b, 0x4d, 0xba, 0x86, 0xb2, 0x90, 0x62, 0xc9,
	0xb7, 0xd6, 0xa4, 0xeb, 0x94, 0x60, 0xe3, 0x6e, 0xad, 0x49, 0xf9, 0xe2, 0x6f, 0xe2, 0x20, 0x45,
	0x57, 0x91, 0x9e, 0x23, 0x26, 0x5d, 0x7e, 0xb1, 0x1b, 0x38, 0x41, 0x2b, 0xd7, 0xc2, 0x7a, 0x80,
	0xc6, 0xc4, 0x6e, 0x03, 0x0b, 0xeb, 0x02, 0x31, 0xa1, 0xb7, 0x20, 0x13, 0xc2, 0x48, 0x51, 0xd8,
	0xe9, 0x00, 0x45, 0x22, 0x1d, 0xd0, 0x59, 0x10, 0x29, 0xd0, 0xdc, 0xe2, 0xa5, 0xd0, 0x9c, 0x2a,
	0x45, 0xb1, 0xe3, 0x58, 0x90, 0x10, 0x37, 0x8a, 0xf6, 0xf9, 0x5d, 0x83, 0x04, 0x70, 0xb1, 0xf8,
	0xd3, 0x18, 0xe4, 0xc6, 0x95, 0x50, 0x1e, 0x52, 0x41, 0x30, 0x3e, 0x65, 0x01, 0x89, 0x9e, 0x40,
	0x6e, 0x1c, 0x41, 0x8a, 0x33, 0xaa, 0x7a, 0x71, 0xf0, 0xa8, 0x66, 0x47, 0x80, 0x63, 0xf1, 0x10,
	0xb2, 0x23, 0xb2, 0x57, 0x64, 0x30, 0x0e, 0x25, 0xe3, 0xdf, 0x1d, 0x4a, 0x6a, 0x90, 0x59, 0x77,
	0xba, 0x2a, 0xd1, 0x1d, 0xd7, 0x40, 0xcb, 0x90, 0x09, 0xff, 0x71, 0x40, 0x9c, 0xe0, 0xaf, 0xfc,
	0x8a, 0x1f, 0x2a, 0xd3, 0x8c, 0xc7, 0xbf, 0xae, 0x05, 0xe4, 0x9d, 0xbb, 0x90, 0x09, 0x03, 0xa3,
	0x02, 0x5c, 0x6b, 0x6f, 0x69, 0x8f, 0x5b, 0xea, 0x76, 0x7b, 0x73, 0x23, 0xb2, 0xdf, 0xd3, 0x90,
	0x68, 0x6f, 0x3d, 0xae, 0x49, 0x31, 0xf1, 0xab, 0x2e, 0xc5, 0x9b, 0x1f, 0x7f, 0xf2, 0xa4, 0x6b,
	0xfa, 0xfb, 0x83, 0x5d, 0x3a, 0xaa, 0x79, 0x3e, 0xcc, 0x12, 0xff, 0x1f, 0x88, 0xae, 0x53, 0xea,
	0x12, 0x9b, 0x65, 0x35, 0x7f, 0xae, 0xff, 0xbf, 0xb8, 0x3b, 0x46, 0xed, 0x26, 0x99, 0xe9, 0xc2,
	0xbf, 0x02, 0x00, 0x00, 0xff, 0xff, 0x79, 0x5b, 0xd8, 0xa8, 0xbd, 0x21, 0x00, 0x00,
}
