// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/mdb/mongodb/v1/user_service.proto

package mongodb

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type GetUserRequest struct {
	// ID of the MongoDB cluster the user belongs to.
	// To get the cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the MongoDB User resource to return.
	// To get the name of the user, use a [UserService.List] request.
	UserName             string   `protobuf:"bytes,2,opt,name=user_name,json=userName,proto3" json:"user_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetUserRequest) Reset()         { *m = GetUserRequest{} }
func (m *GetUserRequest) String() string { return proto.CompactTextString(m) }
func (*GetUserRequest) ProtoMessage()    {}
func (*GetUserRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4731409bfcdabc65, []int{0}
}

func (m *GetUserRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetUserRequest.Unmarshal(m, b)
}
func (m *GetUserRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetUserRequest.Marshal(b, m, deterministic)
}
func (m *GetUserRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetUserRequest.Merge(m, src)
}
func (m *GetUserRequest) XXX_Size() int {
	return xxx_messageInfo_GetUserRequest.Size(m)
}
func (m *GetUserRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetUserRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetUserRequest proto.InternalMessageInfo

func (m *GetUserRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *GetUserRequest) GetUserName() string {
	if m != nil {
		return m.UserName
	}
	return ""
}

type ListUsersRequest struct {
	// ID of the cluster to list MongoDB users in.
	// To get the cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	PageSize  int64  `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListUsersResponse.next_page_token] returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListUsersRequest) Reset()         { *m = ListUsersRequest{} }
func (m *ListUsersRequest) String() string { return proto.CompactTextString(m) }
func (*ListUsersRequest) ProtoMessage()    {}
func (*ListUsersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4731409bfcdabc65, []int{1}
}

func (m *ListUsersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListUsersRequest.Unmarshal(m, b)
}
func (m *ListUsersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListUsersRequest.Marshal(b, m, deterministic)
}
func (m *ListUsersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListUsersRequest.Merge(m, src)
}
func (m *ListUsersRequest) XXX_Size() int {
	return xxx_messageInfo_ListUsersRequest.Size(m)
}
func (m *ListUsersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListUsersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListUsersRequest proto.InternalMessageInfo

func (m *ListUsersRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListUsersRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListUsersRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListUsersResponse struct {
	// List of MongoDB User resources.
	Users []*User `protobuf:"bytes,1,rep,name=users,proto3" json:"users,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListUsersRequest.page_size], use the [next_page_token] as the value
	// for the [ListUsersRequest.page_token] parameter in the next list request. Each subsequent
	// list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListUsersResponse) Reset()         { *m = ListUsersResponse{} }
func (m *ListUsersResponse) String() string { return proto.CompactTextString(m) }
func (*ListUsersResponse) ProtoMessage()    {}
func (*ListUsersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4731409bfcdabc65, []int{2}
}

func (m *ListUsersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListUsersResponse.Unmarshal(m, b)
}
func (m *ListUsersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListUsersResponse.Marshal(b, m, deterministic)
}
func (m *ListUsersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListUsersResponse.Merge(m, src)
}
func (m *ListUsersResponse) XXX_Size() int {
	return xxx_messageInfo_ListUsersResponse.Size(m)
}
func (m *ListUsersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListUsersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListUsersResponse proto.InternalMessageInfo

func (m *ListUsersResponse) GetUsers() []*User {
	if m != nil {
		return m.Users
	}
	return nil
}

func (m *ListUsersResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateUserRequest struct {
	// ID of the MongoDB cluster to create a user in.
	// To get the cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Properties of the user to be created.
	UserSpec             *UserSpec `protobuf:"bytes,2,opt,name=user_spec,json=userSpec,proto3" json:"user_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *CreateUserRequest) Reset()         { *m = CreateUserRequest{} }
func (m *CreateUserRequest) String() string { return proto.CompactTextString(m) }
func (*CreateUserRequest) ProtoMessage()    {}
func (*CreateUserRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4731409bfcdabc65, []int{3}
}

func (m *CreateUserRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateUserRequest.Unmarshal(m, b)
}
func (m *CreateUserRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateUserRequest.Marshal(b, m, deterministic)
}
func (m *CreateUserRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateUserRequest.Merge(m, src)
}
func (m *CreateUserRequest) XXX_Size() int {
	return xxx_messageInfo_CreateUserRequest.Size(m)
}
func (m *CreateUserRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateUserRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateUserRequest proto.InternalMessageInfo

func (m *CreateUserRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CreateUserRequest) GetUserSpec() *UserSpec {
	if m != nil {
		return m.UserSpec
	}
	return nil
}

type CreateUserMetadata struct {
	// ID of the MongoDB cluster the user is being created in.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the user that is being created.
	UserName             string   `protobuf:"bytes,2,opt,name=user_name,json=userName,proto3" json:"user_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateUserMetadata) Reset()         { *m = CreateUserMetadata{} }
func (m *CreateUserMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateUserMetadata) ProtoMessage()    {}
func (*CreateUserMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4731409bfcdabc65, []int{4}
}

func (m *CreateUserMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateUserMetadata.Unmarshal(m, b)
}
func (m *CreateUserMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateUserMetadata.Marshal(b, m, deterministic)
}
func (m *CreateUserMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateUserMetadata.Merge(m, src)
}
func (m *CreateUserMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateUserMetadata.Size(m)
}
func (m *CreateUserMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateUserMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateUserMetadata proto.InternalMessageInfo

func (m *CreateUserMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CreateUserMetadata) GetUserName() string {
	if m != nil {
		return m.UserName
	}
	return ""
}

type UpdateUserRequest struct {
	// ID of the MongoDB cluster the user belongs to.
	// To get the cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the user to be updated.
	// To get the name of the user, use a [UserService.List] request.
	UserName string `protobuf:"bytes,2,opt,name=user_name,json=userName,proto3" json:"user_name,omitempty"`
	// Field mask that specifies which fields of the MongoDB User resource should be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// New password for the user.
	Password string `protobuf:"bytes,4,opt,name=password,proto3" json:"password,omitempty"`
	// New set of permissions for the user.
	Permissions          []*Permission `protobuf:"bytes,5,rep,name=permissions,proto3" json:"permissions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *UpdateUserRequest) Reset()         { *m = UpdateUserRequest{} }
func (m *UpdateUserRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateUserRequest) ProtoMessage()    {}
func (*UpdateUserRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4731409bfcdabc65, []int{5}
}

func (m *UpdateUserRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateUserRequest.Unmarshal(m, b)
}
func (m *UpdateUserRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateUserRequest.Marshal(b, m, deterministic)
}
func (m *UpdateUserRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateUserRequest.Merge(m, src)
}
func (m *UpdateUserRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateUserRequest.Size(m)
}
func (m *UpdateUserRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateUserRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateUserRequest proto.InternalMessageInfo

func (m *UpdateUserRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *UpdateUserRequest) GetUserName() string {
	if m != nil {
		return m.UserName
	}
	return ""
}

func (m *UpdateUserRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateUserRequest) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

func (m *UpdateUserRequest) GetPermissions() []*Permission {
	if m != nil {
		return m.Permissions
	}
	return nil
}

type UpdateUserMetadata struct {
	// ID of the MongoDB cluster the user belongs to.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the user that is being updated.
	UserName             string   `protobuf:"bytes,2,opt,name=user_name,json=userName,proto3" json:"user_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateUserMetadata) Reset()         { *m = UpdateUserMetadata{} }
func (m *UpdateUserMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateUserMetadata) ProtoMessage()    {}
func (*UpdateUserMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4731409bfcdabc65, []int{6}
}

func (m *UpdateUserMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateUserMetadata.Unmarshal(m, b)
}
func (m *UpdateUserMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateUserMetadata.Marshal(b, m, deterministic)
}
func (m *UpdateUserMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateUserMetadata.Merge(m, src)
}
func (m *UpdateUserMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateUserMetadata.Size(m)
}
func (m *UpdateUserMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateUserMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateUserMetadata proto.InternalMessageInfo

func (m *UpdateUserMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *UpdateUserMetadata) GetUserName() string {
	if m != nil {
		return m.UserName
	}
	return ""
}

type DeleteUserRequest struct {
	// ID of the MongoDB cluster the user belongs to.
	// To get the cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the user to delete.
	// To get the name of the user use a [UserService.List] request.
	UserName             string   `protobuf:"bytes,2,opt,name=user_name,json=userName,proto3" json:"user_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteUserRequest) Reset()         { *m = DeleteUserRequest{} }
func (m *DeleteUserRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteUserRequest) ProtoMessage()    {}
func (*DeleteUserRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4731409bfcdabc65, []int{7}
}

func (m *DeleteUserRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteUserRequest.Unmarshal(m, b)
}
func (m *DeleteUserRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteUserRequest.Marshal(b, m, deterministic)
}
func (m *DeleteUserRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteUserRequest.Merge(m, src)
}
func (m *DeleteUserRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteUserRequest.Size(m)
}
func (m *DeleteUserRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteUserRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteUserRequest proto.InternalMessageInfo

func (m *DeleteUserRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *DeleteUserRequest) GetUserName() string {
	if m != nil {
		return m.UserName
	}
	return ""
}

type DeleteUserMetadata struct {
	// ID of the MongoDB cluster the user belongs to.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the user that is being deleted.
	UserName             string   `protobuf:"bytes,2,opt,name=user_name,json=userName,proto3" json:"user_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteUserMetadata) Reset()         { *m = DeleteUserMetadata{} }
func (m *DeleteUserMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteUserMetadata) ProtoMessage()    {}
func (*DeleteUserMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4731409bfcdabc65, []int{8}
}

func (m *DeleteUserMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteUserMetadata.Unmarshal(m, b)
}
func (m *DeleteUserMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteUserMetadata.Marshal(b, m, deterministic)
}
func (m *DeleteUserMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteUserMetadata.Merge(m, src)
}
func (m *DeleteUserMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteUserMetadata.Size(m)
}
func (m *DeleteUserMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteUserMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteUserMetadata proto.InternalMessageInfo

func (m *DeleteUserMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *DeleteUserMetadata) GetUserName() string {
	if m != nil {
		return m.UserName
	}
	return ""
}

type GrantUserPermissionRequest struct {
	// ID of the MongoDB cluster the user belongs to.
	// To get the cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the user to grant the permission to.
	// To get the name of the user, use a [UserService.List] request.
	UserName string `protobuf:"bytes,2,opt,name=user_name,json=userName,proto3" json:"user_name,omitempty"`
	// Permission that should be granted to the specified user.
	Permission           *Permission `protobuf:"bytes,3,opt,name=permission,proto3" json:"permission,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *GrantUserPermissionRequest) Reset()         { *m = GrantUserPermissionRequest{} }
func (m *GrantUserPermissionRequest) String() string { return proto.CompactTextString(m) }
func (*GrantUserPermissionRequest) ProtoMessage()    {}
func (*GrantUserPermissionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4731409bfcdabc65, []int{9}
}

func (m *GrantUserPermissionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GrantUserPermissionRequest.Unmarshal(m, b)
}
func (m *GrantUserPermissionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GrantUserPermissionRequest.Marshal(b, m, deterministic)
}
func (m *GrantUserPermissionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GrantUserPermissionRequest.Merge(m, src)
}
func (m *GrantUserPermissionRequest) XXX_Size() int {
	return xxx_messageInfo_GrantUserPermissionRequest.Size(m)
}
func (m *GrantUserPermissionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GrantUserPermissionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GrantUserPermissionRequest proto.InternalMessageInfo

func (m *GrantUserPermissionRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *GrantUserPermissionRequest) GetUserName() string {
	if m != nil {
		return m.UserName
	}
	return ""
}

func (m *GrantUserPermissionRequest) GetPermission() *Permission {
	if m != nil {
		return m.Permission
	}
	return nil
}

type GrantUserPermissionMetadata struct {
	// ID of the MongoDB cluster the user belongs to.
	// To get the cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the user that is being granted a permission.
	UserName             string   `protobuf:"bytes,2,opt,name=user_name,json=userName,proto3" json:"user_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GrantUserPermissionMetadata) Reset()         { *m = GrantUserPermissionMetadata{} }
func (m *GrantUserPermissionMetadata) String() string { return proto.CompactTextString(m) }
func (*GrantUserPermissionMetadata) ProtoMessage()    {}
func (*GrantUserPermissionMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4731409bfcdabc65, []int{10}
}

func (m *GrantUserPermissionMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GrantUserPermissionMetadata.Unmarshal(m, b)
}
func (m *GrantUserPermissionMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GrantUserPermissionMetadata.Marshal(b, m, deterministic)
}
func (m *GrantUserPermissionMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GrantUserPermissionMetadata.Merge(m, src)
}
func (m *GrantUserPermissionMetadata) XXX_Size() int {
	return xxx_messageInfo_GrantUserPermissionMetadata.Size(m)
}
func (m *GrantUserPermissionMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_GrantUserPermissionMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_GrantUserPermissionMetadata proto.InternalMessageInfo

func (m *GrantUserPermissionMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *GrantUserPermissionMetadata) GetUserName() string {
	if m != nil {
		return m.UserName
	}
	return ""
}

type RevokeUserPermissionRequest struct {
	// ID of the MongoDB cluster the user belongs to.
	// To get the cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the user to revoke a permission from.
	// To get the name of the user, use a [UserService.List] request.
	UserName string `protobuf:"bytes,2,opt,name=user_name,json=userName,proto3" json:"user_name,omitempty"`
	// Name of the database that the user should lose access to.
	DatabaseName         string   `protobuf:"bytes,3,opt,name=database_name,json=databaseName,proto3" json:"database_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RevokeUserPermissionRequest) Reset()         { *m = RevokeUserPermissionRequest{} }
func (m *RevokeUserPermissionRequest) String() string { return proto.CompactTextString(m) }
func (*RevokeUserPermissionRequest) ProtoMessage()    {}
func (*RevokeUserPermissionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4731409bfcdabc65, []int{11}
}

func (m *RevokeUserPermissionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RevokeUserPermissionRequest.Unmarshal(m, b)
}
func (m *RevokeUserPermissionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RevokeUserPermissionRequest.Marshal(b, m, deterministic)
}
func (m *RevokeUserPermissionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RevokeUserPermissionRequest.Merge(m, src)
}
func (m *RevokeUserPermissionRequest) XXX_Size() int {
	return xxx_messageInfo_RevokeUserPermissionRequest.Size(m)
}
func (m *RevokeUserPermissionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RevokeUserPermissionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RevokeUserPermissionRequest proto.InternalMessageInfo

func (m *RevokeUserPermissionRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *RevokeUserPermissionRequest) GetUserName() string {
	if m != nil {
		return m.UserName
	}
	return ""
}

func (m *RevokeUserPermissionRequest) GetDatabaseName() string {
	if m != nil {
		return m.DatabaseName
	}
	return ""
}

type RevokeUserPermissionMetadata struct {
	// ID of the MongoDB cluster the user belongs to.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the user whose permission is being revoked.
	UserName             string   `protobuf:"bytes,2,opt,name=user_name,json=userName,proto3" json:"user_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RevokeUserPermissionMetadata) Reset()         { *m = RevokeUserPermissionMetadata{} }
func (m *RevokeUserPermissionMetadata) String() string { return proto.CompactTextString(m) }
func (*RevokeUserPermissionMetadata) ProtoMessage()    {}
func (*RevokeUserPermissionMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4731409bfcdabc65, []int{12}
}

func (m *RevokeUserPermissionMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RevokeUserPermissionMetadata.Unmarshal(m, b)
}
func (m *RevokeUserPermissionMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RevokeUserPermissionMetadata.Marshal(b, m, deterministic)
}
func (m *RevokeUserPermissionMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RevokeUserPermissionMetadata.Merge(m, src)
}
func (m *RevokeUserPermissionMetadata) XXX_Size() int {
	return xxx_messageInfo_RevokeUserPermissionMetadata.Size(m)
}
func (m *RevokeUserPermissionMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_RevokeUserPermissionMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_RevokeUserPermissionMetadata proto.InternalMessageInfo

func (m *RevokeUserPermissionMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *RevokeUserPermissionMetadata) GetUserName() string {
	if m != nil {
		return m.UserName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetUserRequest)(nil), "yandex.cloud.mdb.mongodb.v1.GetUserRequest")
	proto.RegisterType((*ListUsersRequest)(nil), "yandex.cloud.mdb.mongodb.v1.ListUsersRequest")
	proto.RegisterType((*ListUsersResponse)(nil), "yandex.cloud.mdb.mongodb.v1.ListUsersResponse")
	proto.RegisterType((*CreateUserRequest)(nil), "yandex.cloud.mdb.mongodb.v1.CreateUserRequest")
	proto.RegisterType((*CreateUserMetadata)(nil), "yandex.cloud.mdb.mongodb.v1.CreateUserMetadata")
	proto.RegisterType((*UpdateUserRequest)(nil), "yandex.cloud.mdb.mongodb.v1.UpdateUserRequest")
	proto.RegisterType((*UpdateUserMetadata)(nil), "yandex.cloud.mdb.mongodb.v1.UpdateUserMetadata")
	proto.RegisterType((*DeleteUserRequest)(nil), "yandex.cloud.mdb.mongodb.v1.DeleteUserRequest")
	proto.RegisterType((*DeleteUserMetadata)(nil), "yandex.cloud.mdb.mongodb.v1.DeleteUserMetadata")
	proto.RegisterType((*GrantUserPermissionRequest)(nil), "yandex.cloud.mdb.mongodb.v1.GrantUserPermissionRequest")
	proto.RegisterType((*GrantUserPermissionMetadata)(nil), "yandex.cloud.mdb.mongodb.v1.GrantUserPermissionMetadata")
	proto.RegisterType((*RevokeUserPermissionRequest)(nil), "yandex.cloud.mdb.mongodb.v1.RevokeUserPermissionRequest")
	proto.RegisterType((*RevokeUserPermissionMetadata)(nil), "yandex.cloud.mdb.mongodb.v1.RevokeUserPermissionMetadata")
}

func init() {
	proto.RegisterFile("yandex/cloud/mdb/mongodb/v1/user_service.proto", fileDescriptor_4731409bfcdabc65)
}

var fileDescriptor_4731409bfcdabc65 = []byte{
	// 985 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x57, 0x4d, 0x6f, 0x1b, 0x45,
	0x18, 0xd6, 0x24, 0x8e, 0x15, 0xbf, 0x6e, 0xda, 0x66, 0x24, 0x24, 0xcb, 0x69, 0x50, 0x58, 0x68,
	0x1b, 0x39, 0xf2, 0xae, 0xd7, 0x05, 0x12, 0x92, 0x46, 0x02, 0x07, 0x88, 0x22, 0x1a, 0x08, 0x5b,
	0x2a, 0x41, 0x10, 0xb2, 0xc6, 0xde, 0xe9, 0xb2, 0x8a, 0xf7, 0x83, 0x9d, 0xb5, 0x69, 0x52, 0x22,
	0x24, 0xc4, 0xa9, 0x47, 0xb8, 0x71, 0xe0, 0x0f, 0x70, 0x8b, 0xc4, 0x0f, 0xe0, 0x94, 0x4a, 0x1c,
	0x90, 0x02, 0x3f, 0x81, 0x03, 0x07, 0x0e, 0x88, 0x23, 0x5c, 0xd0, 0xcc, 0x6c, 0xb2, 0xeb, 0x0f,
	0xd6, 0x6e, 0x1d, 0x35, 0xb7, 0xb1, 0xdf, 0x67, 0xe6, 0x7d, 0x9e, 0xf7, 0xd3, 0x06, 0x75, 0x9f,
	0xb8, 0x26, 0x7d, 0xa0, 0x35, 0x5b, 0x5e, 0xdb, 0xd4, 0x1c, 0xb3, 0xa1, 0x39, 0x9e, 0x6b, 0x79,
	0x66, 0x43, 0xeb, 0xe8, 0x5a, 0x9b, 0xd1, 0xa0, 0xce, 0x68, 0xd0, 0xb1, 0x9b, 0x54, 0xf5, 0x03,
	0x2f, 0xf4, 0xf0, 0x9c, 0xc4, 0xab, 0x02, 0xaf, 0x3a, 0x66, 0x43, 0x8d, 0xf0, 0x6a, 0x47, 0x2f,
	0x5e, 0xb3, 0x3c, 0xcf, 0x6a, 0x51, 0x8d, 0xf8, 0xb6, 0x46, 0x5c, 0xd7, 0x0b, 0x49, 0x68, 0x7b,
	0x2e, 0x93, 0x57, 0x8b, 0x0b, 0x91, 0x55, 0x7c, 0x6a, 0xb4, 0xef, 0x6b, 0xf7, 0x6d, 0xda, 0x32,
	0xeb, 0x0e, 0x61, 0x7b, 0x11, 0x62, 0xbe, 0x8b, 0x4c, 0x87, 0xb4, 0x6c, 0x53, 0xbc, 0x10, 0x99,
	0x6f, 0x74, 0x99, 0x3d, 0x9f, 0x06, 0xc2, 0x1a, 0x9f, 0x06, 0xe2, 0x06, 0x68, 0x3a, 0x25, 0xd4,
	0x85, 0xe3, 0xa4, 0x7b, 0x5e, 0x52, 0xf6, 0xe1, 0xf2, 0x26, 0x0d, 0xef, 0x31, 0x1a, 0x18, 0xf4,
	0xb3, 0x36, 0x65, 0x21, 0x5e, 0x02, 0x68, 0xb6, 0xda, 0x2c, 0xa4, 0x41, 0xdd, 0x36, 0x0b, 0x68,
	0x01, 0x2d, 0xe6, 0x6a, 0x97, 0xfe, 0x38, 0xd6, 0xd1, 0xa3, 0xc7, 0x7a, 0xe6, 0xf6, 0xfa, 0x2b,
	0x15, 0x23, 0x17, 0xd9, 0xb7, 0x4c, 0xbc, 0x0a, 0x39, 0x11, 0x42, 0x97, 0x38, 0xb4, 0x30, 0x21,
	0xb0, 0xf3, 0x1c, 0xfb, 0xf7, 0xb1, 0x3e, 0xf3, 0x31, 0x29, 0x1f, 0xbc, 0x51, 0xde, 0xad, 0x94,
	0x5f, 0xab, 0x7f, 0x52, 0x92, 0x97, 0x5f, 0xbd, 0x65, 0x4c, 0x73, 0xfc, 0xbb, 0xc4, 0xa1, 0xca,
	0x37, 0x08, 0xae, 0xde, 0xb1, 0x99, 0x70, 0xce, 0x9e, 0xca, 0xfb, 0x4d, 0xc8, 0xf9, 0xc4, 0xa2,
	0x75, 0x66, 0x1f, 0x48, 0xef, 0x93, 0x35, 0xf8, 0xe7, 0x58, 0xcf, 0xde, 0x5e, 0xd7, 0x2b, 0x95,
	0x8a, 0x31, 0xcd, 0x8d, 0x77, 0xed, 0x03, 0x8a, 0x17, 0x01, 0x04, 0x30, 0xf4, 0xf6, 0xa8, 0x5b,
	0x98, 0x14, 0xaf, 0xe6, 0x1e, 0x3d, 0xd6, 0xa7, 0x04, 0xd2, 0x10, 0xaf, 0x7c, 0xc0, 0x6d, 0x4a,
	0x08, 0xb3, 0x09, 0x4e, 0xcc, 0xf7, 0x5c, 0x46, 0xf1, 0x32, 0x4c, 0x71, 0xd6, 0xac, 0x80, 0x16,
	0x26, 0x17, 0xf3, 0xd5, 0x17, 0xd4, 0x94, 0x12, 0x51, 0x45, 0x2c, 0x25, 0x1e, 0xdf, 0x80, 0x2b,
	0x2e, 0x7d, 0x10, 0xd6, 0x13, 0xce, 0x45, 0x90, 0x8c, 0x19, 0xfe, 0xf5, 0xce, 0x99, 0xd7, 0xaf,
	0x11, 0xcc, 0x6e, 0x04, 0x94, 0x84, 0xf4, 0xa9, 0x33, 0x51, 0x8b, 0x32, 0xc1, 0x7c, 0xda, 0x14,
	0x4e, 0xf2, 0xd5, 0xeb, 0x43, 0x79, 0xde, 0xf5, 0x69, 0x53, 0x66, 0x84, 0x9f, 0x94, 0x1d, 0xc0,
	0x31, 0x8b, 0x6d, 0x1a, 0x12, 0x93, 0x84, 0x04, 0xcf, 0xf7, 0xd3, 0x48, 0x3a, 0x9e, 0xeb, 0x2b,
	0x81, 0x44, 0x8e, 0x7f, 0x98, 0x80, 0xd9, 0x7b, 0xbe, 0x39, 0x8e, 0xb0, 0x31, 0x4a, 0x0c, 0xaf,
	0x41, 0xbe, 0x2d, 0xbc, 0x8b, 0x1e, 0x14, 0x89, 0xcf, 0x57, 0x8b, 0xaa, 0x6c, 0x53, 0xf5, 0xb4,
	0x4d, 0xd5, 0xb7, 0x79, 0x9b, 0x6e, 0x13, 0xb6, 0x67, 0x80, 0x84, 0xf3, 0x33, 0xbe, 0x0e, 0xd3,
	0x3e, 0x61, 0xec, 0x73, 0x2f, 0x30, 0x0b, 0x99, 0xb8, 0x64, 0x56, 0xca, 0x7a, 0x75, 0xc5, 0x38,
	0x33, 0xe1, 0x2d, 0xc8, 0xfb, 0x34, 0x70, 0x6c, 0xc6, 0xf8, 0x24, 0x28, 0x4c, 0x89, 0x12, 0xb9,
	0x99, 0x1a, 0xfa, 0x9d, 0x33, 0xbc, 0x91, 0xbc, 0xcb, 0xe3, 0x1f, 0x07, 0xeb, 0x5c, 0xe2, 0xff,
	0x05, 0xcc, 0xbe, 0x49, 0x5b, 0xf4, 0x62, 0xc2, 0xcf, 0xf5, 0xc4, 0xde, 0xcf, 0x45, 0xcf, 0x6f,
	0x08, 0x8a, 0x9b, 0x01, 0x71, 0x45, 0x83, 0x26, 0xc2, 0xf8, 0xac, 0x0b, 0x6b, 0x1b, 0x20, 0x4e,
	0x5c, 0x54, 0x57, 0xa3, 0xe6, 0xbc, 0x96, 0xe1, 0x5e, 0x8c, 0xc4, 0x03, 0xca, 0x47, 0x30, 0x37,
	0x40, 0xd5, 0xb9, 0x44, 0xec, 0x67, 0x04, 0x73, 0x06, 0xed, 0x78, 0x7b, 0xf4, 0x82, 0x43, 0xb6,
	0x01, 0x33, 0x5c, 0x4c, 0x83, 0x30, 0x2a, 0xef, 0xcb, 0x31, 0xfc, 0x7c, 0x74, 0xff, 0x72, 0xe2,
	0x7e, 0x39, 0xf1, 0xc0, 0xa5, 0xd3, 0x4b, 0x42, 0xcd, 0x2e, 0x5c, 0x1b, 0x24, 0xe6, 0x3c, 0x22,
	0x55, 0xfd, 0x17, 0x20, 0x2f, 0x86, 0xa2, 0xfc, 0x39, 0x80, 0xbf, 0x43, 0x30, 0xb9, 0x49, 0x43,
	0xbc, 0x94, 0x9a, 0xd7, 0xee, 0xed, 0x59, 0x1c, 0xbe, 0x1b, 0x94, 0x8d, 0xaf, 0x7e, 0xfd, 0xfd,
	0xdb, 0x89, 0x75, 0xbc, 0xa6, 0x39, 0xc4, 0x25, 0x16, 0x35, 0xcb, 0x89, 0xe5, 0x1d, 0x71, 0x65,
	0xda, 0xc3, 0x58, 0xc7, 0xa1, 0x58, 0xe9, 0x4c, 0x7b, 0x78, 0xc6, 0xfd, 0x10, 0x7f, 0x8f, 0x20,
	0xc3, 0x17, 0x15, 0x2e, 0xa7, 0x3a, 0xec, 0xdd, 0xaf, 0x45, 0x75, 0x54, 0xb8, 0x5c, 0x7d, 0xca,
	0xb2, 0x20, 0xab, 0x63, 0xed, 0x09, 0xc9, 0xe2, 0x1f, 0x11, 0x64, 0xe5, 0x32, 0xc1, 0xe9, 0x3e,
	0xfb, 0xf6, 0x5e, 0x6f, 0x0c, 0xe3, 0x9f, 0x2c, 0xef, 0x9d, 0x9e, 0x94, 0x0f, 0x8f, 0x4e, 0x4a,
	0xc5, 0x81, 0xdb, 0x2a, 0xc3, 0x3f, 0x09, 0xd2, 0x2f, 0x2b, 0x4f, 0x4a, 0x7a, 0x15, 0x95, 0xf0,
	0x4f, 0x08, 0xb2, 0x72, 0x08, 0x0f, 0xe1, 0xdd, 0xb7, 0xd6, 0x46, 0xe1, 0x6d, 0x4a, 0xde, 0x03,
	0xa6, 0x7c, 0xcc, 0xfb, 0xf5, 0xea, 0x38, 0x95, 0xc1, 0x35, 0xfc, 0x82, 0x20, 0x2b, 0x07, 0xef,
	0x10, 0x0d, 0x7d, 0xbb, 0x61, 0x14, 0x0d, 0xc1, 0xd1, 0x49, 0x69, 0x69, 0xe0, 0x64, 0x7f, 0xae,
	0x77, 0xb1, 0xbe, 0xe5, 0xf8, 0xe1, 0xbe, 0x2c, 0xf7, 0xd2, 0x58, 0xe5, 0xfe, 0x27, 0x82, 0x2b,
	0x62, 0x42, 0xc6, 0x3d, 0x8f, 0x97, 0xd3, 0xfb, 0xf2, 0x7f, 0xb7, 0xc4, 0x28, 0x1a, 0x0f, 0x8f,
	0x4e, 0x4a, 0x2f, 0xa6, 0x0f, 0xe5, 0x38, 0x61, 0x3b, 0xca, 0x3b, 0xe3, 0x24, 0xcc, 0xea, 0xd6,
	0xc5, 0x13, 0xf8, 0x17, 0x82, 0xab, 0x72, 0xce, 0x25, 0xf4, 0xae, 0xa4, 0xea, 0x4d, 0x99, 0xf1,
	0xa3, 0x08, 0xfe, 0xf2, 0xe8, 0xa4, 0xf4, 0xd2, 0x90, 0xe1, 0x1a, 0x2b, 0x7e, 0x5f, 0xb9, 0x33,
	0x8e, 0xe2, 0xa0, 0x47, 0xda, 0x2a, 0x2a, 0xd5, 0xb6, 0x76, 0x37, 0x2d, 0x3b, 0xfc, 0xb4, 0xdd,
	0x50, 0x9b, 0x9e, 0xa3, 0x49, 0xbe, 0x65, 0xf9, 0xbf, 0xc5, 0xf2, 0xca, 0x16, 0x75, 0x45, 0x51,
	0x69, 0x29, 0x7f, 0x7c, 0xd6, 0xa2, 0x63, 0x23, 0x2b, 0xa0, 0xb7, 0xfe, 0x0b, 0x00, 0x00, 0xff,
	0xff, 0x8f, 0x4f, 0xf2, 0x8a, 0xfa, 0x0d, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// UserServiceClient is the client API for UserService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type UserServiceClient interface {
	// Returns the specified MongoDB User resource.
	//
	// To get the list of available MongoDB User resources, make a [List] request.
	Get(ctx context.Context, in *GetUserRequest, opts ...grpc.CallOption) (*User, error)
	// Retrieves the list of MongoDB User resources in the specified cluster.
	List(ctx context.Context, in *ListUsersRequest, opts ...grpc.CallOption) (*ListUsersResponse, error)
	// Creates a MongoDB user in the specified cluster.
	Create(ctx context.Context, in *CreateUserRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified MongoDB user.
	Update(ctx context.Context, in *UpdateUserRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified MongoDB user.
	Delete(ctx context.Context, in *DeleteUserRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Grants permission to the specified MongoDB user.
	GrantPermission(ctx context.Context, in *GrantUserPermissionRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Revokes permission from the specified MongoDB user.
	RevokePermission(ctx context.Context, in *RevokeUserPermissionRequest, opts ...grpc.CallOption) (*operation.Operation, error)
}

type userServiceClient struct {
	cc *grpc.ClientConn
}

func NewUserServiceClient(cc *grpc.ClientConn) UserServiceClient {
	return &userServiceClient{cc}
}

func (c *userServiceClient) Get(ctx context.Context, in *GetUserRequest, opts ...grpc.CallOption) (*User, error) {
	out := new(User)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mongodb.v1.UserService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userServiceClient) List(ctx context.Context, in *ListUsersRequest, opts ...grpc.CallOption) (*ListUsersResponse, error) {
	out := new(ListUsersResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mongodb.v1.UserService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userServiceClient) Create(ctx context.Context, in *CreateUserRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mongodb.v1.UserService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userServiceClient) Update(ctx context.Context, in *UpdateUserRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mongodb.v1.UserService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userServiceClient) Delete(ctx context.Context, in *DeleteUserRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mongodb.v1.UserService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userServiceClient) GrantPermission(ctx context.Context, in *GrantUserPermissionRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mongodb.v1.UserService/GrantPermission", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userServiceClient) RevokePermission(ctx context.Context, in *RevokeUserPermissionRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.mongodb.v1.UserService/RevokePermission", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// UserServiceServer is the server API for UserService service.
type UserServiceServer interface {
	// Returns the specified MongoDB User resource.
	//
	// To get the list of available MongoDB User resources, make a [List] request.
	Get(context.Context, *GetUserRequest) (*User, error)
	// Retrieves the list of MongoDB User resources in the specified cluster.
	List(context.Context, *ListUsersRequest) (*ListUsersResponse, error)
	// Creates a MongoDB user in the specified cluster.
	Create(context.Context, *CreateUserRequest) (*operation.Operation, error)
	// Updates the specified MongoDB user.
	Update(context.Context, *UpdateUserRequest) (*operation.Operation, error)
	// Deletes the specified MongoDB user.
	Delete(context.Context, *DeleteUserRequest) (*operation.Operation, error)
	// Grants permission to the specified MongoDB user.
	GrantPermission(context.Context, *GrantUserPermissionRequest) (*operation.Operation, error)
	// Revokes permission from the specified MongoDB user.
	RevokePermission(context.Context, *RevokeUserPermissionRequest) (*operation.Operation, error)
}

// UnimplementedUserServiceServer can be embedded to have forward compatible implementations.
type UnimplementedUserServiceServer struct {
}

func (*UnimplementedUserServiceServer) Get(ctx context.Context, req *GetUserRequest) (*User, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedUserServiceServer) List(ctx context.Context, req *ListUsersRequest) (*ListUsersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedUserServiceServer) Create(ctx context.Context, req *CreateUserRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (*UnimplementedUserServiceServer) Update(ctx context.Context, req *UpdateUserRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (*UnimplementedUserServiceServer) Delete(ctx context.Context, req *DeleteUserRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedUserServiceServer) GrantPermission(ctx context.Context, req *GrantUserPermissionRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GrantPermission not implemented")
}
func (*UnimplementedUserServiceServer) RevokePermission(ctx context.Context, req *RevokeUserPermissionRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RevokePermission not implemented")
}

func RegisterUserServiceServer(s *grpc.Server, srv UserServiceServer) {
	s.RegisterService(&_UserService_serviceDesc, srv)
}

func _UserService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetUserRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mongodb.v1.UserService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServiceServer).Get(ctx, req.(*GetUserRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListUsersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mongodb.v1.UserService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServiceServer).List(ctx, req.(*ListUsersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateUserRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mongodb.v1.UserService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServiceServer).Create(ctx, req.(*CreateUserRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateUserRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mongodb.v1.UserService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServiceServer).Update(ctx, req.(*UpdateUserRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteUserRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mongodb.v1.UserService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServiceServer).Delete(ctx, req.(*DeleteUserRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserService_GrantPermission_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GrantUserPermissionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServiceServer).GrantPermission(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mongodb.v1.UserService/GrantPermission",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServiceServer).GrantPermission(ctx, req.(*GrantUserPermissionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserService_RevokePermission_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RevokeUserPermissionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServiceServer).RevokePermission(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.mongodb.v1.UserService/RevokePermission",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServiceServer).RevokePermission(ctx, req.(*RevokeUserPermissionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _UserService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.mdb.mongodb.v1.UserService",
	HandlerType: (*UserServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _UserService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _UserService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _UserService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _UserService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _UserService_Delete_Handler,
		},
		{
			MethodName: "GrantPermission",
			Handler:    _UserService_GrantPermission_Handler,
		},
		{
			MethodName: "RevokePermission",
			Handler:    _UserService_RevokePermission_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/mdb/mongodb/v1/user_service.proto",
}
