//Code is generated by ucloud code generator, don't modify it by hand, it will cause undefined behaviors.
//go:generate ucloud-gen-go-api UNet DescribeVIP

package unet

import (
	"github.com/ucloud/ucloud-sdk-go/ucloud/request"
	"github.com/ucloud/ucloud-sdk-go/ucloud/response"
)

// DescribeVIPRequest is request schema for DescribeVIP action
type DescribeVIPRequest struct {
	request.CommonBase

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"false"`

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// vpc的id,指定SubnetId时必填
	VPCId *string `required:"false"`

	// 子网id，不指定则获取VPCId下的所有vip
	SubnetId *string `required:"false"`

	// 业务组名称, 默认为 Default
	Tag *string `required:"false"`

	// 业务组
	BusinessId *string `required:"false"`
}

// DescribeVIPResponse is response schema for DescribeVIP action
type DescribeVIPResponse struct {
	response.CommonBase

	// 内网VIP详情，请见VIPDetailSet
	VIPSet []VIPDetailSet

	// 内网VIP地址列表
	DataSet []string

	// vip数量
	TotalCount int
}

// NewDescribeVIPRequest will create request of DescribeVIP action.
func (c *UNetClient) NewDescribeVIPRequest() *DescribeVIPRequest {
	req := &DescribeVIPRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

// DescribeVIP - 获取内网VIP详细信息
func (c *UNetClient) DescribeVIP(req *DescribeVIPRequest) (*DescribeVIPResponse, error) {
	var err error
	var res DescribeVIPResponse

	err = c.Client.InvokeAction("DescribeVIP", req, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}
