# Guides

These guides cover marimo's core concepts.

!!! tip "Learn by doing!"

    Prefer a hands-on learning experience? marimo comes packaged with interactive
    tutorials that you can launch with `marimo tutorial` at the command line.

| Guide                                                | Description                                                  |
| :--------------------------------------------------- | :----------------------------------------------------------- |
| [Reactive execution](reactivity.md)                  | Understanding how marimo runs cells                          |
| [Interactive elements](interactivity.md)             | Using interactive UI elements                                |
| [Visualizing outputs](outputs.md)                    | Creating markdown, plots, and other visual outputs           |
| [Migrating from Jupyter](coming_from/jupyter.md)     | Tips for transitioning from Jupyter                          |
| [Expensive notebooks](expensive_notebooks.md)        | Tips for working with expensive notebooks                    |
| [Working with data](working_with_data/index.md)      | Using SQL cells, no-code dataframe tools, and reactive plots |
| [Apps](apps.md)                                      | Running notebooks as apps                                    |
| [Scripts](scripts.md)                                | Running notebooks as scripts                                 |
| [Tests](testing/index.md)                            | Running unit tests in notebooks                              |
| [Export to HTML and other formats](exporting.md)     | Exporting notebooks to HTML and flat scripts                 |
| [Run notebooks with WebAssembly](wasm.md)            | Create notebooks in our online playground                    |
| [Deploying](deploying/index.md)                      | Deploying marimo notebooks and apps                          |
| [Editor Features](editor_features/index.md)          | View variables, dataframe schemas, docstrings, and more      |
| [Configuration](configuration/index.md)              | Configure various settings                                   |
| [Coming from other tools](coming_from/index.md)      | Transitioning from Jupyter and other tools                   |
| [Extending marimo](integrating_with_marimo/index.md) | Rich displays of objects, custom UI plugins                  |
| [State management](state.md)                         | Advanced: mutable reactive state                             |
| [Best practices](best_practices.md)                  | Best practices to help you get the most out of marimo        |
| [Troubleshooting](troubleshooting.md)                | Troubleshooting notebooks                                    |
