//Code is generated by ucloud code generator, don't modify it by hand, it will cause undefined behaviors.
//go:generate ucloud-gen-go-api UHost ResizeAttachedDisk

package uhost

import (
	"github.com/ucloud/ucloud-sdk-go/ucloud/request"
	"github.com/ucloud/ucloud-sdk-go/ucloud/response"
)

// ResizeAttachedDiskRequest is request schema for ResizeAttachedDisk action
type ResizeAttachedDiskRequest struct {
	request.CommonBase

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"false"`

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// UHost实例ID。 参见 [DescribeUHostInstance](describe_uhost_instance.html)。
	UHostId *string `required:"true"`

	// 磁盘大小，单位GB，步长为10。取值范围需大于当前磁盘大小，最大值请参考[[api:uhost-api:disk_type|磁盘类型]]。
	DiskSpace *int `required:"true"`

	// 磁盘ID。参见 [DescribeUHostInstance](describe_uhost_instance.html)返回值中的DiskSet。
	DiskId *string `required:"true"`
}

// ResizeAttachedDiskResponse is response schema for ResizeAttachedDisk action
type ResizeAttachedDiskResponse struct {
	response.CommonBase

	// 改配成功的磁盘id
	DiskId string
}

// NewResizeAttachedDiskRequest will create request of ResizeAttachedDisk action.
func (c *UHostClient) NewResizeAttachedDiskRequest() *ResizeAttachedDiskRequest {
	req := &ResizeAttachedDiskRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

// ResizeAttachedDisk - 修改挂载的磁盘大小，包含系统盘和数据盘
func (c *UHostClient) ResizeAttachedDisk(req *ResizeAttachedDiskRequest) (*ResizeAttachedDiskResponse, error) {
	var err error
	var res ResizeAttachedDiskResponse

	err = c.Client.InvokeAction("ResizeAttachedDisk", req, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}
