// Code is generated by ucloud-model, DO NOT EDIT IT.

package vpc

import (
	"github.com/ucloud/ucloud-sdk-go/ucloud/request"
	"github.com/ucloud/ucloud-sdk-go/ucloud/response"
)

// CreateNATGWPolicyRequest is request schema for CreateNATGWPolicy action
type CreateNATGWPolicyRequest struct {
	request.CommonBase

	// [公共参数] 项目Id。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 目标IP。填写对应的目标IP地址
	DstIP *string `required:"true"`

	// 目标端口。可填写固定端口，也可填写端口范围。支持的端口范围为1-65535
	DstPort *string `required:"true"`

	// NAT网关Id
	NATGWId *string `required:"true"`

	// 转发策略名称。默认为空
	PolicyName *string `required:"false"`

	// 协议类型。枚举值为：TCP、UDP
	Protocol *string `required:"true"`

	// 源IP。填写对应的EIP Id
	SrcEIPId *string `required:"true"`

	// 源端口。可填写固定端口，也可填写端口范围。支持的端口范围为1-65535
	SrcPort *string `required:"true"`
}

// CreateNATGWPolicyResponse is response schema for CreateNATGWPolicy action
type CreateNATGWPolicyResponse struct {
	response.CommonBase

	// 创建时分配的策略Id
	PolicyId string
}

// NewCreateNATGWPolicyRequest will create request of CreateNATGWPolicy action.
func (c *VPCClient) NewCreateNATGWPolicyRequest() *CreateNATGWPolicyRequest {
	req := &CreateNATGWPolicyRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(false)
	return req
}

// CreateNATGWPolicy - 添加NAT网关端口转发规则
func (c *VPCClient) CreateNATGWPolicy(req *CreateNATGWPolicyRequest) (*CreateNATGWPolicyResponse, error) {
	var err error
	var res CreateNATGWPolicyResponse

	reqCopier := *req

	err = c.Client.InvokeAction("CreateNATGWPolicy", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}
