// Code is generated by ucloud-model, DO NOT EDIT IT.

package vpc

import (
	"github.com/ucloud/ucloud-sdk-go/ucloud/request"
	"github.com/ucloud/ucloud-sdk-go/ucloud/response"
)

// DescribeNATGWPolicyRequest is request schema for DescribeNATGWPolicy action
type DescribeNATGWPolicyRequest struct {
	request.CommonBase

	// [公共参数] 项目Id。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 返回数据长度，默认为10000
	Limit *int `required:"false"`

	// NAT网关Id
	NATGWId *string `required:"true"`

	// 列表起始位置偏移量，默认为0
	Offset *int `required:"false"`
}

// DescribeNATGWPolicyResponse is response schema for DescribeNATGWPolicy action
type DescribeNATGWPolicyResponse struct {
	response.CommonBase

	// 查到的NATGW 转发策略的详细信息
	DataSet []NATGWPolicyDataSet

	// 满足条件的转发策略总数
	TotalCount int
}

// NewDescribeNATGWPolicyRequest will create request of DescribeNATGWPolicy action.
func (c *VPCClient) NewDescribeNATGWPolicyRequest() *DescribeNATGWPolicyRequest {
	req := &DescribeNATGWPolicyRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

// DescribeNATGWPolicy - 展示NAT网关端口转发规则
func (c *VPCClient) DescribeNATGWPolicy(req *DescribeNATGWPolicyRequest) (*DescribeNATGWPolicyResponse, error) {
	var err error
	var res DescribeNATGWPolicyResponse

	reqCopier := *req

	err = c.Client.InvokeAction("DescribeNATGWPolicy", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}
