// Code is generated by ucloud-model, DO NOT EDIT IT.

package vpc

import (
	"github.com/ucloud/ucloud-sdk-go/ucloud/request"
	"github.com/ucloud/ucloud-sdk-go/ucloud/response"
)

// EnableWhiteListRequest is request schema for EnableWhiteList action
type EnableWhiteListRequest struct {
	request.CommonBase

	// [公共参数] 项目Id。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// 白名单开关标记。0：关闭；1：开启。默认为0
	IfOpen *int `required:"true"`

	// NAT网关Id
	NATGWId *string `required:"true"`
}

// EnableWhiteListResponse is response schema for EnableWhiteList action
type EnableWhiteListResponse struct {
	response.CommonBase
}

// NewEnableWhiteListRequest will create request of EnableWhiteList action.
func (c *VPCClient) NewEnableWhiteListRequest() *EnableWhiteListRequest {
	req := &EnableWhiteListRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

// EnableWhiteList - 修改NAT网关白名单开关
func (c *VPCClient) EnableWhiteList(req *EnableWhiteListRequest) (*EnableWhiteListResponse, error) {
	var err error
	var res EnableWhiteListResponse

	reqCopier := *req

	err = c.Client.InvokeAction("EnableWhiteList", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}
