// Code is generated by ucloud-model, DO NOT EDIT IT.

package vpc

import (
	"github.com/ucloud/ucloud-sdk-go/ucloud/request"
	"github.com/ucloud/ucloud-sdk-go/ucloud/response"
)

// GetAvailableResourceForWhiteListRequest is request schema for GetAvailableResourceForWhiteList action
type GetAvailableResourceForWhiteListRequest struct {
	request.CommonBase

	// [公共参数] 项目Id。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// NAT网关Id
	NATGWId *string `required:"true"`
}

// GetAvailableResourceForWhiteListResponse is response schema for GetAvailableResourceForWhiteList action
type GetAvailableResourceForWhiteListResponse struct {
	response.CommonBase

	// 返回白名单列表的详细信息
	DataSet []GetAvailableResourceForWhiteListDataSet

	// 白名单资源列表的总的个数
	TotalCount int
}

// NewGetAvailableResourceForWhiteListRequest will create request of GetAvailableResourceForWhiteList action.
func (c *VPCClient) NewGetAvailableResourceForWhiteListRequest() *GetAvailableResourceForWhiteListRequest {
	req := &GetAvailableResourceForWhiteListRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

// GetAvailableResourceForWhiteList - 获取NAT网关可添加白名单的资源
func (c *VPCClient) GetAvailableResourceForWhiteList(req *GetAvailableResourceForWhiteListRequest) (*GetAvailableResourceForWhiteListResponse, error) {
	var err error
	var res GetAvailableResourceForWhiteListResponse

	reqCopier := *req

	err = c.Client.InvokeAction("GetAvailableResourceForWhiteList", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}
