// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/iam/v1/api_key_service.proto

package iam

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type GetApiKeyRequest struct {
	// ID of the API key to return.
	// To get the API key ID, use a [ApiKeyService.List] request.
	ApiKeyId             string   `protobuf:"bytes,1,opt,name=api_key_id,json=apiKeyId,proto3" json:"api_key_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetApiKeyRequest) Reset()         { *m = GetApiKeyRequest{} }
func (m *GetApiKeyRequest) String() string { return proto.CompactTextString(m) }
func (*GetApiKeyRequest) ProtoMessage()    {}
func (*GetApiKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7823c2139024242e, []int{0}
}

func (m *GetApiKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetApiKeyRequest.Unmarshal(m, b)
}
func (m *GetApiKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetApiKeyRequest.Marshal(b, m, deterministic)
}
func (m *GetApiKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetApiKeyRequest.Merge(m, src)
}
func (m *GetApiKeyRequest) XXX_Size() int {
	return xxx_messageInfo_GetApiKeyRequest.Size(m)
}
func (m *GetApiKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetApiKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetApiKeyRequest proto.InternalMessageInfo

func (m *GetApiKeyRequest) GetApiKeyId() string {
	if m != nil {
		return m.ApiKeyId
	}
	return ""
}

type ListApiKeysRequest struct {
	// ID of the service account to list API keys for.
	// To get the service account ID, use a [yandex.cloud.iam.v1.ServiceAccountService.List] request.
	// If not specified, it defaults to the subject that made the request.
	ServiceAccountId string `protobuf:"bytes,1,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListApiKeysResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token]
	// to the [ListApiKeysResponse.next_page_token]
	// returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListApiKeysRequest) Reset()         { *m = ListApiKeysRequest{} }
func (m *ListApiKeysRequest) String() string { return proto.CompactTextString(m) }
func (*ListApiKeysRequest) ProtoMessage()    {}
func (*ListApiKeysRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7823c2139024242e, []int{1}
}

func (m *ListApiKeysRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListApiKeysRequest.Unmarshal(m, b)
}
func (m *ListApiKeysRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListApiKeysRequest.Marshal(b, m, deterministic)
}
func (m *ListApiKeysRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListApiKeysRequest.Merge(m, src)
}
func (m *ListApiKeysRequest) XXX_Size() int {
	return xxx_messageInfo_ListApiKeysRequest.Size(m)
}
func (m *ListApiKeysRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListApiKeysRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListApiKeysRequest proto.InternalMessageInfo

func (m *ListApiKeysRequest) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

func (m *ListApiKeysRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListApiKeysRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListApiKeysResponse struct {
	// List of API keys.
	ApiKeys []*ApiKey `protobuf:"bytes,1,rep,name=api_keys,json=apiKeys,proto3" json:"api_keys,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListApiKeysRequest.page_size], use
	// the [next_page_token] as the value
	// for the [ListApiKeysRequest.page_token] query parameter
	// in the next list request. Each subsequent list request will have its own
	// [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListApiKeysResponse) Reset()         { *m = ListApiKeysResponse{} }
func (m *ListApiKeysResponse) String() string { return proto.CompactTextString(m) }
func (*ListApiKeysResponse) ProtoMessage()    {}
func (*ListApiKeysResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_7823c2139024242e, []int{2}
}

func (m *ListApiKeysResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListApiKeysResponse.Unmarshal(m, b)
}
func (m *ListApiKeysResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListApiKeysResponse.Marshal(b, m, deterministic)
}
func (m *ListApiKeysResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListApiKeysResponse.Merge(m, src)
}
func (m *ListApiKeysResponse) XXX_Size() int {
	return xxx_messageInfo_ListApiKeysResponse.Size(m)
}
func (m *ListApiKeysResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListApiKeysResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListApiKeysResponse proto.InternalMessageInfo

func (m *ListApiKeysResponse) GetApiKeys() []*ApiKey {
	if m != nil {
		return m.ApiKeys
	}
	return nil
}

func (m *ListApiKeysResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateApiKeyRequest struct {
	// ID of the service account to create an API key for.
	// To get the service account ID, use a [yandex.cloud.iam.v1.ServiceAccountService.List] request.
	// If not specified, it defaults to the subject that made the request.
	ServiceAccountId string `protobuf:"bytes,1,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// Description of the API key.
	Description          string   `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateApiKeyRequest) Reset()         { *m = CreateApiKeyRequest{} }
func (m *CreateApiKeyRequest) String() string { return proto.CompactTextString(m) }
func (*CreateApiKeyRequest) ProtoMessage()    {}
func (*CreateApiKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7823c2139024242e, []int{3}
}

func (m *CreateApiKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateApiKeyRequest.Unmarshal(m, b)
}
func (m *CreateApiKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateApiKeyRequest.Marshal(b, m, deterministic)
}
func (m *CreateApiKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateApiKeyRequest.Merge(m, src)
}
func (m *CreateApiKeyRequest) XXX_Size() int {
	return xxx_messageInfo_CreateApiKeyRequest.Size(m)
}
func (m *CreateApiKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateApiKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateApiKeyRequest proto.InternalMessageInfo

func (m *CreateApiKeyRequest) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

func (m *CreateApiKeyRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

type CreateApiKeyResponse struct {
	// ApiKey resource.
	ApiKey *ApiKey `protobuf:"bytes,1,opt,name=api_key,json=apiKey,proto3" json:"api_key,omitempty"`
	// Secret part of the API key. This secret key you may use in the requests for authentication.
	Secret               string   `protobuf:"bytes,2,opt,name=secret,proto3" json:"secret,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateApiKeyResponse) Reset()         { *m = CreateApiKeyResponse{} }
func (m *CreateApiKeyResponse) String() string { return proto.CompactTextString(m) }
func (*CreateApiKeyResponse) ProtoMessage()    {}
func (*CreateApiKeyResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_7823c2139024242e, []int{4}
}

func (m *CreateApiKeyResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateApiKeyResponse.Unmarshal(m, b)
}
func (m *CreateApiKeyResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateApiKeyResponse.Marshal(b, m, deterministic)
}
func (m *CreateApiKeyResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateApiKeyResponse.Merge(m, src)
}
func (m *CreateApiKeyResponse) XXX_Size() int {
	return xxx_messageInfo_CreateApiKeyResponse.Size(m)
}
func (m *CreateApiKeyResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateApiKeyResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CreateApiKeyResponse proto.InternalMessageInfo

func (m *CreateApiKeyResponse) GetApiKey() *ApiKey {
	if m != nil {
		return m.ApiKey
	}
	return nil
}

func (m *CreateApiKeyResponse) GetSecret() string {
	if m != nil {
		return m.Secret
	}
	return ""
}

type DeleteApiKeyRequest struct {
	// ID of the API key to delete.
	// To get the API key ID, use a [ApiKeyService.List] request.
	ApiKeyId             string   `protobuf:"bytes,1,opt,name=api_key_id,json=apiKeyId,proto3" json:"api_key_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteApiKeyRequest) Reset()         { *m = DeleteApiKeyRequest{} }
func (m *DeleteApiKeyRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteApiKeyRequest) ProtoMessage()    {}
func (*DeleteApiKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7823c2139024242e, []int{5}
}

func (m *DeleteApiKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteApiKeyRequest.Unmarshal(m, b)
}
func (m *DeleteApiKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteApiKeyRequest.Marshal(b, m, deterministic)
}
func (m *DeleteApiKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteApiKeyRequest.Merge(m, src)
}
func (m *DeleteApiKeyRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteApiKeyRequest.Size(m)
}
func (m *DeleteApiKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteApiKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteApiKeyRequest proto.InternalMessageInfo

func (m *DeleteApiKeyRequest) GetApiKeyId() string {
	if m != nil {
		return m.ApiKeyId
	}
	return ""
}

func init() {
	proto.RegisterType((*GetApiKeyRequest)(nil), "yandex.cloud.iam.v1.GetApiKeyRequest")
	proto.RegisterType((*ListApiKeysRequest)(nil), "yandex.cloud.iam.v1.ListApiKeysRequest")
	proto.RegisterType((*ListApiKeysResponse)(nil), "yandex.cloud.iam.v1.ListApiKeysResponse")
	proto.RegisterType((*CreateApiKeyRequest)(nil), "yandex.cloud.iam.v1.CreateApiKeyRequest")
	proto.RegisterType((*CreateApiKeyResponse)(nil), "yandex.cloud.iam.v1.CreateApiKeyResponse")
	proto.RegisterType((*DeleteApiKeyRequest)(nil), "yandex.cloud.iam.v1.DeleteApiKeyRequest")
}

func init() {
	proto.RegisterFile("yandex/cloud/iam/v1/api_key_service.proto", fileDescriptor_7823c2139024242e)
}

var fileDescriptor_7823c2139024242e = []byte{
	// 602 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x94, 0xcf, 0x4f, 0x13, 0x41,
	0x14, 0xc7, 0xb3, 0x14, 0x4b, 0xfb, 0x90, 0x80, 0x53, 0x82, 0xcd, 0x82, 0x06, 0x37, 0x2a, 0x05,
	0xc3, 0xfe, 0x40, 0xe1, 0x20, 0x60, 0x02, 0x6a, 0x08, 0xd1, 0x83, 0x29, 0x9e, 0xbc, 0x34, 0xc3,
	0xee, 0xb3, 0x4e, 0x68, 0x77, 0xd6, 0xce, 0x6c, 0x43, 0x31, 0x5e, 0x3c, 0x72, 0xf5, 0x0f, 0xf0,
	0xcf, 0x81, 0xbb, 0x7f, 0x81, 0x89, 0x07, 0xff, 0x06, 0x4f, 0x66, 0x67, 0xa6, 0x40, 0xeb, 0x0a,
	0xea, 0x71, 0xf7, 0xbd, 0xf9, 0x7e, 0xdf, 0xe7, 0xbd, 0x99, 0x07, 0x8b, 0x3d, 0x1a, 0x47, 0x78,
	0xe8, 0x85, 0x2d, 0x9e, 0x46, 0x1e, 0xa3, 0x6d, 0xaf, 0x1b, 0x78, 0x34, 0x61, 0x8d, 0x03, 0xec,
	0x35, 0x04, 0x76, 0xba, 0x2c, 0x44, 0x37, 0xe9, 0x70, 0xc9, 0x49, 0x45, 0xa7, 0xba, 0x2a, 0xd5,
	0x65, 0xb4, 0xed, 0x76, 0x03, 0x7b, 0xae, 0xc9, 0x79, 0xb3, 0x85, 0xd9, 0x11, 0x8f, 0xc6, 0x31,
	0x97, 0x54, 0x32, 0x1e, 0x0b, 0x7d, 0xc4, 0x9e, 0x35, 0x51, 0xf5, 0xb5, 0x9f, 0xbe, 0xf5, 0xb0,
	0x9d, 0xc8, 0x9e, 0x09, 0xde, 0xb9, 0xc4, 0xda, 0xa4, 0xdc, 0x1a, 0x48, 0xe9, 0xd2, 0x16, 0x8b,
	0x94, 0xbe, 0x0e, 0x3b, 0x4f, 0x60, 0x6a, 0x07, 0xe5, 0x56, 0xc2, 0x5e, 0x60, 0xaf, 0x8e, 0xef,
	0x53, 0x14, 0x92, 0x2c, 0x01, 0xf4, 0xcb, 0x67, 0x51, 0xd5, 0x9a, 0xb7, 0x6a, 0xe5, 0xed, 0xeb,
	0x3f, 0x4e, 0x02, 0xeb, 0xf8, 0x34, 0x18, 0xdd, 0xd8, 0x5c, 0xf5, 0xeb, 0x25, 0xaa, 0x0e, 0xec,
	0x46, 0xce, 0x17, 0x0b, 0xc8, 0x4b, 0x26, 0x8c, 0x82, 0xe8, 0x4b, 0xac, 0x01, 0x31, 0xe4, 0x0d,
	0x1a, 0x86, 0x3c, 0x8d, 0xe5, 0xb9, 0x54, 0xe9, 0x4c, 0x66, 0xca, 0xe4, 0x6c, 0xe9, 0x94, 0xdd,
	0x88, 0x2c, 0x40, 0x39, 0xa1, 0x4d, 0x6c, 0x08, 0x76, 0x84, 0xd5, 0x91, 0x79, 0xab, 0x56, 0xd8,
	0x86, 0x9f, 0x27, 0x41, 0xd1, 0x5f, 0x0e, 0x7c, 0xdf, 0xaf, 0x97, 0xb2, 0xe0, 0x1e, 0x3b, 0x42,
	0x52, 0x03, 0x50, 0x89, 0x92, 0x1f, 0x60, 0x5c, 0x2d, 0x28, 0xe1, 0xf2, 0xf1, 0x69, 0x70, 0x6d,
	0x63, 0x33, 0xf0, 0xfd, 0xba, 0x52, 0x79, 0x9d, 0xc5, 0x9c, 0x14, 0x2a, 0x03, 0x05, 0x8a, 0x84,
	0xc7, 0x02, 0xc9, 0x1a, 0x94, 0x0c, 0xa4, 0xa8, 0x5a, 0xf3, 0x85, 0xda, 0xf8, 0xca, 0xac, 0x9b,
	0x33, 0x1d, 0xd7, 0xb4, 0x66, 0x4c, 0x13, 0x0b, 0x72, 0x1f, 0x26, 0x63, 0x3c, 0x94, 0x8d, 0x0b,
	0xee, 0x59, 0x9d, 0xe5, 0xfa, 0x44, 0xf6, 0xfb, 0xd5, 0x99, 0xed, 0x11, 0x54, 0x9e, 0x76, 0x90,
	0x4a, 0x1c, 0xec, 0xed, 0xff, 0x36, 0xe6, 0x01, 0x8c, 0x47, 0x28, 0xc2, 0x0e, 0x4b, 0xb2, 0xe1,
	0x69, 0xcb, 0x3e, 0xf0, 0xca, 0xea, 0x5a, 0xfd, 0x62, 0xd4, 0x89, 0x60, 0x7a, 0xd0, 0xdb, 0x30,
	0x3f, 0x82, 0x31, 0xc3, 0xac, 0x1c, 0xaf, 0x40, 0x2e, 0x6a, 0x64, 0x32, 0x03, 0x45, 0x81, 0x61,
	0x07, 0xa5, 0x01, 0x35, 0x5f, 0xce, 0x16, 0x54, 0x9e, 0x61, 0x0b, 0x87, 0x09, 0xff, 0xe1, 0xf6,
	0xac, 0x7c, 0x2b, 0xc0, 0x84, 0x3e, 0xbd, 0xa7, 0x81, 0x49, 0x07, 0x46, 0xb3, 0x69, 0x91, 0x85,
	0xdc, 0xca, 0x7e, 0xbf, 0x69, 0x76, 0xed, 0xea, 0x44, 0x4d, 0xef, 0xdc, 0xfc, 0xf4, 0xf5, 0xfb,
	0xe7, 0x91, 0x1b, 0x64, 0xf2, 0xc2, 0x43, 0x51, 0x23, 0xe5, 0x50, 0xd8, 0x41, 0x49, 0xee, 0xe5,
	0x2a, 0x0d, 0xbf, 0x0e, 0xfb, 0xb2, 0x9e, 0x39, 0x77, 0x95, 0xc7, 0x6d, 0x32, 0x37, 0xe4, 0xe1,
	0x7d, 0x38, 0xef, 0xc9, 0x47, 0xd2, 0x83, 0xa2, 0x9e, 0x0f, 0xc9, 0xaf, 0x3e, 0xe7, 0xe2, 0xd8,
	0x8b, 0x7f, 0x91, 0x69, 0x40, 0x6d, 0x55, 0xc4, 0xb4, 0x33, 0x0c, 0xfa, 0xd8, 0x5a, 0x22, 0x09,
	0x14, 0xf5, 0xd0, 0xfe, 0x60, 0x9d, 0x33, 0x51, 0x7b, 0xc6, 0xd5, 0x3b, 0xc8, 0xed, 0xef, 0x20,
	0xf7, 0x79, 0xb6, 0x83, 0xfa, 0xb0, 0x4b, 0x97, 0xc2, 0x6e, 0x6f, 0xbe, 0x59, 0x6f, 0x32, 0xf9,
	0x2e, 0xdd, 0x77, 0x43, 0xde, 0xf6, 0xb4, 0xe7, 0xb2, 0xde, 0x46, 0x4d, 0xbe, 0xdc, 0xc4, 0x58,
	0xa9, 0x7a, 0x39, 0x9b, 0x6c, 0x9d, 0xd1, 0xf6, 0x7e, 0x51, 0x85, 0x1f, 0xfe, 0x0a, 0x00, 0x00,
	0xff, 0xff, 0x77, 0x3b, 0x11, 0x86, 0x66, 0x05, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ApiKeyServiceClient is the client API for ApiKeyService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ApiKeyServiceClient interface {
	// Retrieves the list of API keys for the specified service account.
	List(ctx context.Context, in *ListApiKeysRequest, opts ...grpc.CallOption) (*ListApiKeysResponse, error)
	// Returns the specified API key.
	//
	// To get the list of available API keys, make a [List] request.
	Get(ctx context.Context, in *GetApiKeyRequest, opts ...grpc.CallOption) (*ApiKey, error)
	// Creates an API key for the specified service account.
	Create(ctx context.Context, in *CreateApiKeyRequest, opts ...grpc.CallOption) (*CreateApiKeyResponse, error)
	// Deletes the specified API key.
	Delete(ctx context.Context, in *DeleteApiKeyRequest, opts ...grpc.CallOption) (*empty.Empty, error)
}

type apiKeyServiceClient struct {
	cc *grpc.ClientConn
}

func NewApiKeyServiceClient(cc *grpc.ClientConn) ApiKeyServiceClient {
	return &apiKeyServiceClient{cc}
}

func (c *apiKeyServiceClient) List(ctx context.Context, in *ListApiKeysRequest, opts ...grpc.CallOption) (*ListApiKeysResponse, error) {
	out := new(ListApiKeysResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.ApiKeyService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiKeyServiceClient) Get(ctx context.Context, in *GetApiKeyRequest, opts ...grpc.CallOption) (*ApiKey, error) {
	out := new(ApiKey)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.ApiKeyService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiKeyServiceClient) Create(ctx context.Context, in *CreateApiKeyRequest, opts ...grpc.CallOption) (*CreateApiKeyResponse, error) {
	out := new(CreateApiKeyResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.ApiKeyService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiKeyServiceClient) Delete(ctx context.Context, in *DeleteApiKeyRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.ApiKeyService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ApiKeyServiceServer is the server API for ApiKeyService service.
type ApiKeyServiceServer interface {
	// Retrieves the list of API keys for the specified service account.
	List(context.Context, *ListApiKeysRequest) (*ListApiKeysResponse, error)
	// Returns the specified API key.
	//
	// To get the list of available API keys, make a [List] request.
	Get(context.Context, *GetApiKeyRequest) (*ApiKey, error)
	// Creates an API key for the specified service account.
	Create(context.Context, *CreateApiKeyRequest) (*CreateApiKeyResponse, error)
	// Deletes the specified API key.
	Delete(context.Context, *DeleteApiKeyRequest) (*empty.Empty, error)
}

// UnimplementedApiKeyServiceServer can be embedded to have forward compatible implementations.
type UnimplementedApiKeyServiceServer struct {
}

func (*UnimplementedApiKeyServiceServer) List(ctx context.Context, req *ListApiKeysRequest) (*ListApiKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedApiKeyServiceServer) Get(ctx context.Context, req *GetApiKeyRequest) (*ApiKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedApiKeyServiceServer) Create(ctx context.Context, req *CreateApiKeyRequest) (*CreateApiKeyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (*UnimplementedApiKeyServiceServer) Delete(ctx context.Context, req *DeleteApiKeyRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}

func RegisterApiKeyServiceServer(s *grpc.Server, srv ApiKeyServiceServer) {
	s.RegisterService(&_ApiKeyService_serviceDesc, srv)
}

func _ApiKeyService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListApiKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiKeyServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.ApiKeyService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiKeyServiceServer).List(ctx, req.(*ListApiKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiKeyService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetApiKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiKeyServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.ApiKeyService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiKeyServiceServer).Get(ctx, req.(*GetApiKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiKeyService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateApiKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiKeyServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.ApiKeyService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiKeyServiceServer).Create(ctx, req.(*CreateApiKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiKeyService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteApiKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiKeyServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.ApiKeyService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiKeyServiceServer).Delete(ctx, req.(*DeleteApiKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ApiKeyService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.iam.v1.ApiKeyService",
	HandlerType: (*ApiKeyServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "List",
			Handler:    _ApiKeyService_List_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _ApiKeyService_Get_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _ApiKeyService_Create_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _ApiKeyService_Delete_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/iam/v1/api_key_service.proto",
}
