// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/iam/v1/key_service.proto

package iam

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type KeyFormat int32

const (
	// Privacy-Enhanced Mail (PEM) format. Default value.
	KeyFormat_PEM_FILE KeyFormat = 0
)

var KeyFormat_name = map[int32]string{
	0: "PEM_FILE",
}

var KeyFormat_value = map[string]int32{
	"PEM_FILE": 0,
}

func (x KeyFormat) String() string {
	return proto.EnumName(KeyFormat_name, int32(x))
}

func (KeyFormat) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_dce2d1f6e04851f2, []int{0}
}

type GetKeyRequest struct {
	// ID of the Key resource to return.
	// To get the ID use a [KeyService.List] request.
	KeyId string `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// Output format of the key.
	Format               KeyFormat `protobuf:"varint,2,opt,name=format,proto3,enum=yandex.cloud.iam.v1.KeyFormat" json:"format,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *GetKeyRequest) Reset()         { *m = GetKeyRequest{} }
func (m *GetKeyRequest) String() string { return proto.CompactTextString(m) }
func (*GetKeyRequest) ProtoMessage()    {}
func (*GetKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_dce2d1f6e04851f2, []int{0}
}

func (m *GetKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetKeyRequest.Unmarshal(m, b)
}
func (m *GetKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetKeyRequest.Marshal(b, m, deterministic)
}
func (m *GetKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetKeyRequest.Merge(m, src)
}
func (m *GetKeyRequest) XXX_Size() int {
	return xxx_messageInfo_GetKeyRequest.Size(m)
}
func (m *GetKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetKeyRequest proto.InternalMessageInfo

func (m *GetKeyRequest) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

func (m *GetKeyRequest) GetFormat() KeyFormat {
	if m != nil {
		return m.Format
	}
	return KeyFormat_PEM_FILE
}

type ListKeysRequest struct {
	// Output format of the key.
	Format KeyFormat `protobuf:"varint,1,opt,name=format,proto3,enum=yandex.cloud.iam.v1.KeyFormat" json:"format,omitempty"`
	// ID of the service account to list key pairs for.
	// To get the service account ID, use a [yandex.cloud.iam.v1.ServiceAccountService.List] request.
	// If not specified, it defaults to the subject that made the request.
	ServiceAccountId string `protobuf:"bytes,2,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListKeysResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListKeysResponse.next_page_token] returned by a previous list request.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListKeysRequest) Reset()         { *m = ListKeysRequest{} }
func (m *ListKeysRequest) String() string { return proto.CompactTextString(m) }
func (*ListKeysRequest) ProtoMessage()    {}
func (*ListKeysRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_dce2d1f6e04851f2, []int{1}
}

func (m *ListKeysRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListKeysRequest.Unmarshal(m, b)
}
func (m *ListKeysRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListKeysRequest.Marshal(b, m, deterministic)
}
func (m *ListKeysRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListKeysRequest.Merge(m, src)
}
func (m *ListKeysRequest) XXX_Size() int {
	return xxx_messageInfo_ListKeysRequest.Size(m)
}
func (m *ListKeysRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListKeysRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListKeysRequest proto.InternalMessageInfo

func (m *ListKeysRequest) GetFormat() KeyFormat {
	if m != nil {
		return m.Format
	}
	return KeyFormat_PEM_FILE
}

func (m *ListKeysRequest) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

func (m *ListKeysRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListKeysRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListKeysResponse struct {
	// List of Key resources.
	Keys []*Key `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListKeysRequest.page_size], use
	// the [next_page_token] as the value
	// for the [ListKeysRequest.page_token] query parameter
	// in the next list request. Each subsequent list request will have its own
	// [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListKeysResponse) Reset()         { *m = ListKeysResponse{} }
func (m *ListKeysResponse) String() string { return proto.CompactTextString(m) }
func (*ListKeysResponse) ProtoMessage()    {}
func (*ListKeysResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_dce2d1f6e04851f2, []int{2}
}

func (m *ListKeysResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListKeysResponse.Unmarshal(m, b)
}
func (m *ListKeysResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListKeysResponse.Marshal(b, m, deterministic)
}
func (m *ListKeysResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListKeysResponse.Merge(m, src)
}
func (m *ListKeysResponse) XXX_Size() int {
	return xxx_messageInfo_ListKeysResponse.Size(m)
}
func (m *ListKeysResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListKeysResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListKeysResponse proto.InternalMessageInfo

func (m *ListKeysResponse) GetKeys() []*Key {
	if m != nil {
		return m.Keys
	}
	return nil
}

func (m *ListKeysResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateKeyRequest struct {
	// ID of the service account to create a key pair for.
	// To get the service account ID, use a [yandex.cloud.iam.v1.ServiceAccountService.List] request.
	// If not specified, it defaults to the subject that made the request.
	ServiceAccountId string `protobuf:"bytes,1,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// Description of the key pair.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Output format of the key.
	Format KeyFormat `protobuf:"varint,3,opt,name=format,proto3,enum=yandex.cloud.iam.v1.KeyFormat" json:"format,omitempty"`
	// An algorithm used to generate a key pair of the Key resource.
	KeyAlgorithm         Key_Algorithm `protobuf:"varint,4,opt,name=key_algorithm,json=keyAlgorithm,proto3,enum=yandex.cloud.iam.v1.Key_Algorithm" json:"key_algorithm,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *CreateKeyRequest) Reset()         { *m = CreateKeyRequest{} }
func (m *CreateKeyRequest) String() string { return proto.CompactTextString(m) }
func (*CreateKeyRequest) ProtoMessage()    {}
func (*CreateKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_dce2d1f6e04851f2, []int{3}
}

func (m *CreateKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateKeyRequest.Unmarshal(m, b)
}
func (m *CreateKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateKeyRequest.Marshal(b, m, deterministic)
}
func (m *CreateKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateKeyRequest.Merge(m, src)
}
func (m *CreateKeyRequest) XXX_Size() int {
	return xxx_messageInfo_CreateKeyRequest.Size(m)
}
func (m *CreateKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateKeyRequest proto.InternalMessageInfo

func (m *CreateKeyRequest) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

func (m *CreateKeyRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *CreateKeyRequest) GetFormat() KeyFormat {
	if m != nil {
		return m.Format
	}
	return KeyFormat_PEM_FILE
}

func (m *CreateKeyRequest) GetKeyAlgorithm() Key_Algorithm {
	if m != nil {
		return m.KeyAlgorithm
	}
	return Key_ALGORITHM_UNSPECIFIED
}

type CreateKeyResponse struct {
	// Key resource.
	Key *Key `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// A private key of the Key resource.
	// This key must be stored securely.
	PrivateKey           string   `protobuf:"bytes,2,opt,name=private_key,json=privateKey,proto3" json:"private_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateKeyResponse) Reset()         { *m = CreateKeyResponse{} }
func (m *CreateKeyResponse) String() string { return proto.CompactTextString(m) }
func (*CreateKeyResponse) ProtoMessage()    {}
func (*CreateKeyResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_dce2d1f6e04851f2, []int{4}
}

func (m *CreateKeyResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateKeyResponse.Unmarshal(m, b)
}
func (m *CreateKeyResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateKeyResponse.Marshal(b, m, deterministic)
}
func (m *CreateKeyResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateKeyResponse.Merge(m, src)
}
func (m *CreateKeyResponse) XXX_Size() int {
	return xxx_messageInfo_CreateKeyResponse.Size(m)
}
func (m *CreateKeyResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateKeyResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CreateKeyResponse proto.InternalMessageInfo

func (m *CreateKeyResponse) GetKey() *Key {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *CreateKeyResponse) GetPrivateKey() string {
	if m != nil {
		return m.PrivateKey
	}
	return ""
}

type DeleteKeyRequest struct {
	// ID of the key to delete.
	// To get key ID use a [KeyService.List] request.
	KeyId                string   `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteKeyRequest) Reset()         { *m = DeleteKeyRequest{} }
func (m *DeleteKeyRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteKeyRequest) ProtoMessage()    {}
func (*DeleteKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_dce2d1f6e04851f2, []int{5}
}

func (m *DeleteKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteKeyRequest.Unmarshal(m, b)
}
func (m *DeleteKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteKeyRequest.Marshal(b, m, deterministic)
}
func (m *DeleteKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteKeyRequest.Merge(m, src)
}
func (m *DeleteKeyRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteKeyRequest.Size(m)
}
func (m *DeleteKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteKeyRequest proto.InternalMessageInfo

func (m *DeleteKeyRequest) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

func init() {
	proto.RegisterEnum("yandex.cloud.iam.v1.KeyFormat", KeyFormat_name, KeyFormat_value)
	proto.RegisterType((*GetKeyRequest)(nil), "yandex.cloud.iam.v1.GetKeyRequest")
	proto.RegisterType((*ListKeysRequest)(nil), "yandex.cloud.iam.v1.ListKeysRequest")
	proto.RegisterType((*ListKeysResponse)(nil), "yandex.cloud.iam.v1.ListKeysResponse")
	proto.RegisterType((*CreateKeyRequest)(nil), "yandex.cloud.iam.v1.CreateKeyRequest")
	proto.RegisterType((*CreateKeyResponse)(nil), "yandex.cloud.iam.v1.CreateKeyResponse")
	proto.RegisterType((*DeleteKeyRequest)(nil), "yandex.cloud.iam.v1.DeleteKeyRequest")
}

func init() {
	proto.RegisterFile("yandex/cloud/iam/v1/key_service.proto", fileDescriptor_dce2d1f6e04851f2)
}

var fileDescriptor_dce2d1f6e04851f2 = []byte{
	// 685 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x54, 0x41, 0x53, 0xd3, 0x5c,
	0x14, 0xfd, 0x42, 0x4b, 0x87, 0x5e, 0x0a, 0x94, 0xf7, 0xa9, 0xd4, 0x2a, 0xda, 0x89, 0x82, 0x9d,
	0x2a, 0x49, 0x5b, 0x07, 0x9c, 0x11, 0x58, 0x80, 0x02, 0xc3, 0x14, 0x67, 0x98, 0xe0, 0xca, 0x4d,
	0x7d, 0x6d, 0x2f, 0xe5, 0x4d, 0x9b, 0xbc, 0x98, 0xbc, 0x76, 0x08, 0x8e, 0x1b, 0x97, 0x6c, 0xfd,
	0x2d, 0xfe, 0x06, 0xd8, 0xeb, 0x4f, 0x70, 0xe1, 0x4f, 0x70, 0x5c, 0x39, 0x79, 0x49, 0x4b, 0x60,
	0x52, 0x91, 0x65, 0x72, 0xcf, 0x3b, 0xe7, 0x9e, 0x73, 0xdf, 0xbb, 0xb0, 0xe0, 0x51, 0xab, 0x85,
	0xc7, 0x7a, 0xb3, 0xcb, 0x7b, 0x2d, 0x9d, 0x51, 0x53, 0xef, 0x57, 0xf4, 0x0e, 0x7a, 0x75, 0x17,
	0x9d, 0x3e, 0x6b, 0xa2, 0x66, 0x3b, 0x5c, 0x70, 0xf2, 0x7f, 0x00, 0xd3, 0x24, 0x4c, 0x63, 0xd4,
	0xd4, 0xfa, 0x95, 0xfc, 0xfd, 0x36, 0xe7, 0xed, 0x2e, 0xea, 0xd4, 0x66, 0x3a, 0xb5, 0x2c, 0x2e,
	0xa8, 0x60, 0xdc, 0x72, 0x83, 0x23, 0xf9, 0x7b, 0x61, 0x55, 0x7e, 0x35, 0x7a, 0x87, 0x3a, 0x9a,
	0xb6, 0xf0, 0xc2, 0xe2, 0xfc, 0x08, 0xd9, 0xd8, 0x72, 0x9f, 0x76, 0x59, 0x4b, 0x72, 0x07, 0x65,
	0xb5, 0x0b, 0x53, 0x3b, 0x28, 0x6a, 0xe8, 0x19, 0xf8, 0xa1, 0x87, 0xae, 0x20, 0x8f, 0x20, 0xe5,
	0xf7, 0xcc, 0x5a, 0x39, 0xa5, 0xa0, 0x14, 0xd3, 0x9b, 0x99, 0x9f, 0x67, 0x15, 0xe5, 0xf4, 0xbc,
	0x92, 0x5c, 0x5b, 0x5f, 0x2e, 0x1b, 0xe3, 0x1d, 0xf4, 0x76, 0x5b, 0x64, 0x05, 0x52, 0x87, 0xdc,
	0x31, 0xa9, 0xc8, 0x8d, 0x15, 0x94, 0xe2, 0x74, 0xf5, 0x81, 0x16, 0x63, 0x4a, 0xab, 0xa1, 0xb7,
	0x2d, 0x51, 0x46, 0x88, 0x56, 0xbf, 0x2b, 0x30, 0xb3, 0xc7, 0x5c, 0x5f, 0xcf, 0x1d, 0x08, 0x5e,
	0x70, 0x29, 0x37, 0xe1, 0x22, 0x2b, 0x40, 0xc2, 0x60, 0xeb, 0xb4, 0xd9, 0xe4, 0x3d, 0x4b, 0xf8,
	0x4d, 0x8f, 0xc9, 0xa6, 0x27, 0x86, 0x0d, 0x67, 0x43, 0xcc, 0x46, 0x00, 0xd9, 0x6d, 0x91, 0x27,
	0x90, 0xb6, 0x69, 0x1b, 0xeb, 0x2e, 0x3b, 0xc1, 0x5c, 0xa2, 0xa0, 0x14, 0x13, 0x9b, 0xf0, 0xfb,
	0xac, 0x92, 0x5a, 0x5b, 0xaf, 0x94, 0xcb, 0x65, 0x63, 0xc2, 0x2f, 0x1e, 0xb0, 0x13, 0x24, 0x45,
	0x00, 0x09, 0x14, 0xbc, 0x83, 0x56, 0x2e, 0x29, 0x89, 0xd3, 0xa7, 0xe7, 0x95, 0x71, 0x89, 0x34,
	0x24, 0xcb, 0x5b, 0xbf, 0xa6, 0x1e, 0x41, 0xf6, 0xc2, 0x95, 0x6b, 0x73, 0xcb, 0x45, 0xf2, 0x0c,
	0x92, 0x1d, 0xf4, 0xdc, 0x9c, 0x52, 0x48, 0x14, 0x27, 0xab, 0xb9, 0x51, 0xa6, 0x0c, 0x89, 0x22,
	0x8b, 0x30, 0x63, 0xe1, 0xb1, 0xa8, 0x47, 0x04, 0xa5, 0x13, 0x63, 0xca, 0xff, 0xbd, 0x3f, 0x54,
	0xfa, 0xa5, 0x40, 0xf6, 0x95, 0x83, 0x54, 0x60, 0x64, 0x64, 0xf1, 0x49, 0x28, 0xd7, 0x26, 0xf1,
	0x14, 0x26, 0x5b, 0xe8, 0x36, 0x1d, 0x66, 0xfb, 0x17, 0x22, 0x8c, 0x2e, 0x74, 0x58, 0x5d, 0x5e,
	0x31, 0xa2, 0xd5, 0xc8, 0x98, 0x12, 0x37, 0x1a, 0xd3, 0x0e, 0x4c, 0xf9, 0xf7, 0x89, 0x76, 0xdb,
	0xdc, 0x61, 0xe2, 0xc8, 0x94, 0x41, 0x4e, 0x57, 0xd5, 0x51, 0xc7, 0xb5, 0x8d, 0x01, 0xd2, 0xc8,
	0x74, 0xd0, 0x1b, 0x7e, 0xa9, 0xef, 0x61, 0x36, 0xe2, 0x3c, 0x4c, 0xb9, 0x04, 0x89, 0x0e, 0x7a,
	0xd2, 0xeb, 0xdf, 0x42, 0xf6, 0x41, 0xe4, 0x21, 0x4c, 0xda, 0x0e, 0xeb, 0x53, 0x81, 0x75, 0xff,
	0x4c, 0x90, 0x2f, 0x84, 0xbf, 0x6a, 0xe8, 0xa9, 0x2f, 0x20, 0xfb, 0x1a, 0xbb, 0x78, 0x29, 0xdb,
	0x7f, 0x79, 0x0e, 0xa5, 0xbb, 0x90, 0x1e, 0x1a, 0x27, 0x19, 0x98, 0xd8, 0xdf, 0x7a, 0x53, 0xdf,
	0xde, 0xdd, 0xdb, 0xca, 0xfe, 0x57, 0xfd, 0x9a, 0x00, 0xa8, 0xa1, 0x77, 0x10, 0x64, 0x4f, 0x1a,
	0x90, 0xd8, 0x41, 0x41, 0xe2, 0xdd, 0x5f, 0x7a, 0x88, 0xf9, 0x91, 0x6e, 0xd4, 0xf9, 0xcf, 0xdf,
	0x7e, 0x7c, 0x19, 0x9b, 0x23, 0xb7, 0x23, 0xaf, 0xdd, 0xd5, 0x3f, 0x06, 0x7d, 0x7e, 0x22, 0x0c,
	0x92, 0xfe, 0x6d, 0x24, 0x8f, 0x63, 0x09, 0xae, 0x3c, 0xbf, 0xfc, 0xc2, 0x35, 0xa8, 0x20, 0x68,
	0xf5, 0x96, 0xd4, 0x9c, 0x26, 0x99, 0xa8, 0x26, 0xb1, 0x21, 0x15, 0xcc, 0x84, 0xc4, 0xd3, 0x5c,
	0xbd, 0xaa, 0xf9, 0xc5, 0xeb, 0x60, 0xa1, 0xdc, 0x9c, 0x94, 0x9b, 0x55, 0x2f, 0xc9, 0xbd, 0x54,
	0x4a, 0xe4, 0x10, 0x52, 0xc1, 0x8c, 0x46, 0x28, 0x5e, 0x1d, 0x60, 0xfe, 0x8e, 0x16, 0x2c, 0x4f,
	0x6d, 0xb0, 0x3c, 0xb5, 0x2d, 0x7f, 0x79, 0x0e, 0x42, 0x2c, 0xc5, 0x87, 0xb8, 0xb9, 0xfe, 0x6e,
	0xb5, 0xcd, 0xc4, 0x51, 0xaf, 0xa1, 0x35, 0xb9, 0xa9, 0x07, 0x4a, 0x4b, 0xc1, 0x0e, 0x6d, 0xf3,
	0xa5, 0x36, 0x5a, 0x92, 0x4e, 0x8f, 0xd9, 0xbd, 0xab, 0x8c, 0x9a, 0x8d, 0x94, 0x2c, 0x3f, 0xff,
	0x13, 0x00, 0x00, 0xff, 0xff, 0xca, 0x77, 0xed, 0xa5, 0x14, 0x06, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// KeyServiceClient is the client API for KeyService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type KeyServiceClient interface {
	// Returns the specified Key resource.
	//
	// To get the list of available Key resources, make a [List] request.
	Get(ctx context.Context, in *GetKeyRequest, opts ...grpc.CallOption) (*Key, error)
	// Retrieves the list of Key resources for the specified service account.
	List(ctx context.Context, in *ListKeysRequest, opts ...grpc.CallOption) (*ListKeysResponse, error)
	// Creates a key pair for the specified service account.
	Create(ctx context.Context, in *CreateKeyRequest, opts ...grpc.CallOption) (*CreateKeyResponse, error)
	// Deletes the specified key pair.
	Delete(ctx context.Context, in *DeleteKeyRequest, opts ...grpc.CallOption) (*empty.Empty, error)
}

type keyServiceClient struct {
	cc *grpc.ClientConn
}

func NewKeyServiceClient(cc *grpc.ClientConn) KeyServiceClient {
	return &keyServiceClient{cc}
}

func (c *keyServiceClient) Get(ctx context.Context, in *GetKeyRequest, opts ...grpc.CallOption) (*Key, error) {
	out := new(Key)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.KeyService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyServiceClient) List(ctx context.Context, in *ListKeysRequest, opts ...grpc.CallOption) (*ListKeysResponse, error) {
	out := new(ListKeysResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.KeyService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyServiceClient) Create(ctx context.Context, in *CreateKeyRequest, opts ...grpc.CallOption) (*CreateKeyResponse, error) {
	out := new(CreateKeyResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.KeyService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyServiceClient) Delete(ctx context.Context, in *DeleteKeyRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.KeyService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// KeyServiceServer is the server API for KeyService service.
type KeyServiceServer interface {
	// Returns the specified Key resource.
	//
	// To get the list of available Key resources, make a [List] request.
	Get(context.Context, *GetKeyRequest) (*Key, error)
	// Retrieves the list of Key resources for the specified service account.
	List(context.Context, *ListKeysRequest) (*ListKeysResponse, error)
	// Creates a key pair for the specified service account.
	Create(context.Context, *CreateKeyRequest) (*CreateKeyResponse, error)
	// Deletes the specified key pair.
	Delete(context.Context, *DeleteKeyRequest) (*empty.Empty, error)
}

// UnimplementedKeyServiceServer can be embedded to have forward compatible implementations.
type UnimplementedKeyServiceServer struct {
}

func (*UnimplementedKeyServiceServer) Get(ctx context.Context, req *GetKeyRequest) (*Key, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedKeyServiceServer) List(ctx context.Context, req *ListKeysRequest) (*ListKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedKeyServiceServer) Create(ctx context.Context, req *CreateKeyRequest) (*CreateKeyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (*UnimplementedKeyServiceServer) Delete(ctx context.Context, req *DeleteKeyRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}

func RegisterKeyServiceServer(s *grpc.Server, srv KeyServiceServer) {
	s.RegisterService(&_KeyService_serviceDesc, srv)
}

func _KeyService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.KeyService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyServiceServer).Get(ctx, req.(*GetKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.KeyService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyServiceServer).List(ctx, req.(*ListKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.KeyService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyServiceServer).Create(ctx, req.(*CreateKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.KeyService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyServiceServer).Delete(ctx, req.(*DeleteKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _KeyService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.iam.v1.KeyService",
	HandlerType: (*KeyServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _KeyService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _KeyService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _KeyService_Create_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _KeyService_Delete_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/iam/v1/key_service.proto",
}
