// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/mdb/mongodb/v1/cluster.proto

package mongodb

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	config "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/mongodb/v1/config"
	timeofday "google.golang.org/genproto/googleapis/type/timeofday"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Deployment environment.
type Cluster_Environment int32

const (
	Cluster_ENVIRONMENT_UNSPECIFIED Cluster_Environment = 0
	// Stable environment with a conservative update policy: only hotfixes
	// are applied during regular maintenance.
	Cluster_PRODUCTION Cluster_Environment = 1
	// Environment with more aggressive update policy: new versions
	// are rolled out irrespective of backward compatibility.
	Cluster_PRESTABLE Cluster_Environment = 2
)

var Cluster_Environment_name = map[int32]string{
	0: "ENVIRONMENT_UNSPECIFIED",
	1: "PRODUCTION",
	2: "PRESTABLE",
}

var Cluster_Environment_value = map[string]int32{
	"ENVIRONMENT_UNSPECIFIED": 0,
	"PRODUCTION":              1,
	"PRESTABLE":               2,
}

func (x Cluster_Environment) String() string {
	return proto.EnumName(Cluster_Environment_name, int32(x))
}

func (Cluster_Environment) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{0, 0}
}

type Cluster_Health int32

const (
	// State of the cluster is unknown ([Host.health] for every host in the cluster is UNKNOWN).
	Cluster_HEALTH_UNKNOWN Cluster_Health = 0
	// Cluster is alive and well ([Host.health] for every host in the cluster is ALIVE).
	Cluster_ALIVE Cluster_Health = 1
	// Cluster is inoperable ([Host.health] for every host in the cluster is DEAD).
	Cluster_DEAD Cluster_Health = 2
	// Cluster is working below capacity ([Host.health] for at least one host in the cluster is not ALIVE).
	Cluster_DEGRADED Cluster_Health = 3
)

var Cluster_Health_name = map[int32]string{
	0: "HEALTH_UNKNOWN",
	1: "ALIVE",
	2: "DEAD",
	3: "DEGRADED",
}

var Cluster_Health_value = map[string]int32{
	"HEALTH_UNKNOWN": 0,
	"ALIVE":          1,
	"DEAD":           2,
	"DEGRADED":       3,
}

func (x Cluster_Health) String() string {
	return proto.EnumName(Cluster_Health_name, int32(x))
}

func (Cluster_Health) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{0, 1}
}

type Cluster_Status int32

const (
	// Cluster state is unknown.
	Cluster_STATUS_UNKNOWN Cluster_Status = 0
	// Cluster is being created.
	Cluster_CREATING Cluster_Status = 1
	// Cluster is running normally.
	Cluster_RUNNING Cluster_Status = 2
	// Cluster encountered a problem and cannot operate.
	Cluster_ERROR Cluster_Status = 3
	// Cluster is being updated.
	Cluster_UPDATING Cluster_Status = 4
	// Cluster is stopping.
	Cluster_STOPPING Cluster_Status = 5
	// Cluster stopped.
	Cluster_STOPPED Cluster_Status = 6
	// Cluster is starting.
	Cluster_STARTING Cluster_Status = 7
)

var Cluster_Status_name = map[int32]string{
	0: "STATUS_UNKNOWN",
	1: "CREATING",
	2: "RUNNING",
	3: "ERROR",
	4: "UPDATING",
	5: "STOPPING",
	6: "STOPPED",
	7: "STARTING",
}

var Cluster_Status_value = map[string]int32{
	"STATUS_UNKNOWN": 0,
	"CREATING":       1,
	"RUNNING":        2,
	"ERROR":          3,
	"UPDATING":       4,
	"STOPPING":       5,
	"STOPPED":        6,
	"STARTING":       7,
}

func (x Cluster_Status) String() string {
	return proto.EnumName(Cluster_Status_name, int32(x))
}

func (Cluster_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{0, 2}
}

type Host_Type int32

const (
	Host_TYPE_UNSPECIFIED Host_Type = 0
	// A mongod host.
	Host_MONGOD Host_Type = 1
	// A mongos host.
	Host_MONGOS Host_Type = 2
	// A mongocfg host.
	Host_MONGOCFG Host_Type = 3
)

var Host_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "MONGOD",
	2: "MONGOS",
	3: "MONGOCFG",
}

var Host_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"MONGOD":           1,
	"MONGOS":           2,
	"MONGOCFG":         3,
}

func (x Host_Type) String() string {
	return proto.EnumName(Host_Type_name, int32(x))
}

func (Host_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{6, 0}
}

type Host_Role int32

const (
	// Role of the host in the cluster is unknown.
	Host_ROLE_UNKNOWN Host_Role = 0
	// Host is the primary MongoDB server in the cluster.
	Host_PRIMARY Host_Role = 1
	// Host is a secondary MongoDB server in the cluster.
	Host_SECONDARY Host_Role = 2
)

var Host_Role_name = map[int32]string{
	0: "ROLE_UNKNOWN",
	1: "PRIMARY",
	2: "SECONDARY",
}

var Host_Role_value = map[string]int32{
	"ROLE_UNKNOWN": 0,
	"PRIMARY":      1,
	"SECONDARY":    2,
}

func (x Host_Role) String() string {
	return proto.EnumName(Host_Role_name, int32(x))
}

func (Host_Role) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{6, 1}
}

type Host_Health int32

const (
	// Health of the host is unknown.
	Host_HEALTH_UNKNOWN Host_Health = 0
	// The host is performing all its functions normally.
	Host_ALIVE Host_Health = 1
	// The host is inoperable, and cannot perform any of its essential functions.
	Host_DEAD Host_Health = 2
	// The host is degraded, and can perform only some of its essential functions.
	Host_DEGRADED Host_Health = 3
)

var Host_Health_name = map[int32]string{
	0: "HEALTH_UNKNOWN",
	1: "ALIVE",
	2: "DEAD",
	3: "DEGRADED",
}

var Host_Health_value = map[string]int32{
	"HEALTH_UNKNOWN": 0,
	"ALIVE":          1,
	"DEAD":           2,
	"DEGRADED":       3,
}

func (x Host_Health) String() string {
	return proto.EnumName(Host_Health_name, int32(x))
}

func (Host_Health) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{6, 2}
}

type Service_Type int32

const (
	Service_TYPE_UNSPECIFIED Service_Type = 0
	// The host is running a mongod daemon.
	Service_MONGOD Service_Type = 1
	// The host is running a mongos daemon.
	Service_MONGOS Service_Type = 2
	// The host is running a MongoDB config server.
	Service_MONGOCFG Service_Type = 3
)

var Service_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "MONGOD",
	2: "MONGOS",
	3: "MONGOCFG",
}

var Service_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"MONGOD":           1,
	"MONGOS":           2,
	"MONGOCFG":         3,
}

func (x Service_Type) String() string {
	return proto.EnumName(Service_Type_name, int32(x))
}

func (Service_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{7, 0}
}

type Service_Health int32

const (
	// Health of the server is unknown.
	Service_HEALTH_UNKNOWN Service_Health = 0
	// The server is working normally.
	Service_ALIVE Service_Health = 1
	// The server is dead or unresponsive.
	Service_DEAD Service_Health = 2
)

var Service_Health_name = map[int32]string{
	0: "HEALTH_UNKNOWN",
	1: "ALIVE",
	2: "DEAD",
}

var Service_Health_value = map[string]int32{
	"HEALTH_UNKNOWN": 0,
	"ALIVE":          1,
	"DEAD":           2,
}

func (x Service_Health) String() string {
	return proto.EnumName(Service_Health_name, int32(x))
}

func (Service_Health) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{7, 1}
}

// A managed MongoDB cluster. For more information, see the [documentation](/docs/managed-mongodb/concepts).
type Cluster struct {
	// ID of the MongoDB cluster.
	// This ID is assigned by MDB at creation time.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the MongoDB cluster belongs to.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	CreatedAt *timestamp.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the MongoDB cluster.
	// The name is unique within the folder. 1-63 characters long.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the MongoDB cluster. 0-256 characters long.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the MongoDB cluster as `` key:value `` pairs. Maximum 64 per resource.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Deployment environment of the MongoDB cluster.
	Environment Cluster_Environment `protobuf:"varint,7,opt,name=environment,proto3,enum=yandex.cloud.mdb.mongodb.v1.Cluster_Environment" json:"environment,omitempty"`
	// Description of monitoring systems relevant to the MongoDB cluster.
	Monitoring []*Monitoring `protobuf:"bytes,8,rep,name=monitoring,proto3" json:"monitoring,omitempty"`
	// Configuration of the MongoDB cluster.
	Config *ClusterConfig `protobuf:"bytes,9,opt,name=config,proto3" json:"config,omitempty"`
	// ID of the network that the cluster belongs to.
	NetworkId string `protobuf:"bytes,10,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// Aggregated cluster health.
	Health Cluster_Health `protobuf:"varint,11,opt,name=health,proto3,enum=yandex.cloud.mdb.mongodb.v1.Cluster_Health" json:"health,omitempty"`
	// Current state of the cluster.
	Status Cluster_Status `protobuf:"varint,12,opt,name=status,proto3,enum=yandex.cloud.mdb.mongodb.v1.Cluster_Status" json:"status,omitempty"`
	// Indicates current sharding status of the cluster.
	Sharded              bool     `protobuf:"varint,13,opt,name=sharded,proto3" json:"sharded,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Cluster) Reset()         { *m = Cluster{} }
func (m *Cluster) String() string { return proto.CompactTextString(m) }
func (*Cluster) ProtoMessage()    {}
func (*Cluster) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{0}
}

func (m *Cluster) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Cluster.Unmarshal(m, b)
}
func (m *Cluster) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Cluster.Marshal(b, m, deterministic)
}
func (m *Cluster) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster.Merge(m, src)
}
func (m *Cluster) XXX_Size() int {
	return xxx_messageInfo_Cluster.Size(m)
}
func (m *Cluster) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster proto.InternalMessageInfo

func (m *Cluster) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Cluster) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *Cluster) GetCreatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Cluster) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Cluster) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Cluster) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Cluster) GetEnvironment() Cluster_Environment {
	if m != nil {
		return m.Environment
	}
	return Cluster_ENVIRONMENT_UNSPECIFIED
}

func (m *Cluster) GetMonitoring() []*Monitoring {
	if m != nil {
		return m.Monitoring
	}
	return nil
}

func (m *Cluster) GetConfig() *ClusterConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Cluster) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

func (m *Cluster) GetHealth() Cluster_Health {
	if m != nil {
		return m.Health
	}
	return Cluster_HEALTH_UNKNOWN
}

func (m *Cluster) GetStatus() Cluster_Status {
	if m != nil {
		return m.Status
	}
	return Cluster_STATUS_UNKNOWN
}

func (m *Cluster) GetSharded() bool {
	if m != nil {
		return m.Sharded
	}
	return false
}

// Monitoring system.
type Monitoring struct {
	// Name of the monitoring system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the monitoring system.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Link to the monitoring system charts for the MongoDB cluster.
	Link                 string   `protobuf:"bytes,3,opt,name=link,proto3" json:"link,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Monitoring) Reset()         { *m = Monitoring{} }
func (m *Monitoring) String() string { return proto.CompactTextString(m) }
func (*Monitoring) ProtoMessage()    {}
func (*Monitoring) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{1}
}

func (m *Monitoring) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Monitoring.Unmarshal(m, b)
}
func (m *Monitoring) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Monitoring.Marshal(b, m, deterministic)
}
func (m *Monitoring) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Monitoring.Merge(m, src)
}
func (m *Monitoring) XXX_Size() int {
	return xxx_messageInfo_Monitoring.Size(m)
}
func (m *Monitoring) XXX_DiscardUnknown() {
	xxx_messageInfo_Monitoring.DiscardUnknown(m)
}

var xxx_messageInfo_Monitoring proto.InternalMessageInfo

func (m *Monitoring) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Monitoring) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Monitoring) GetLink() string {
	if m != nil {
		return m.Link
	}
	return ""
}

type ClusterConfig struct {
	// Version of MongoDB server software.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// MongoDB feature compatibility version. See usage details in [MongoDB documentation](https://docs.mongodb.com/manual/reference/command/setFeatureCompatibilityVersion/).
	//
	// Possible values:
	// * 3.6 — persist data compatibility for version 3.6. After setting this option the data will not be compatible with 3.4 or lower.
	// * 4.0 — persist data compatibility for version 4.0. After setting this option the data will not be compatible with 3.6 or lower.
	FeatureCompatibilityVersion string `protobuf:"bytes,5,opt,name=feature_compatibility_version,json=featureCompatibilityVersion,proto3" json:"feature_compatibility_version,omitempty"`
	// Configuration for MongoDB servers in the cluster.
	//
	// Types that are valid to be assigned to Mongodb:
	//	*ClusterConfig_Mongodb_3_6
	//	*ClusterConfig_Mongodb_4_0
	Mongodb isClusterConfig_Mongodb `protobuf_oneof:"mongodb"`
	// Time to start the daily backup, in the UTC timezone.
	BackupWindowStart *timeofday.TimeOfDay `protobuf:"bytes,3,opt,name=backup_window_start,json=backupWindowStart,proto3" json:"backup_window_start,omitempty"`
	// Access policy to DB
	Access               *Access  `protobuf:"bytes,6,opt,name=access,proto3" json:"access,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ClusterConfig) Reset()         { *m = ClusterConfig{} }
func (m *ClusterConfig) String() string { return proto.CompactTextString(m) }
func (*ClusterConfig) ProtoMessage()    {}
func (*ClusterConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{2}
}

func (m *ClusterConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterConfig.Unmarshal(m, b)
}
func (m *ClusterConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterConfig.Marshal(b, m, deterministic)
}
func (m *ClusterConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterConfig.Merge(m, src)
}
func (m *ClusterConfig) XXX_Size() int {
	return xxx_messageInfo_ClusterConfig.Size(m)
}
func (m *ClusterConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterConfig proto.InternalMessageInfo

func (m *ClusterConfig) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *ClusterConfig) GetFeatureCompatibilityVersion() string {
	if m != nil {
		return m.FeatureCompatibilityVersion
	}
	return ""
}

type isClusterConfig_Mongodb interface {
	isClusterConfig_Mongodb()
}

type ClusterConfig_Mongodb_3_6 struct {
	Mongodb_3_6 *Mongodb3_6 `protobuf:"bytes,2,opt,name=mongodb_3_6,json=mongodb36,proto3,oneof"`
}

type ClusterConfig_Mongodb_4_0 struct {
	Mongodb_4_0 *Mongodb4_0 `protobuf:"bytes,4,opt,name=mongodb_4_0,json=mongodb40,proto3,oneof"`
}

func (*ClusterConfig_Mongodb_3_6) isClusterConfig_Mongodb() {}

func (*ClusterConfig_Mongodb_4_0) isClusterConfig_Mongodb() {}

func (m *ClusterConfig) GetMongodb() isClusterConfig_Mongodb {
	if m != nil {
		return m.Mongodb
	}
	return nil
}

func (m *ClusterConfig) GetMongodb_3_6() *Mongodb3_6 {
	if x, ok := m.GetMongodb().(*ClusterConfig_Mongodb_3_6); ok {
		return x.Mongodb_3_6
	}
	return nil
}

func (m *ClusterConfig) GetMongodb_4_0() *Mongodb4_0 {
	if x, ok := m.GetMongodb().(*ClusterConfig_Mongodb_4_0); ok {
		return x.Mongodb_4_0
	}
	return nil
}

func (m *ClusterConfig) GetBackupWindowStart() *timeofday.TimeOfDay {
	if m != nil {
		return m.BackupWindowStart
	}
	return nil
}

func (m *ClusterConfig) GetAccess() *Access {
	if m != nil {
		return m.Access
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ClusterConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ClusterConfig_Mongodb_3_6)(nil),
		(*ClusterConfig_Mongodb_4_0)(nil),
	}
}

type Mongodb3_6 struct {
	// Configuration and resource allocation for mongod in a MongoDB 3.6 cluster.
	Mongod *Mongodb3_6_Mongod `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	// Configuration and resource allocation for mongocfg in a MongoDB 3.6 cluster.
	Mongocfg *Mongodb3_6_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// Configuration and resource allocation for mongos in a MongoDB 3.6 cluster.
	Mongos               *Mongodb3_6_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *Mongodb3_6) Reset()         { *m = Mongodb3_6{} }
func (m *Mongodb3_6) String() string { return proto.CompactTextString(m) }
func (*Mongodb3_6) ProtoMessage()    {}
func (*Mongodb3_6) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{3}
}

func (m *Mongodb3_6) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Mongodb3_6.Unmarshal(m, b)
}
func (m *Mongodb3_6) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Mongodb3_6.Marshal(b, m, deterministic)
}
func (m *Mongodb3_6) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mongodb3_6.Merge(m, src)
}
func (m *Mongodb3_6) XXX_Size() int {
	return xxx_messageInfo_Mongodb3_6.Size(m)
}
func (m *Mongodb3_6) XXX_DiscardUnknown() {
	xxx_messageInfo_Mongodb3_6.DiscardUnknown(m)
}

var xxx_messageInfo_Mongodb3_6 proto.InternalMessageInfo

func (m *Mongodb3_6) GetMongod() *Mongodb3_6_Mongod {
	if m != nil {
		return m.Mongod
	}
	return nil
}

func (m *Mongodb3_6) GetMongocfg() *Mongodb3_6_MongoCfg {
	if m != nil {
		return m.Mongocfg
	}
	return nil
}

func (m *Mongodb3_6) GetMongos() *Mongodb3_6_Mongos {
	if m != nil {
		return m.Mongos
	}
	return nil
}

type Mongodb3_6_Mongod struct {
	// Configuration for a mongod 3.6 hosts.
	Config *config.MongodConfigSet3_6 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to MongoDB hosts.
	Resources            *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Mongodb3_6_Mongod) Reset()         { *m = Mongodb3_6_Mongod{} }
func (m *Mongodb3_6_Mongod) String() string { return proto.CompactTextString(m) }
func (*Mongodb3_6_Mongod) ProtoMessage()    {}
func (*Mongodb3_6_Mongod) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{3, 0}
}

func (m *Mongodb3_6_Mongod) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Mongodb3_6_Mongod.Unmarshal(m, b)
}
func (m *Mongodb3_6_Mongod) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Mongodb3_6_Mongod.Marshal(b, m, deterministic)
}
func (m *Mongodb3_6_Mongod) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mongodb3_6_Mongod.Merge(m, src)
}
func (m *Mongodb3_6_Mongod) XXX_Size() int {
	return xxx_messageInfo_Mongodb3_6_Mongod.Size(m)
}
func (m *Mongodb3_6_Mongod) XXX_DiscardUnknown() {
	xxx_messageInfo_Mongodb3_6_Mongod.DiscardUnknown(m)
}

var xxx_messageInfo_Mongodb3_6_Mongod proto.InternalMessageInfo

func (m *Mongodb3_6_Mongod) GetConfig() *config.MongodConfigSet3_6 {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Mongodb3_6_Mongod) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type Mongodb3_6_MongoCfg struct {
	Config *config.MongoCfgConfigSet3_6 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources            *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Mongodb3_6_MongoCfg) Reset()         { *m = Mongodb3_6_MongoCfg{} }
func (m *Mongodb3_6_MongoCfg) String() string { return proto.CompactTextString(m) }
func (*Mongodb3_6_MongoCfg) ProtoMessage()    {}
func (*Mongodb3_6_MongoCfg) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{3, 1}
}

func (m *Mongodb3_6_MongoCfg) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Mongodb3_6_MongoCfg.Unmarshal(m, b)
}
func (m *Mongodb3_6_MongoCfg) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Mongodb3_6_MongoCfg.Marshal(b, m, deterministic)
}
func (m *Mongodb3_6_MongoCfg) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mongodb3_6_MongoCfg.Merge(m, src)
}
func (m *Mongodb3_6_MongoCfg) XXX_Size() int {
	return xxx_messageInfo_Mongodb3_6_MongoCfg.Size(m)
}
func (m *Mongodb3_6_MongoCfg) XXX_DiscardUnknown() {
	xxx_messageInfo_Mongodb3_6_MongoCfg.DiscardUnknown(m)
}

var xxx_messageInfo_Mongodb3_6_MongoCfg proto.InternalMessageInfo

func (m *Mongodb3_6_MongoCfg) GetConfig() *config.MongoCfgConfigSet3_6 {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Mongodb3_6_MongoCfg) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type Mongodb3_6_Mongos struct {
	Config *config.MongosConfigSet3_6 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources            *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Mongodb3_6_Mongos) Reset()         { *m = Mongodb3_6_Mongos{} }
func (m *Mongodb3_6_Mongos) String() string { return proto.CompactTextString(m) }
func (*Mongodb3_6_Mongos) ProtoMessage()    {}
func (*Mongodb3_6_Mongos) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{3, 2}
}

func (m *Mongodb3_6_Mongos) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Mongodb3_6_Mongos.Unmarshal(m, b)
}
func (m *Mongodb3_6_Mongos) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Mongodb3_6_Mongos.Marshal(b, m, deterministic)
}
func (m *Mongodb3_6_Mongos) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mongodb3_6_Mongos.Merge(m, src)
}
func (m *Mongodb3_6_Mongos) XXX_Size() int {
	return xxx_messageInfo_Mongodb3_6_Mongos.Size(m)
}
func (m *Mongodb3_6_Mongos) XXX_DiscardUnknown() {
	xxx_messageInfo_Mongodb3_6_Mongos.DiscardUnknown(m)
}

var xxx_messageInfo_Mongodb3_6_Mongos proto.InternalMessageInfo

func (m *Mongodb3_6_Mongos) GetConfig() *config.MongosConfigSet3_6 {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Mongodb3_6_Mongos) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type Mongodb4_0 struct {
	// Configuration and resource allocation for mongod in a MongoDB 4.0 cluster.
	Mongod *Mongodb4_0_Mongod `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	// Configuration and resource allocation for mongocfg in a MongoDB 4.0 cluster.
	Mongocfg *Mongodb4_0_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// Configuration and resource allocation for mongos in a MongoDB 4.0 cluster.
	Mongos               *Mongodb4_0_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *Mongodb4_0) Reset()         { *m = Mongodb4_0{} }
func (m *Mongodb4_0) String() string { return proto.CompactTextString(m) }
func (*Mongodb4_0) ProtoMessage()    {}
func (*Mongodb4_0) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{4}
}

func (m *Mongodb4_0) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Mongodb4_0.Unmarshal(m, b)
}
func (m *Mongodb4_0) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Mongodb4_0.Marshal(b, m, deterministic)
}
func (m *Mongodb4_0) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mongodb4_0.Merge(m, src)
}
func (m *Mongodb4_0) XXX_Size() int {
	return xxx_messageInfo_Mongodb4_0.Size(m)
}
func (m *Mongodb4_0) XXX_DiscardUnknown() {
	xxx_messageInfo_Mongodb4_0.DiscardUnknown(m)
}

var xxx_messageInfo_Mongodb4_0 proto.InternalMessageInfo

func (m *Mongodb4_0) GetMongod() *Mongodb4_0_Mongod {
	if m != nil {
		return m.Mongod
	}
	return nil
}

func (m *Mongodb4_0) GetMongocfg() *Mongodb4_0_MongoCfg {
	if m != nil {
		return m.Mongocfg
	}
	return nil
}

func (m *Mongodb4_0) GetMongos() *Mongodb4_0_Mongos {
	if m != nil {
		return m.Mongos
	}
	return nil
}

type Mongodb4_0_Mongod struct {
	// Configuration for mongod 4.0 hosts.
	Config *config.MongodConfigSet4_0 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongod hosts.
	Resources            *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Mongodb4_0_Mongod) Reset()         { *m = Mongodb4_0_Mongod{} }
func (m *Mongodb4_0_Mongod) String() string { return proto.CompactTextString(m) }
func (*Mongodb4_0_Mongod) ProtoMessage()    {}
func (*Mongodb4_0_Mongod) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{4, 0}
}

func (m *Mongodb4_0_Mongod) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Mongodb4_0_Mongod.Unmarshal(m, b)
}
func (m *Mongodb4_0_Mongod) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Mongodb4_0_Mongod.Marshal(b, m, deterministic)
}
func (m *Mongodb4_0_Mongod) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mongodb4_0_Mongod.Merge(m, src)
}
func (m *Mongodb4_0_Mongod) XXX_Size() int {
	return xxx_messageInfo_Mongodb4_0_Mongod.Size(m)
}
func (m *Mongodb4_0_Mongod) XXX_DiscardUnknown() {
	xxx_messageInfo_Mongodb4_0_Mongod.DiscardUnknown(m)
}

var xxx_messageInfo_Mongodb4_0_Mongod proto.InternalMessageInfo

func (m *Mongodb4_0_Mongod) GetConfig() *config.MongodConfigSet4_0 {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Mongodb4_0_Mongod) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type Mongodb4_0_MongoCfg struct {
	// Configuration for mongocfg 4.0 hosts.
	Config *config.MongoCfgConfigSet4_0 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources            *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Mongodb4_0_MongoCfg) Reset()         { *m = Mongodb4_0_MongoCfg{} }
func (m *Mongodb4_0_MongoCfg) String() string { return proto.CompactTextString(m) }
func (*Mongodb4_0_MongoCfg) ProtoMessage()    {}
func (*Mongodb4_0_MongoCfg) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{4, 1}
}

func (m *Mongodb4_0_MongoCfg) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Mongodb4_0_MongoCfg.Unmarshal(m, b)
}
func (m *Mongodb4_0_MongoCfg) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Mongodb4_0_MongoCfg.Marshal(b, m, deterministic)
}
func (m *Mongodb4_0_MongoCfg) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mongodb4_0_MongoCfg.Merge(m, src)
}
func (m *Mongodb4_0_MongoCfg) XXX_Size() int {
	return xxx_messageInfo_Mongodb4_0_MongoCfg.Size(m)
}
func (m *Mongodb4_0_MongoCfg) XXX_DiscardUnknown() {
	xxx_messageInfo_Mongodb4_0_MongoCfg.DiscardUnknown(m)
}

var xxx_messageInfo_Mongodb4_0_MongoCfg proto.InternalMessageInfo

func (m *Mongodb4_0_MongoCfg) GetConfig() *config.MongoCfgConfigSet4_0 {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Mongodb4_0_MongoCfg) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type Mongodb4_0_Mongos struct {
	// Configuration for mongos 4.0 hosts.
	Config *config.MongosConfigSet4_0 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongos hosts.
	Resources            *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Mongodb4_0_Mongos) Reset()         { *m = Mongodb4_0_Mongos{} }
func (m *Mongodb4_0_Mongos) String() string { return proto.CompactTextString(m) }
func (*Mongodb4_0_Mongos) ProtoMessage()    {}
func (*Mongodb4_0_Mongos) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{4, 2}
}

func (m *Mongodb4_0_Mongos) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Mongodb4_0_Mongos.Unmarshal(m, b)
}
func (m *Mongodb4_0_Mongos) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Mongodb4_0_Mongos.Marshal(b, m, deterministic)
}
func (m *Mongodb4_0_Mongos) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mongodb4_0_Mongos.Merge(m, src)
}
func (m *Mongodb4_0_Mongos) XXX_Size() int {
	return xxx_messageInfo_Mongodb4_0_Mongos.Size(m)
}
func (m *Mongodb4_0_Mongos) XXX_DiscardUnknown() {
	xxx_messageInfo_Mongodb4_0_Mongos.DiscardUnknown(m)
}

var xxx_messageInfo_Mongodb4_0_Mongos proto.InternalMessageInfo

func (m *Mongodb4_0_Mongos) GetConfig() *config.MongosConfigSet4_0 {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Mongodb4_0_Mongos) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type Shard struct {
	// Name of the shard.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the cluster that the shard belongs to.
	ClusterId            string   `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Shard) Reset()         { *m = Shard{} }
func (m *Shard) String() string { return proto.CompactTextString(m) }
func (*Shard) ProtoMessage()    {}
func (*Shard) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{5}
}

func (m *Shard) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Shard.Unmarshal(m, b)
}
func (m *Shard) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Shard.Marshal(b, m, deterministic)
}
func (m *Shard) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Shard.Merge(m, src)
}
func (m *Shard) XXX_Size() int {
	return xxx_messageInfo_Shard.Size(m)
}
func (m *Shard) XXX_DiscardUnknown() {
	xxx_messageInfo_Shard.DiscardUnknown(m)
}

var xxx_messageInfo_Shard proto.InternalMessageInfo

func (m *Shard) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Shard) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type Host struct {
	// Name of the MongoDB host. The host name is assigned by MDB at creation time, and cannot be changed.
	// 1-63 characters long.
	//
	// The name is unique across all existing MDB hosts in Yandex.Cloud, as it defines the FQDN of the host.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the MongoDB host. The ID is assigned by MDB at creation time.
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the availability zone where the MongoDB host resides.
	ZoneId string `protobuf:"bytes,3,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// Resources allocated to the MongoDB host.
	Resources *Resources `protobuf:"bytes,4,opt,name=resources,proto3" json:"resources,omitempty"`
	// Role of the host in the cluster.
	Role Host_Role `protobuf:"varint,5,opt,name=role,proto3,enum=yandex.cloud.mdb.mongodb.v1.Host_Role" json:"role,omitempty"`
	// Status code of the aggregated health of the host.
	Health Host_Health `protobuf:"varint,6,opt,name=health,proto3,enum=yandex.cloud.mdb.mongodb.v1.Host_Health" json:"health,omitempty"`
	// Services provided by the host.
	Services []*Service `protobuf:"bytes,7,rep,name=services,proto3" json:"services,omitempty"`
	// ID of the subnet that the host belongs to.
	SubnetId string `protobuf:"bytes,8,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Flag showing public IP assignment status to this host.
	AssignPublicIp bool `protobuf:"varint,9,opt,name=assign_public_ip,json=assignPublicIp,proto3" json:"assign_public_ip,omitempty"`
	// Shard which this host belongs to.
	ShardName string `protobuf:"bytes,10,opt,name=shard_name,json=shardName,proto3" json:"shard_name,omitempty"`
	// Host type
	Type                 Host_Type `protobuf:"varint,11,opt,name=type,proto3,enum=yandex.cloud.mdb.mongodb.v1.Host_Type" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *Host) Reset()         { *m = Host{} }
func (m *Host) String() string { return proto.CompactTextString(m) }
func (*Host) ProtoMessage()    {}
func (*Host) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{6}
}

func (m *Host) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Host.Unmarshal(m, b)
}
func (m *Host) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Host.Marshal(b, m, deterministic)
}
func (m *Host) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Host.Merge(m, src)
}
func (m *Host) XXX_Size() int {
	return xxx_messageInfo_Host.Size(m)
}
func (m *Host) XXX_DiscardUnknown() {
	xxx_messageInfo_Host.DiscardUnknown(m)
}

var xxx_messageInfo_Host proto.InternalMessageInfo

func (m *Host) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Host) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *Host) GetZoneId() string {
	if m != nil {
		return m.ZoneId
	}
	return ""
}

func (m *Host) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *Host) GetRole() Host_Role {
	if m != nil {
		return m.Role
	}
	return Host_ROLE_UNKNOWN
}

func (m *Host) GetHealth() Host_Health {
	if m != nil {
		return m.Health
	}
	return Host_HEALTH_UNKNOWN
}

func (m *Host) GetServices() []*Service {
	if m != nil {
		return m.Services
	}
	return nil
}

func (m *Host) GetSubnetId() string {
	if m != nil {
		return m.SubnetId
	}
	return ""
}

func (m *Host) GetAssignPublicIp() bool {
	if m != nil {
		return m.AssignPublicIp
	}
	return false
}

func (m *Host) GetShardName() string {
	if m != nil {
		return m.ShardName
	}
	return ""
}

func (m *Host) GetType() Host_Type {
	if m != nil {
		return m.Type
	}
	return Host_TYPE_UNSPECIFIED
}

type Service struct {
	// Type of the service provided by the host.
	Type Service_Type `protobuf:"varint,1,opt,name=type,proto3,enum=yandex.cloud.mdb.mongodb.v1.Service_Type" json:"type,omitempty"`
	// Status code of server availability.
	Health               Service_Health `protobuf:"varint,2,opt,name=health,proto3,enum=yandex.cloud.mdb.mongodb.v1.Service_Health" json:"health,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Service) Reset()         { *m = Service{} }
func (m *Service) String() string { return proto.CompactTextString(m) }
func (*Service) ProtoMessage()    {}
func (*Service) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{7}
}

func (m *Service) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Service.Unmarshal(m, b)
}
func (m *Service) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Service.Marshal(b, m, deterministic)
}
func (m *Service) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Service.Merge(m, src)
}
func (m *Service) XXX_Size() int {
	return xxx_messageInfo_Service.Size(m)
}
func (m *Service) XXX_DiscardUnknown() {
	xxx_messageInfo_Service.DiscardUnknown(m)
}

var xxx_messageInfo_Service proto.InternalMessageInfo

func (m *Service) GetType() Service_Type {
	if m != nil {
		return m.Type
	}
	return Service_TYPE_UNSPECIFIED
}

func (m *Service) GetHealth() Service_Health {
	if m != nil {
		return m.Health
	}
	return Service_HEALTH_UNKNOWN
}

type Resources struct {
	// ID of the preset for computational resources available to a host (CPU, memory etc.).
	// All available presets are listed in the [documentation](/docs/managed-mongodb/concepts/instance-types).
	ResourcePresetId string `protobuf:"bytes,1,opt,name=resource_preset_id,json=resourcePresetId,proto3" json:"resource_preset_id,omitempty"`
	// Volume of the storage available to a host, in bytes.
	DiskSize int64 `protobuf:"varint,2,opt,name=disk_size,json=diskSize,proto3" json:"disk_size,omitempty"`
	// Type of the storage environment for the host.
	// Possible values:
	// * network-hdd — network HDD drive,
	// * network-ssd — network SSD drive,
	// * local-ssd — local SSD storage.
	DiskTypeId           string   `protobuf:"bytes,3,opt,name=disk_type_id,json=diskTypeId,proto3" json:"disk_type_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Resources) Reset()         { *m = Resources{} }
func (m *Resources) String() string { return proto.CompactTextString(m) }
func (*Resources) ProtoMessage()    {}
func (*Resources) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{8}
}

func (m *Resources) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Resources.Unmarshal(m, b)
}
func (m *Resources) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Resources.Marshal(b, m, deterministic)
}
func (m *Resources) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Resources.Merge(m, src)
}
func (m *Resources) XXX_Size() int {
	return xxx_messageInfo_Resources.Size(m)
}
func (m *Resources) XXX_DiscardUnknown() {
	xxx_messageInfo_Resources.DiscardUnknown(m)
}

var xxx_messageInfo_Resources proto.InternalMessageInfo

func (m *Resources) GetResourcePresetId() string {
	if m != nil {
		return m.ResourcePresetId
	}
	return ""
}

func (m *Resources) GetDiskSize() int64 {
	if m != nil {
		return m.DiskSize
	}
	return 0
}

func (m *Resources) GetDiskTypeId() string {
	if m != nil {
		return m.DiskTypeId
	}
	return ""
}

type Access struct {
	// Allow access for DataLens
	DataLens             bool     `protobuf:"varint,1,opt,name=data_lens,json=dataLens,proto3" json:"data_lens,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Access) Reset()         { *m = Access{} }
func (m *Access) String() string { return proto.CompactTextString(m) }
func (*Access) ProtoMessage()    {}
func (*Access) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{9}
}

func (m *Access) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Access.Unmarshal(m, b)
}
func (m *Access) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Access.Marshal(b, m, deterministic)
}
func (m *Access) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Access.Merge(m, src)
}
func (m *Access) XXX_Size() int {
	return xxx_messageInfo_Access.Size(m)
}
func (m *Access) XXX_DiscardUnknown() {
	xxx_messageInfo_Access.DiscardUnknown(m)
}

var xxx_messageInfo_Access proto.InternalMessageInfo

func (m *Access) GetDataLens() bool {
	if m != nil {
		return m.DataLens
	}
	return false
}

func init() {
	proto.RegisterEnum("yandex.cloud.mdb.mongodb.v1.Cluster_Environment", Cluster_Environment_name, Cluster_Environment_value)
	proto.RegisterEnum("yandex.cloud.mdb.mongodb.v1.Cluster_Health", Cluster_Health_name, Cluster_Health_value)
	proto.RegisterEnum("yandex.cloud.mdb.mongodb.v1.Cluster_Status", Cluster_Status_name, Cluster_Status_value)
	proto.RegisterEnum("yandex.cloud.mdb.mongodb.v1.Host_Type", Host_Type_name, Host_Type_value)
	proto.RegisterEnum("yandex.cloud.mdb.mongodb.v1.Host_Role", Host_Role_name, Host_Role_value)
	proto.RegisterEnum("yandex.cloud.mdb.mongodb.v1.Host_Health", Host_Health_name, Host_Health_value)
	proto.RegisterEnum("yandex.cloud.mdb.mongodb.v1.Service_Type", Service_Type_name, Service_Type_value)
	proto.RegisterEnum("yandex.cloud.mdb.mongodb.v1.Service_Health", Service_Health_name, Service_Health_value)
	proto.RegisterType((*Cluster)(nil), "yandex.cloud.mdb.mongodb.v1.Cluster")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.mdb.mongodb.v1.Cluster.LabelsEntry")
	proto.RegisterType((*Monitoring)(nil), "yandex.cloud.mdb.mongodb.v1.Monitoring")
	proto.RegisterType((*ClusterConfig)(nil), "yandex.cloud.mdb.mongodb.v1.ClusterConfig")
	proto.RegisterType((*Mongodb3_6)(nil), "yandex.cloud.mdb.mongodb.v1.Mongodb3_6")
	proto.RegisterType((*Mongodb3_6_Mongod)(nil), "yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongod")
	proto.RegisterType((*Mongodb3_6_MongoCfg)(nil), "yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoCfg")
	proto.RegisterType((*Mongodb3_6_Mongos)(nil), "yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongos")
	proto.RegisterType((*Mongodb4_0)(nil), "yandex.cloud.mdb.mongodb.v1.Mongodb4_0")
	proto.RegisterType((*Mongodb4_0_Mongod)(nil), "yandex.cloud.mdb.mongodb.v1.Mongodb4_0.Mongod")
	proto.RegisterType((*Mongodb4_0_MongoCfg)(nil), "yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoCfg")
	proto.RegisterType((*Mongodb4_0_Mongos)(nil), "yandex.cloud.mdb.mongodb.v1.Mongodb4_0.Mongos")
	proto.RegisterType((*Shard)(nil), "yandex.cloud.mdb.mongodb.v1.Shard")
	proto.RegisterType((*Host)(nil), "yandex.cloud.mdb.mongodb.v1.Host")
	proto.RegisterType((*Service)(nil), "yandex.cloud.mdb.mongodb.v1.Service")
	proto.RegisterType((*Resources)(nil), "yandex.cloud.mdb.mongodb.v1.Resources")
	proto.RegisterType((*Access)(nil), "yandex.cloud.mdb.mongodb.v1.Access")
}

func init() {
	proto.RegisterFile("yandex/cloud/mdb/mongodb/v1/cluster.proto", fileDescriptor_ccaf7a2567168975)
}

var fileDescriptor_ccaf7a2567168975 = []byte{
	// 1404 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x58, 0x5f, 0x73, 0xda, 0xc6,
	0x16, 0x8f, 0x00, 0x0b, 0x71, 0x70, 0x3c, 0xba, 0x7b, 0x33, 0x37, 0x8c, 0x3d, 0x99, 0xeb, 0xe1,
	0xde, 0xb6, 0x4e, 0xdb, 0x08, 0x12, 0x33, 0x9e, 0xc4, 0x99, 0x4e, 0x83, 0x41, 0xb6, 0x35, 0xc5,
	0x82, 0x59, 0xb0, 0x33, 0xe9, 0x8b, 0x46, 0xa0, 0x05, 0x6b, 0x2c, 0x24, 0x46, 0x2b, 0x9c, 0x90,
	0xe7, 0x7e, 0x83, 0xbe, 0xf7, 0xa1, 0xdf, 0xa1, 0x1f, 0xa4, 0x4f, 0xfd, 0x3a, 0x9d, 0xfd, 0x23,
	0x4c, 0xd2, 0x96, 0xe0, 0x94, 0xcc, 0xf4, 0x6d, 0xf7, 0x9c, 0xf3, 0xfb, 0x71, 0xfe, 0xed, 0xea,
	0x2c, 0xf0, 0x70, 0xe6, 0x86, 0x1e, 0x79, 0x53, 0x19, 0x04, 0xd1, 0xd4, 0xab, 0x8c, 0xbd, 0x7e,
	0x65, 0x1c, 0x85, 0xa3, 0xc8, 0xeb, 0x57, 0xae, 0x1f, 0x57, 0x06, 0xc1, 0x94, 0x26, 0x24, 0x36,
	0x26, 0x71, 0x94, 0x44, 0x68, 0x47, 0x98, 0x1a, 0xdc, 0xd4, 0x18, 0x7b, 0x7d, 0x43, 0x9a, 0x1a,
	0xd7, 0x8f, 0xb7, 0xff, 0x3b, 0x8a, 0xa2, 0x51, 0x40, 0x2a, 0xdc, 0xb4, 0x3f, 0x1d, 0x56, 0x12,
	0x7f, 0x4c, 0x68, 0xe2, 0x8e, 0x27, 0x02, 0xbd, 0xbd, 0x23, 0x0d, 0x92, 0xd9, 0x84, 0x70, 0x65,
	0x34, 0xf4, 0xdc, 0x99, 0x54, 0xee, 0x2f, 0xf5, 0x22, 0x0a, 0x87, 0xfe, 0x28, 0x95, 0xec, 0x3b,
	0x07, 0xb7, 0x07, 0xd5, 0x9c, 0xaa, 0x00, 0x95, 0x7f, 0xcb, 0x43, 0xbe, 0x21, 0xc2, 0x42, 0x5b,
	0x90, 0xf1, 0xbd, 0x92, 0xb2, 0xab, 0xec, 0x15, 0x70, 0xc6, 0xf7, 0xd0, 0x0e, 0x14, 0x86, 0x51,
	0xe0, 0x91, 0xd8, 0xf1, 0xbd, 0x52, 0x86, 0x8b, 0x35, 0x21, 0xb0, 0x3c, 0xf4, 0x0c, 0x60, 0x10,
	0x13, 0x37, 0x21, 0x9e, 0xe3, 0x26, 0xa5, 0xec, 0xae, 0xb2, 0x57, 0x7c, 0xb2, 0x6d, 0x88, 0xa0,
	0x8c, 0x34, 0x6a, 0xa3, 0x97, 0x46, 0x8d, 0x0b, 0xd2, 0xba, 0x9e, 0x20, 0x04, 0xb9, 0xd0, 0x1d,
	0x93, 0x52, 0x8e, 0x53, 0xf2, 0x35, 0xda, 0x85, 0xa2, 0x47, 0xe8, 0x20, 0xf6, 0x27, 0x89, 0x1f,
	0x85, 0xa5, 0x0d, 0xae, 0x5a, 0x14, 0xa1, 0x53, 0x50, 0x03, 0xb7, 0x4f, 0x02, 0x5a, 0x52, 0x77,
	0xb3, 0x7b, 0xc5, 0x27, 0x55, 0x63, 0x49, 0xfe, 0x0d, 0x19, 0x93, 0xd1, 0xe2, 0x10, 0x33, 0x4c,
	0xe2, 0x19, 0x96, 0x78, 0x84, 0xa1, 0x48, 0xc2, 0x6b, 0x3f, 0x8e, 0xc2, 0x31, 0x09, 0x93, 0x52,
	0x7e, 0x57, 0xd9, 0xdb, 0x5a, 0x91, 0xce, 0xbc, 0xc1, 0xe1, 0x45, 0x12, 0x74, 0x02, 0x30, 0x8e,
	0x42, 0x3f, 0x89, 0x62, 0x3f, 0x1c, 0x95, 0x34, 0xee, 0xe1, 0x17, 0x4b, 0x29, 0xcf, 0xe6, 0xe6,
	0x78, 0x01, 0x8a, 0x8e, 0x40, 0x15, 0xb5, 0x2a, 0x15, 0x78, 0x4e, 0xbf, 0x5c, 0xc5, 0xaf, 0x06,
	0x47, 0x60, 0x89, 0x44, 0x0f, 0x00, 0x42, 0x92, 0xbc, 0x8e, 0xe2, 0x2b, 0x56, 0x39, 0xe0, 0xb9,
	0x2c, 0x48, 0x89, 0xe5, 0xa1, 0x06, 0xa8, 0x97, 0xc4, 0x0d, 0x92, 0xcb, 0x52, 0x91, 0x87, 0xfe,
	0xd5, 0x4a, 0xa1, 0x9f, 0x72, 0x08, 0x96, 0x50, 0x46, 0x42, 0x13, 0x37, 0x99, 0xd2, 0xd2, 0xe6,
	0x2d, 0x48, 0xba, 0x1c, 0x82, 0x25, 0x14, 0x95, 0x20, 0x4f, 0x2f, 0xdd, 0xd8, 0x23, 0x5e, 0xe9,
	0xee, 0xae, 0xb2, 0xa7, 0xe1, 0x74, 0xbb, 0xfd, 0x0c, 0x8a, 0x0b, 0xa5, 0x43, 0x3a, 0x64, 0xaf,
	0xc8, 0x4c, 0xf6, 0x26, 0x5b, 0xa2, 0x7b, 0xb0, 0x71, 0xed, 0x06, 0x53, 0x22, 0x1b, 0x53, 0x6c,
	0x0e, 0x33, 0x4f, 0x95, 0xb2, 0x05, 0xc5, 0x85, 0x32, 0xa1, 0x1d, 0xb8, 0x6f, 0xda, 0x17, 0x16,
	0x6e, 0xdb, 0x67, 0xa6, 0xdd, 0x73, 0xce, 0xed, 0x6e, 0xc7, 0x6c, 0x58, 0xc7, 0x96, 0xd9, 0xd4,
	0xef, 0xa0, 0x2d, 0x80, 0x0e, 0x6e, 0x37, 0xcf, 0x1b, 0x3d, 0xab, 0x6d, 0xeb, 0x0a, 0xba, 0x0b,
	0x85, 0x0e, 0x36, 0xbb, 0xbd, 0xfa, 0x51, 0xcb, 0xd4, 0x33, 0xe5, 0x6f, 0x41, 0x15, 0x61, 0x23,
	0x04, 0x5b, 0xa7, 0x66, 0xbd, 0xd5, 0x3b, 0x75, 0xce, 0xed, 0xef, 0xec, 0xf6, 0x4b, 0x5b, 0xbf,
	0x83, 0x0a, 0xb0, 0x51, 0x6f, 0x59, 0x17, 0xa6, 0xae, 0x20, 0x0d, 0x72, 0x4d, 0xb3, 0xde, 0xd4,
	0x33, 0x68, 0x13, 0xb4, 0xa6, 0x79, 0x82, 0xeb, 0x4d, 0xb3, 0xa9, 0x67, 0xcb, 0x33, 0x50, 0x45,
	0xc8, 0x8c, 0xa0, 0xdb, 0xab, 0xf7, 0xce, 0xbb, 0x0b, 0x04, 0x9b, 0xa0, 0x35, 0xb0, 0x59, 0xef,
	0x59, 0xf6, 0x89, 0xae, 0xa0, 0x22, 0xe4, 0xf1, 0xb9, 0x6d, 0xb3, 0x4d, 0x86, 0x71, 0x9b, 0x18,
	0xb7, 0xb1, 0x9e, 0x65, 0x56, 0xe7, 0x9d, 0xa6, 0xb0, 0xca, 0xb1, 0x5d, 0xb7, 0xd7, 0xee, 0x74,
	0xd8, 0x6e, 0x83, 0x61, 0xf8, 0xce, 0x6c, 0xea, 0xaa, 0x50, 0xd5, 0x31, 0x37, 0xcc, 0x97, 0x2f,
	0x00, 0x6e, 0x5a, 0x6c, 0x7e, 0xe6, 0x94, 0xbf, 0x3e, 0x73, 0x99, 0x3f, 0x9e, 0x39, 0x04, 0xb9,
	0xc0, 0x0f, 0xaf, 0xf8, 0xf1, 0x2e, 0x60, 0xbe, 0x2e, 0xff, 0x98, 0x85, 0xbb, 0xef, 0xb4, 0x1d,
	0xab, 0xe2, 0x35, 0x89, 0x29, 0xe3, 0x10, 0xf4, 0xe9, 0x16, 0x1d, 0xc1, 0x83, 0x21, 0x71, 0x93,
	0x69, 0x4c, 0x9c, 0x41, 0x34, 0x9e, 0xb8, 0x89, 0xdf, 0xf7, 0x03, 0x3f, 0x99, 0x39, 0xa9, 0xbd,
	0x38, 0xe7, 0x3b, 0xd2, 0xa8, 0xb1, 0x68, 0x73, 0x21, 0x39, 0x2c, 0x28, 0xca, 0x46, 0x72, 0xf6,
	0x9d, 0x03, 0xee, 0xe5, 0x0a, 0x47, 0x4b, 0x5e, 0x8d, 0xa7, 0x77, 0x70, 0x21, 0xbd, 0x28, 0x0f,
	0x16, 0xa9, 0x6a, 0x4e, 0x95, 0xdf, 0x3f, 0x2b, 0x52, 0xd5, 0x9c, 0xea, 0x02, 0x55, 0xad, 0x8a,
	0x8e, 0xe1, 0xdf, 0x7d, 0x77, 0x70, 0x35, 0x9d, 0x38, 0xaf, 0xfd, 0xd0, 0x8b, 0x5e, 0x3b, 0x34,
	0x71, 0xe3, 0xf4, 0x1e, 0xfc, 0x4f, 0x7a, 0x0f, 0xb2, 0xcb, 0x9d, 0xdf, 0x81, 0xed, 0x61, 0xd3,
	0x9d, 0xe1, 0x7f, 0x09, 0xc8, 0x4b, 0x8e, 0xe8, 0x32, 0x00, 0x7a, 0x0e, 0xaa, 0x3b, 0x18, 0x10,
	0xca, 0x6e, 0x35, 0x06, 0xfd, 0xdf, 0x52, 0x6f, 0xea, 0xdc, 0x14, 0x4b, 0xc8, 0x51, 0x01, 0xf2,
	0x52, 0x59, 0xfe, 0x75, 0x83, 0x97, 0x5b, 0x86, 0x8d, 0x8e, 0x41, 0x15, 0x1a, 0x5e, 0x91, 0xe2,
	0x13, 0x63, 0xc5, 0x7c, 0xc9, 0x25, 0x96, 0x68, 0xd4, 0x02, 0x8d, 0xaf, 0x06, 0xc3, 0x91, 0xcc,
	0x7c, 0xf5, 0x56, 0x4c, 0x8d, 0xe1, 0x08, 0xcf, 0x19, 0xe6, 0x5e, 0x51, 0x99, 0xa7, 0xdb, 0x79,
	0x45, 0xa5, 0x57, 0x74, 0xfb, 0x27, 0x05, 0x54, 0xa1, 0x45, 0xf6, 0xfc, 0xba, 0x14, 0x81, 0x1e,
	0x2c, 0xa5, 0x14, 0xa6, 0x92, 0x59, 0x74, 0x6f, 0x97, 0x24, 0xfb, 0xce, 0xc1, 0xfc, 0xea, 0x6c,
	0x42, 0x21, 0x26, 0x34, 0x9a, 0xc6, 0x03, 0x42, 0x65, 0xc4, 0x9f, 0x2f, 0xa5, 0xc4, 0xa9, 0x35,
	0xbe, 0x01, 0x6e, 0xff, 0xac, 0x80, 0x96, 0xc6, 0x8f, 0x3a, 0xef, 0xb9, 0xf8, 0x74, 0x65, 0x17,
	0x1b, 0xc3, 0xd1, 0x27, 0x74, 0x72, 0x9e, 0x45, 0xfa, 0x37, 0xb2, 0x48, 0x3f, 0x9d, 0x83, 0x8b,
	0x3d, 0x5d, 0x73, 0xaa, 0x1f, 0xd7, 0xd3, 0x6c, 0xd2, 0x59, 0x4f, 0x4f, 0xcf, 0x99, 0xd6, 0xd0,
	0xd3, 0x73, 0xae, 0x4f, 0xd6, 0xd3, 0x35, 0xa7, 0xfa, 0xcf, 0xef, 0xe9, 0xf5, 0x3b, 0xb9, 0xe6,
	0x9e, 0x5e, 0xbb, 0x83, 0xe5, 0x43, 0xd8, 0xe8, 0xb2, 0x11, 0xe7, 0x4f, 0x3f, 0xc8, 0x0f, 0x00,
	0xe4, 0x13, 0xe3, 0x66, 0xe2, 0x2e, 0x48, 0x89, 0xe5, 0x95, 0x7f, 0xd9, 0x80, 0xdc, 0x69, 0x44,
	0x93, 0x8f, 0xc0, 0xa2, 0xfb, 0x90, 0x7f, 0x1b, 0x85, 0x84, 0xe9, 0xc4, 0xc7, 0x5c, 0x65, 0x5b,
	0xcb, 0x7b, 0x37, 0xac, 0xdc, 0x47, 0x86, 0x85, 0x0e, 0x21, 0x17, 0x47, 0x01, 0xe1, 0xdf, 0xf3,
	0xad, 0x0f, 0x10, 0xb0, 0x10, 0x0c, 0x1c, 0x05, 0x04, 0x73, 0x0c, 0x7a, 0x31, 0x1f, 0x47, 0x55,
	0x8e, 0xde, 0xfb, 0x30, 0xfa, 0xbd, 0x59, 0xf4, 0x05, 0x68, 0x94, 0xc4, 0xd7, 0x3e, 0x0b, 0x21,
	0xcf, 0x47, 0xef, 0xff, 0x2f, 0xe5, 0xe8, 0x0a, 0x63, 0x3c, 0x47, 0xb1, 0xa7, 0x0e, 0x9d, 0xf6,
	0x43, 0x92, 0xb0, 0x04, 0x69, 0xe2, 0xa9, 0x23, 0x04, 0x96, 0x87, 0xf6, 0x40, 0x77, 0x29, 0xf5,
	0x47, 0xa1, 0x33, 0x99, 0xf6, 0x03, 0x7f, 0xe0, 0xf8, 0x13, 0x3e, 0x9c, 0x6b, 0x78, 0x4b, 0xc8,
	0x3b, 0x5c, 0x6c, 0x4d, 0x58, 0x11, 0xf8, 0x00, 0xeb, 0xf0, 0xf2, 0xc8, 0xc1, 0x9b, 0x4b, 0x6c,
	0x56, 0xa3, 0x43, 0xc8, 0xb1, 0x89, 0x40, 0x8e, 0xdd, 0x2b, 0x64, 0xa9, 0x37, 0x9b, 0x10, 0xcc,
	0x31, 0xe5, 0x23, 0xc8, 0xb1, 0x1d, 0xba, 0x07, 0x7a, 0xef, 0x55, 0xc7, 0x7c, 0x6f, 0x8e, 0x05,
	0x50, 0xcf, 0xda, 0xf6, 0x49, 0xbb, 0xa9, 0x2b, 0xf3, 0x75, 0x57, 0x4c, 0xa3, 0x7c, 0xdd, 0x38,
	0x3e, 0xd1, 0xb3, 0xe5, 0x1a, 0xe4, 0x58, 0xde, 0x91, 0x0e, 0x9b, 0xb8, 0xdd, 0x32, 0x17, 0x26,
	0xd1, 0x22, 0xe4, 0x3b, 0xd8, 0x3a, 0xab, 0xe3, 0x57, 0x62, 0x08, 0xee, 0x9a, 0x8d, 0xb6, 0xdd,
	0x64, 0xdb, 0x35, 0x0c, 0xc1, 0x3f, 0x64, 0x20, 0x2f, 0x53, 0x8e, 0xbe, 0x91, 0x29, 0x50, 0x78,
	0x0a, 0x1e, 0xae, 0x52, 0xa6, 0x85, 0x2c, 0x2c, 0x3c, 0x5d, 0x32, 0x2b, 0xbc, 0x3a, 0x52, 0x82,
	0x77, 0xdb, 0x65, 0x2d, 0xa9, 0x7c, 0x7c, 0xeb, 0xa4, 0x94, 0xdf, 0x40, 0x61, 0x7e, 0x76, 0xd0,
	0xd7, 0x80, 0xd2, 0xd3, 0xe3, 0x4c, 0x62, 0x42, 0x45, 0xe7, 0x89, 0x03, 0xad, 0xa7, 0x9a, 0x0e,
	0x57, 0x58, 0xfc, 0x25, 0xee, 0xf9, 0xf4, 0xca, 0xa1, 0xfe, 0x5b, 0xf1, 0xe0, 0xc9, 0x62, 0x8d,
	0x09, 0xba, 0xfe, 0x5b, 0x36, 0xc6, 0x6f, 0x72, 0x25, 0x4b, 0xd0, 0xcd, 0xf9, 0x06, 0x26, 0x63,
	0x61, 0x5a, 0x5e, 0xf9, 0x33, 0x50, 0xc5, 0xe4, 0xc8, 0x89, 0xdc, 0xc4, 0x75, 0x02, 0x12, 0x52,
	0xfe, 0x6b, 0x1a, 0xd6, 0x98, 0xa0, 0x45, 0x42, 0x7a, 0x64, 0x7d, 0x7f, 0x32, 0xf2, 0x93, 0xcb,
	0x69, 0xdf, 0x18, 0x44, 0xe3, 0x8a, 0x48, 0xec, 0x23, 0xf1, 0x6f, 0xc2, 0x28, 0x7a, 0x34, 0x22,
	0x21, 0x7f, 0xd6, 0x57, 0x96, 0xfc, 0xcd, 0xf0, 0x5c, 0x2e, 0xfb, 0x2a, 0x37, 0xdd, 0xff, 0x3d,
	0x00, 0x00, 0xff, 0xff, 0x05, 0xe4, 0xe8, 0xa2, 0x4f, 0x11, 0x00, 0x00,
}
