// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/mdb/redis/v1/cluster.proto

package redis

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	config "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/redis/v1/config"
	timeofday "google.golang.org/genproto/googleapis/type/timeofday"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type Cluster_Environment int32

const (
	Cluster_ENVIRONMENT_UNSPECIFIED Cluster_Environment = 0
	// Stable environment with a conservative update policy:
	// only hotfixes are applied during regular maintenance.
	Cluster_PRODUCTION Cluster_Environment = 1
	// Environment with more aggressive update policy: new versions
	// are rolled out irrespective of backward compatibility.
	Cluster_PRESTABLE Cluster_Environment = 2
)

var Cluster_Environment_name = map[int32]string{
	0: "ENVIRONMENT_UNSPECIFIED",
	1: "PRODUCTION",
	2: "PRESTABLE",
}

var Cluster_Environment_value = map[string]int32{
	"ENVIRONMENT_UNSPECIFIED": 0,
	"PRODUCTION":              1,
	"PRESTABLE":               2,
}

func (x Cluster_Environment) String() string {
	return proto.EnumName(Cluster_Environment_name, int32(x))
}

func (Cluster_Environment) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_c43051bc9a49dd6b, []int{0, 0}
}

type Cluster_Health int32

const (
	// Cluster is in unknown state (we have no data)
	Cluster_HEALTH_UNKNOWN Cluster_Health = 0
	// Cluster is alive and well (all hosts are alive)
	Cluster_ALIVE Cluster_Health = 1
	// Cluster is inoperable (it cannot perform any of its essential functions)
	Cluster_DEAD Cluster_Health = 2
	// Cluster is partially alive (it can perform some of its essential functions)
	Cluster_DEGRADED Cluster_Health = 3
)

var Cluster_Health_name = map[int32]string{
	0: "HEALTH_UNKNOWN",
	1: "ALIVE",
	2: "DEAD",
	3: "DEGRADED",
}

var Cluster_Health_value = map[string]int32{
	"HEALTH_UNKNOWN": 0,
	"ALIVE":          1,
	"DEAD":           2,
	"DEGRADED":       3,
}

func (x Cluster_Health) String() string {
	return proto.EnumName(Cluster_Health_name, int32(x))
}

func (Cluster_Health) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_c43051bc9a49dd6b, []int{0, 1}
}

type Cluster_Status int32

const (
	// Cluster status is unknown
	Cluster_STATUS_UNKNOWN Cluster_Status = 0
	// Cluster is being created
	Cluster_CREATING Cluster_Status = 1
	// Cluster is running
	Cluster_RUNNING Cluster_Status = 2
	// Cluster failed
	Cluster_ERROR Cluster_Status = 3
	// Cluster is being updated.
	Cluster_UPDATING Cluster_Status = 4
	// Cluster is stopping.
	Cluster_STOPPING Cluster_Status = 5
	// Cluster stopped.
	Cluster_STOPPED Cluster_Status = 6
	// Cluster is starting.
	Cluster_STARTING Cluster_Status = 7
)

var Cluster_Status_name = map[int32]string{
	0: "STATUS_UNKNOWN",
	1: "CREATING",
	2: "RUNNING",
	3: "ERROR",
	4: "UPDATING",
	5: "STOPPING",
	6: "STOPPED",
	7: "STARTING",
}

var Cluster_Status_value = map[string]int32{
	"STATUS_UNKNOWN": 0,
	"CREATING":       1,
	"RUNNING":        2,
	"ERROR":          3,
	"UPDATING":       4,
	"STOPPING":       5,
	"STOPPED":        6,
	"STARTING":       7,
}

func (x Cluster_Status) String() string {
	return proto.EnumName(Cluster_Status_name, int32(x))
}

func (Cluster_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_c43051bc9a49dd6b, []int{0, 2}
}

type Host_Role int32

const (
	// Role of the host in the cluster is unknown.
	Host_ROLE_UNKNOWN Host_Role = 0
	// Host is the master Redis server in the cluster.
	Host_MASTER Host_Role = 1
	// Host is a replica (standby) Redis server in the cluster.
	Host_REPLICA Host_Role = 2
)

var Host_Role_name = map[int32]string{
	0: "ROLE_UNKNOWN",
	1: "MASTER",
	2: "REPLICA",
}

var Host_Role_value = map[string]int32{
	"ROLE_UNKNOWN": 0,
	"MASTER":       1,
	"REPLICA":      2,
}

func (x Host_Role) String() string {
	return proto.EnumName(Host_Role_name, int32(x))
}

func (Host_Role) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_c43051bc9a49dd6b, []int{4, 0}
}

type Host_Health int32

const (
	// Health of the host is unknown.
	Host_HEALTH_UNKNOWN Host_Health = 0
	// The host is performing all its functions normally.
	Host_ALIVE Host_Health = 1
	// The host is inoperable, and cannot perform any of its essential functions.
	Host_DEAD Host_Health = 2
	// The host is degraded, and can perform only some of its essential functions.
	Host_DEGRADED Host_Health = 3
)

var Host_Health_name = map[int32]string{
	0: "HEALTH_UNKNOWN",
	1: "ALIVE",
	2: "DEAD",
	3: "DEGRADED",
}

var Host_Health_value = map[string]int32{
	"HEALTH_UNKNOWN": 0,
	"ALIVE":          1,
	"DEAD":           2,
	"DEGRADED":       3,
}

func (x Host_Health) String() string {
	return proto.EnumName(Host_Health_name, int32(x))
}

func (Host_Health) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_c43051bc9a49dd6b, []int{4, 1}
}

type Service_Type int32

const (
	Service_TYPE_UNSPECIFIED Service_Type = 0
	// The host is a Redis server.
	Service_REDIS Service_Type = 1
	// The host provides a Sentinel-only service (a quorum node).
	Service_ARBITER Service_Type = 2
	// The host is a Redis Cluster node.
	Service_REDIS_CLUSTER Service_Type = 3
)

var Service_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "REDIS",
	2: "ARBITER",
	3: "REDIS_CLUSTER",
}

var Service_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"REDIS":            1,
	"ARBITER":          2,
	"REDIS_CLUSTER":    3,
}

func (x Service_Type) String() string {
	return proto.EnumName(Service_Type_name, int32(x))
}

func (Service_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_c43051bc9a49dd6b, []int{5, 0}
}

type Service_Health int32

const (
	// Health of the server is unknown.
	Service_HEALTH_UNKNOWN Service_Health = 0
	// The server is working normally.
	Service_ALIVE Service_Health = 1
	// The server is dead or unresponsive.
	Service_DEAD Service_Health = 2
)

var Service_Health_name = map[int32]string{
	0: "HEALTH_UNKNOWN",
	1: "ALIVE",
	2: "DEAD",
}

var Service_Health_value = map[string]int32{
	"HEALTH_UNKNOWN": 0,
	"ALIVE":          1,
	"DEAD":           2,
}

func (x Service_Health) String() string {
	return proto.EnumName(Service_Health_name, int32(x))
}

func (Service_Health) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_c43051bc9a49dd6b, []int{5, 1}
}

// Description of a Redis cluster. For more information, see
// the Managed Service for Redis [documentation](/docs/managed-redis/concepts/).
type Cluster struct {
	// ID of the Redis cluster.
	// This ID is assigned by MDB at creation time.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the Redis cluster belongs to.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	CreatedAt *timestamp.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the Redis cluster.
	// The name is unique within the folder. 3-63 characters long.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the Redis cluster. 0-256 characters long.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the Redis cluster as `key:value` pairs.
	// Maximum 64 per cluster.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Deployment environment of the Redis cluster.
	Environment Cluster_Environment `protobuf:"varint,7,opt,name=environment,proto3,enum=yandex.cloud.mdb.redis.v1.Cluster_Environment" json:"environment,omitempty"`
	// Description of monitoring systems relevant to the Redis cluster.
	Monitoring []*Monitoring `protobuf:"bytes,8,rep,name=monitoring,proto3" json:"monitoring,omitempty"`
	// Configuration of the Redis cluster.
	Config    *ClusterConfig `protobuf:"bytes,9,opt,name=config,proto3" json:"config,omitempty"`
	NetworkId string         `protobuf:"bytes,10,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// Aggregated cluster health.
	Health Cluster_Health `protobuf:"varint,11,opt,name=health,proto3,enum=yandex.cloud.mdb.redis.v1.Cluster_Health" json:"health,omitempty"`
	// Cluster status.
	Status Cluster_Status `protobuf:"varint,12,opt,name=status,proto3,enum=yandex.cloud.mdb.redis.v1.Cluster_Status" json:"status,omitempty"`
	// Redis cluster mode on/off.
	Sharded              bool     `protobuf:"varint,13,opt,name=sharded,proto3" json:"sharded,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Cluster) Reset()         { *m = Cluster{} }
func (m *Cluster) String() string { return proto.CompactTextString(m) }
func (*Cluster) ProtoMessage()    {}
func (*Cluster) Descriptor() ([]byte, []int) {
	return fileDescriptor_c43051bc9a49dd6b, []int{0}
}

func (m *Cluster) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Cluster.Unmarshal(m, b)
}
func (m *Cluster) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Cluster.Marshal(b, m, deterministic)
}
func (m *Cluster) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster.Merge(m, src)
}
func (m *Cluster) XXX_Size() int {
	return xxx_messageInfo_Cluster.Size(m)
}
func (m *Cluster) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster proto.InternalMessageInfo

func (m *Cluster) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Cluster) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *Cluster) GetCreatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Cluster) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Cluster) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Cluster) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Cluster) GetEnvironment() Cluster_Environment {
	if m != nil {
		return m.Environment
	}
	return Cluster_ENVIRONMENT_UNSPECIFIED
}

func (m *Cluster) GetMonitoring() []*Monitoring {
	if m != nil {
		return m.Monitoring
	}
	return nil
}

func (m *Cluster) GetConfig() *ClusterConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Cluster) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

func (m *Cluster) GetHealth() Cluster_Health {
	if m != nil {
		return m.Health
	}
	return Cluster_HEALTH_UNKNOWN
}

func (m *Cluster) GetStatus() Cluster_Status {
	if m != nil {
		return m.Status
	}
	return Cluster_STATUS_UNKNOWN
}

func (m *Cluster) GetSharded() bool {
	if m != nil {
		return m.Sharded
	}
	return false
}

type Monitoring struct {
	// Name of the monitoring system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the monitoring system.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Link to the monitoring system charts for the Redis cluster.
	Link                 string   `protobuf:"bytes,3,opt,name=link,proto3" json:"link,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Monitoring) Reset()         { *m = Monitoring{} }
func (m *Monitoring) String() string { return proto.CompactTextString(m) }
func (*Monitoring) ProtoMessage()    {}
func (*Monitoring) Descriptor() ([]byte, []int) {
	return fileDescriptor_c43051bc9a49dd6b, []int{1}
}

func (m *Monitoring) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Monitoring.Unmarshal(m, b)
}
func (m *Monitoring) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Monitoring.Marshal(b, m, deterministic)
}
func (m *Monitoring) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Monitoring.Merge(m, src)
}
func (m *Monitoring) XXX_Size() int {
	return xxx_messageInfo_Monitoring.Size(m)
}
func (m *Monitoring) XXX_DiscardUnknown() {
	xxx_messageInfo_Monitoring.DiscardUnknown(m)
}

var xxx_messageInfo_Monitoring proto.InternalMessageInfo

func (m *Monitoring) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Monitoring) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Monitoring) GetLink() string {
	if m != nil {
		return m.Link
	}
	return ""
}

type ClusterConfig struct {
	// Version of Redis server software.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Configuration for Redis servers in the cluster.
	//
	// Types that are valid to be assigned to RedisConfig:
	//	*ClusterConfig_RedisConfig_5_0
	RedisConfig isClusterConfig_RedisConfig `protobuf_oneof:"redis_config"`
	// Resources allocated to Redis hosts.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
	// Time to start the daily backup, in the UTC timezone.
	BackupWindowStart *timeofday.TimeOfDay `protobuf:"bytes,4,opt,name=backup_window_start,json=backupWindowStart,proto3" json:"backup_window_start,omitempty"`
	// Access policy to DB
	Access               *Access  `protobuf:"bytes,5,opt,name=access,proto3" json:"access,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ClusterConfig) Reset()         { *m = ClusterConfig{} }
func (m *ClusterConfig) String() string { return proto.CompactTextString(m) }
func (*ClusterConfig) ProtoMessage()    {}
func (*ClusterConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_c43051bc9a49dd6b, []int{2}
}

func (m *ClusterConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterConfig.Unmarshal(m, b)
}
func (m *ClusterConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterConfig.Marshal(b, m, deterministic)
}
func (m *ClusterConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterConfig.Merge(m, src)
}
func (m *ClusterConfig) XXX_Size() int {
	return xxx_messageInfo_ClusterConfig.Size(m)
}
func (m *ClusterConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterConfig proto.InternalMessageInfo

func (m *ClusterConfig) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

type isClusterConfig_RedisConfig interface {
	isClusterConfig_RedisConfig()
}

type ClusterConfig_RedisConfig_5_0 struct {
	RedisConfig_5_0 *config.RedisConfigSet5_0 `protobuf:"bytes,2,opt,name=redis_config_5_0,json=redisConfig50,proto3,oneof"`
}

func (*ClusterConfig_RedisConfig_5_0) isClusterConfig_RedisConfig() {}

func (m *ClusterConfig) GetRedisConfig() isClusterConfig_RedisConfig {
	if m != nil {
		return m.RedisConfig
	}
	return nil
}

func (m *ClusterConfig) GetRedisConfig_5_0() *config.RedisConfigSet5_0 {
	if x, ok := m.GetRedisConfig().(*ClusterConfig_RedisConfig_5_0); ok {
		return x.RedisConfig_5_0
	}
	return nil
}

func (m *ClusterConfig) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *ClusterConfig) GetBackupWindowStart() *timeofday.TimeOfDay {
	if m != nil {
		return m.BackupWindowStart
	}
	return nil
}

func (m *ClusterConfig) GetAccess() *Access {
	if m != nil {
		return m.Access
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ClusterConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ClusterConfig_RedisConfig_5_0)(nil),
	}
}

type Shard struct {
	// Name of the Redis shard. The shard name is assigned by user at creation time, and cannot be changed.
	// 1-63 characters long.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the Redis cluster the shard belongs to. The ID is assigned by MDB at creation time.
	ClusterId            string   `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Shard) Reset()         { *m = Shard{} }
func (m *Shard) String() string { return proto.CompactTextString(m) }
func (*Shard) ProtoMessage()    {}
func (*Shard) Descriptor() ([]byte, []int) {
	return fileDescriptor_c43051bc9a49dd6b, []int{3}
}

func (m *Shard) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Shard.Unmarshal(m, b)
}
func (m *Shard) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Shard.Marshal(b, m, deterministic)
}
func (m *Shard) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Shard.Merge(m, src)
}
func (m *Shard) XXX_Size() int {
	return xxx_messageInfo_Shard.Size(m)
}
func (m *Shard) XXX_DiscardUnknown() {
	xxx_messageInfo_Shard.DiscardUnknown(m)
}

var xxx_messageInfo_Shard proto.InternalMessageInfo

func (m *Shard) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Shard) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type Host struct {
	// Name of the Redis host. The host name is assigned by MDB at creation time, and cannot be changed.
	// 1-63 characters long.
	//
	// The name is unique across all existing MDB hosts in Yandex.Cloud, as it defines the FQDN of the host.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the Redis cluster. The ID is assigned by MDB at creation time.
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the availability zone where the Redis host resides.
	ZoneId string `protobuf:"bytes,3,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// ID of the subnet that the host belongs to.
	SubnetId string `protobuf:"bytes,4,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Resources allocated to the Redis host.
	Resources *Resources `protobuf:"bytes,5,opt,name=resources,proto3" json:"resources,omitempty"`
	// Role of the host in the cluster.
	Role Host_Role `protobuf:"varint,6,opt,name=role,proto3,enum=yandex.cloud.mdb.redis.v1.Host_Role" json:"role,omitempty"`
	// Status code of the aggregated health of the host.
	Health Host_Health `protobuf:"varint,7,opt,name=health,proto3,enum=yandex.cloud.mdb.redis.v1.Host_Health" json:"health,omitempty"`
	// Services provided by the host.
	Services             []*Service `protobuf:"bytes,8,rep,name=services,proto3" json:"services,omitempty"`
	ShardName            string     `protobuf:"bytes,9,opt,name=shard_name,json=shardName,proto3" json:"shard_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Host) Reset()         { *m = Host{} }
func (m *Host) String() string { return proto.CompactTextString(m) }
func (*Host) ProtoMessage()    {}
func (*Host) Descriptor() ([]byte, []int) {
	return fileDescriptor_c43051bc9a49dd6b, []int{4}
}

func (m *Host) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Host.Unmarshal(m, b)
}
func (m *Host) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Host.Marshal(b, m, deterministic)
}
func (m *Host) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Host.Merge(m, src)
}
func (m *Host) XXX_Size() int {
	return xxx_messageInfo_Host.Size(m)
}
func (m *Host) XXX_DiscardUnknown() {
	xxx_messageInfo_Host.DiscardUnknown(m)
}

var xxx_messageInfo_Host proto.InternalMessageInfo

func (m *Host) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Host) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *Host) GetZoneId() string {
	if m != nil {
		return m.ZoneId
	}
	return ""
}

func (m *Host) GetSubnetId() string {
	if m != nil {
		return m.SubnetId
	}
	return ""
}

func (m *Host) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *Host) GetRole() Host_Role {
	if m != nil {
		return m.Role
	}
	return Host_ROLE_UNKNOWN
}

func (m *Host) GetHealth() Host_Health {
	if m != nil {
		return m.Health
	}
	return Host_HEALTH_UNKNOWN
}

func (m *Host) GetServices() []*Service {
	if m != nil {
		return m.Services
	}
	return nil
}

func (m *Host) GetShardName() string {
	if m != nil {
		return m.ShardName
	}
	return ""
}

type Service struct {
	// Type of the service provided by the host.
	Type Service_Type `protobuf:"varint,1,opt,name=type,proto3,enum=yandex.cloud.mdb.redis.v1.Service_Type" json:"type,omitempty"`
	// Status code of server availability.
	Health               Service_Health `protobuf:"varint,2,opt,name=health,proto3,enum=yandex.cloud.mdb.redis.v1.Service_Health" json:"health,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Service) Reset()         { *m = Service{} }
func (m *Service) String() string { return proto.CompactTextString(m) }
func (*Service) ProtoMessage()    {}
func (*Service) Descriptor() ([]byte, []int) {
	return fileDescriptor_c43051bc9a49dd6b, []int{5}
}

func (m *Service) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Service.Unmarshal(m, b)
}
func (m *Service) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Service.Marshal(b, m, deterministic)
}
func (m *Service) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Service.Merge(m, src)
}
func (m *Service) XXX_Size() int {
	return xxx_messageInfo_Service.Size(m)
}
func (m *Service) XXX_DiscardUnknown() {
	xxx_messageInfo_Service.DiscardUnknown(m)
}

var xxx_messageInfo_Service proto.InternalMessageInfo

func (m *Service) GetType() Service_Type {
	if m != nil {
		return m.Type
	}
	return Service_TYPE_UNSPECIFIED
}

func (m *Service) GetHealth() Service_Health {
	if m != nil {
		return m.Health
	}
	return Service_HEALTH_UNKNOWN
}

type Resources struct {
	// ID of the preset for computational resources available to a host (CPU, memory etc.).
	// All available presets are listed in the [documentation](/docs/managed-redis/concepts/instance-types).
	ResourcePresetId string `protobuf:"bytes,1,opt,name=resource_preset_id,json=resourcePresetId,proto3" json:"resource_preset_id,omitempty"`
	// Volume of the storage available to a host, in bytes.
	DiskSize             int64    `protobuf:"varint,2,opt,name=disk_size,json=diskSize,proto3" json:"disk_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Resources) Reset()         { *m = Resources{} }
func (m *Resources) String() string { return proto.CompactTextString(m) }
func (*Resources) ProtoMessage()    {}
func (*Resources) Descriptor() ([]byte, []int) {
	return fileDescriptor_c43051bc9a49dd6b, []int{6}
}

func (m *Resources) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Resources.Unmarshal(m, b)
}
func (m *Resources) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Resources.Marshal(b, m, deterministic)
}
func (m *Resources) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Resources.Merge(m, src)
}
func (m *Resources) XXX_Size() int {
	return xxx_messageInfo_Resources.Size(m)
}
func (m *Resources) XXX_DiscardUnknown() {
	xxx_messageInfo_Resources.DiscardUnknown(m)
}

var xxx_messageInfo_Resources proto.InternalMessageInfo

func (m *Resources) GetResourcePresetId() string {
	if m != nil {
		return m.ResourcePresetId
	}
	return ""
}

func (m *Resources) GetDiskSize() int64 {
	if m != nil {
		return m.DiskSize
	}
	return 0
}

type Access struct {
	// Allow access for DataLens
	DataLens             bool     `protobuf:"varint,1,opt,name=data_lens,json=dataLens,proto3" json:"data_lens,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Access) Reset()         { *m = Access{} }
func (m *Access) String() string { return proto.CompactTextString(m) }
func (*Access) ProtoMessage()    {}
func (*Access) Descriptor() ([]byte, []int) {
	return fileDescriptor_c43051bc9a49dd6b, []int{7}
}

func (m *Access) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Access.Unmarshal(m, b)
}
func (m *Access) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Access.Marshal(b, m, deterministic)
}
func (m *Access) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Access.Merge(m, src)
}
func (m *Access) XXX_Size() int {
	return xxx_messageInfo_Access.Size(m)
}
func (m *Access) XXX_DiscardUnknown() {
	xxx_messageInfo_Access.DiscardUnknown(m)
}

var xxx_messageInfo_Access proto.InternalMessageInfo

func (m *Access) GetDataLens() bool {
	if m != nil {
		return m.DataLens
	}
	return false
}

func init() {
	proto.RegisterEnum("yandex.cloud.mdb.redis.v1.Cluster_Environment", Cluster_Environment_name, Cluster_Environment_value)
	proto.RegisterEnum("yandex.cloud.mdb.redis.v1.Cluster_Health", Cluster_Health_name, Cluster_Health_value)
	proto.RegisterEnum("yandex.cloud.mdb.redis.v1.Cluster_Status", Cluster_Status_name, Cluster_Status_value)
	proto.RegisterEnum("yandex.cloud.mdb.redis.v1.Host_Role", Host_Role_name, Host_Role_value)
	proto.RegisterEnum("yandex.cloud.mdb.redis.v1.Host_Health", Host_Health_name, Host_Health_value)
	proto.RegisterEnum("yandex.cloud.mdb.redis.v1.Service_Type", Service_Type_name, Service_Type_value)
	proto.RegisterEnum("yandex.cloud.mdb.redis.v1.Service_Health", Service_Health_name, Service_Health_value)
	proto.RegisterType((*Cluster)(nil), "yandex.cloud.mdb.redis.v1.Cluster")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.mdb.redis.v1.Cluster.LabelsEntry")
	proto.RegisterType((*Monitoring)(nil), "yandex.cloud.mdb.redis.v1.Monitoring")
	proto.RegisterType((*ClusterConfig)(nil), "yandex.cloud.mdb.redis.v1.ClusterConfig")
	proto.RegisterType((*Shard)(nil), "yandex.cloud.mdb.redis.v1.Shard")
	proto.RegisterType((*Host)(nil), "yandex.cloud.mdb.redis.v1.Host")
	proto.RegisterType((*Service)(nil), "yandex.cloud.mdb.redis.v1.Service")
	proto.RegisterType((*Resources)(nil), "yandex.cloud.mdb.redis.v1.Resources")
	proto.RegisterType((*Access)(nil), "yandex.cloud.mdb.redis.v1.Access")
}

func init() {
	proto.RegisterFile("yandex/cloud/mdb/redis/v1/cluster.proto", fileDescriptor_c43051bc9a49dd6b)
}

var fileDescriptor_c43051bc9a49dd6b = []byte{
	// 1154 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x56, 0x5d, 0x6f, 0xe2, 0x46,
	0x17, 0x5e, 0x0c, 0x18, 0x7c, 0x48, 0x90, 0x77, 0xde, 0xd5, 0xbb, 0x6e, 0x56, 0xab, 0x52, 0xab,
	0xdb, 0xa5, 0x52, 0xd7, 0x24, 0xac, 0x22, 0xed, 0x87, 0xb4, 0xad, 0x03, 0x4e, 0x62, 0x95, 0x18,
	0x34, 0x36, 0x59, 0xb5, 0x17, 0xb5, 0x0c, 0x9e, 0x10, 0x2b, 0xc6, 0x46, 0xb6, 0x21, 0x25, 0x57,
	0xbd, 0xe9, 0xaf, 0xeb, 0x9f, 0xe8, 0x4f, 0xa9, 0x66, 0xc6, 0x24, 0x64, 0xdb, 0x90, 0x74, 0xd5,
	0x3b, 0x9f, 0x33, 0xcf, 0x73, 0x7c, 0xe6, 0x7c, 0x3c, 0x36, 0xbc, 0x5c, 0x7a, 0x91, 0x4f, 0x7e,
	0x6d, 0x8d, 0xc3, 0x78, 0xee, 0xb7, 0xa6, 0xfe, 0xa8, 0x95, 0x10, 0x3f, 0x48, 0x5b, 0x8b, 0xbd,
	0xd6, 0x38, 0x9c, 0xa7, 0x19, 0x49, 0xb4, 0x59, 0x12, 0x67, 0x31, 0xfa, 0x82, 0x03, 0x35, 0x06,
	0xd4, 0xa6, 0xfe, 0x48, 0x63, 0x40, 0x6d, 0xb1, 0xb7, 0xf3, 0xe5, 0x24, 0x8e, 0x27, 0x21, 0x69,
	0x31, 0xe0, 0x68, 0x7e, 0xd6, 0xca, 0x82, 0x29, 0x49, 0x33, 0x6f, 0x3a, 0xe3, 0xdc, 0x9d, 0x67,
	0x39, 0x20, 0x5b, 0xce, 0x08, 0x3b, 0x8c, 0xcf, 0x7c, 0x6f, 0x99, 0x1f, 0xb6, 0x36, 0x64, 0x10,
	0x47, 0x67, 0xc1, 0x84, 0xdb, 0xfb, 0xee, 0x2e, 0x27, 0xa8, 0x7f, 0x54, 0xa0, 0xd2, 0xe1, 0xb9,
	0xa1, 0x3a, 0x08, 0x81, 0xaf, 0x14, 0x1a, 0x85, 0xa6, 0x84, 0x85, 0xc0, 0x47, 0xcf, 0x40, 0x3a,
	0x8b, 0x43, 0x9f, 0x24, 0x6e, 0xe0, 0x2b, 0x02, 0x73, 0x57, 0xb9, 0xc3, 0xf4, 0xd1, 0x5b, 0x80,
	0x71, 0x42, 0xbc, 0x8c, 0xf8, 0xae, 0x97, 0x29, 0xc5, 0x46, 0xa1, 0x59, 0x6b, 0xef, 0x68, 0x3c,
	0x37, 0x6d, 0x95, 0xbc, 0xe6, 0xac, 0x92, 0xc7, 0x52, 0x8e, 0xd6, 0x33, 0x84, 0xa0, 0x14, 0x79,
	0x53, 0xa2, 0x94, 0x58, 0x48, 0xf6, 0x8c, 0x1a, 0x50, 0xf3, 0x49, 0x3a, 0x4e, 0x82, 0x59, 0x16,
	0xc4, 0x91, 0x52, 0x66, 0x47, 0xeb, 0x2e, 0x74, 0x08, 0x62, 0xe8, 0x8d, 0x48, 0x98, 0x2a, 0x62,
	0xa3, 0xd8, 0xac, 0xb5, 0x35, 0xed, 0xce, 0x22, 0x6a, 0xf9, 0x8d, 0xb4, 0x1e, 0x23, 0x18, 0x51,
	0x96, 0x2c, 0x71, 0xce, 0x46, 0x03, 0xa8, 0x91, 0x68, 0x11, 0x24, 0x71, 0x34, 0x25, 0x51, 0xa6,
	0x54, 0x1a, 0x85, 0x66, 0xfd, 0x41, 0xc1, 0x8c, 0x1b, 0x16, 0x5e, 0x0f, 0x81, 0x0c, 0x80, 0x69,
	0x1c, 0x05, 0x59, 0x9c, 0x04, 0xd1, 0x44, 0xa9, 0xb2, 0xec, 0x5e, 0x6c, 0x08, 0x78, 0x72, 0x0d,
	0xc6, 0x6b, 0x44, 0xf4, 0x03, 0x88, 0xbc, 0x47, 0x8a, 0xc4, 0xaa, 0xd9, 0xbc, 0x3f, 0xa7, 0x0e,
	0xc3, 0xe3, 0x9c, 0x87, 0x9e, 0x03, 0x44, 0x24, 0xbb, 0x8c, 0x93, 0x0b, 0xda, 0x31, 0x60, 0x35,
	0x94, 0x72, 0x8f, 0xe9, 0x23, 0x1d, 0xc4, 0x73, 0xe2, 0x85, 0xd9, 0xb9, 0x52, 0x63, 0x97, 0xfe,
	0xf6, 0x01, 0x97, 0x3e, 0x66, 0x04, 0x9c, 0x13, 0x69, 0x88, 0x34, 0xf3, 0xb2, 0x79, 0xaa, 0x6c,
	0x3d, 0x38, 0x84, 0xcd, 0x08, 0x38, 0x27, 0x22, 0x05, 0x2a, 0xe9, 0xb9, 0x97, 0xf8, 0xc4, 0x57,
	0xb6, 0x1b, 0x85, 0x66, 0x15, 0xaf, 0xcc, 0x9d, 0xb7, 0x50, 0x5b, 0x6b, 0x18, 0x92, 0xa1, 0x78,
	0x41, 0x96, 0xf9, 0x3c, 0xd2, 0x47, 0xf4, 0x04, 0xca, 0x0b, 0x2f, 0x9c, 0x93, 0x7c, 0x18, 0xb9,
	0xf1, 0x4e, 0x78, 0x53, 0x50, 0x4d, 0xa8, 0xad, 0xb5, 0x07, 0x3d, 0x83, 0xa7, 0x86, 0x75, 0x6a,
	0xe2, 0xbe, 0x75, 0x62, 0x58, 0x8e, 0x3b, 0xb4, 0xec, 0x81, 0xd1, 0x31, 0x0f, 0x4d, 0xa3, 0x2b,
	0x3f, 0x42, 0x75, 0x80, 0x01, 0xee, 0x77, 0x87, 0x1d, 0xc7, 0xec, 0x5b, 0x72, 0x01, 0x6d, 0x83,
	0x34, 0xc0, 0x86, 0xed, 0xe8, 0x07, 0x3d, 0x43, 0x16, 0xd4, 0xef, 0x41, 0xe4, 0x97, 0x46, 0x08,
	0xea, 0xc7, 0x86, 0xde, 0x73, 0x8e, 0xdd, 0xa1, 0xf5, 0xa3, 0xd5, 0xff, 0x68, 0xc9, 0x8f, 0x90,
	0x04, 0x65, 0xbd, 0x67, 0x9e, 0x1a, 0x72, 0x01, 0x55, 0xa1, 0xd4, 0x35, 0xf4, 0xae, 0x2c, 0xa0,
	0x2d, 0xa8, 0x76, 0x8d, 0x23, 0xac, 0x77, 0x8d, 0xae, 0x5c, 0x54, 0x97, 0x20, 0xf2, 0x2b, 0xd3,
	0x00, 0xb6, 0xa3, 0x3b, 0x43, 0x7b, 0x2d, 0xc0, 0x16, 0x54, 0x3b, 0xd8, 0xd0, 0x1d, 0xd3, 0x3a,
	0x92, 0x0b, 0xa8, 0x06, 0x15, 0x3c, 0xb4, 0x2c, 0x6a, 0x08, 0x34, 0xb6, 0x81, 0x71, 0x1f, 0xcb,
	0x45, 0x8a, 0x1a, 0x0e, 0xba, 0x1c, 0x55, 0xa2, 0x96, 0xed, 0xf4, 0x07, 0x03, 0x6a, 0x95, 0x29,
	0x87, 0x59, 0x46, 0x57, 0x16, 0xf9, 0x91, 0x8e, 0x19, 0xb0, 0xa2, 0x9e, 0x02, 0xdc, 0x0c, 0xd7,
	0xf5, 0x9e, 0x15, 0xee, 0xde, 0x33, 0xe1, 0xef, 0x7b, 0x86, 0xa0, 0x14, 0x06, 0xd1, 0x05, 0x5b,
	0x69, 0x09, 0xb3, 0x67, 0xf5, 0x4f, 0x01, 0xb6, 0x6f, 0x8d, 0x1c, 0xed, 0xe2, 0x82, 0x24, 0x29,
	0x8d, 0xc1, 0xc3, 0xaf, 0x4c, 0xf4, 0x0b, 0xc8, 0x6c, 0x04, 0x5c, 0x3e, 0x94, 0xee, 0xbe, 0xbb,
	0xcb, 0x5e, 0x53, 0x6b, 0xbf, 0xde, 0x30, 0x2c, 0x1c, 0xac, 0x61, 0x6a, 0xf3, 0x57, 0xd8, 0x24,
	0xdb, 0x77, 0x77, 0x8f, 0x1f, 0xe1, 0xed, 0xe4, 0xc6, 0xb9, 0xbf, 0x8b, 0x0e, 0x40, 0x4a, 0x48,
	0x1a, 0xcf, 0x93, 0x31, 0x49, 0x73, 0xdd, 0xf9, 0x7a, 0x43, 0x60, 0xbc, 0xc2, 0xe2, 0x1b, 0x1a,
	0x3a, 0x84, 0xff, 0x8d, 0xbc, 0xf1, 0xc5, 0x7c, 0xe6, 0x5e, 0x06, 0x91, 0x1f, 0x5f, 0xba, 0x69,
	0xe6, 0x25, 0x19, 0x13, 0xa4, 0x5a, 0xfb, 0xff, 0x2b, 0x15, 0xa3, 0x0a, 0xcb, 0x14, 0xac, 0x7f,
	0xd6, 0xf5, 0x96, 0xf8, 0x31, 0xa7, 0x7c, 0x64, 0x0c, 0x9b, 0x12, 0xd0, 0x5b, 0x10, 0xbd, 0xf1,
	0x98, 0xa4, 0x29, 0x13, 0xac, 0x5a, 0xfb, 0xab, 0x0d, 0x89, 0xe8, 0x0c, 0x88, 0x73, 0xc2, 0x41,
	0x1d, 0xb6, 0xd6, 0xcb, 0xa4, 0xbe, 0x83, 0xb2, 0x4d, 0xf7, 0xe0, 0x1f, 0xbb, 0xf6, 0x1c, 0x20,
	0xff, 0x80, 0xdc, 0x48, 0xb1, 0x94, 0x7b, 0x4c, 0x5f, 0xfd, 0xad, 0x04, 0xa5, 0xe3, 0x38, 0xcd,
	0x3e, 0x83, 0x8b, 0x9e, 0x42, 0xe5, 0x2a, 0x8e, 0x08, 0x3d, 0xe3, 0x1d, 0x17, 0xa9, 0x69, 0x32,
	0xf5, 0x4f, 0xe7, 0xa3, 0x88, 0x64, 0xf4, 0x88, 0x4b, 0x75, 0x95, 0x3b, 0x4c, 0xff, 0x76, 0x13,
	0xca, 0x9f, 0xd7, 0x84, 0x37, 0x50, 0x4a, 0xe2, 0x90, 0x28, 0x22, 0x53, 0x92, 0x4d, 0x74, 0x7a,
	0x37, 0x0d, 0xc7, 0x21, 0xc1, 0x8c, 0x81, 0x3e, 0x5c, 0x0b, 0x19, 0x57, 0xef, 0x6f, 0xee, 0xe3,
	0x7e, 0xa2, 0x62, 0x1f, 0xa0, 0x9a, 0x92, 0x64, 0x11, 0xd0, 0xe4, 0xb9, 0x5c, 0xab, 0x1b, 0x22,
	0xd8, 0x1c, 0x8a, 0xaf, 0x39, 0xb4, 0xa4, 0x4c, 0xb3, 0x5c, 0x56, 0x6c, 0x89, 0x97, 0x94, 0x79,
	0x2c, 0x6f, 0x4a, 0xd4, 0x3d, 0x28, 0xd1, 0x64, 0x91, 0x0c, 0x5b, 0xb8, 0xdf, 0x33, 0xd6, 0x96,
	0x1f, 0x40, 0x3c, 0xd1, 0x6d, 0xc7, 0xc0, 0xf9, 0xea, 0x1b, 0x83, 0x9e, 0xd9, 0xd1, 0xff, 0x0b,
	0xd1, 0xf9, 0x5d, 0x80, 0x4a, 0x9e, 0x28, 0x7a, 0x0f, 0x25, 0x3a, 0xba, 0x6c, 0x0a, 0xea, 0xed,
	0x97, 0xf7, 0x5f, 0x4d, 0x73, 0x96, 0x33, 0x82, 0x19, 0x69, 0xed, 0x23, 0x21, 0xdc, 0xab, 0xf0,
	0x2b, 0xfa, 0xed, 0xf2, 0xaa, 0x47, 0x50, 0xa2, 0x01, 0xd1, 0x13, 0x90, 0x9d, 0x9f, 0x06, 0xc6,
	0x27, 0xf2, 0x2b, 0x41, 0x19, 0x1b, 0x5d, 0xd3, 0xe6, 0x25, 0xd0, 0xf1, 0x81, 0x49, 0xeb, 0x21,
	0xa0, 0xc7, 0xb0, 0xcd, 0xfc, 0x6e, 0xa7, 0x37, 0x64, 0x25, 0x2a, 0xaa, 0x7b, 0xff, 0xba, 0x2a,
	0xea, 0x29, 0x48, 0xd7, 0xc3, 0x86, 0xbe, 0x03, 0xb4, 0x1a, 0x37, 0x77, 0x96, 0x90, 0x94, 0xcf,
	0x32, 0x5f, 0x0e, 0x79, 0x75, 0x32, 0x60, 0x07, 0x7c, 0xe0, 0xfd, 0x20, 0xbd, 0x70, 0xd3, 0xe0,
	0x8a, 0x7f, 0x61, 0x8a, 0xb8, 0x4a, 0x1d, 0x76, 0x70, 0x45, 0xd4, 0x17, 0x20, 0xf2, 0x05, 0x66,
	0x30, 0x2f, 0xf3, 0xdc, 0x90, 0x44, 0x29, 0x8b, 0x55, 0xc5, 0x55, 0xea, 0xe8, 0x91, 0x28, 0x3d,
	0x30, 0x7e, 0xee, 0x4c, 0x82, 0xec, 0x7c, 0x3e, 0xd2, 0xc6, 0xf1, 0x34, 0xff, 0x19, 0x7b, 0xc5,
	0x7f, 0xc6, 0x26, 0xf1, 0xab, 0x09, 0x89, 0xd8, 0x9f, 0xd1, 0xdd, 0x7f, 0x69, 0xef, 0xd9, 0xc3,
	0x48, 0x64, 0xb0, 0xd7, 0x7f, 0x05, 0x00, 0x00, 0xff, 0xff, 0x5e, 0xfd, 0xbe, 0xf3, 0x51, 0x0a,
	0x00, 0x00,
}
