// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/vpc/v1/subnet_service.proto

package vpc

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type GetSubnetRequest struct {
	// ID of the Subnet resource to return.
	// To get the subnet ID use a [SubnetService.List] request.
	SubnetId             string   `protobuf:"bytes,1,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetSubnetRequest) Reset()         { *m = GetSubnetRequest{} }
func (m *GetSubnetRequest) String() string { return proto.CompactTextString(m) }
func (*GetSubnetRequest) ProtoMessage()    {}
func (*GetSubnetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3ec158e4cb3e4034, []int{0}
}

func (m *GetSubnetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetSubnetRequest.Unmarshal(m, b)
}
func (m *GetSubnetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetSubnetRequest.Marshal(b, m, deterministic)
}
func (m *GetSubnetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSubnetRequest.Merge(m, src)
}
func (m *GetSubnetRequest) XXX_Size() int {
	return xxx_messageInfo_GetSubnetRequest.Size(m)
}
func (m *GetSubnetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSubnetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetSubnetRequest proto.InternalMessageInfo

func (m *GetSubnetRequest) GetSubnetId() string {
	if m != nil {
		return m.SubnetId
	}
	return ""
}

type ListSubnetsRequest struct {
	// ID of the folder to list subnets in.
	// To get the folder ID use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListSubnetsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests. Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListSubnetsResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// The expression must specify:
	// 1. The field name. Currently you can use filtering only on [Subnet.name] field.
	// 2. An operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.
	// 3. The value. Must be 3-63 characters long and match the regular expression `^[a-z][-a-z0-9]{1,61}[a-z0-9]$`.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSubnetsRequest) Reset()         { *m = ListSubnetsRequest{} }
func (m *ListSubnetsRequest) String() string { return proto.CompactTextString(m) }
func (*ListSubnetsRequest) ProtoMessage()    {}
func (*ListSubnetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3ec158e4cb3e4034, []int{1}
}

func (m *ListSubnetsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSubnetsRequest.Unmarshal(m, b)
}
func (m *ListSubnetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSubnetsRequest.Marshal(b, m, deterministic)
}
func (m *ListSubnetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSubnetsRequest.Merge(m, src)
}
func (m *ListSubnetsRequest) XXX_Size() int {
	return xxx_messageInfo_ListSubnetsRequest.Size(m)
}
func (m *ListSubnetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSubnetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListSubnetsRequest proto.InternalMessageInfo

func (m *ListSubnetsRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *ListSubnetsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListSubnetsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListSubnetsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListSubnetsResponse struct {
	// List of Subnet resources.
	Subnets []*Subnet `protobuf:"bytes,1,rep,name=subnets,proto3" json:"subnets,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListSubnetsRequest.page_size], use
	// the [next_page_token] as the value
	// for the [ListSubnetsRequest.page_token] query parameter
	// in the next list request. Subsequent list requests will have their own
	// [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSubnetsResponse) Reset()         { *m = ListSubnetsResponse{} }
func (m *ListSubnetsResponse) String() string { return proto.CompactTextString(m) }
func (*ListSubnetsResponse) ProtoMessage()    {}
func (*ListSubnetsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3ec158e4cb3e4034, []int{2}
}

func (m *ListSubnetsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSubnetsResponse.Unmarshal(m, b)
}
func (m *ListSubnetsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSubnetsResponse.Marshal(b, m, deterministic)
}
func (m *ListSubnetsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSubnetsResponse.Merge(m, src)
}
func (m *ListSubnetsResponse) XXX_Size() int {
	return xxx_messageInfo_ListSubnetsResponse.Size(m)
}
func (m *ListSubnetsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSubnetsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListSubnetsResponse proto.InternalMessageInfo

func (m *ListSubnetsResponse) GetSubnets() []*Subnet {
	if m != nil {
		return m.Subnets
	}
	return nil
}

func (m *ListSubnetsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateSubnetRequest struct {
	// ID of the folder to create a subnet in.
	// To get folder ID use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Name of the subnet.
	// The name must be unique within the folder.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the subnet.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels, `` key:value `` pairs.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// ID of the network to create subnet in.
	NetworkId string `protobuf:"bytes,5,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// ID of the availability zone where the subnet resides.
	// To get a list of available zones, use the [yandex.cloud.compute.v1.ZoneService.List] request.
	ZoneId string `protobuf:"bytes,6,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// CIDR block.
	// The range of internal addresses that are defined for this subnet.
	// This field can be set only at Subnet resource creation time and cannot be changed.
	// For example, 10.0.0.0/22 or 192.168.0.0/24.
	// Minimum subnet size is /28, maximum subnet size is /16.
	V4CidrBlocks []string `protobuf:"bytes,7,rep,name=v4_cidr_blocks,json=v4CidrBlocks,proto3" json:"v4_cidr_blocks,omitempty"`
	// ID of route table the subnet is linked to.
	RouteTableId         string   `protobuf:"bytes,9,opt,name=route_table_id,json=routeTableId,proto3" json:"route_table_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateSubnetRequest) Reset()         { *m = CreateSubnetRequest{} }
func (m *CreateSubnetRequest) String() string { return proto.CompactTextString(m) }
func (*CreateSubnetRequest) ProtoMessage()    {}
func (*CreateSubnetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3ec158e4cb3e4034, []int{3}
}

func (m *CreateSubnetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateSubnetRequest.Unmarshal(m, b)
}
func (m *CreateSubnetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateSubnetRequest.Marshal(b, m, deterministic)
}
func (m *CreateSubnetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateSubnetRequest.Merge(m, src)
}
func (m *CreateSubnetRequest) XXX_Size() int {
	return xxx_messageInfo_CreateSubnetRequest.Size(m)
}
func (m *CreateSubnetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateSubnetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateSubnetRequest proto.InternalMessageInfo

func (m *CreateSubnetRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *CreateSubnetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateSubnetRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *CreateSubnetRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *CreateSubnetRequest) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

func (m *CreateSubnetRequest) GetZoneId() string {
	if m != nil {
		return m.ZoneId
	}
	return ""
}

func (m *CreateSubnetRequest) GetV4CidrBlocks() []string {
	if m != nil {
		return m.V4CidrBlocks
	}
	return nil
}

func (m *CreateSubnetRequest) GetRouteTableId() string {
	if m != nil {
		return m.RouteTableId
	}
	return ""
}

type CreateSubnetMetadata struct {
	// ID of the subnet that is being created.
	SubnetId             string   `protobuf:"bytes,1,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateSubnetMetadata) Reset()         { *m = CreateSubnetMetadata{} }
func (m *CreateSubnetMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateSubnetMetadata) ProtoMessage()    {}
func (*CreateSubnetMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_3ec158e4cb3e4034, []int{4}
}

func (m *CreateSubnetMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateSubnetMetadata.Unmarshal(m, b)
}
func (m *CreateSubnetMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateSubnetMetadata.Marshal(b, m, deterministic)
}
func (m *CreateSubnetMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateSubnetMetadata.Merge(m, src)
}
func (m *CreateSubnetMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateSubnetMetadata.Size(m)
}
func (m *CreateSubnetMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateSubnetMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateSubnetMetadata proto.InternalMessageInfo

func (m *CreateSubnetMetadata) GetSubnetId() string {
	if m != nil {
		return m.SubnetId
	}
	return ""
}

type UpdateSubnetRequest struct {
	// ID of the Subnet resource to update.
	SubnetId string `protobuf:"bytes,1,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Field mask that specifies which fields of the Subnet resource are going to be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Name of the subnet.
	// The name must be unique within the folder.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the subnet.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `` key:value `` pairs.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// ID of route table the subnet is linked to.
	RouteTableId         string   `protobuf:"bytes,6,opt,name=route_table_id,json=routeTableId,proto3" json:"route_table_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateSubnetRequest) Reset()         { *m = UpdateSubnetRequest{} }
func (m *UpdateSubnetRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateSubnetRequest) ProtoMessage()    {}
func (*UpdateSubnetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3ec158e4cb3e4034, []int{5}
}

func (m *UpdateSubnetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateSubnetRequest.Unmarshal(m, b)
}
func (m *UpdateSubnetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateSubnetRequest.Marshal(b, m, deterministic)
}
func (m *UpdateSubnetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateSubnetRequest.Merge(m, src)
}
func (m *UpdateSubnetRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateSubnetRequest.Size(m)
}
func (m *UpdateSubnetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateSubnetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateSubnetRequest proto.InternalMessageInfo

func (m *UpdateSubnetRequest) GetSubnetId() string {
	if m != nil {
		return m.SubnetId
	}
	return ""
}

func (m *UpdateSubnetRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateSubnetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateSubnetRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *UpdateSubnetRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *UpdateSubnetRequest) GetRouteTableId() string {
	if m != nil {
		return m.RouteTableId
	}
	return ""
}

type UpdateSubnetMetadata struct {
	// ID of the Subnet resource that is being updated.
	SubnetId             string   `protobuf:"bytes,1,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateSubnetMetadata) Reset()         { *m = UpdateSubnetMetadata{} }
func (m *UpdateSubnetMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateSubnetMetadata) ProtoMessage()    {}
func (*UpdateSubnetMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_3ec158e4cb3e4034, []int{6}
}

func (m *UpdateSubnetMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateSubnetMetadata.Unmarshal(m, b)
}
func (m *UpdateSubnetMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateSubnetMetadata.Marshal(b, m, deterministic)
}
func (m *UpdateSubnetMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateSubnetMetadata.Merge(m, src)
}
func (m *UpdateSubnetMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateSubnetMetadata.Size(m)
}
func (m *UpdateSubnetMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateSubnetMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateSubnetMetadata proto.InternalMessageInfo

func (m *UpdateSubnetMetadata) GetSubnetId() string {
	if m != nil {
		return m.SubnetId
	}
	return ""
}

type DeleteSubnetRequest struct {
	// ID of the subnet to delete.
	// To get the subnet ID use a [SubnetService.List] request.
	SubnetId             string   `protobuf:"bytes,1,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteSubnetRequest) Reset()         { *m = DeleteSubnetRequest{} }
func (m *DeleteSubnetRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteSubnetRequest) ProtoMessage()    {}
func (*DeleteSubnetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3ec158e4cb3e4034, []int{7}
}

func (m *DeleteSubnetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteSubnetRequest.Unmarshal(m, b)
}
func (m *DeleteSubnetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteSubnetRequest.Marshal(b, m, deterministic)
}
func (m *DeleteSubnetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteSubnetRequest.Merge(m, src)
}
func (m *DeleteSubnetRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteSubnetRequest.Size(m)
}
func (m *DeleteSubnetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteSubnetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteSubnetRequest proto.InternalMessageInfo

func (m *DeleteSubnetRequest) GetSubnetId() string {
	if m != nil {
		return m.SubnetId
	}
	return ""
}

type DeleteSubnetMetadata struct {
	// ID of the Subnet resource that is being deleted.
	SubnetId             string   `protobuf:"bytes,1,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteSubnetMetadata) Reset()         { *m = DeleteSubnetMetadata{} }
func (m *DeleteSubnetMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteSubnetMetadata) ProtoMessage()    {}
func (*DeleteSubnetMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_3ec158e4cb3e4034, []int{8}
}

func (m *DeleteSubnetMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteSubnetMetadata.Unmarshal(m, b)
}
func (m *DeleteSubnetMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteSubnetMetadata.Marshal(b, m, deterministic)
}
func (m *DeleteSubnetMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteSubnetMetadata.Merge(m, src)
}
func (m *DeleteSubnetMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteSubnetMetadata.Size(m)
}
func (m *DeleteSubnetMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteSubnetMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteSubnetMetadata proto.InternalMessageInfo

func (m *DeleteSubnetMetadata) GetSubnetId() string {
	if m != nil {
		return m.SubnetId
	}
	return ""
}

type ListSubnetOperationsRequest struct {
	// ID of the Subnet resource to list operations for.
	SubnetId string `protobuf:"bytes,1,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available
	// results is larger than [page_size], the service returns a [ListSubnetOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests. Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListSubnetOperationsResponse.next_page_token] returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSubnetOperationsRequest) Reset()         { *m = ListSubnetOperationsRequest{} }
func (m *ListSubnetOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListSubnetOperationsRequest) ProtoMessage()    {}
func (*ListSubnetOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3ec158e4cb3e4034, []int{9}
}

func (m *ListSubnetOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSubnetOperationsRequest.Unmarshal(m, b)
}
func (m *ListSubnetOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSubnetOperationsRequest.Marshal(b, m, deterministic)
}
func (m *ListSubnetOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSubnetOperationsRequest.Merge(m, src)
}
func (m *ListSubnetOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListSubnetOperationsRequest.Size(m)
}
func (m *ListSubnetOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSubnetOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListSubnetOperationsRequest proto.InternalMessageInfo

func (m *ListSubnetOperationsRequest) GetSubnetId() string {
	if m != nil {
		return m.SubnetId
	}
	return ""
}

func (m *ListSubnetOperationsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListSubnetOperationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListSubnetOperationsResponse struct {
	// List of operations for the specified Subnet resource.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListSubnetOperationsRequest.page_size], use the [next_page_token] as the value
	// for the [ListSubnetOperationsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSubnetOperationsResponse) Reset()         { *m = ListSubnetOperationsResponse{} }
func (m *ListSubnetOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListSubnetOperationsResponse) ProtoMessage()    {}
func (*ListSubnetOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3ec158e4cb3e4034, []int{10}
}

func (m *ListSubnetOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSubnetOperationsResponse.Unmarshal(m, b)
}
func (m *ListSubnetOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSubnetOperationsResponse.Marshal(b, m, deterministic)
}
func (m *ListSubnetOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSubnetOperationsResponse.Merge(m, src)
}
func (m *ListSubnetOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListSubnetOperationsResponse.Size(m)
}
func (m *ListSubnetOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSubnetOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListSubnetOperationsResponse proto.InternalMessageInfo

func (m *ListSubnetOperationsResponse) GetOperations() []*operation.Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListSubnetOperationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*GetSubnetRequest)(nil), "yandex.cloud.vpc.v1.GetSubnetRequest")
	proto.RegisterType((*ListSubnetsRequest)(nil), "yandex.cloud.vpc.v1.ListSubnetsRequest")
	proto.RegisterType((*ListSubnetsResponse)(nil), "yandex.cloud.vpc.v1.ListSubnetsResponse")
	proto.RegisterType((*CreateSubnetRequest)(nil), "yandex.cloud.vpc.v1.CreateSubnetRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.vpc.v1.CreateSubnetRequest.LabelsEntry")
	proto.RegisterType((*CreateSubnetMetadata)(nil), "yandex.cloud.vpc.v1.CreateSubnetMetadata")
	proto.RegisterType((*UpdateSubnetRequest)(nil), "yandex.cloud.vpc.v1.UpdateSubnetRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.vpc.v1.UpdateSubnetRequest.LabelsEntry")
	proto.RegisterType((*UpdateSubnetMetadata)(nil), "yandex.cloud.vpc.v1.UpdateSubnetMetadata")
	proto.RegisterType((*DeleteSubnetRequest)(nil), "yandex.cloud.vpc.v1.DeleteSubnetRequest")
	proto.RegisterType((*DeleteSubnetMetadata)(nil), "yandex.cloud.vpc.v1.DeleteSubnetMetadata")
	proto.RegisterType((*ListSubnetOperationsRequest)(nil), "yandex.cloud.vpc.v1.ListSubnetOperationsRequest")
	proto.RegisterType((*ListSubnetOperationsResponse)(nil), "yandex.cloud.vpc.v1.ListSubnetOperationsResponse")
}

func init() {
	proto.RegisterFile("yandex/cloud/vpc/v1/subnet_service.proto", fileDescriptor_3ec158e4cb3e4034)
}

var fileDescriptor_3ec158e4cb3e4034 = []byte{
	// 1053 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x56, 0xcf, 0x73, 0xdb, 0x44,
	0x14, 0x1e, 0xc5, 0x8e, 0x12, 0x3f, 0xa7, 0x69, 0xd8, 0x84, 0xc1, 0xe3, 0x34, 0x8c, 0x23, 0x20,
	0x35, 0x2e, 0x92, 0x2c, 0xe7, 0xc7, 0x90, 0x26, 0x19, 0xc0, 0xa5, 0x14, 0xcf, 0xb4, 0x03, 0xa3,
	0x84, 0x0b, 0x99, 0x8e, 0x47, 0xb6, 0x36, 0x46, 0x63, 0x45, 0x12, 0xd2, 0xda, 0x34, 0x2e, 0x3d,
	0xd0, 0x1b, 0x99, 0xe1, 0xd4, 0xe1, 0xc4, 0x81, 0x13, 0x27, 0x6e, 0x39, 0xf0, 0x2f, 0x24, 0xe7,
	0x72, 0xe5, 0xc8, 0x81, 0x73, 0x8f, 0x9c, 0x98, 0xdd, 0x95, 0x1d, 0xd9, 0x96, 0x1d, 0x53, 0xe8,
	0x4d, 0xab, 0xf7, 0xed, 0xdb, 0xef, 0xbd, 0xfd, 0xde, 0x7b, 0x0b, 0xf9, 0x13, 0xc3, 0x31, 0xf1,
	0x23, 0xb5, 0x6e, 0xbb, 0x2d, 0x53, 0x6d, 0x7b, 0x75, 0xb5, 0xad, 0xa9, 0x41, 0xab, 0xe6, 0x60,
	0x52, 0x0d, 0xb0, 0xdf, 0xb6, 0xea, 0x58, 0xf1, 0x7c, 0x97, 0xb8, 0x68, 0x91, 0x23, 0x15, 0x86,
	0x54, 0xda, 0x5e, 0x5d, 0x69, 0x6b, 0xd9, 0x1b, 0x0d, 0xd7, 0x6d, 0xd8, 0x58, 0x35, 0x3c, 0x4b,
	0x35, 0x1c, 0xc7, 0x25, 0x06, 0xb1, 0x5c, 0x27, 0xe0, 0x5b, 0xb2, 0xb9, 0xd0, 0xca, 0x56, 0xb5,
	0xd6, 0x91, 0x7a, 0x64, 0x61, 0xdb, 0xac, 0x1e, 0x1b, 0x41, 0xb3, 0x8b, 0xe8, 0x3b, 0x9e, 0x7a,
	0x71, 0x3d, 0xec, 0x33, 0x27, 0xb1, 0x88, 0x3e, 0x82, 0x21, 0x62, 0xad, 0x0f, 0xd1, 0xdb, 0x3f,
	0xe4, 0x69, 0xa5, 0xdf, 0x93, 0x61, 0x5b, 0x66, 0xc4, 0x2c, 0xed, 0xc1, 0xc2, 0x3d, 0x4c, 0xf6,
	0x99, 0x67, 0x1d, 0x7f, 0xdd, 0xc2, 0x01, 0x41, 0xef, 0x42, 0x2a, 0xcc, 0x85, 0x65, 0x66, 0x84,
	0x9c, 0x90, 0x4f, 0x95, 0xe7, 0xfe, 0x3a, 0xd7, 0x84, 0xd3, 0x0b, 0x2d, 0xb9, 0xbb, 0xb7, 0x59,
	0xd4, 0x67, 0xb9, 0xb9, 0x62, 0x4a, 0xbf, 0x09, 0x80, 0xee, 0x5b, 0x41, 0xe8, 0x20, 0x88, 0x78,
	0x38, 0x72, 0x6d, 0x13, 0xfb, 0x23, 0x3d, 0x70, 0x73, 0xc5, 0x44, 0x37, 0x21, 0xe5, 0x19, 0x0d,
	0x5c, 0x0d, 0xac, 0x0e, 0xce, 0x4c, 0xe5, 0x84, 0x7c, 0xa2, 0x0c, 0x7f, 0x9f, 0x6b, 0xe2, 0xee,
	0x9e, 0x56, 0x2c, 0x16, 0xf5, 0x59, 0x6a, 0xdc, 0xb7, 0x3a, 0x18, 0xe5, 0x01, 0x18, 0x90, 0xb8,
	0x4d, 0xec, 0x64, 0x12, 0xcc, 0x69, 0xea, 0xf4, 0x42, 0x9b, 0x66, 0x48, 0x9d, 0x79, 0x39, 0xa0,
	0x36, 0x24, 0x81, 0x78, 0x64, 0xd9, 0x04, 0xfb, 0x99, 0x24, 0x43, 0xc1, 0xe9, 0x45, 0xcf, 0x5f,
	0x68, 0x91, 0x08, 0x2c, 0xf6, 0xf1, 0x0e, 0x3c, 0xd7, 0x09, 0x30, 0xda, 0x84, 0x19, 0x1e, 0x5b,
	0x90, 0x11, 0x72, 0x89, 0x7c, 0xba, 0xb4, 0xac, 0xc4, 0x08, 0x40, 0x09, 0xf3, 0xd5, 0xc5, 0xa2,
	0x35, 0xb8, 0xee, 0xe0, 0x47, 0xa4, 0x1a, 0x21, 0x48, 0x43, 0x49, 0xe9, 0xd7, 0xe8, 0xef, 0xcf,
	0xbb, 0xcc, 0xa4, 0x1f, 0x93, 0xb0, 0x78, 0xc7, 0xc7, 0x06, 0xc1, 0x43, 0x19, 0x9f, 0x34, 0x5f,
	0x9b, 0x90, 0x74, 0x8c, 0x63, 0x9e, 0xaa, 0x54, 0x79, 0xf5, 0xc5, 0xb9, 0xb6, 0xf2, 0xed, 0xa1,
	0x21, 0x77, 0x1e, 0x1e, 0xca, 0x86, 0xdc, 0x29, 0xca, 0xdb, 0x0f, 0x1f, 0x6b, 0xef, 0x6d, 0x69,
	0x4f, 0x0e, 0xc3, 0x95, 0xce, 0xe0, 0xe8, 0x16, 0xa4, 0x4d, 0x1c, 0xd4, 0x7d, 0xcb, 0xa3, 0x97,
	0xdf, 0x9f, 0xbe, 0xd2, 0xe6, 0x96, 0x1e, 0xb5, 0xa2, 0x1f, 0x04, 0x10, 0x6d, 0xa3, 0x86, 0xed,
	0x20, 0x93, 0x64, 0x59, 0xd8, 0x88, 0xcd, 0x42, 0x4c, 0x24, 0xca, 0x7d, 0xb6, 0xed, 0xae, 0x43,
	0xfc, 0x93, 0xf2, 0x07, 0x2f, 0xce, 0xb5, 0xf4, 0xa1, 0x5c, 0x2d, 0xca, 0xdb, 0x94, 0x60, 0xe1,
	0x29, 0x8b, 0x66, 0x6b, 0x83, 0x47, 0xb5, 0xb5, 0x7e, 0x76, 0xa1, 0x89, 0xd9, 0xa4, 0x26, 0xb3,
	0x2f, 0x84, 0x16, 0xc2, 0x30, 0x7a, 0x78, 0x3d, 0x24, 0x81, 0x6e, 0x01, 0x38, 0x98, 0x7c, 0xe3,
	0xfa, 0x4d, 0x9a, 0x9f, 0xe9, 0x98, 0xfc, 0xa4, 0x42, 0x7b, 0xc5, 0x44, 0xab, 0x30, 0xd3, 0x71,
	0x1d, 0x4c, 0x91, 0x22, 0x43, 0xce, 0xf6, 0x50, 0x22, 0x35, 0x54, 0x4c, 0xf4, 0x36, 0xcc, 0xb7,
	0x37, 0xaa, 0x75, 0xcb, 0xf4, 0xab, 0x35, 0xdb, 0xad, 0x37, 0x83, 0xcc, 0x4c, 0x2e, 0x91, 0x4f,
	0xe9, 0x73, 0xed, 0x8d, 0x3b, 0x96, 0xe9, 0x97, 0xd9, 0x3f, 0xa4, 0xc0, 0xbc, 0xef, 0xb6, 0x08,
	0xae, 0x12, 0xa3, 0x66, 0x33, 0x7f, 0xa9, 0x01, 0x7f, 0x73, 0xcc, 0x7e, 0x40, 0xcd, 0x15, 0x33,
	0xbb, 0x0d, 0xe9, 0x48, 0xf4, 0x68, 0x01, 0x12, 0x4d, 0x7c, 0xc2, 0x6f, 0x53, 0xa7, 0x9f, 0x68,
	0x09, 0xa6, 0xdb, 0x86, 0xdd, 0x0a, 0xef, 0x4e, 0xe7, 0x8b, 0xdb, 0x53, 0xef, 0x0b, 0xd2, 0x3a,
	0x2c, 0x45, 0x93, 0xf9, 0x00, 0x13, 0xc3, 0x34, 0x88, 0x81, 0x96, 0x87, 0x2a, 0x31, 0x52, 0x7b,
	0x7f, 0x24, 0x60, 0xf1, 0x0b, 0xcf, 0x8c, 0x13, 0xd3, 0x84, 0xe5, 0x8b, 0x76, 0x20, 0xdd, 0x62,
	0x1e, 0x58, 0x77, 0x62, 0xbc, 0xd2, 0xa5, 0xac, 0xc2, 0x1b, 0x98, 0xd2, 0x6d, 0x60, 0xca, 0x27,
	0xb4, 0x81, 0x3d, 0x30, 0x82, 0xa6, 0x0e, 0x1c, 0x4e, 0xbf, 0x7b, 0x4a, 0x4c, 0xfc, 0x27, 0x25,
	0x26, 0x27, 0x55, 0xe2, 0xf4, 0x18, 0x25, 0xc6, 0xa4, 0xe1, 0xd5, 0x28, 0x71, 0x58, 0x13, 0xe2,
	0x2b, 0xd4, 0x44, 0x34, 0xac, 0xc9, 0x34, 0xf1, 0x21, 0x2c, 0x7e, 0x8c, 0x6d, 0xfc, 0xf2, 0x92,
	0xa0, 0xc7, 0x46, 0x3d, 0x4c, 0x76, 0xec, 0x4f, 0x02, 0x2c, 0x5f, 0xb6, 0xd3, 0xcf, 0xba, 0x23,
	0x28, 0x78, 0x09, 0x49, 0xfe, 0xff, 0xf3, 0x40, 0xfa, 0x5e, 0x80, 0x1b, 0xf1, 0xec, 0xc2, 0xae,
	0xff, 0x11, 0x40, 0x6f, 0x6c, 0x76, 0x1b, 0xff, 0x6a, 0xbf, 0xd0, 0x2e, 0xc7, 0x6a, 0x6f, 0xbf,
	0x1e, 0xd9, 0x34, 0xe9, 0x04, 0x28, 0x7d, 0x37, 0x03, 0xd7, 0x38, 0x8f, 0x7d, 0xfe, 0xce, 0x40,
	0x0e, 0x24, 0xee, 0x61, 0x82, 0xde, 0x89, 0x15, 0xf6, 0xe0, 0x6c, 0xce, 0x8e, 0x9b, 0x47, 0xd2,
	0x5b, 0x4f, 0x7f, 0xff, 0xf3, 0xd9, 0xd4, 0x0a, 0x5a, 0xee, 0x7f, 0x31, 0x04, 0xea, 0xe3, 0x5e,
	0xf6, 0x9f, 0x20, 0x1f, 0x92, 0x34, 0x19, 0xe8, 0x66, 0xac, 0xa7, 0xe1, 0x61, 0x9e, 0xcd, 0x5f,
	0x0d, 0xe4, 0x79, 0x94, 0xde, 0x60, 0xe7, 0xbf, 0x86, 0xae, 0x0f, 0x9c, 0x8f, 0x9e, 0x09, 0x20,
	0xf2, 0x06, 0x87, 0xf2, 0x93, 0x8e, 0x92, 0xec, 0xd5, 0x37, 0x20, 0xed, 0x9e, 0x3d, 0x2f, 0xbc,
	0x39, 0xa2, 0x77, 0x8a, 0x7c, 0xcd, 0x28, 0x2d, 0x49, 0x83, 0x94, 0x6e, 0x0b, 0x05, 0xf4, 0xb3,
	0x00, 0x22, 0x2f, 0xb1, 0x11, 0xac, 0x62, 0xda, 0xca, 0x24, 0xac, 0x3e, 0xe5, 0xac, 0x62, 0xab,
	0x37, 0xca, 0x2a, 0x57, 0x1a, 0x77, 0x51, 0x94, 0xe1, 0xaf, 0x02, 0x88, 0xbc, 0x1a, 0x47, 0x30,
	0x8c, 0x29, 0xf6, 0x49, 0x18, 0x1e, 0x9c, 0x3d, 0x2f, 0xc8, 0x23, 0x0a, 0xfd, 0xf5, 0xc1, 0xee,
	0x7f, 0xf7, 0xd8, 0x23, 0x27, 0x5c, 0x59, 0x85, 0xb1, 0xca, 0xfa, 0x45, 0x80, 0x79, 0x2a, 0x8b,
	0xcb, 0x0a, 0x43, 0xc5, 0x2b, 0xb4, 0x33, 0xd4, 0x2a, 0xb2, 0xda, 0xbf, 0xd8, 0x11, 0xca, 0x4e,
	0x61, 0xe4, 0xf2, 0x68, 0x6d, 0x0c, 0xb9, 0xcb, 0x77, 0x71, 0x50, 0xde, 0xfb, 0x72, 0xa7, 0x61,
	0x91, 0xaf, 0x5a, 0x35, 0xa5, 0xee, 0x1e, 0xab, 0xfc, 0x38, 0x99, 0xbf, 0x8f, 0x1b, 0xae, 0xdc,
	0xc0, 0x0e, 0x0b, 0x5d, 0x8d, 0x79, 0x82, 0xef, 0xb4, 0xbd, 0x7a, 0x4d, 0x64, 0xe6, 0xf5, 0x7f,
	0x02, 0x00, 0x00, 0xff, 0xff, 0x8c, 0xa4, 0x59, 0x70, 0x45, 0x0c, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// SubnetServiceClient is the client API for SubnetService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SubnetServiceClient interface {
	// Returns the specified Subnet resource.
	//
	// To get the list of available Subnet resources, make a [List] request.
	Get(ctx context.Context, in *GetSubnetRequest, opts ...grpc.CallOption) (*Subnet, error)
	// Retrieves the list of Subnet resources in the specified folder.
	List(ctx context.Context, in *ListSubnetsRequest, opts ...grpc.CallOption) (*ListSubnetsResponse, error)
	// Creates a subnet in the specified folder and network.
	// Method starts an asynchronous operation that can be cancelled while it is in progress.
	Create(ctx context.Context, in *CreateSubnetRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified subnet.
	// Method starts an asynchronous operation that can be cancelled while it is in progress.
	Update(ctx context.Context, in *UpdateSubnetRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified subnet.
	Delete(ctx context.Context, in *DeleteSubnetRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// List operations for the specified subnet.
	ListOperations(ctx context.Context, in *ListSubnetOperationsRequest, opts ...grpc.CallOption) (*ListSubnetOperationsResponse, error)
}

type subnetServiceClient struct {
	cc *grpc.ClientConn
}

func NewSubnetServiceClient(cc *grpc.ClientConn) SubnetServiceClient {
	return &subnetServiceClient{cc}
}

func (c *subnetServiceClient) Get(ctx context.Context, in *GetSubnetRequest, opts ...grpc.CallOption) (*Subnet, error) {
	out := new(Subnet)
	err := c.cc.Invoke(ctx, "/yandex.cloud.vpc.v1.SubnetService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subnetServiceClient) List(ctx context.Context, in *ListSubnetsRequest, opts ...grpc.CallOption) (*ListSubnetsResponse, error) {
	out := new(ListSubnetsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.vpc.v1.SubnetService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subnetServiceClient) Create(ctx context.Context, in *CreateSubnetRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.vpc.v1.SubnetService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subnetServiceClient) Update(ctx context.Context, in *UpdateSubnetRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.vpc.v1.SubnetService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subnetServiceClient) Delete(ctx context.Context, in *DeleteSubnetRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.vpc.v1.SubnetService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subnetServiceClient) ListOperations(ctx context.Context, in *ListSubnetOperationsRequest, opts ...grpc.CallOption) (*ListSubnetOperationsResponse, error) {
	out := new(ListSubnetOperationsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.vpc.v1.SubnetService/ListOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SubnetServiceServer is the server API for SubnetService service.
type SubnetServiceServer interface {
	// Returns the specified Subnet resource.
	//
	// To get the list of available Subnet resources, make a [List] request.
	Get(context.Context, *GetSubnetRequest) (*Subnet, error)
	// Retrieves the list of Subnet resources in the specified folder.
	List(context.Context, *ListSubnetsRequest) (*ListSubnetsResponse, error)
	// Creates a subnet in the specified folder and network.
	// Method starts an asynchronous operation that can be cancelled while it is in progress.
	Create(context.Context, *CreateSubnetRequest) (*operation.Operation, error)
	// Updates the specified subnet.
	// Method starts an asynchronous operation that can be cancelled while it is in progress.
	Update(context.Context, *UpdateSubnetRequest) (*operation.Operation, error)
	// Deletes the specified subnet.
	Delete(context.Context, *DeleteSubnetRequest) (*operation.Operation, error)
	// List operations for the specified subnet.
	ListOperations(context.Context, *ListSubnetOperationsRequest) (*ListSubnetOperationsResponse, error)
}

// UnimplementedSubnetServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSubnetServiceServer struct {
}

func (*UnimplementedSubnetServiceServer) Get(ctx context.Context, req *GetSubnetRequest) (*Subnet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedSubnetServiceServer) List(ctx context.Context, req *ListSubnetsRequest) (*ListSubnetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedSubnetServiceServer) Create(ctx context.Context, req *CreateSubnetRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (*UnimplementedSubnetServiceServer) Update(ctx context.Context, req *UpdateSubnetRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (*UnimplementedSubnetServiceServer) Delete(ctx context.Context, req *DeleteSubnetRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedSubnetServiceServer) ListOperations(ctx context.Context, req *ListSubnetOperationsRequest) (*ListSubnetOperationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOperations not implemented")
}

func RegisterSubnetServiceServer(s *grpc.Server, srv SubnetServiceServer) {
	s.RegisterService(&_SubnetService_serviceDesc, srv)
}

func _SubnetService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSubnetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubnetServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.vpc.v1.SubnetService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubnetServiceServer).Get(ctx, req.(*GetSubnetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SubnetService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSubnetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubnetServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.vpc.v1.SubnetService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubnetServiceServer).List(ctx, req.(*ListSubnetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SubnetService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSubnetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubnetServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.vpc.v1.SubnetService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubnetServiceServer).Create(ctx, req.(*CreateSubnetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SubnetService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSubnetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubnetServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.vpc.v1.SubnetService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubnetServiceServer).Update(ctx, req.(*UpdateSubnetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SubnetService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSubnetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubnetServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.vpc.v1.SubnetService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubnetServiceServer).Delete(ctx, req.(*DeleteSubnetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SubnetService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSubnetOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubnetServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.vpc.v1.SubnetService/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubnetServiceServer).ListOperations(ctx, req.(*ListSubnetOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SubnetService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.vpc.v1.SubnetService",
	HandlerType: (*SubnetServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _SubnetService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _SubnetService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _SubnetService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _SubnetService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _SubnetService_Delete_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _SubnetService_ListOperations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/vpc/v1/subnet_service.proto",
}
