---
layout: "docs"
page_title: "sha256 - Functions - Configuration Language"
sidebar_current: "configuration-functions-crypto-sha256"
description: |-
  The sha256 function computes the SHA256 hash of a given string and encodes it
  with hexadecimal digits.
---

# `sha256` Function


`sha256` computes the SHA256 hash of a given string and encodes it with
hexadecimal digits.

The given string is first encoded as UTF-8 and then the SHA256 algorithm is applied
as defined in [RFC 4634](https://tools.ietf.org/html/rfc4634). The raw hash is
then encoded to lowercase hexadecimal digits before returning.

## Examples

```
> sha256("hello world")
b94d27b9934d3e08a52e52d7da7dabfac484efe37a5380ee9088f7ace2efcde9
```
