---
layout: "docs"
page_title: "timestamp - Functions - Configuration Language"
sidebar_current: "configuration-functions-datetime-timestamp"
description: |-
  The timestamp function returns a string representation of the current date
  and time.
---

# `timestamp` Function


`timestamp` returns the current date and time.

In the Packer language, timestamps are conventionally represented as
strings using [RFC 3339](https://tools.ietf.org/html/rfc3339)
"Date and Time format" syntax, and so `timestamp` returns a string
in this format.

The result of this function will change every second, so using this function
directly with resource attributes will cause a diff to be detected on every
Packer run.

-> **Breaking change note:** Packer previously let you decide your own "Date
and Time format" syntax. With HCL2 and for parity with Terraform, Packer will
be using the [RFC 3339](https://tools.ietf.org/html/rfc3339) "Date and Time
format" syntax. As a string. [`formatdate`](./formatdate.html) still allows you
to format a date.

## Examples

```
> timestamp()
2018-05-13T07:44:12Z
```

## Related Functions

* [`formatdate`](./formatdate.html) can convert the resulting timestamp to
  other date and time formats.
